/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.report.SortField;
import kd.fi.fa.business.utils.FaBillParamUtils;

public class AbstractFaRptFormPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener {
    protected Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    protected static String SORT_ENTRY = "sortentry";
    protected static String SORT_ENTRY_FIELD = "ordfield";
    protected static String SORT_ENTRY_TYPE = "ordtype";

    protected String getOrgKey() {
        return "q_org";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(SORT_ENTRY);
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getModel().getDataEntityType().getProperties().get((Object)SORT_ENTRY) != null) {
            DynamicObject orgRow;
            DynamicObjectCollection sortEntry = this.getModel().getEntryEntity(SORT_ENTRY);
            if (!sortEntry.isEmpty()) {
                return;
            }
            ComboProp ordFieldProp = (ComboProp)sortEntry.getDynamicObjectType().getProperty(SORT_ENTRY_FIELD);
            List comboItems = ordFieldProp.getComboItems();
            boolean orgItem = false;
            boolean periodItem = false;
            for (ValueMapItem comboItem : comboItems) {
                String itemVal = comboItem.getValue();
                if (itemVal.startsWith("org")) {
                    orgItem = true;
                }
                if (!itemVal.startsWith("period")) continue;
                periodItem = true;
            }
            if (orgItem) {
                orgRow = sortEntry.addNew();
                orgRow.set(SORT_ENTRY_FIELD, (Object)"org.number");
                orgRow.set(SORT_ENTRY_TYPE, (Object)"ASC");
            }
            if (periodItem) {
                orgRow = sortEntry.addNew();
                orgRow.set(SORT_ENTRY_FIELD, (Object)"period.number");
                orgRow.set(SORT_ENTRY_TYPE, (Object)"ASC");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(SORT_ENTRY);
        if (entryGrid != null && ("deleteentry".equals(operateKey) || "moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey))) {
            DynamicObject preEntityRow;
            String preField;
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(SORT_ENTRY);
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(SORT_ENTRY, currentRowIndex);
            String field = rowEntity.getString(SORT_ENTRY_FIELD);
            if ("org.number".equals(field) || "period.number".equals(field)) {
                args.setCancel(true);
            } else if ("moveentryup".equals(operateKey) && ("org.number".equals(preField = (preEntityRow = this.getModel().getEntryRowEntity(SORT_ENTRY, currentRowIndex - 1)).getString(SORT_ENTRY_FIELD)) || "period.number".equals(preField))) {
                args.setCancel(true);
            }
        }
    }

    protected boolean needSum(String entityId, Collection<?> orgIds) {
        ArrayList<QFilter> paramFilters = new ArrayList<QFilter>(2);
        paramFilters.add(new QFilter("org", "=", (Object)0L));
        paramFilters.add(new QFilter("entity", "=", (Object)entityId));
        DynamicObject globalSum = FaBillParamUtils.queryOne((String)"CardReportSumFlag", paramFilters);
        if (globalSum != null) {
            String val = globalSum.getString("value");
            boolean enable = Boolean.parseBoolean(val);
            return enable;
        }
        paramFilters.clear();
        paramFilters.add(new QFilter("org", "in", orgIds));
        paramFilters.add(new QFilter("entity", "=", (Object)entityId));
        DynamicObjectCollection cardReportSumFlags = FaBillParamUtils.query((String)"CardReportSumFlag", paramFilters);
        if (cardReportSumFlags == null || cardReportSumFlags.size() != orgIds.size()) {
            return true;
        }
        boolean sumFlag = false;
        for (DynamicObject orgCfg : cardReportSumFlags) {
            String val = orgCfg.getString("value");
            boolean enable = Boolean.parseBoolean(val);
            if (!enable) continue;
            sumFlag = true;
            break;
        }
        return sumFlag;
    }

    private void showDepreUseControl(List<Long> orgPks) {
        BasedataEdit depreuseCtl = (BasedataEdit)this.getControl("depreuse");
        if (depreuseCtl == null) {
            return;
        }
        DynamicObject[] assetBook = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", orgPks)});
        HashSet<Long> depres = new HashSet<Long>(4);
        for (DynamicObject book : assetBook) {
            depres.add((Long)book.getDynamicObject("depreuse").getPkValue());
        }
        depreuseCtl.setQFilters(Collections.singletonList(new QFilter("id", "in", depres)));
        if (depres.size() > 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"depreuse"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"depreuse"});
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        ArrayList<Long> orgPks = null;
        Object orgValue = this.getModel().getValue(this.getOrgKey());
        if (orgValue instanceof DynamicObject) {
            orgPks = new ArrayList<Long>(1);
            DynamicObject org2 = (DynamicObject)orgValue;
            orgPks.add(org2.getLong("id"));
            this.showDepreUseControl(orgPks);
            return;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(this.getOrgKey());
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        Map<Long, String> orgNameMap = orgs.stream().collect(Collectors.toMap(org -> org.getLong("fbasedataid_id"), org -> org.getDynamicObject("fbasedataid").getString("name")));
        orgPks = new ArrayList<Long>(orgNameMap.keySet());
        this.showDepreUseControl(orgPks);
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        String entityId = this.getView().getEntityId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)appId, (String)entityId, (String)"47150e89000000ac");
        if (allPermOrgs.hasAllOrgPerm()) {
            return;
        }
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        HashSet<Long> noPermOrgs = new HashSet<Long>(orgNameMap.size());
        for (Map.Entry<Long, String> orgEntry : orgNameMap.entrySet()) {
            if (hasPermOrgs.contains(orgEntry.getKey())) continue;
            noPermOrgs.add(orgEntry.getKey());
        }
        if (noPermOrgs.isEmpty()) {
            return;
        }
        ArrayList<String> orgNames = new ArrayList<String>(noPermOrgs.size());
        for (Long orgId : noPermOrgs) {
            orgNames.add(orgNameMap.get(orgId));
        }
        orgNames.removeIf(Objects::isNull);
        this.logger.warn("\u65b9\u6848\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5b58\u5728\u65e0\u6743\u9650\u7684\u9009\u9879\uff0c\u5df2\u81ea\u52a8\u6e05\u9664\u3002\u6e05\u9664\u7ec4\u7ec7\u5217\u8868:" + String.join((CharSequence)",", orgNames));
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5b58\u5728\u65e0\u6743\u9650\u7684\u9009\u9879\uff0c\u5df2\u81ea\u52a8\u6e05\u9664\u3002", (String)"AbstractFaRptFormPlugin_01", (String)"fi-fa-report", (Object[])new Object[0]), String.join((CharSequence)",", orgNames)));
        Object[] newOrgs = orgs.stream().filter(org -> !noPermOrgs.contains(org.getLong("fbasedataid_id"))).map(org -> org.getLong("fbasedataid_id")).toArray();
        this.getModel().setValue(this.getOrgKey(), (Object)newOrgs);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection sortEntry;
        super.verifyQuery(queryParam);
        if (this.getModel().getDataEntityType().getProperties().get((Object)SORT_ENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(SORT_ENTRY))) {
            HashSet<String> fieldSet = new HashSet<String>(10);
            for (DynamicObject sortRow : sortEntry) {
                if (StringUtils.isEmpty((String)sortRow.getString(SORT_ENTRY_FIELD))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"AbstractFaRptFormPlugin_03", (String)"fi-fa-report", (Object[])new Object[0]));
                    return false;
                }
                if (fieldSet.add(sortRow.getString(SORT_ENTRY_FIELD))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"AbstractFaRptFormPlugin_02", (String)"fi-fa-report", (Object[])new Object[0]));
                return false;
            }
            this.setOtherEntryFilter(queryParam.getFilter());
        }
        return true;
    }

    public void entryRowClick(RowClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if (SORT_ENTRY.equals(entryname)) {
            ComboEdit ordfieldEdit = (ComboEdit)this.getControl(SORT_ENTRY_FIELD);
            ComboProp ordFieldProp = (ComboProp)this.getModel().getEntryEntity(SORT_ENTRY).getDynamicObjectType().getProperty(SORT_ENTRY_FIELD);
            List comboItems = ordFieldProp.getComboItems();
            DynamicObjectCollection sortEntry = this.getModel().getEntryEntity(SORT_ENTRY);
            HashSet<String> existsFields = new HashSet<String>(sortEntry.size());
            for (DynamicObject sortRow : sortEntry) {
                String ordfield = sortRow.getString(SORT_ENTRY_FIELD);
                existsFields.add(ordfield);
            }
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
            for (ValueMapItem comboItem : comboItems) {
                ComboItem editItem = new ComboItem(comboItem.getName(), comboItem.getValue());
                if (existsFields.contains(comboItem.getValue())) {
                    editItem.setItemVisible(false);
                } else {
                    editItem.setItemVisible(true);
                }
                items.add(editItem);
            }
            ordfieldEdit.setComboItems(items);
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection sortEntry;
        super.setOtherEntryFilter(filterInfo);
        if (this.getModel().getDataEntityType().getProperties().get((Object)SORT_ENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(SORT_ENTRY))) {
            HashMap otherEntryFilter = new HashMap();
            ArrayList<SortField> saveEntrys = new ArrayList<SortField>();
            for (DynamicObject sortRow : sortEntry) {
                String field = sortRow.getString(SORT_ENTRY_FIELD);
                String type = sortRow.getString(SORT_ENTRY_TYPE);
                if (StringUtils.isEmpty((String)field) || StringUtils.isEmpty((String)type)) continue;
                SortField sortField = new SortField(field, type);
                saveEntrys.add(sortField);
            }
            otherEntryFilter.put(SORT_ENTRY, saveEntrys);
            filterInfo.setOtherEntryFilter(otherEntryFilter);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        DynamicObjectCollection sortEntry;
        super.loadOtherEntryFilter(scheme);
        if (scheme.getDataEntityType().getProperties().get((Object)SORT_ENTRY) != null && (sortEntry = scheme.getDynamicObjectCollection(SORT_ENTRY)) != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(SORT_ENTRY);
            model.batchCreateNewEntryRow(SORT_ENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(SORT_ENTRY_FIELD, (Object)sortRow.getString(SORT_ENTRY_FIELD), i);
                model.setValue(SORT_ENTRY_TYPE, (Object)sortRow.getString(SORT_ENTRY_TYPE), i);
            }
            model.endInit();
            this.getView().updateView(SORT_ENTRY);
        }
    }
}

