/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;
import kd.fi.fa.report.formplugin.DepreSplitAssInfo;
import kd.fi.fa.report.util.FaReportUtils;

public class FaAssetListPlugin
extends AbstractFaRptFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FaAssetListPlugin.class);
    private static String showFilterFields;

    public void afterBindData(EventObject e) {
        Object commFilter;
        ReportQueryParam reportQueryParam;
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ReportShowParameter && Objects.nonNull(reportQueryParam = ((ReportShowParameter)formShowParameter).getReportQueryParam()) && Objects.nonNull(commFilter = reportQueryParam.getCustomParam().get("assetTreeReportCommFilterCondition"))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)commFilter.toString(), FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void initialize() {
        ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
        showFilterFields = rf.getShowFilterFields();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        ReportFilter rf = (ReportFilter)this.getView().getControl("reportfilterap");
        FilterInfo filterCondition = queryParam.getFilter();
        if (filterCondition.getBoolean("list_initcard")) {
            String newShowFilter = showFilterFields.replace(",\"q_period\"", "");
            rf.setShowFilterFields(newShowFilter);
        } else {
            rf.setShowFilterFields(showFilterFields);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_qing_asset_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            List columns = reportList.getColumns();
            showParameter.setCustomParam("columns", (Object)SerializationUtils.serializeToBase64((Object)columns));
            view.showForm(showParameter);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("q_org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
            param.getListFilterParameter().setQFilters(collect);
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map assetBooksMap;
        ReportQueryParam reportQueryParam;
        Long orgId = null;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ReportShowParameter && Objects.nonNull(reportQueryParam = ((ReportShowParameter)formShowParameter).getReportQueryParam())) {
            FilterInfo filter = reportQueryParam.getFilter();
            FilterItemInfo filterItem = filter.getFilterItem("q_org");
            orgId = filterItem.getLong();
        }
        if (Objects.isNull(orgId)) {
            orgId = RequestContext.get().getOrgId();
        }
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        boolean isShowDepre = false;
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"FaAssetListPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"org,startperiod,curperiod", null);
            for (DynamicObject assetBook : assetBooksMap.values()) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            if (ids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"FaAssetListPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            }
        } else {
            assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)});
            for (DynamicObject assetBook : assetBooksMap.values()) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"FaAssetListPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        list.add(new QFilter("id", "in", ids));
        orgBd.setQFilters(list);
        if (!ids.contains(orgId)) {
            orgId = (Long)new ArrayList(ids).get(0);
        }
        this.getModel().setValue("q_org", (Object)new Long[]{orgId});
        assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgId)});
        DynamicObject[] assetBook = assetBooksMap.values().toArray(new DynamicObject[0]);
        if (assetBook.length > 1) {
            isShowDepre = true;
        }
        this.getModel().setValue("depreuse", assetBook[0].getDynamicObject("depreuse").getPkValue());
        this.getView().setVisible(Boolean.valueOf(isShowDepre), new String[]{"depreuse"});
        this.changeFilterPanel(assetBook, true);
    }

    private void changeFilterPanel(DynamicObject[] assetbooks, boolean isHideDepre) {
        boolean bl;
        IDataModel model = this.getModel();
        if (assetbooks == null || assetbooks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAssetListPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period");
        BasedataEdit q_Depre = (BasedataEdit)this.getControl("depreuse");
        BasedataEdit q_peroidType = (BasedataEdit)this.getControl("periodtype");
        long mixPeriod = 0L;
        long compareMixPeriod = 0L;
        long maxPeriod = 99999999L;
        long compareMaxPeriod = 99999999L;
        DynamicObject compareMaxAssetBook = null;
        HashMap<String, DynamicObject> regDepreuseMap = new HashMap<String, DynamicObject>();
        HashSet<Long> depres = new HashSet<Long>(6);
        HashSet<Long> periodTypes = new HashSet<Long>(assetbooks.length + 1);
        DynamicObject periodType = assetbooks[0].getDynamicObject("periodtype");
        long periodTypeIdTemp = (Long)periodType.getPkValue();
        periodTypes.add(periodTypeIdTemp);
        for (DynamicObject assetBook : assetbooks) {
            String key;
            DynamicObject tempAssetBook;
            DynamicObject dynamicObject;
            DynamicObject org = assetBook.getDynamicObject("org");
            DynamicObject assetPeriodType = assetBook.getDynamicObject("periodtype");
            periodTypes.add(assetPeriodType.getLong("id"));
            depres.add((Long)assetBook.getDynamicObject("depreuse").getPkValue());
            if (periodTypeIdTemp != assetPeriodType.getLong("id") || (dynamicObject = assetBook.getDynamicObject("startperiod")) == null) continue;
            long startPeriodId = Long.parseLong(dynamicObject.getString("number"));
            DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
            if (currentPeriod == null) continue;
            long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
            if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                mixPeriod = (Long)dynamicObject.getPkValue();
                compareMixPeriod = startPeriodId;
            }
            if ((tempAssetBook = (DynamicObject)regDepreuseMap.get(key = assetBook.getDynamicObject("depreuse").getString("number"))) == null) {
                regDepreuseMap.put(key, assetBook);
                continue;
            }
            DynamicObject tempMaxPeriod = tempAssetBook.getDynamicObject("curperiod");
            long tempMaxPeriodId = Long.parseLong(tempMaxPeriod.getString("number"));
            if (currentPeriodId <= tempMaxPeriodId) continue;
            regDepreuseMap.put(key, assetBook);
        }
        DynamicObject q_DepreNum = (DynamicObject)this.getModel().getValue("depreuse");
        Boolean flag = Boolean.TRUE;
        if (q_DepreNum != null && flag.booleanValue()) {
            compareMaxAssetBook = (DynamicObject)regDepreuseMap.get(q_DepreNum.getString("number"));
            if (null != compareMaxAssetBook) {
                DynamicObject maxPeriodObj = compareMaxAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            } else {
                flag = Boolean.FALSE;
            }
        }
        if (!flag.booleanValue() || null == q_DepreNum) {
            DynamicObject maxPeriodObj;
            DynamicObject ismainAssetBook = null;
            String firstDepreuseNumber = null;
            DynamicObject firstDepreuseAssetBook = null;
            for (Map.Entry entry : regDepreuseMap.entrySet()) {
                String key = (String)entry.getKey();
                DynamicObject valueObj = (DynamicObject)entry.getValue();
                Boolean ismainbook = valueObj.getBoolean("ismainbook");
                if (ismainbook.booleanValue()) {
                    ismainAssetBook = valueObj;
                    break;
                }
                if (firstDepreuseNumber == null) {
                    firstDepreuseNumber = key;
                    firstDepreuseAssetBook = valueObj;
                    continue;
                }
                if (Long.getLong(firstDepreuseNumber) <= Long.getLong(key)) continue;
                firstDepreuseNumber = key;
                firstDepreuseAssetBook = valueObj;
            }
            if (ismainAssetBook != null) {
                compareMaxAssetBook = ismainAssetBook;
                maxPeriodObj = compareMaxAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            } else if (firstDepreuseAssetBook != null) {
                compareMaxAssetBook = firstDepreuseAssetBook;
                maxPeriodObj = firstDepreuseAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            }
        }
        if (compareMaxAssetBook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\u671f\u95f4\u7684\u9ed8\u8ba4\u503c\u3002", (String)"FaAssetListPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
        if (isHideDepre) {
            q_Depre.setQFilter(new QFilter("id", "in", depres));
        }
        q_peroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
        Object qPeriodValue = model.getValue("q_period");
        if (Objects.isNull(qPeriodValue)) {
            model.setValue("q_period", (Object)maxPeriod);
        }
        q_peroidType.setQFilter(new QFilter("id", "in", periodTypes));
        DynamicObject depreUse = compareMaxAssetBook.getDynamicObject("depreuse");
        model.setValue("depreuse", depreUse.getPkValue());
        model.setValue("periodtype", periodTypes.toArray()[0]);
        boolean visible1 = true;
        if (depres.size() == 1 && isHideDepre) {
            visible1 = false;
        }
        this.getView().setVisible(Boolean.valueOf(visible1), new String[]{"depreuse"});
        boolean bl2 = true;
        if (periodTypes.size() == 1) {
            bl = false;
        }
        this.getView().setVisible(Boolean.valueOf(bl), new String[]{"periodtype"});
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        queryParam.getCustomParam().put("pageId", FaReportUtils.getRptCacheKey(view.getPageId()));
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        if (orgs == null || orgs.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetListPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaAssetListPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("q_period") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"FaAssetListPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("periodtype") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u3002", (String)"FaAssetListPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getPkValue());
        }
        QFilter qorg = new QFilter("org", "in", orgIds);
        QFilter qdepreUse = new QFilter("depreuse", "=", filterCondition.getDynamicObject("depreuse").getPkValue());
        DynamicObject assetbook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"basecurrency", (QFilter[])new QFilter[]{qorg, qdepreUse});
        if (assetbook == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAssetListPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        queryParam.getCustomParam().put("enableSum", String.valueOf(this.needSum("fa_rpt_card", orgIds)));
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
        if (orgs == null || orgs.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetListPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter forg = new QFilter("org", "in", orgIds);
        if (propName.equals("q_org")) {
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype,ismainbook", (QFilter[])new QFilter[]{forg});
            DynamicObject mainAssetbook = null;
            mainAssetbook = this.getMainAssetbook(assetBooks);
            if (mainAssetbook != null) {
                this.getModel().setValue("depreuse", (Object)mainAssetbook.getDynamicObject("depreuse"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u4e3b\u8d26\u7c3f\u3002", (String)"FaAssetListPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
            }
            this.changeFilterPanel(assetBooks, true);
        } else if (propName.equals("depreuse")) {
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetListPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype,ismainbook", (QFilter[])new QFilter[]{forg, fdepreuse});
            this.changeFilterPanel(assetBooks, false);
        } else if (propName.equals("periodtype")) {
            QFilter fperiodType;
            BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period");
            long mixPeriod = 0L;
            long compareMixPeriod = 0L;
            long maxPeriod = 99999999L;
            long compareMaxPeriod = 99999999L;
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg, fdepreuse, fperiodType = new QFilter("periodtype", "=", periodType.getPkValue())});
            if (assetBooks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u671f\u95f4\u7c7b\u578b\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaAssetListPlugin_12", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject assetBook : assetBooks) {
                DynamicObject startPeriod = assetBook.getDynamicObject("startperiod");
                if (startPeriod == null) continue;
                long startPeriodId = Long.parseLong(startPeriod.getString("number"));
                DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
                if (currentPeriod == null) continue;
                long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
                if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                    mixPeriod = (Long)startPeriod.getPkValue();
                    compareMixPeriod = startPeriodId;
                }
                if (compareMaxPeriod != 99999999L && currentPeriodId >= compareMaxPeriod) continue;
                maxPeriod = (Long)currentPeriod.getPkValue();
                compareMaxPeriod = currentPeriodId;
            }
            List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
            q_peroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
            model.setValue("q_period", (Object)maxPeriod);
        }
    }

    private DynamicObject getMainAssetbook(DynamicObject[] assetBooks) {
        for (DynamicObject assetbook : assetBooks) {
            if (!assetbook.getBoolean("ismainbook")) continue;
            return assetbook;
        }
        return null;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (rowData.isEmpty()) {
            return;
        }
        this.appendCardDepreSplitMsg(rowData, queryParam);
    }

    private void appendCardDepreSplitMsg(DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        List<DepreSplitAssInfo> assInfoList;
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObject depreUse = filterCondition.getDynamicObject("depreuse");
        DynamicObject period = filterCondition.getDynamicObject("q_period");
        HashSet<Long> orgIdSet = new HashSet<Long>(4);
        HashSet<Long> realCardIdSet = new HashSet<Long>(rowData.size());
        HashSet<Object> fincardIds = new HashSet<Object>(rowData.size());
        for (DynamicObject row : rowData) {
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard == null) continue;
            Object fincardId = row.get(Fa.id((String)"fid"));
            fincardIds.add(fincardId);
            Long orgId = row.getLong("assetbook.id");
            orgIdSet.add(orgId);
            realCardIdSet.add(realCard.getLong("id"));
        }
        DynamicObjectCollection realCardMaster = QueryServiceHelper.query((String)"fa_card_real", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIdSet)});
        HashMap<Long, Long> realCardMasterMap = new HashMap<Long, Long>(realCardMaster.size());
        for (DynamicObject realCard : realCardMaster) {
            realCardMasterMap.put(realCard.getLong("id"), realCard.getLong("masterid"));
        }
        QFilter[] splitSetUpFilters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("beginperiod", "<=", period.getPkValue()), new QFilter("endperiod", ">", period.getPkValue()), new QFilter("depreuse", "=", depreUse.getPkValue()), new QFilter("createorg", "in", orgIdSet), new QFilter("realcard", "in", realCardMasterMap.values())};
        DynamicObject[] depreSplitSetup = BusinessDataServiceHelper.load((String)"fa_depresplitsetup", (String)"createorg.id createorg, depreuse.id depreuse, realcard.id realcard, assentry.orgduty, assentry.orgduty.name, assentry.percent, assentry.assinfo, assentry.assinfoimport", (QFilter[])splitSetUpFilters);
        boolean hasSplitSchema = false;
        HashMap<Long, Map<DynamicObject, String>> orgSchemeMap = new HashMap<Long, Map<DynamicObject, String>>(orgIdSet.size());
        for (Long orgId : orgIdSet) {
            Map<DynamicObject, String> splitSchemaMap = FaAssetListPlugin.getOrgDepreSplitSchema(orgId, Long.parseLong(depreUse.getPkValue().toString()));
            if (splitSchemaMap == null || splitSchemaMap.size() <= 0) continue;
            orgSchemeMap.put(orgId, splitSchemaMap);
        }
        boolean bl = hasSplitSchema = orgSchemeMap.size() > 0;
        if (!(hasSplitSchema || depreSplitSetup != null && depreSplitSetup.length != 0)) {
            return;
        }
        HashMap<String, BasedataEntityType> bosEntityTypeMap = new HashMap<String, BasedataEntityType>(20);
        HashMap<String, String> bosEntityNameMap = new HashMap<String, String>(20);
        HashSet<Long> asstDataIdSet = new HashSet<Long>(10);
        HashMap<String, String> asstGroupNameMap = new HashMap<String, String>(20);
        HashMap<Long, DepreSplitAssInfo> orgSchemaAssInfo = new HashMap<Long, DepreSplitAssInfo>(orgIdSet.size());
        HashSet<String> schemaConfigFields = new HashSet<String>(6);
        for (Map.Entry entry : orgSchemeMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Map orgSplitSchema = (Map)entry.getValue();
            DepreSplitAssInfo depreSplitAssInfo = new DepreSplitAssInfo();
            for (Map.Entry entry2 : orgSplitSchema.entrySet()) {
                DynamicObject assType = (DynamicObject)entry2.getKey();
                String valueType = assType.getString("valuetype");
                String bizNum = "";
                String string = "";
                if ("1".equals(valueType)) {
                    bizNum = assType.getString("valuesource.number");
                    String string2 = assType.getString("valuesource.name");
                    if (!bosEntityNameMap.containsKey(bizNum)) {
                        bosEntityNameMap.put(bizNum, string2);
                    }
                    if (!bosEntityTypeMap.containsKey(bizNum)) {
                        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)bizNum);
                        bosEntityTypeMap.put(bizNum, dataEntityType);
                    }
                    String nameProperty = ((BasedataEntityType)bosEntityTypeMap.get(bizNum)).getNameProperty();
                    depreSplitAssInfo.addSchemaBaseDataInfo(bizNum, 0L, Fa.dot((String[])new String[]{(String)entry2.getValue(), nameProperty}));
                    continue;
                }
                if (!"2".equals(valueType)) continue;
                bizNum = assType.getString("assistanttype.id");
                String string3 = assType.getString("assistanttype.name");
                asstGroupNameMap.put(bizNum, string3);
                depreSplitAssInfo.assSchemaAsstDataInfo(bizNum, Fa.dot((String[])new String[]{(String)entry2.getValue(), "name"}));
            }
            orgSchemaAssInfo.put(orgId, depreSplitAssInfo);
            List<String> schemaAssValueField = depreSplitAssInfo.getSchemaAssValueField();
            schemaConfigFields.addAll(schemaAssValueField);
        }
        HashSet<String> selectFields = new HashSet<String>(schemaConfigFields.size());
        for (String field : schemaConfigFields) {
            if (field.startsWith("fincard.")) {
                selectFields.add(field.replaceFirst("fincard\\.", "") + " as " + field);
                continue;
            }
            selectFields.add(field);
        }
        selectFields.add("id");
        selectFields.add("realcard.headusedept");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fa_card_fin", (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{new QFilter("id", "in", fincardIds)});
        Map<Object, DynamicObject> extraFinCardMap = dynamicObjectCollection.stream().collect(Collectors.toMap(c -> c.get("id"), c -> c));
        Map<Long, String> orgDutyNameMap = null;
        if (hasSplitSchema) {
            Set<Long> headUseDepts = dynamicObjectCollection.stream().map(c -> c.getLong("realcard.headusedept")).collect(Collectors.toSet());
            orgDutyNameMap = FaAssetListPlugin.getOrgDuty(headUseDepts);
        } else {
            orgDutyNameMap = Collections.emptyMap();
        }
        HashMap<String, Set<Long>> baseDataKeyMap = new HashMap<String, Set<Long>>(10);
        HashMap<String, List<DepreSplitAssInfo>> cardAssInfoMap = new HashMap<String, List<DepreSplitAssInfo>>(depreSplitSetup.length);
        for (DynamicObject setup : depreSplitSetup) {
            long l = setup.getLong("createorg.id");
            long depreuseId = setup.getLong("depreuse.id");
            long realcardId = setup.getLong("realcard.id");
            String key = l + "." + depreuseId + "." + realcardId;
            DynamicObjectCollection assentry = setup.getDynamicObjectCollection("assentry");
            assInfoList = new ArrayList(assentry.size());
            cardAssInfoMap.put(key, assInfoList);
            for (DynamicObject detail : assentry) {
                long orgDuty = detail.getLong("orgduty.id");
                String orgDutyName = detail.getString("orgduty.name");
                BigDecimal percent = detail.getBigDecimal("percent");
                String assinfo = detail.getString("assinfo");
                String assinfoimport = detail.getString("assinfoimport");
                String[] assGroups = assinfo.split(";");
                String[] assImportGroups = assinfoimport.split(",");
                DepreSplitAssInfo depreSplitAssInfo = new DepreSplitAssInfo();
                depreSplitAssInfo.setOrgDutyName(orgDutyName);
                depreSplitAssInfo.setPercent(percent);
                assInfoList.add(depreSplitAssInfo);
                for (int i = 0; i < assGroups.length; ++i) {
                    String assGroup = assGroups[i];
                    String importGroup = assImportGroups[i];
                    String[] split = assGroup.split("\\|");
                    String bizNum = split[0];
                    String bizDataId = split[1];
                    if (importGroup.startsWith("[2]")) {
                        depreSplitAssInfo.addAsstData(bizNum, Long.parseLong(bizDataId));
                        asstDataIdSet.add(Long.parseLong(bizDataId));
                        continue;
                    }
                    depreSplitAssInfo.addBaseDataInfo(bizNum, Long.parseLong(bizDataId));
                    this.putKeyMap(baseDataKeyMap, bizNum, Long.parseLong(bizDataId));
                }
            }
        }
        HashMap<String, Map<Object, DynamicObject>> hashMap = new HashMap<String, Map<Object, DynamicObject>>(baseDataKeyMap.size());
        if (baseDataKeyMap.size() > 0) {
            DynamicObject[] bosEntities = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "in", baseDataKeyMap.keySet())});
            Map<String, String> setBosEntityNameMap = Arrays.stream(bosEntities).collect(Collectors.toMap(b -> b.getString("number"), b -> b.getString("name")));
            bosEntityNameMap.putAll(setBosEntityNameMap);
            for (Map.Entry entry : baseDataKeyMap.entrySet()) {
                String bizNum = (String)entry.getKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bizNum);
                BasedataEntityType entityType = (BasedataEntityType)dataEntityType;
                String nameProp = entityType.getNameProperty();
                String numberProp = entityType.getNumberProperty();
                bosEntityTypeMap.put(bizNum, entityType);
                Map baseDataCache = BusinessDataServiceHelper.loadFromCache((String)bizNum, (String)String.join((CharSequence)",", nameProp, numberProp), (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                hashMap.put(bizNum, baseDataCache);
            }
        }
        Map<Long, DynamicObject> asstDataNameMap = new HashMap<Long, DynamicObject>(asstDataIdSet.size());
        if (asstDataIdSet.size() > 0) {
            DynamicObject[] asstData = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"id, number,name,group.id,group.name", (QFilter[])new QFilter[]{new QFilter("id", "in", asstDataIdSet)});
            asstDataNameMap = Arrays.stream(asstData).collect(Collectors.toMap(b -> b.getLong("id"), b -> b));
        }
        this.fillDepreSplitAssInfoMsg(bosEntityTypeMap, bosEntityNameMap, cardAssInfoMap, hashMap, asstDataNameMap);
        for (DynamicObject row : rowData) {
            DynamicObject dynamicObject = row.getDynamicObject("realcard");
            if (dynamicObject == null) continue;
            Object fincardId = row.get(Fa.id((String)"fid"));
            DynamicObject extraCard = extraFinCardMap.get(fincardId);
            Object orgId = row.get("assetbook.id");
            long realcardId = dynamicObject.getLong("id");
            Long masterId = (Long)realCardMasterMap.get(realcardId);
            String key = orgId + "." + depreUse.getLong("id") + "." + masterId;
            assInfoList = (List)cardAssInfoMap.get(key);
            DepreSplitAssInfo schemaAssInfo = (DepreSplitAssInfo)orgSchemaAssInfo.get(orgId);
            if (assInfoList == null && schemaAssInfo == null) continue;
            StringBuilder msgBuilder = null;
            msgBuilder = assInfoList != null ? this.appendSplitSetupMsg(bosEntityNameMap, asstGroupNameMap, extraCard, assInfoList, schemaAssInfo) : this.appendSplitSchemaMsg(bosEntityNameMap, asstGroupNameMap, extraCard, schemaAssInfo, orgDutyNameMap);
            String depresetupmsg = msgBuilder.substring(0, msgBuilder.length() - 1);
            if (depresetupmsg.length() > 500) {
                depresetupmsg = depresetupmsg.substring(0, 496) + "...";
            }
            row.set("depresetupmsg", (Object)depresetupmsg);
        }
    }

    private void fillDepreSplitAssInfoMsg(Map<String, BasedataEntityType> bosEntityTypeMap, Map<String, String> bosEntityNameMap, Map<String, List<DepreSplitAssInfo>> cardAssInfoMap, Map<String, Map<Object, DynamicObject>> baseDataNameMap, Map<Long, DynamicObject> asstDataNameMap) {
        for (Map.Entry<String, List<DepreSplitAssInfo>> entry : cardAssInfoMap.entrySet()) {
            List<DepreSplitAssInfo> depreSplitAss = entry.getValue();
            for (DepreSplitAssInfo assInfo : depreSplitAss) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append(assInfo.getOrgDutyName()).append(" ");
                msgBuilder.append(assInfo.getPercent().setScale(4, 4)).append("% ");
                for (int i = 0; i < assInfo.getDataIndex(); ++i) {
                    if (i != 0) {
                        msgBuilder.append("/");
                    }
                    if (assInfo.isBaseDataByIndex(i)) {
                        String bizNum = assInfo.getBizNum().get(i);
                        Long dataId = assInfo.getBizDataId().get(i);
                        String entityName = bosEntityNameMap.get(bizNum);
                        BasedataEntityType basedataEntityType = bosEntityTypeMap.get(bizNum);
                        Map<Object, DynamicObject> dataMap = baseDataNameMap.get(bizNum);
                        DynamicObject baseData = null;
                        if (dataMap != null) {
                            baseData = dataMap.get(dataId);
                        }
                        msgBuilder.append(entityName).append("-");
                        if (baseData == null) continue;
                        msgBuilder.append(baseData.getString(basedataEntityType.getNameProperty()));
                        continue;
                    }
                    Long dataId = assInfo.getBizDataId().get(i);
                    DynamicObject asstData = asstDataNameMap.get(dataId);
                    if (asstData == null) continue;
                    msgBuilder.append(asstData.getString("group.name")).append("-").append(asstData.getString("name"));
                }
                assInfo.setMsg(msgBuilder.toString());
            }
        }
    }

    private StringBuilder appendSplitSchemaMsg(Map<String, String> bosEntityNameMap, Map<String, String> asstGroupNameMap, DynamicObject extraCard, DepreSplitAssInfo schemaAssInfo, Map<Long, String> orgDutyNameMap) {
        StringBuilder msgBuilder = new StringBuilder();
        long useOrgId = extraCard.getLong("realcard.headusedept");
        if (orgDutyNameMap.containsKey(useOrgId)) {
            String orgDutyName = orgDutyNameMap.get(useOrgId);
            msgBuilder.append(orgDutyName).append(" ");
        }
        msgBuilder.append("100.0000% ");
        for (int i = 0; i < schemaAssInfo.getDataIndex(); ++i) {
            Object assValue;
            if (i != 0) {
                msgBuilder.append("/");
            }
            List<String> schemaAssValueField = schemaAssInfo.getSchemaAssValueField();
            if (schemaAssInfo.isBaseDataByIndex(i)) {
                String bizNum = schemaAssInfo.getBizNum().get(i);
                String bizEntityName = bosEntityNameMap.get(bizNum);
                msgBuilder.append(bizEntityName).append("-");
                assValue = extraCard.get(schemaAssValueField.get(i));
                msgBuilder.append(assValue == null ? "" : assValue);
                continue;
            }
            String asstGroupId = schemaAssInfo.getBizNum().get(i);
            String asstGroupName = asstGroupNameMap.get(asstGroupId);
            msgBuilder.append(asstGroupName).append("-");
            assValue = extraCard.get(schemaAssValueField.get(i));
            msgBuilder.append(assValue == null ? "" : assValue);
        }
        msgBuilder.append(";");
        return msgBuilder;
    }

    private StringBuilder appendSplitSetupMsg(Map<String, String> bosEntityNameMap, Map<String, String> asstGroupNameMap, DynamicObject extraCard, List<DepreSplitAssInfo> assInfoList, DepreSplitAssInfo schemaAssInfo) {
        StringBuilder msgBuilder = new StringBuilder();
        for (DepreSplitAssInfo assInfo : assInfoList) {
            Set<String> splitSetupHeadAss = assInfo.getHeadAssEntity();
            String setupMsg = assInfo.getMsg();
            if (schemaAssInfo == null) {
                msgBuilder.append(setupMsg).append(";");
                continue;
            }
            StringBuilder schemaMsgBuilder = new StringBuilder();
            for (int i = 0; i < schemaAssInfo.getDataIndex(); ++i) {
                Object assValue;
                if (splitSetupHeadAss.contains(schemaAssInfo.getBizNum().get(i))) continue;
                schemaMsgBuilder.append("/");
                List<String> schemaAssValueField = schemaAssInfo.getSchemaAssValueField();
                if (schemaAssInfo.isBaseDataByIndex(i)) {
                    String bizNum = schemaAssInfo.getBizNum().get(i);
                    String bizEntityName = bosEntityNameMap.get(bizNum);
                    schemaMsgBuilder.append(bizEntityName).append("-");
                    assValue = extraCard.get(schemaAssValueField.get(i));
                    schemaMsgBuilder.append(assValue);
                    continue;
                }
                String asstGroupId = schemaAssInfo.getBizNum().get(i);
                String asstGroupName = asstGroupNameMap.get(asstGroupId);
                schemaMsgBuilder.append(asstGroupName).append("-");
                assValue = extraCard.get(schemaAssValueField.get(i));
                schemaMsgBuilder.append(assValue == null ? "" : assValue);
            }
            msgBuilder.append(setupMsg).append((CharSequence)schemaMsgBuilder).append(";");
        }
        return msgBuilder;
    }

    private void putKeyMap(Map<String, Set<Long>> keyMap, String bizNum, Long dataId) {
        Set<Long> dataIdSet = keyMap.get(bizNum);
        if (dataIdSet == null) {
            dataIdSet = new HashSet<Long>(10);
        }
        dataIdSet.add(dataId);
        keyMap.put(bizNum, dataIdSet);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String formName = null;
        String formId = null;
        Object pkValue = null;
        if (null != rowData.get("fid")) {
            pkValue = rowData.getDynamicObject("fid").getPkValue();
        }
        if (null == pkValue) {
            return;
        }
        if (!StringUtils.isBlank((Object)pkValue) && !"0".equals(pkValue.toString())) {
            formId = "fa_card_fin";
            formName = ResManager.loadKDString((String)"\u8d44\u4ea7\u8d22\u52a1\u5361\u7247", (String)"FaAssetListPlugin_13", (String)"fi-fa-report", (Object[])new Object[0]);
            this.showTabForm(formId, pkValue);
        }
    }

    private void showTabForm(String formId, Object pkValue) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        FilterInfo filter = this.getQueryParam().getFilter();
        Long queryPeriodId = ((DynamicObject)filter.getFilterItem("q_period").getValue()).getLong("id");
        parameter.setCustomParam("queryPeriodId", (Object)queryPeriodId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private static Map<Long, String> getOrgDuty(Set<Long> orgIds) {
        HashMap<Long, String> map = new HashMap<Long, String>(orgIds.size(), 1.0f);
        String selectFields = "id,org.id orgId, orgduty.id dutyId, orgduty.name dutyName";
        QFilter groupFilter = new QFilter("orgduty.group", "=", (Object)1);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{groupFilter, orgFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"faOrgDuty", (String)"bos_org_dutyrelation", (String)selectFields, (QFilter[])filters, null);){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                map.put(row.getLong("orgId"), row.getString("dutyName"));
            }
        }
        return map;
    }

    public static Map<DynamicObject, String> getOrgDepreSplitSchema(long orgId, long depreuse) {
        return (Map)ThreadCache.get((Object)("getOrgDepreSplitSchema#" + orgId + "#" + depreuse), () -> DepreSplitDetailUtils.queryDepreSplitSchema((long)orgId, (long)depreuse));
    }
}

