/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;
import kd.fi.fa.report.formplugin.FaBlocListPlugin;

public class FaAssetRecordPlugin
extends AbstractFaRptFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FaBlocListPlugin.class);

    @Override
    public void beforeBindData(EventObject e) {
        this.setFilterFields();
    }

    private void setFilterFields() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("fa_card_fin");
        HashSet<String> filterFiledSet = new HashSet<String>();
        filterFiledSet.add("realcard.originmethod.name");
        filterFiledSet.add("number");
        filterFiledSet.add("realcard.assetname");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String keyLike = "filtergridap";
        Set<String> mapValueSet = this.getMapValueSetByLikeKey(customParams, keyLike);
        if (mapValueSet.size() > 0) {
            for (String value : mapValueSet) {
                Arrays.stream(value.split(",")).forEach(v -> filterFiledSet.add(v.trim()));
            }
        }
        filterGrid.setFilterFieldKeys(new ArrayList(filterFiledSet));
    }

    private Set<String> getMapValueSetByLikeKey(Map<String, Object> map, String keyLike) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            if (!entity.getKey().contains(keyLike)) continue;
            set.add((String)entity.getValue());
        }
        return set;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener(this::beforeFilterF7SelectEvent);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void beforeFilterF7SelectEvent(BeforeFilterF7SelectEvent evt) {
        DynamicObjectCollection orgDynObjList = (DynamicObjectCollection)this.getModel().getValue("q_org");
        HashSet<Long> orgIdSet = new HashSet<Long>(orgDynObjList.size());
        for (DynamicObject orgDynObj : orgDynObjList) {
            Long orgId = orgDynObj.getLong("fbasedataid_id");
            orgIdSet.add(orgId);
        }
        List filters = evt.getQfilters();
        String fieldName = evt.getFieldName();
        if (fieldName.equals("realcard.assetname")) {
            DynamicObjectCollection faCardRealDynObjList = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet)});
            Set realCardIdSet = faCardRealDynObjList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            filters.add(new QFilter("id", "in", realCardIdSet));
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            if (!"1".equals(row.getString("rowtype").trim())) continue;
            row.set("assetcat", (Object)"");
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        if (orgs == null || orgs.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetRecordPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getPkValue());
        }
        if (filterCondition.getFilterItem("period_start").getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"FaAssetRecordPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getFilterItem("period_end").getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"FaAssetRecordPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaAssetRecordPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        QFilter qorg = new QFilter("org", "in", orgIds);
        QFilter qdepreUse = new QFilter("depreuse", "=", filterCondition.getDynamicObject("depreuse").getPkValue());
        DynamicObject[] assetBookDynObjArray = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{qorg, qdepreUse});
        if (assetBookDynObjArray == null || assetBookDynObjArray.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaAssetRecordPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        HashSet<Long> periodTypeId = new HashSet<Long>(assetBookDynObjArray.length);
        for (DynamicObject assetBookDynObj : assetBookDynObjArray) {
            DynamicObject dynamicObject = assetBookDynObj.getDynamicObject("periodtype");
            periodTypeId.add((Long)dynamicObject.getPkValue());
        }
        if (periodTypeId.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"FaAssetRecordPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObject periodStart = filterCondition.getDynamicObject("period_start");
        DynamicObject periodEnd = filterCondition.getDynamicObject("period_end");
        if (periodStart != null && periodEnd != null && FaPeriodUtils.compare2period((long)((Long)periodStart.getPkValue()), (long)((Long)periodEnd.getPkValue())) == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5f00\u59cb\u671f\u95f4\u665a\u4e8e\u67e5\u8be2\u7684\u7ed3\u675f\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FaAssetRecordPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetRecordPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            DynamicObject[] assetBooks;
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,curperiod", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            if (ids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetRecordPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            }
        } else {
            for (DynamicObject assetBook : BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)})) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetRecordPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        list.add(new QFilter("id", "in", ids));
        orgBd.setQFilters(list);
        if (!ids.contains(curLoginOrg)) {
            curLoginOrg = (Long)new ArrayList(ids).get(0);
        }
        this.getModel().setValue("q_org", (Object)new Long[]{curLoginOrg});
        DynamicObject[] assetBook = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)curLoginOrg)});
        this.getModel().setValue("q_org", (Object)new Long[]{curLoginOrg});
        this.changeFilterPanel(assetBook);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (propName.equals("q_org")) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
            if (orgs == null || orgs.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetRecordPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            LinkedList<Object> orgIds = new LinkedList<Object>();
            for (DynamicObject org : orgs) {
                orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
            }
            QFilter forg = new QFilter("org", "in", orgIds);
            DynamicObject[] assetBook = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod, ismainbook", (QFilter[])new QFilter[]{forg});
            this.orgChangeFilterPanel(assetBook);
        } else if (propName.equals("depreuse") && null == this.getPageCache().get("orgchange")) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
            if (orgs == null || orgs.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetRecordPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetRecordPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            LinkedList<Object> orgIds = new LinkedList<Object>();
            for (DynamicObject org : orgs) {
                orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
            }
            QFilter forg = new QFilter("org", "in", orgIds);
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBook = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{forg, fdepreuse});
            this.changeFilterPanel(assetBook);
        } else if (propName.equals("period_start")) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("period_start");
            DynamicObject endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_end", startPeriod.getPkValue());
            }
        } else if (propName.equals("period_end")) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("period_start");
            DynamicObject endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_start", endPeriod.getPkValue());
            }
        }
    }

    private void changeFilterPanel(DynamicObject[] assetbook) {
        IDataModel model = this.getModel();
        if (assetbook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAssetRecordPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit start = (BasedataEdit)this.getControl("period_start");
        BasedataEdit end = (BasedataEdit)this.getControl("period_end");
        HashSet periodIdSet = new HashSet(1);
        HashSet<Long> depreUseSet = new HashSet<Long>(1);
        for (DynamicObject book : assetbook) {
            DynamicObject[] depreUses;
            DynamicObject enablePeriod = book.getDynamicObject("startperiod");
            if (enablePeriod == null) {
                start.setQFilter(new QFilter("id", "=", null));
                end.setQFilter(new QFilter("id", "=", null));
                model.setValue("period_start", null);
                model.setValue("period_end", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaAssetRecordPlugin_12", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            DynamicObject currentPeriod = book.getDynamicObject("curperiod");
            long currentPeriodPk = (Long)currentPeriod.getPkValue();
            List periodIds = FaPeriodUtils.getPeriodIdByRange((long)((Long)enablePeriod.getPkValue()), (long)currentPeriodPk);
            periodIdSet.addAll(periodIds);
            model.setValue("period_start", (Object)currentPeriodPk);
            model.setValue("period_end", (Object)currentPeriodPk);
            model.setValue("depreuse", (Object)book.getLong(FaDaoOrmImpl.id((String)"depreuse")));
            this.getPageCache().put("orgchange", "orgchange");
            DynamicObject org = book.getDynamicObject("org");
            for (DynamicObject depreUse : depreUses = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"depreuse", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue())})) {
                depreUseSet.add(depreUse.getLong("depreuse.id"));
            }
        }
        if (depreUseSet.size() == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"depreuse"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"depreuse"});
        }
        start.setQFilter(new QFilter("id", "in", periodIdSet));
        end.setQFilter(new QFilter("id", "in", periodIdSet));
        this.getPageCache().remove("orgchange");
    }

    private void orgChangeFilterPanel(DynamicObject[] assetbook) {
        IDataModel model = this.getModel();
        if (assetbook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAssetRecordPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit start = (BasedataEdit)this.getControl("period_start");
        BasedataEdit end = (BasedataEdit)this.getControl("period_end");
        HashSet periodIdSet = new HashSet(1);
        DynamicObject enablePeriod = null;
        DynamicObject currentPeriod = null;
        for (DynamicObject book : assetbook) {
            if (null == enablePeriod) {
                enablePeriod = book.getDynamicObject("startperiod");
            } else if (FaPeriodUtils.compare2period((long)((Long)book.getDynamicObject("startperiod").getPkValue()), (long)((Long)enablePeriod.getPkValue())) <= 0) {
                enablePeriod = book.getDynamicObject("startperiod");
            }
            if (null == currentPeriod) {
                currentPeriod = book.getDynamicObject("curperiod");
            } else if (FaPeriodUtils.compare2period((long)((Long)book.getDynamicObject("curperiod").getPkValue()), (long)((Long)currentPeriod.getPkValue())) >= 0) {
                currentPeriod = book.getDynamicObject("curperiod");
            }
            if (enablePeriod != null) continue;
            start.setQFilter(new QFilter("id", "=", null));
            end.setQFilter(new QFilter("id", "=", null));
            model.setValue("period_start", null);
            model.setValue("period_end", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaAssetRecordPlugin_12", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        HashSet periodIds = new HashSet(1);
        if (enablePeriod != null && currentPeriod != null) {
            List periodIdByRange = FaPeriodUtils.getPeriodIdByRange((long)((Long)enablePeriod.getPkValue()), (long)((Long)currentPeriod.getPkValue()));
            periodIds.addAll(periodIdByRange);
        }
        periodIdSet.addAll(periodIds);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject filterDepreUse = dataEntity.getDynamicObject("depreuse");
        if (filterDepreUse != null) {
            long depreUseId = filterDepreUse.getLong("id");
            Set depreUseIdSet = Arrays.stream(assetbook).map(v -> v.getLong(Fa.id((String)"depreuse"))).collect(Collectors.toSet());
            if (!depreUseIdSet.contains(depreUseId)) {
                DynamicObject depreUse = null;
                for (DynamicObject book : assetbook) {
                    depreUse = book.getDynamicObject("depreuse");
                    if (book.getBoolean("ismainbook")) break;
                }
                dataEntity.set("depreuse", depreUse);
            }
        }
        if (assetbook.length == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"depreuse"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"depreuse"});
        }
        start.setQFilter(new QFilter("id", "in", periodIdSet));
        end.setQFilter(new QFilter("id", "in", periodIdSet));
        this.getPageCache().remove("orgchange");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_asset_record_qing");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            Map customParam = this.getQueryParam().getCustomParam();
            if (customParam.containsKey("isNotData")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u8f7b\u5206\u6790\u3002", (String)"FaAssetRecordPlugin_13", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            List columns = reportList.getColumns();
            showParameter.setCustomParam("columns", (Object)SerializationUtils.serializeToBase64((Object)columns));
            view.showForm(showParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        if ("vouchernumber".equals(fieldName)) {
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String voucherIds = rowData.getString("voucherids");
            if (StringUtils.isEmpty((String)voucherIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1ID\u4e0d\u5b58\u5728\u3002", (String)"FaAssetRecordPlugin_14", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            List<Long> voucherIdList = Arrays.stream(voucherIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            if (voucherIdList.size() == 1) {
                Long voucherId = (Long)voucherIdList.get(0);
                String title = ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"FaAssetRecordPlugin_15", (String)"fi-fa-report", (Object[])new Object[0]);
                FaUtils.showTabForm((String)"gl_voucher", (String)title, (Object)voucherId, (IFormView)this.getView(), (OperationStatus)OperationStatus.VIEW, (boolean)true);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("gl_voucher");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                voucherIdList.forEach(arg_0 -> ((ListShowParameter)showParameter).addLinkQueryPkId(arg_0));
                this.getView().showForm((FormShowParameter)showParameter);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

