/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SummaryEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.report.FaDepreForecastHelper;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;
import kd.fi.fa.report.util.FaReportUtils;

public class FaDepreForecastPlugin
extends AbstractFaRptFormPlugin
implements CellClickListener {
    private static Log log = LogFactory.getLog(FaDepreForecastPlugin.class);
    private static final String CACHE_DELETE_TOTAL = "delete_total";

    public void setFloatButtomData(List<SummaryEvent> summaryEvents) {
        Map forecastSumMap;
        if (CollectionUtils.isEmpty(summaryEvents)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        IPageCache pageCache = this.getPageCache();
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("q_org");
        long depreuseId = filterInfo.getLong("depreuse");
        Long endPeriodId = filterInfo.getLong("q_period");
        String cacheKey = "fa_rpt_depre_forecast_sumdata_" + orgId + "_" + depreuseId + "_" + endPeriodId;
        String forecastSumMapStr = this.getPageCache().get(cacheKey);
        QFilter commFilter = filterInfo.getCommFilter("fa_card_real");
        if (commFilter != null || StringUtils.isEmpty((CharSequence)forecastSumMapStr)) {
            FaDepreForecastHelper helper = new FaDepreForecastHelper();
            forecastSumMap = helper.sumDepreForecast(queryParam, pageCache);
        } else {
            forecastSumMap = (Map)SerializationUtils.fromJsonString((String)forecastSumMapStr, Map.class);
        }
        if (forecastSumMap != null && !forecastSumMap.isEmpty()) {
            summaryEvents.stream().forEach(t -> {
                t.setSrcSummaryValue(forecastSumMap.get(t.getColumnName()));
                t.setFormatSummaryValue(forecastSumMap.get(t.getColumnName()));
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"deprehelp"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("fa_card_real");
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList("billno", "number", "assetname", "assetcat"));
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        Collection values = type.getAllFields().values();
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        for (Object iDataEntityProperty : values) {
            if (!fieldSet.contains(iDataEntityProperty.getName()) || !(iDataEntityProperty instanceof IFieldHandle)) continue;
            if (iDataEntityProperty.getName().equals("assetcat")) {
                List createFilterFields = ((IFieldHandle)iDataEntityProperty).createFilterFields(type);
                for (FilterField filterField : createFilterFields) {
                    if (!"assetcat.number".equals(filterField.getFieldName()) && !"assetcat.name".equals(filterField.getFieldName())) continue;
                    filterFields.add(filterField);
                }
                continue;
            }
            filterFields.addAll(((IFieldHandle)iDataEntityProperty).createFilterFields(type));
        }
        ArrayList<Map> filterColumns = new ArrayList<Map>(filterFields.size());
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
        long defaultOrgId = this.initQOrg();
        if (defaultOrgId == 0L) {
            return;
        }
        this.setQueryComponents(defaultOrgId);
    }

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener(evt -> this.beforeDeptSelect(evt));
    }

    private void beforeDeptSelect(BeforeFilterF7SelectEvent evt) {
        List filters = evt.getQfilters();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("q_org");
        if ("assetcat.name".equals(evt.getFieldName()) || "assetcat.number".equals(evt.getFieldName())) {
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(org.getLong("masterid"));
            filters.add(FaReportUtils.getAssetCateFilter(orgIds));
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        String errMsg = null;
        if (filterCondition.getValue("q_org") == null) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreForecastPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]);
        }
        if (filterCondition.getValue("depreuse") == null) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaDepreForecastPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]);
        }
        if (filterCondition.getValue("q_startperiod") == null) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u6d4b\u5f00\u59cb\u671f\u95f4\u3002", (String)"FaDepreForecastPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]);
        }
        if (filterCondition.getValue("q_period") == null) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u6d4b\u7ed3\u675f\u671f\u95f4\u3002", (String)"FaDepreForecastPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]);
        }
        if (errMsg == null) {
            DynamicObject endperiod = (DynamicObject)filterCondition.getValue("q_period");
            long endPeriodId = endperiod.getLong("id");
            DynamicObject startperiod = (DynamicObject)filterCondition.getValue("q_startperiod");
            long startPeriodId = startperiod.getLong("id");
            DynamicObject depreuse = (DynamicObject)this.getModel().getValue("depreuse");
            if (depreuse == null) {
                this.getModel().setValue("q_startperiod", null);
                this.getModel().setValue("q_period", null);
                return false;
            }
            long depreuseId = depreuse.getLong("id");
            String selectFields = Fa.comma((String[])new String[]{"id", "curperiod", "periodtype", "periodtype_id", "curperiod_id"});
            Long orgId = ((DynamicObject)this.getModel().getValue("q_org")).getLong("id");
            DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
            this.getModel().setValue("book", book.get("id"));
            long curPeriodId = (Long)book.get("curperiod_id");
            if (startPeriodId < curPeriodId) {
                errMsg = ResManager.loadKDString((String)"\u9884\u6d4b\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"FaDepreForecastPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]);
            }
            if (endPeriodId < startPeriodId) {
                errMsg = ResManager.loadKDString((String)"\u9884\u6d4b\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"FaDepreForecastPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]);
            }
        }
        if (errMsg != null) {
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("q_org");
        if (org == null) {
            this.getModel().setValue("depreuse", null);
            this.getModel().setValue("q_startperiod", null);
            this.getModel().setValue("q_period", null);
            return;
        }
        long orgId = org.getLong("id");
        if ("q_org".equals(propName)) {
            model.beginInit();
            this.setQueryComponents(orgId);
            model.endInit();
            this.getView().updateView("depreuse");
            this.getView().updateView("q_startperiod");
            this.getView().updateView("q_period");
        } else if ("depreuse".equals(propName)) {
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getModel().setValue("q_period", null);
                this.getModel().setValue("q_startperiod", null);
                return;
            }
            long depreuseId = depreuse.getLong("id");
            String selectFields = Fa.comma((String[])new String[]{"id", "curperiod", "periodtype"});
            DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
            if (book != null) {
                model.setValue("book", book.get("id"));
                this.setQPeriod(book);
            }
        } else if ("q_startperiod".equals(propName)) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("q_startperiod");
            DynamicObject endPeriod = (DynamicObject)model.getValue("q_period");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("q_period", startPeriod.getPkValue());
            }
        } else if ("q_period".equals(propName)) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("q_startperiod");
            DynamicObject endPeriod = (DynamicObject)model.getValue("q_period");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("q_startperiod", endPeriod.getPkValue());
            }
        }
    }

    private void setQueryComponents(long defaultOrgId) {
        String selectFields = Fa.comma((String[])new String[]{"id", "depreuse", "ismainbook", "curperiod", "periodtype"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter("org", "=", (Object)defaultOrgId).toArray());
        if (books.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u7ec4\u7ec7\u7684\u8d26\u7c3f\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaDepreForecastPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        HashSet<Object> depreuseIds = new HashSet<Object>();
        DynamicObject mainBook = null;
        for (DynamicObject book : books) {
            depreuseIds.add(book.get("depreuse"));
            if (!book.getBoolean("ismainbook")) continue;
            mainBook = book;
        }
        if (mainBook == null) {
            mainBook = (DynamicObject)books.get(0);
        }
        BasedataEdit q_depreuse = (BasedataEdit)this.getControl("depreuse");
        q_depreuse.setQFilter(new QFilter("id", "in", depreuseIds));
        assert (mainBook != null);
        this.getModel().setValue("depreuse", mainBook.get("depreuse"));
        this.getModel().setValue("book", mainBook.get("id"));
        this.setQPeriod(mainBook);
    }

    private void setQPeriod(DynamicObject book) {
        Object defaultCurPeriodId = book.get("curperiod");
        this.getModel().setValue("q_startperiod", defaultCurPeriodId);
        this.getModel().setValue("q_period", defaultCurPeriodId);
    }

    private long initQOrg() {
        long defaultOrgId = 0L;
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit q_org = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            q_org.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"FaDepreForecastPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return defaultOrgId;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            DynamicObject[] assetBooks;
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,curperiod,periodtype", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        } else {
            for (DynamicObject assetBook : BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)})) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7", (String)"FaDepreForecastPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            return defaultOrgId;
        }
        list.add(new QFilter("id", "in", ids));
        q_org.setQFilters(list);
        defaultOrgId = RequestContext.get().getOrgId();
        if (!ids.contains(defaultOrgId)) {
            defaultOrgId = (Long)new ArrayList(ids).get(0);
        }
        this.getModel().setValue("q_org", (Object)defaultOrgId);
        return defaultOrgId;
    }

    private void periodBeforeF7Listener(BeforeF7SelectEvent evt) {
        BasedataEdit base = (BasedataEdit)evt.getSource();
        String key = base.getKey();
        DynamicObject depreuse = (DynamicObject)this.getModel().getValue("depreuse");
        if (depreuse == null) {
            this.getModel().setValue(key, null);
            return;
        }
        long depreuseId = depreuse.getLong("id");
        String selectFields = Fa.comma((String[])new String[]{"id", "curperiod", "periodtype", "periodtype_id", "curperiod_id"});
        Long orgId = ((DynamicObject)this.getModel().getValue("q_org")).getLong("id");
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId)});
        if (book != null) {
            this.getModel().setValue("book", book.get("id"));
            Object defaultCurPeriodTypeId = book.get("periodtype_id");
            Object defaultCurPeriodId = book.get("curperiod_id");
            List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(new QFilter("periodtype", "=", defaultCurPeriodTypeId).and("id", ">=", defaultCurPeriodId).and("isadjustperiod", "=", (Object)false));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit startPeriodF7 = (BasedataEdit)this.getControl("q_startperiod");
        BasedataEdit endPeriodF7 = (BasedataEdit)this.getControl("q_period");
        startPeriodF7.addBeforeF7SelectListener(this::periodBeforeF7Listener);
        endPeriodF7.addBeforeF7SelectListener(this::periodBeforeF7Listener);
    }

    public void cellClick(CellClickEvent p0) {
    }

    public void cellDoubleClick(CellClickEvent p0) {
        if (p0.getFieldKey().equals("fseq") && p0.getRow() == 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"deprehelp"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        if ("deprehelp".equals(itemKey)) {
            int[] selectRows = reportList.getEntryState().getSelectedRows();
            IReportListModel reportModel = reportList.getReportModel();
            HashSet<Object> realCardIds = new HashSet<Object>();
            for (int selectRow : selectRows) {
                DynamicObject rowData;
                Object realCardId;
                if (selectRow < 1 || (realCardId = (rowData = reportModel.getRowData(selectRow)).get("realcard.id")).equals(0L)) continue;
                realCardIds.add(realCardId);
            }
            if (realCardIds.isEmpty()) {
                return;
            }
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("q_org");
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            DynamicObject period = (DynamicObject)model.getValue("q_period");
            DynamicObject bookObj = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", org.get("id")), new QFilter("depreuse", "=", depreuse.get("id"))});
            DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIds)});
            Set masterIdSet = realCards.stream().map(v -> v.get("masterid")).collect(Collectors.toSet());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fa_deprehelp");
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("assetBookId", bookObj.get("id"));
            data.put("masterids", masterIdSet);
            data.put("depreEndPeriodId", period.get("id"));
            parameter.setCustomParam("data", data);
            this.getView().showForm(parameter);
        } else if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_qing_depreforecast");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            List columns = reportList.getColumns();
            showParameter.setCustomParam("columns", (Object)SerializationUtils.serializeToBase64((Object)columns));
            view.showForm(showParameter);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.setAsyncTotal(true);
        reportList.setShowCount(false);
        this.getPageCache().put(CACHE_DELETE_TOTAL, "0");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate.getType().equalsIgnoreCase("exportexcel")) {
            int deleteTotal;
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            int total = reportList.getTotalRecords();
            String deleteTotalStr = this.getPageCache().get(CACHE_DELETE_TOTAL);
            int n = deleteTotal = StringUtils.isEmpty((CharSequence)deleteTotalStr) ? 0 : Integer.parseInt(deleteTotalStr);
            if (total - deleteTotal <= 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u5f15\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u5148\u67e5\u8be2\u540e\u518d\u5f15\u51fa\u3002", (String)"FaDepreForecastPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FaDepreForecastHelper helper = new FaDepreForecastHelper();
        if (rowData.isEmpty()) {
            return;
        }
        HashMap<String, DynamicObject> finNumDyObjMap = new HashMap<String, DynamicObject>(rowData.size());
        for (DynamicObject row : rowData) {
            String cardNumber = row.getString("number");
            finNumDyObjMap.put(cardNumber, row);
        }
        Set noForecastFinNumSet = finNumDyObjMap.keySet();
        DataSet dataSet = helper.queryDataSet(queryParam, finNumDyObjMap.keySet());
        for (Object row : dataSet) {
            String cardNumber = row.getString("number");
            if (!StringUtils.isNotEmpty((CharSequence)cardNumber)) continue;
            DynamicObject rowObj = (DynamicObject)finNumDyObjMap.get(cardNumber);
            helper.setDyObjFieldsFromDataSet(rowObj, (Row)row);
            noForecastFinNumSet.remove(cardNumber);
        }
        if (CollectionUtils.isNotEmpty(noForecastFinNumSet)) {
            log.info("\u5361\u7247[{}]\u56e0\u4e3a\u65e0\u6298\u65e7\u9884\u6d4b\u7ed3\u679c\uff0c\u6240\u4ee5\u5220\u9664\u6570\u636e\u884c", (Object)noForecastFinNumSet.stream().collect(Collectors.joining(",")));
            for (String cardNum : noForecastFinNumSet) {
                DynamicObject noForecastCardObj = (DynamicObject)finNumDyObjMap.get(cardNum);
                rowData.remove((Object)noForecastCardObj);
            }
            String deleteTotalStr = this.getPageCache().get(CACHE_DELETE_TOTAL);
            int deleteTotal = StringUtils.isEmpty((CharSequence)deleteTotalStr) ? 0 : Integer.parseInt(deleteTotalStr);
            this.getPageCache().put(CACHE_DELETE_TOTAL, String.valueOf(deleteTotal += noForecastFinNumSet.size()));
        }
    }
}

