/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.business.enums.report.SumFlagEnum;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;
import kd.fi.fa.report.util.FaReportUtils;

public class FaDepreciationPlugin
extends AbstractFaRptFormPlugin {
    private static final Log logger = LogFactory.getLog(FaDepreciationPlugin.class);
    private static final String FILTER_GRID_AP = "filtergridap";
    private static String[] rangefields = new String[]{"fseq", "orgname", "period", "category", "number", "realcard", "actual_depreciation"};
    private static String[] hideFields = new String[]{"billno", "number", "realcard", "prepare_use_amount", "depreciation_amount", "depreciation_method", "depreciation_rate"};
    private static String[] rangefields_hide = new String[]{"billno", "basecurrency", "category1", "summarytype", "order", "change_flag", "prepare_use_amount", "depreciation_amount", "depreciation_method", "depreciation_rate", "year_depreciation"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("q_org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
            param.getListFilterParameter().setQFilters(collect);
        });
        BasedataEdit q_StartPeroid = (BasedataEdit)this.getControl("period_start");
        q_StartPeroid.addBeforeF7SelectListener(evt -> this.setPeriodFilter());
        BasedataEdit q_EndPeroid = (BasedataEdit)this.getControl("period_end");
        q_EndPeroid.addBeforeF7SelectListener(evt -> this.setPeriodFilter());
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID_AP);
        filterGrid.addBeforeF7SelectListener(this::beforeCommonFilterF7Select);
    }

    private void setPeriodFilter() {
        QFilter fperiodType;
        IDataModel model = this.getModel();
        BasedataEdit q_StartPeroid = (BasedataEdit)this.getControl("period_start");
        BasedataEdit q_EndPeroid = (BasedataEdit)this.getControl("period_end");
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
        if (orgs == null || orgs.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter forg = new QFilter("org", "in", orgIds);
        long mixPeriod = 0L;
        long maxPeriod = 99999999L;
        DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
        DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
        if (depreuse == null || periodType == null) {
            return;
        }
        QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
        DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg, fdepreuse, fperiodType = new QFilter("periodtype", "=", periodType.getPkValue())});
        if (assetBooks.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u671f\u95f4\u7c7b\u578b\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaDepreciationPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            q_StartPeroid.setQFilter(new QFilter("id", "in", (Object)""));
            q_EndPeroid.setQFilter(new QFilter("id", "in", (Object)""));
            return;
        }
        for (DynamicObject assetBook : assetBooks) {
            DynamicObject startPeriod = assetBook.getDynamicObject("startperiod");
            if (startPeriod == null) continue;
            long startPeriodId = (Long)startPeriod.getPkValue();
            DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
            if (currentPeriod == null) continue;
            long currentPeriodId = (Long)currentPeriod.getPkValue();
            if (mixPeriod == 0L) {
                mixPeriod = startPeriodId;
            }
            if (startPeriodId < mixPeriod) {
                mixPeriod = startPeriodId;
            }
            if (maxPeriod == 99999999L) {
                maxPeriod = currentPeriodId;
            }
            if (currentPeriodId <= maxPeriod) continue;
            maxPeriod = currentPeriodId;
        }
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
        q_StartPeroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
        q_EndPeroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
    }

    private void beforeCommonFilterF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName = evt.getFieldName();
        List filters = evt.getQfilters();
        if ("assetcat.number".equals(fieldName)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("q_org");
            List<Long> orgIds = org.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
            filters.add(FaReportUtils.getAssetCateFilter(orgIds));
        }
        if ("realcard.number".equals(fieldName)) {
            filters.add(new QFilter("isbak", "=", (Object)"0"));
            DynamicObjectCollection orgList = (DynamicObjectCollection)this.getModel().getValue("q_org");
            if (orgList != null && !orgList.isEmpty()) {
                Set orgIds = orgList.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                filters.add(new QFilter("org", "in", orgIds));
            }
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID_AP);
        this.setFilterFields(filterGrid);
    }

    private void setFilterFields(FilterGrid filterGrid) {
        filterGrid.setEntityNumber("fa_card_fin");
        HashSet<String> filterFiledSet = new HashSet<String>(10);
        filterFiledSet.add("assetcat.number");
        filterFiledSet.add("assetcat.applytype");
        filterFiledSet.add("realcard.number");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String keyLike = FILTER_GRID_AP;
        Set<String> mapValueSet = this.getMapValueSetByLikeKey(customParams, keyLike);
        if (mapValueSet.size() > 0) {
            for (String value : mapValueSet) {
                Arrays.stream(value.split(",")).forEach(v -> filterFiledSet.add(v.trim()));
            }
        }
        filterGrid.setFilterFieldKeys(new ArrayList(filterFiledSet));
    }

    private Set<String> getMapValueSetByLikeKey(Map<String, Object> map, String keyLike) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            if (!entity.getKey().contains(keyLike)) continue;
            set.add((String)entity.getValue());
        }
        return set;
    }

    public void afterCreateNewData(EventObject e) {
        ReportShowParameter report = (ReportShowParameter)this.getView().getFormShowParameter();
        String hyLinkOrg = "" + report.getCustomParam("q_org");
        String hyLinkDepreuse = "" + report.getCustomParam("depreuse");
        Long curLoginOrg = null;
        curLoginOrg = hyLinkOrg == null || "".equals(hyLinkOrg) || "null".equals(hyLinkOrg) ? Long.valueOf(RequestContext.get().getOrgId()) : Long.valueOf(hyLinkOrg);
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            DynamicObject[] assetBooks;
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,curperiod,periodtype", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        } else {
            for (DynamicObject assetBook : BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)})) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null || assetBook.getDynamicObject("org") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        list.add(new QFilter("id", "in", ids));
        orgBd.setQFilters(list);
        if (!ids.contains(curLoginOrg)) {
            curLoginOrg = (Long)new ArrayList(ids).get(0);
        }
        this.getModel().setValue("q_org", (Object)new Long[]{curLoginOrg});
        DynamicObject[] assetBook = null;
        assetBook = hyLinkOrg == null || "".equals(hyLinkOrg) || "null".equals(hyLinkOrg) ? BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)curLoginOrg)}) : BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)curLoginOrg), new QFilter("depreuse", "in", (Object)Long.parseLong(hyLinkDepreuse))});
        this.changeFilterPanel(assetBook, true);
    }

    private void changeFilterPanel(DynamicObject[] assetbooks, boolean isHideDepre) {
        IDataModel model = this.getModel();
        if (assetbooks == null || assetbooks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u8d44\u4ea7\u8d26\u7c3f\u6216\u8005\u8be5\u8d44\u4ea7\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"FaDepreciationPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit start = (BasedataEdit)this.getControl("period_start");
        BasedataEdit end = (BasedataEdit)this.getControl("period_end");
        BasedataEdit q_depre = (BasedataEdit)this.getControl("depreuse");
        BasedataEdit q_peroidType = (BasedataEdit)this.getControl("periodtype");
        long mixPeriod = 0L;
        long maxPeriod = 99999999L;
        HashSet<Long> depres = new HashSet<Long>(assetbooks.length);
        HashSet<Long> periodTypes = new HashSet<Long>(assetbooks.length + 1);
        DynamicObject periodType = assetbooks[0].getDynamicObject("periodtype");
        long periodTypeIdTemp = (Long)periodType.getPkValue();
        periodTypes.add(periodTypeIdTemp);
        for (DynamicObject assetBook : assetbooks) {
            DynamicObject startPeriod;
            DynamicObject assetPeriodType = assetBook.getDynamicObject("periodtype");
            periodTypes.add(assetPeriodType.getLong("id"));
            depres.add((Long)assetBook.getDynamicObject("depreuse").getPkValue());
            if (periodTypeIdTemp != assetPeriodType.getLong("id") || (startPeriod = assetBook.getDynamicObject("startperiod")) == null) continue;
            long startPeriodId = (Long)startPeriod.getPkValue();
            DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
            if (currentPeriod == null) continue;
            long currentPeriodId = (Long)currentPeriod.getPkValue();
            if (mixPeriod == 0L) {
                mixPeriod = startPeriodId;
            }
            if (startPeriodId < mixPeriod) {
                mixPeriod = startPeriodId;
            }
            if (maxPeriod == 99999999L) {
                maxPeriod = currentPeriodId;
            }
            if (currentPeriodId <= maxPeriod) continue;
            maxPeriod = currentPeriodId;
        }
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
        start.setQFilter(new QFilter("id", "in", (Object)periodIds));
        end.setQFilter(new QFilter("id", "in", (Object)periodIds));
        if (isHideDepre) {
            q_depre.setQFilter(new QFilter("id", "in", depres));
        }
        q_peroidType.setQFilter(new QFilter("id", "in", periodTypes));
        ReportShowParameter report = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = report.getCustomParams();
        if (customParams.containsKey("fromDepreEditPage")) {
            DynamicObject assetbook = assetbooks[0];
            Object periodId = assetbook.get("curperiod_id");
            model.setValue("period_start", periodId);
            model.setValue("period_end", periodId);
        } else {
            model.setValue("period_start", (Object)maxPeriod);
            model.setValue("period_end", (Object)maxPeriod);
        }
        DynamicObject depreUse = assetbooks[0].getDynamicObject("depreuse");
        model.setValue("depreuse", depreUse.getPkValue());
        model.setValue("periodtype", periodType.getPkValue());
        boolean visible = true;
        if (depres.size() == 1 && isHideDepre) {
            visible = false;
        }
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"depreuse"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        Map customParam = queryParam.getCustomParam();
        customParam.put("pageId", view.getPageId());
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        if (orgs == null || orgs.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaDepreciationPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("period_start") == null || filterCondition.getDynamicObject("period_end") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u5f00\u59cb\u671f\u95f4\u548c\u7ed3\u675f\u671f\u95f4\u3002", (String)"FaDepreciationPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if ("sum".equals(filterCondition.getString("display")) && "0".equals(filterCondition.getString("sum_method"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6309\u6c47\u603b\u8868\u5c55\u793a\u65f6\uff0c\u8bf7\u9009\u62e9\u6c47\u603b\u65b9\u5f0f\u3002", (String)"FaDepreciationPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getPkValue());
        }
        QFilter forg = new QFilter("org", "in", orgIds);
        QFilter depreuse = new QFilter("depreuse", "=", filterCondition.getDynamicObject("depreuse").getPkValue());
        DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{forg, depreuse});
        if (assetBooks == null || assetBooks.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8d44\u4ea7\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaDepreciationPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject enablePeriod = assetBooks[0].getDynamicObject("startperiod");
        if (enablePeriod == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6838\u7b97\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u3002", (String)"FaDepreciationPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("periodtype") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u3002", (String)"FaDepreciationPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        queryParam.getCustomParam().put("enableSum", String.valueOf(this.needSum("fa_rpt_depreciation", orgIds)));
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String displayStr;
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
        if (orgs == null || orgs.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter forg = new QFilter("org", "in", orgIds);
        if (propName.equals("q_org")) {
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg});
            this.changeFilterPanel(assetBooks, true);
        } else if (propName.equals("depreuse")) {
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationPlugin_12", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg, fdepreuse});
            this.changeFilterPanel(assetBooks, false);
        } else if (propName.equals("periodtype")) {
            QFilter fperiodType;
            BasedataEdit q_StartPeroid = (BasedataEdit)this.getControl("period_start");
            BasedataEdit q_EndPeroid = (BasedataEdit)this.getControl("period_end");
            long mixPeriod = 0L;
            long maxPeriod = 99999999L;
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg, fdepreuse, fperiodType = new QFilter("periodtype", "=", periodType.getPkValue())});
            if (assetBooks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u671f\u95f4\u7c7b\u578b\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaDepreciationPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
                q_StartPeroid.setQFilter(new QFilter("id", "in", (Object)""));
                q_EndPeroid.setQFilter(new QFilter("id", "in", (Object)""));
                model.setValue("period_start", null);
                model.setValue("period_end", null);
                return;
            }
            for (DynamicObject assetBook : assetBooks) {
                DynamicObject startPeriod2 = assetBook.getDynamicObject("startperiod");
                if (startPeriod2 == null) continue;
                long startPeriodId = (Long)startPeriod2.getPkValue();
                DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
                if (currentPeriod == null) continue;
                long currentPeriodId = (Long)currentPeriod.getPkValue();
                if (mixPeriod == 0L) {
                    mixPeriod = startPeriodId;
                }
                if (startPeriodId < mixPeriod) {
                    mixPeriod = startPeriodId;
                }
                if (maxPeriod == 99999999L) {
                    maxPeriod = currentPeriodId;
                }
                if (currentPeriodId <= maxPeriod) continue;
                maxPeriod = currentPeriodId;
            }
            List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
            q_StartPeroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
            q_EndPeroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
            model.setValue("period_start", (Object)mixPeriod);
            model.setValue("period_end", (Object)maxPeriod);
        }
        if (propName.equals("period_start")) {
            startPeriod = (DynamicObject)model.getValue("period_start");
            endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_end", startPeriod.getPkValue());
            }
        }
        if (propName.equals("period_end")) {
            startPeriod = (DynamicObject)model.getValue("period_start");
            endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_start", endPeriod.getPkValue());
            }
        }
        if (propName.equals("display") && "sum".equals(displayStr = this.getModel().getValue("display").toString())) {
            model.setValue("sum_method", (Object)"1");
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        FilterInfo filterCondition = event.getQueryParam().getFilter();
        if ("sum".equalsIgnoreCase(filterCondition.getString("display"))) {
            List columns = event.getColumns();
            this.setColumnVisible(columns);
        }
    }

    private void setRangeVisible(List<AbstractReportColumn> columns) {
        int count = 0;
        List<String> hideFields = FaDepreciationPlugin.showRangeFields();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!hideFields.contains(key)) continue;
                col.setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            for (AbstractReportColumn child : colGroup.getChildren()) {
                if (!(child instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)child;
                String key = col.getFieldKey();
                if ("actual_depreciation".equals(key)) {
                    col.setHide(false);
                    continue;
                }
                col.setHide(true);
            }
            switch (count) {
                case 1: {
                    colGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u6298\u65e7\u989d", (String)"FaDepreciationPlugin_13", (String)"fi-fa-report", (Object[])new Object[0])));
                    break;
                }
            }
            ++count;
        }
    }

    private void setColumnVisible(List<AbstractReportColumn> columns) {
        List<String> hideFields = FaDepreciationPlugin.hideFields();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!hideFields.contains(key)) continue;
                col.setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnVisible(colGroup.getChildren());
        }
    }

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam param) {
        if ("reportlistap".equals(gridPk)) {
            Map<String, Map<String, BigDecimal>> finCardIdToDepreciation = this.getDepAdjustData(param);
            for (DynamicObject rowDyn : rowData) {
                DynamicObject realCard;
                String bizperiod;
                String period;
                if (SumFlagEnum.TOTAL.getIndex() == rowDyn.getInt("summarytype")) {
                    rowDyn.set("number", (Object)SumFlagEnum.valueOf((String)rowDyn.getString("number")).getName());
                }
                String id = rowDyn.getString("category");
                DynamicObject fid = rowDyn.getDynamicObject("fid");
                if (null != fid && null != rowDyn.getDynamicObject("period") && null != fid.getDynamicObject("bizperiod") && !(period = rowDyn.getDynamicObject("period").getString("periodyear")).equals(bizperiod = rowDyn.getString("year"))) {
                    rowDyn.set("year_depreciation", (Object)0);
                }
                if ((realCard = rowDyn.getDynamicObject("realcard")) == null) continue;
                DynamicObject assetcat = realCard.getDynamicObject("assetcat");
                String assetName = assetcat.getString("name");
                rowDyn.set("category", (Object)assetName);
                DynamicObject period2 = rowDyn.getDynamicObject("period");
                long periodId = period2.getLong("id");
                long realCardMasterId = realCard.getLong("masterid");
                String key = periodId + "_" + realCardMasterId;
                Map<String, BigDecimal> depData = finCardIdToDepreciation.get(key);
                if (depData == null) {
                    rowDyn.set("bef_adjust_depreciation", (Object)rowDyn.getBigDecimal("actual_depreciation"));
                    rowDyn.set("aft_adjust_depreciation", (Object)rowDyn.getBigDecimal("actual_depreciation"));
                    continue;
                }
                rowDyn.set("bef_adjust_depreciation", (Object)depData.get("bef_adjust_depreciation"));
                rowDyn.set("aft_adjust_depreciation", (Object)depData.get("aft_adjust_depreciation"));
            }
        }
    }

    private Map<String, Map<String, BigDecimal>> getDepAdjustData(ReportQueryParam param) {
        HashMap<String, Map<String, BigDecimal>> processData = new HashMap<String, Map<String, BigDecimal>>(16);
        FilterInfo filterInfo = param.getFilter();
        Long depUseId = filterInfo.getLong("depreuse");
        Long startPeriodId = filterInfo.getLong("period_start");
        Long endPeriodId = filterInfo.getLong("period_end");
        DynamicObjectCollection orgColl = filterInfo.getDynamicObjectCollection("q_org");
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgColl) {
            orgIds.add(org.getPkValue());
        }
        String queryField = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), Fa.dot((String[])new String[]{"entryentity", "bfrdepreamount"}), Fa.dot((String[])new String[]{"entryentity", "aftdepreamount"}), "period"});
        Map queryDepAdjust = BusinessDataServiceHelper.loadFromCache((String)"fa_depreadjustbill", (String)queryField, (QFilter[])new QFilter[]{new QFilter("depreuse", "=", (Object)depUseId), new QFilter("period", ">=", (Object)startPeriodId), new QFilter("period", "<=", (Object)endPeriodId), new QFilter("org", "in", orgIds)});
        for (Map.Entry depAdjust : queryDepAdjust.entrySet()) {
            DynamicObject depAdjustBill = (DynamicObject)depAdjust.getValue();
            long periodId = depAdjustBill.getDynamicObject("period").getLong("id");
            DynamicObjectCollection entryEntity = depAdjustBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                long realCardId = entry.getDynamicObject("realcard").getLong("id");
                BigDecimal bfrDepAmount = entry.getBigDecimal("bfrdepreamount");
                BigDecimal aftDepAmount = entry.getBigDecimal("aftdepreamount");
                HashMap<String, BigDecimal> depData = new HashMap<String, BigDecimal>(2);
                depData.put("bef_adjust_depreciation", bfrDepAmount);
                depData.put("aft_adjust_depreciation", aftDepAmount);
                processData.put(periodId + "_" + realCardId, depData);
            }
        }
        return processData;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_qing_depreciation");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            List columns = reportList.getColumns();
            showParameter.setCustomParam("columns", (Object)SerializationUtils.serializeToBase64((Object)columns));
            view.showForm(showParameter);
        }
    }

    private static List<String> showRangeFields() {
        return Arrays.asList(rangefields_hide);
    }

    private static List<String> hideFields() {
        return Arrays.asList(hideFields);
    }
}

