/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.report.qing.FaReportQingUtils;
import kd.fi.fa.report.util.Rpt;
import org.apache.log4j.Logger;

public class AssignQingDataProvider
implements IQingDataProvider {
    private static final Logger log = Logger.getLogger(AssignQingDataProvider.class);
    private static final String CACHE_ID = "AccBalQingDataProvider_cacheId";
    private static final String DIM_NAMES_CACHE_ID = "dim_Names_cacheId";
    private static final String CACHE_QUERY_PARAM = "queryparam";
    private static final String QING_META = "AccBalQingDataProvider_qingMeta";
    public static final String algoKey = "AssignQingDataProvider";
    private static int asstypeCount = 0;
    private final HashMap<String, String> type_showTypes = new HashMap();
    private final HashMap<String, HashMap<String, String>> dimValues = new HashMap();
    private final HashMap<String, String> dim_Names = new HashMap();
    private static final ThreadLocal<Set<String>> asstypeSets = new ThreadLocal();

    public QingMeta getMeta(String pageId) {
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        IAppCache appCache = AppCache.get((String)"fa");
        DataSet dataSet = this.getResultDataSet(queryParam);
        ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>();
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>();
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b", (String)"AssignQingDataProvider_0", (String)"fi-fa-report", (Object[])new Object[0])), "assetcat", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6298\u65e7\u671f\u95f4", (String)"AssignQingDataProvider_1", (String)"fi-fa-report", (Object[])new Object[0])), "assperiod", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u90e8\u95e8\u5c5e\u6027", (String)"AssignQingDataProvider_2", (String)"fi-fa-report", (Object[])new Object[0])), "orgduty", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8", (String)"AssignQingDataProvider_3", (String)"fi-fa-report", (Object[])new Object[0])), "headusedept", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u53f7", (String)"AssignQingDataProvider_4", (String)"fi-fa-report", (Object[])new Object[0])), "billno", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801", (String)"AssignQingDataProvider_5", (String)"fi-fa-report", (Object[])new Object[0])), "realnumber", "text"));
        columnList.add((AbstractReportColumn)Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u540d\u79f0", (String)"AssignQingDataProvider_6", (String)"fi-fa-report", (Object[])new Object[0])), "realcardname", "text"));
        this.setAssTypeName(columnList, appCache, pageId);
        ReportColumn childColumn_monthDepre = new ReportColumn();
        childColumn_monthDepre.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5206\u644a\u91d1\u989d", (String)"AssignQingDataProvider_7", (String)"fi-fa-report", (Object[])new Object[0])));
        childColumn_monthDepre.setFieldKey("monthdepre");
        childColumn_monthDepre.setFieldType("amount");
        columnList.add((AbstractReportColumn)childColumn_monthDepre);
        dataSet = FaReportQingUtils.getAssetLevelDs(dataSet, algoKey, "assetcat", "assetcatLevel", "org", columnList, columnMap);
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        List<ReportColumn> allReportColumns = this.getAllReportColumns(columnList, null);
        QingMeta qingMeta = this.createQingMeta(allReportColumns);
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        return qingMeta;
    }

    private void setAssTypeName(List<AbstractReportColumn> columns, IAppCache appCache, String pageId) {
        DynamicObject[] basDimNames;
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        FilterInfo filterCondition = queryParam.getFilter();
        String showType = filterCondition.getFilterItem("asstshowtype").getValue().toString();
        String selectprops = "";
        switch (showType) {
            case "0": {
                selectprops = "id,name";
                break;
            }
            case "1": {
                selectprops = "id,number";
                break;
            }
            case "2": {
                selectprops = "id,number,name";
                break;
            }
            default: {
                selectprops = "id,name";
            }
        }
        if (null != asstypeSets.get()) {
            asstypeSets.get().remove("dataid");
        }
        LinkedList<String> baseDimIds = new LinkedList<String>();
        for (DynamicObject dynamicObject : basDimNames = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)asstypeSets.get().toArray(new String[0]))})) {
            this.dim_Names.put(dynamicObject.getString("id"), dynamicObject.getString("name"));
            baseDimIds.add(dynamicObject.getString("id"));
        }
        baseDimIds.stream().forEach(entityName -> {
            DynamicObject[] baseNames;
            if (StringUtils.isEmpty((Object)entityName)) {
                return;
            }
            block10: for (DynamicObject baseName : baseNames = BusinessDataServiceHelper.load((String)entityName, (String)"id,name", null)) {
                HashMap<String, String> baseValues = this.dimValues.get(entityName);
                if (baseValues == null) {
                    baseValues = new HashMap();
                }
                this.dimValues.put((String)entityName, baseValues);
                switch (showType) {
                    case "0": {
                        baseValues.put(baseName.getString("id"), baseName.getLocaleString("name").toString());
                        continue block10;
                    }
                    case "1": {
                        baseValues.put(baseName.getString("id"), baseName.getString("number"));
                        continue block10;
                    }
                    case "2": {
                        baseValues.put(baseName.getString("id"), baseName.getString("number") + "," + baseName.getLocaleString("name").toString());
                        continue block10;
                    }
                    default: {
                        baseValues.put(baseName.getString("id"), baseName.getLocaleString("name").toString());
                    }
                }
            }
        });
        asstypeSets.get().removeAll(baseDimIds);
        HashSet<Long> groupIds = new HashSet<Long>(asstypeSets.get().size(), 1.0f);
        for (String assType : asstypeSets.get()) {
            if (StringUtils.isEmpty((Object)assType) || "null".equals(assType)) continue;
            groupIds.add(Long.parseLong(assType));
        }
        DynamicObject[] assDimNames = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"id,name,group", (QFilter[])new QFilter[]{new QFilter("group", "in", groupIds)});
        block22: for (DynamicObject assDimName : assDimNames) {
            DynamicObject group = assDimName.getDynamicObject("group");
            String groupId = group.getString("id");
            String groupName = group.getString("name");
            this.dim_Names.put(groupId, groupName);
            HashMap<String, String> baseValues = this.dimValues.get(groupId);
            if (baseValues == null) {
                baseValues = new HashMap();
            }
            this.dimValues.put(groupId, baseValues);
            switch (showType) {
                case "0": {
                    baseValues.put(assDimName.getString("id"), assDimName.getLocaleString("name").toString());
                    continue block22;
                }
                case "1": {
                    baseValues.put(assDimName.getString("id"), assDimName.getString("number"));
                    continue block22;
                }
                case "2": {
                    baseValues.put(assDimName.getString("id"), assDimName.getString("number") + "," + assDimName.getLocaleString("name").toString());
                    continue block22;
                }
                default: {
                    baseValues.put(assDimName.getString("id"), assDimName.getLocaleString("name").toString());
                }
            }
        }
        for (Map.Entry entry : this.type_showTypes.entrySet()) {
            String dimKey = (String)entry.getKey();
            ReportColumn childColumn = new ReportColumn();
            String dimName = this.dim_Names.get(dimKey);
            childColumn.setCaption(new LocaleString(dimName));
            childColumn.setFieldKey((String)entry.getValue());
            childColumn.setFieldType("text");
            columns.add((AbstractReportColumn)childColumn);
        }
        appCache.put(DIM_NAMES_CACHE_ID + pageId, this.dimValues);
    }

    /*
     * WARNING - void declaration
     */
    private DataSet getResultDataSet(ReportQueryParam queryParam) {
        void var15_18;
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObject org = filterCondition.getDynamicObject("q_org");
        DynamicObject depreUse = filterCondition.getDynamicObject("depreuse");
        DynamicObject periodStart = filterCondition.getDynamicObject("period_start");
        DynamicObject periodEnd = filterCondition.getDynamicObject("period_end");
        DataSet result = null;
        DataSet subEntryDataSet = this.getAssignDetailSubEntryDataSet(periodStart.getPkValue(), periodEnd.getPkValue(), org, depreUse);
        HashMap<Long, String[]> dataid_assDatas = new HashMap<Long, String[]>();
        HashMap objectDatas = new HashMap();
        asstypeSets.remove();
        asstypeSets.set(new HashSet(2));
        asstypeSets.get().add("dataid");
        while (subEntryDataSet.hasNext()) {
            String[] asstype_assids;
            Row row = subEntryDataSet.next();
            long dataid = row.getLong("dataid");
            String asstype = row.getString("asstype");
            asstypeSets.get().add(asstype);
            long l = row.getLong("assid");
            if (dataid_assDatas.get(dataid) == null) {
                asstype_assids = new HashMap();
                asstype_assids.put(asstype, l);
                dataid_assDatas.put(dataid, asstype_assids);
                continue;
            }
            asstype_assids = (String[])dataid_assDatas.get(dataid);
            asstype_assids.put(asstype, l);
        }
        asstypeCount = asstypeSets.get().size();
        String[] oriAsstypes = asstypeSets.get().toArray(new String[0]);
        LinkedList<String> assTypeShowList = new LinkedList<String>();
        assTypeShowList.add("dataid");
        this.type_showTypes.clear();
        for (int i = 1; i <= asstypeCount; ++i) {
            if ("dataid".equals(oriAsstypes[i - 1])) continue;
            assTypeShowList.add("tp__" + oriAsstypes[i - 1]);
            this.type_showTypes.put(oriAsstypes[i - 1], "tp__" + oriAsstypes[i - 1]);
        }
        String[] asstypes = assTypeShowList.toArray(new String[0]);
        for (Map.Entry entry : dataid_assDatas.entrySet()) {
            LinkedList<Object> datas = new LinkedList<Object>();
            datas.add(entry.getKey());
            for (String asstype : asstypes) {
                if ("dataid".equals(asstype)) continue;
                String asstypeTemp = asstype.split("__")[1];
                Map type_ids = (Map)entry.getValue();
                if (type_ids.get(asstypeTemp) == null) {
                    datas.add(0L);
                    continue;
                }
                datas.add(type_ids.get(asstypeTemp));
            }
            objectDatas.put(entry.getKey(), datas.toArray());
        }
        asstypeCount = asstypeSets.get().size();
        LinkedList<LongType> dataTypeList = new LinkedList<LongType>();
        boolean bl = false;
        while (var15_18 < asstypeCount) {
            dataTypeList.add(DataType.LongType);
            ++var15_18;
        }
        RowMeta rowMeta = new RowMeta(asstypes, dataTypeList.toArray(new DataType[0]));
        DataSet asstype_ids = Algo.create((String)"").createDataSet(objectDatas.values().iterator(), rowMeta);
        DataSet entryDataSet = this.getAssignDetailEntryDataSet(periodStart.getPkValue(), periodEnd.getPkValue(), org, depreUse);
        result = entryDataSet.leftJoin(asstype_ids).on("dataid", "dataid").select(this.getFieldsByDataSet(entryDataSet).toArray(new String[0]), this.getFieldsByDataSet(asstype_ids).toArray(new String[0])).finish();
        return result;
    }

    private List<String> getFieldsByDataSet(DataSet dataSet) {
        Field[] fields;
        ArrayList<String> selFields = new ArrayList<String>(12);
        if (dataSet == null) {
            return selFields;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            if ("dataid".equalsIgnoreCase(field.getName())) continue;
            selFields.add(field.getAlias());
        }
        return selFields;
    }

    private DataSet getAssignDetailSubEntryDataSet(Object periodStart, Object periodEnd, DynamicObject org, DynamicObject depreUse) {
        String selectFileds = "B.fasstype as asstype,B.fassid as assid,A.fentryid as dataid";
        String sql = "select " + selectFileds + " from t_fa_depredetailsubentry  B left join t_fa_depredetailentry  A on B.fentryid = A.fentryid left join t_fa_depresplitdetail C on C.fdetailsid = A.fdetailsid  where C.FPERIODID<=" + periodEnd + " and C.FPERIODID>=" + periodStart + " and C.forgid = ? and C.fdepreuseid = ?";
        return DB.queryDataSet((String)"fa_depre_sum.depresplitsum", (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{org.getPkValue(), depreUse.getPkValue()});
    }

    private DataSet getAssignDetailEntryDataSet(Object periodStart, Object periodEnd, DynamicObject org, DynamicObject depreUse) {
        String selectFileds = "A.fentryid as dataid,C.frealcardid as realcardid,D.fbillno as billno,D.fnumber as realnumber,D.fassetname as realcardname,A.forgdutyid as orgduty,A.fsplitamount as monthdepre,C.fsplitdeptid as headusedept,C.fassetcatid as assetcat,E.flevel as assetcatLevel,C.FPERIODID as assperiod,C.forgid as org,C.fdepreuseid as depreuse";
        String sql = "select " + selectFileds + " from t_fa_depredetailentry  A left join t_fa_depresplitdetail C on C.fdetailsid = A.fdetailsid left join t_fa_card_real D on D.fid = C.frealcardid left join t_fa_assetcategory E on E.fid = C.fassetcatid where C.FPERIODID<=" + periodEnd + " and C.FPERIODID>=" + periodStart + " and C.forgid = ? and C.fdepreuseid = ?";
        return DB.queryDataSet((String)"fa_depre_sum.depresplitsum", (DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{org.getPkValue(), depreUse.getPkValue()});
    }

    private IPageCache getPageCache(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return (IPageCache)view.getService(IPageCache.class);
    }

    private QingMeta createQingMeta(List<ReportColumn> columns) {
        QingMeta qingMeta = new QingMeta();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            if (reportColumn.isHide()) continue;
            String fieldKey = reportColumn.getFieldKey();
            LocaleString caption = reportColumn.getCaption();
            String fieldType = reportColumn.getFieldType();
            int qingType = this.getQingType(fieldType);
            String entity = null;
            if (qingType == QingFieldType.BaseData.toNumber()) {
                entity = ((ReportColumn)abstractReportColumn).getEntityId();
            }
            qingMeta.addColumn(this.createFieldObj(fieldKey, caption, qingType, "assgrp".equals(fieldKey), entity));
        }
        return qingMeta;
    }

    private int getQingType(String fieldType) {
        switch (fieldType) {
            case "basedata": {
                return QingFieldType.Int.toNumber();
            }
            case "price": 
            case "qty": 
            case "amount": {
                return QingFieldType.Number.toNumber();
            }
            case "text": {
                return QingFieldType.String.toNumber();
            }
            case "integer": {
                return QingFieldType.Int.toNumber();
            }
            case "date": {
                return QingFieldType.Date.toNumber();
            }
        }
        return 0;
    }

    private kd.bos.entity.qing.Field createFieldObj(String key, LocaleString name, int fieldType, boolean hide, String entity) {
        kd.bos.entity.qing.Field field = new kd.bos.entity.qing.Field();
        field.setKey(key);
        field.setName(name);
        field.setFieldType(fieldType);
        field.setHide(hide);
        field.setEntity(entity);
        return field;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns, String parentName) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (parentName != null) {
                    column.setCaption(new LocaleString(parentName + "-" + column.getCaption().getLocaleValue()));
                }
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren(), group.getCaption().getLocaleValue()));
        }
        return list;
    }

    private QingData getDataStartFromZero(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"fa");
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(CACHE_ID + pageId, String.class)));
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = AssignQingDataProvider.buildQingDataIndexMap(qingMeta);
        int size = fieldMap.size();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        Map<String, Set<Long>> baseDataMap = this.initBaseDataMap(fieldMap);
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow, limit);
            String[] fieldNames = cacheDataSet.getRowMeta().getFieldNames();
            HashMap dimValuesAppCache = null;
            for (Row row : list) {
                for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
                    String key = entry.getKey();
                    Set<Long> ids = entry.getValue();
                    ids.add(row.getLong(key));
                }
                Object[] data = new Object[size];
                for (String fieldName : fieldNames) {
                    Integer idx = fieldMap.get(fieldName.toLowerCase());
                    if (idx == null) continue;
                    if (fieldName.startsWith("tp__")) {
                        String assetType = fieldName.substring(4);
                        if (dimValuesAppCache == null) {
                            dimValuesAppCache = (HashMap)appCache.get(DIM_NAMES_CACHE_ID + pageId, HashMap.class);
                        }
                        HashMap id_name = (HashMap)dimValuesAppCache.get(assetType);
                        String asstypeid = row.getString(fieldName);
                        if (id_name == null) {
                            data[idx.intValue()] = "";
                            log.error((Object)("qing_no_assetType:" + assetType));
                            continue;
                        }
                        data[idx.intValue()] = id_name.get(asstypeid);
                        continue;
                    }
                    data[idx.intValue()] = row.get(fieldName);
                }
                rowList.add(data);
            }
        }
        this.setBaseDataName(rowList, fieldMap, baseDataMap);
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    public QingData getData(String pageId, int startRow, int limit) {
        return this.getDataStartFromZero(pageId, startRow - 1, limit);
    }

    private void setBaseDataName(List<Object[]> rowList, Map<String, Integer> fieldMap, Map<String, Set<Long>> baseDataMap) {
        HashMap<String, String> keyToTypeMap = new HashMap<String, String>();
        keyToTypeMap.put("headusedept", "bos_org");
        keyToTypeMap.put("assetcat", "fa_assetcategory");
        keyToTypeMap.put("assperiod", "bd_period");
        keyToTypeMap.put("orgduty", "bos_org_duty");
        for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
            String key = entry.getKey();
            Integer idx = fieldMap.get(key);
            Set<Long> ids = entry.getValue();
            String entityId = (String)keyToTypeMap.get(key);
            Map<Long, String> baseDataIdNameMap = Rpt.getBaseDataMap(entityId, ids);
            for (Object[] obj : rowList) {
                Long id = Long.parseLong(obj[idx].toString());
                String name = baseDataIdNameMap.get(id);
                obj[idx.intValue()] = name;
            }
        }
    }

    private Map<String, Set<Long>> initBaseDataMap(Map<String, Integer> fieldMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        String baseDataStr = "assetcat,assperiod,headusedept,orgduty";
        for (String str : baseDataStr.split(",")) {
            Integer idx = fieldMap.get(str);
            if (idx == null) continue;
            result.put(str, new HashSet());
        }
        return result;
    }

    private static Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            qingDataIndexMap.put(col.getKey(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }
}

