/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.FractionalType;
import kd.bos.algo.datatype.IntegralType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.fi.fa.business.card.AssetCardQueryServiceHelper;

public class DepreForcastQingDataProvider
implements IQingDataProvider {
    public static final String QING_PAGE = "fa_qing_depreforecast";
    public static final String CACHE_QUERY_PARAM = "queryparam";
    public static final String COLUMNS = "columns";
    private static final String CACHE_ID = "DepreForcastQingDataProvider_cacheID";
    private static final String QING_META = "DepreForcastQingDataProvider_qingMeta";

    public QingData getData(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"fa");
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(CACHE_ID + pageId, String.class)));
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = this.buildQingDataIndexMap(qingMeta);
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow - 1 >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow - 1, limit);
            Set<Map.Entry<String, Integer>> entrySet = fieldMap.entrySet();
            int size = entrySet.size();
            for (Row row : list) {
                Object[] data = new Object[size];
                for (Map.Entry<String, Integer> entry : entrySet) {
                    String fieldName = entry.getKey();
                    int columnIndex = entry.getValue();
                    data[columnIndex] = row.get(fieldName);
                }
                rowList.add(data);
            }
        }
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    private Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            qingDataIndexMap.put(col.getKey().toLowerCase(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    public QingMeta getMeta(String pageId) {
        IAppCache appCache = AppCache.get((String)"fa");
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        String columns = pageCache.get(COLUMNS);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        List columnLst = (List)SerializationUtils.deSerializeFromBase64((String)columns);
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>(columnLst.size());
        ArrayList<String> otherRealFields = new ArrayList<String>(columnLst.size());
        for (AbstractReportColumn _column : columnLst) {
            ReportColumn column = (ReportColumn)_column;
            if (column.getRefBasedataProp() != null && "realcard".equals(column.getRefBasedataProp())) {
                String realRefField = "realcard." + column.getDisplayProp();
                realRefField = realRefField.toLowerCase();
                otherRealFields.add(realRefField);
                columnMap.put(realRefField, column);
                continue;
            }
            if (column.getRefBasedataProp() != null && "fincard".equals(column.getRefBasedataProp())) {
                String finRefField = column.getDisplayProp();
                finRefField = finRefField.toLowerCase();
                otherRealFields.add(finRefField);
                columnMap.put(finRefField, column);
                continue;
            }
            columnMap.put(column.getFieldKey().toLowerCase(), column);
            if (!"realcard".equals(column.getFieldKey())) continue;
            columnMap.put("realcard.assetname", column);
        }
        otherRealFields.add("realcard.assetname");
        DataSet dataSet = AssetCardQueryServiceHelper.queryDepreForecastDataSet((String)"DepreForcastQingDataProvider", (ReportQueryParam)queryParam, otherRealFields, (boolean)true);
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        QingMeta qingMeta = new QingMeta();
        for (Field field : fields) {
            kd.bos.entity.qing.Field qingField = new kd.bos.entity.qing.Field();
            String fieldName = field.getName().toLowerCase();
            ReportColumn reportColumn = (ReportColumn)columnMap.get(fieldName);
            if (reportColumn == null) continue;
            qingField.setKey(fieldName);
            qingField.setName(reportColumn.getCaption());
            qingField.setHide(reportColumn.isHide());
            if ("realcard".equals(fieldName)) {
                qingField.setHide(true);
            }
            qingField.setFieldType(this.getQingTypeByAlgoType(field.getDataType()).toNumber());
            qingMeta.addColumn(qingField);
        }
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        return qingMeta;
    }

    private IPageCache getPageCache(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return (IPageCache)view.getService(IPageCache.class);
    }

    private QingFieldType getQingTypeByAlgoType(DataType algoType) {
        if (algoType instanceof FractionalType) {
            return QingFieldType.Number;
        }
        if (algoType instanceof IntegralType) {
            return QingFieldType.Int;
        }
        if (algoType instanceof DateType) {
            return QingFieldType.Date;
        }
        if (algoType instanceof TimestampType) {
            return QingFieldType.DateTime;
        }
        if (algoType instanceof BooleanType) {
            return QingFieldType.Boolean;
        }
        return QingFieldType.String;
    }
}

