/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.FractionalType;
import kd.bos.algo.datatype.IntegralType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.fa.report.qing.FaReportQingUtils;
import kd.fi.fa.report.query.FaAssetRecordListQuery;

public class FaQingAssetRecordDataProvider
implements IQingDataProvider {
    public static final String QING_PAGE = "fa_asset_record_qing";
    private static final String CACHE_QUERY_PARAM = "queryparam";
    private static final String COLUMNS = "columns";
    private static final String CACHE_ID = "FaQingAssetRecordDataProvider_cacheID";
    private static final String QING_META = "FaQingAssetRecordDataProvider_qingMeta";
    private static final String ALGOKEY = "FaQingAssetRecordDataProvider";

    public QingData getData(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"fa");
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(CACHE_ID + pageId, String.class)));
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = this.buildQingDataIndexMap(qingMeta);
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow - 1 >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow - 1, limit);
            Set<Map.Entry<String, Integer>> entrySet = fieldMap.entrySet();
            int size = entrySet.size();
            for (Row row : list) {
                Object[] data = new Object[size];
                for (Map.Entry<String, Integer> entry : entrySet) {
                    String fieldName = entry.getKey();
                    int columnIndex = entry.getValue();
                    data[columnIndex] = row.get(fieldName);
                }
                rowList.add(data);
            }
        }
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    private Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            if (qingDataIndexMap.containsKey(col.getKey().toLowerCase())) continue;
            qingDataIndexMap.put(col.getKey().toLowerCase(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    public QingMeta getMeta(String pageId) {
        IAppCache appCache = AppCache.get((String)"fa");
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        String columns = pageCache.get(COLUMNS);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        List columnLst = (List)SerializationUtils.deSerializeFromBase64((String)columns);
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>(16);
        HashSet<String> otherRealFields = new HashSet<String>(16);
        DataSet predictDataSet = this.getCombDs("fa_changemode", "type");
        for (AbstractReportColumn columnField : columnLst) {
            ReportColumn column = (ReportColumn)columnField;
            if (column.getRefBasedataProp() != null && "realcard".equals(column.getRefBasedataProp())) {
                String realRefField = "realcard." + column.getDisplayProp();
                realRefField = realRefField.toLowerCase();
                otherRealFields.add(realRefField);
                columnMap.put(realRefField, column);
                continue;
            }
            if (column.getRefBasedataProp() != null && "fincardid".equals(column.getRefBasedataProp())) {
                String finRefField = column.getDisplayProp();
                finRefField = finRefField.toLowerCase();
                otherRealFields.add(finRefField);
                columnMap.put(finRefField, column);
                continue;
            }
            columnMap.put(column.getFieldKey().toLowerCase(), column);
            if ("assetcat".equals(column.getFieldKey())) {
                columnMap.put("realcard.assetcat.name", column);
            }
            if ("addredtype".equals(column.getFieldKey())) {
                columnMap.put("typename", column);
            }
            if (!"addredmethod".equals(column.getFieldKey())) continue;
            columnMap.put("addredmethodname", column);
        }
        otherRealFields.add("realcard.assetname");
        otherRealFields.add("realcard.assetcat.name");
        otherRealFields.add("realcard.assetcat.level");
        otherRealFields.add("realcard.org.name");
        otherRealFields.add("realcard.org.id");
        otherRealFields.add("realcard.originmethod.name");
        otherRealFields.add("realcard.originmethod.type");
        DataSet dataSet = new FaAssetRecordListQuery().query(queryParam, otherRealFields, Boolean.FALSE, Boolean.TRUE);
        dataSet = dataSet.removeFields(new String[]{"currency"});
        dataSet = FaReportQingUtils.getAssetLevelDs(dataSet, ALGOKEY, "assetcat", "realcard.assetcat.level", "realcard.org.id", columnLst, columnMap);
        dataSet = dataSet.join(predictDataSet, JoinType.LEFT).on("addredmethodtype", "typevalue").select(dataSet.getRowMeta().getFieldNames(), predictDataSet.getRowMeta().getFieldNames()).finish();
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        QingMeta qingMeta = new QingMeta();
        for (Field field : fields) {
            kd.bos.entity.qing.Field qingField = new kd.bos.entity.qing.Field();
            String fieldName = field.getName().toLowerCase();
            if (!columnMap.containsKey(fieldName)) continue;
            ReportColumn reportColumn = (ReportColumn)columnMap.get(fieldName);
            qingField.setKey(fieldName);
            qingField.setName(reportColumn.getCaption());
            qingField.setHide(reportColumn.isHide());
            qingField.setFieldType(this.getQingTypeByAlgoType(field.getDataType()).toNumber());
            if (field.getDataType() instanceof TimestampType) {
                qingField.setFieldType(QingFieldType.String.toNumber());
            }
            qingMeta.addColumn(qingField);
        }
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        return qingMeta;
    }

    private IPageCache getPageCache(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return (IPageCache)view.getService(IPageCache.class);
    }

    private QingFieldType getQingTypeByAlgoType(DataType algoType) {
        if (algoType instanceof FractionalType) {
            return QingFieldType.Number;
        }
        if (algoType instanceof IntegralType) {
            return QingFieldType.Int;
        }
        if (algoType instanceof DateType) {
            return QingFieldType.Date;
        }
        if (algoType instanceof TimestampType) {
            return QingFieldType.DateTime;
        }
        if (algoType instanceof BooleanType) {
            return QingFieldType.Boolean;
        }
        return QingFieldType.String;
    }

    private DataSet getCombDs(String metaDyName, String combName) {
        Algo algo = Algo.create((String)ALGOKEY);
        ArrayList<Object[]> predictResult = new ArrayList<Object[]>();
        Field[] fieldArray = new Field[]{new Field("typename", (DataType)DataType.StringType), new Field("typevalue", (DataType)DataType.StringType)};
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)metaDyName);
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            if (!combName.equals(property.getName())) continue;
            List items = ((ComboProp)property).getComboItems();
            for (ValueMapItem item : items) {
                predictResult.add(new Object[]{item.getName().toString(), item.getValue()});
            }
        }
        DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(fieldArray));
        for (Object[] row : predictResult) {
            builder.append(row);
        }
        return builder.build();
    }
}

