/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.FractionalType;
import kd.bos.algo.datatype.IntegralType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.fi.fa.business.enums.AssetCatApplyTypeEnum;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.report.qing.FaReportQingUtils;
import kd.fi.fa.report.query.FaDepreciationListQuery;
import kd.fi.fa.report.util.Rpt;

public class FaQingDepreciationDataProvider
implements IQingDataProvider {
    public static final String CACHE_QUERY_PARAM = "queryparam";
    public static final String COLUMNS = "columns";
    private static final String CACHE_ID = "FaQingDepreciationDataProvider_cacheID";
    private static final String QING_META = "FaQingDepreciationDataProvider_qingMeta";
    public static final String BEGINNING = "beginning";
    public static final String CURRENT = "current";
    public static final String ENDING = "ending";
    private static final Log logger = LogFactory.getLog(FaQingDepreciationDataProvider.class);

    public QingData getData(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"fa");
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(CACHE_ID + pageId, String.class)));
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = this.buildQingDataIndexMap(qingMeta);
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow - 1 >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow - 1, limit);
            Set<Map.Entry<String, Integer>> entrySet = fieldMap.entrySet();
            int size = entrySet.size();
            for (Row row : list) {
                Object[] data = new Object[size];
                for (Map.Entry<String, Integer> entry : entrySet) {
                    String fieldName = entry.getKey();
                    int columnIndex = entry.getValue();
                    if ("realcard.assetcat.applytype".equals(fieldName)) {
                        data[columnIndex] = AssetCatApplyTypeEnum.getNameByValue((Object)row.get(fieldName));
                        continue;
                    }
                    data[columnIndex] = row.get(fieldName);
                }
                rowList.add(data);
            }
        }
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    private Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            if (qingDataIndexMap.containsKey(col.getKey().toLowerCase())) continue;
            qingDataIndexMap.put(col.getKey().toLowerCase(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    public QingMeta getMeta(String pageId) {
        Field[] fields;
        long t1 = System.currentTimeMillis();
        IAppCache appCache = AppCache.get((String)"fa");
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        String columns = pageCache.get(COLUMNS);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        List columnList = (List)SerializationUtils.deSerializeFromBase64((String)columns);
        columnList.add(Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5206\u7c7b", (String)"FaQingDepreciationDataProvider_3", (String)"fi-fa-report", (Object[])new Object[0])), "realcard.assetcat.applytype", "text"));
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>();
        HashSet<String> otherRealFields = new HashSet<String>();
        for (AbstractReportColumn _column : columnList) {
            if (_column instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)_column;
                if (column.getRefBasedataProp() != null && "realcard".equals(column.getRefBasedataProp())) {
                    String realRefField = "realcard." + column.getDisplayProp();
                    realRefField = realRefField.toLowerCase();
                    otherRealFields.add(realRefField);
                    columnMap.put(realRefField, column);
                    continue;
                }
                if (column.getRefBasedataProp() != null && "fid".equals(column.getRefBasedataProp())) {
                    String finRefField = column.getDisplayProp();
                    finRefField = finRefField.toLowerCase();
                    otherRealFields.add(finRefField);
                    columnMap.put(finRefField, column);
                    continue;
                }
                columnMap.put(column.getFieldKey().toLowerCase(), column);
                if ("realcard".equals(column.getFieldKey())) {
                    columnMap.put("realcard.assetname", column);
                }
                if ("category1".equals(column.getFieldKey())) {
                    columnMap.put("category1.name", column);
                }
                if ("depreciation_method".equals(column.getFieldKey())) {
                    columnMap.put("depreciation_method.name", column);
                }
                if (!"period".equals(column.getFieldKey())) continue;
                columnMap.put("period_1_number", column);
                continue;
            }
            ReportColumnGroup columnGroup = (ReportColumnGroup)_column;
            List groupColumns = columnGroup.getChildren();
            for (Object groupColumn : groupColumns) {
                ReportColumn column = (ReportColumn)groupColumn;
                if (BEGINNING.equals(columnGroup.getFieldKey())) {
                    column.getCaption().setLocaleValue(String.format(ResManager.loadKDString((String)"\u671f\u521d%s", (String)"FaQingDepreciationDataProvider_0", (String)"fi-fa-report", (Object[])new Object[0]), column.getCaption().getLocaleValue()));
                } else if (CURRENT.equals(columnGroup.getFieldKey())) {
                    column.getCaption().setLocaleValue(String.format(ResManager.loadKDString((String)"\u672c\u671f%s", (String)"FaQingDepreciationDataProvider_1", (String)"fi-fa-report", (Object[])new Object[0]), column.getCaption().getLocaleValue()));
                } else if (ENDING.equals(columnGroup.getFieldKey())) {
                    column.getCaption().setLocaleValue(String.format(ResManager.loadKDString((String)"\u671f\u672b%s", (String)"FaQingDepreciationDataProvider_2", (String)"fi-fa-report", (Object[])new Object[0]), column.getCaption().getLocaleValue()));
                }
                if (column.getRefBasedataProp() != null && "realcard".equals(column.getRefBasedataProp())) {
                    String realRefField = "realcard." + column.getDisplayProp();
                    realRefField = realRefField.toLowerCase();
                    otherRealFields.add(realRefField);
                    columnMap.put(realRefField, column);
                } else if (column.getRefBasedataProp() != null && "fid".equals(column.getRefBasedataProp())) {
                    String finRefField = column.getDisplayProp();
                    finRefField = finRefField.toLowerCase();
                    otherRealFields.add(finRefField);
                    columnMap.put(finRefField, column);
                }
                columnMap.put(column.getFieldKey(), column);
            }
        }
        otherRealFields.add("realcard.assetcat.applytype");
        DataSet dataSet = null;
        QingMeta qingMeta = new QingMeta();
        try {
            FaDepreciationListQuery queryPlugin = new FaDepreciationListQuery();
            queryPlugin.setFromQingAnaly(true);
            DataSet batchSplitDataSet = queryPlugin.queryBatchBy(queryParam);
            int i = 0;
            for (Row row : batchSplitDataSet) {
                long pt1 = System.currentTimeMillis();
                ReportBatchQueryInfo reportBatchQueryInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo();
                reportBatchQueryInfo.setCurrentBatchIndex(i++);
                reportBatchQueryInfo.getCurrentBatchRows().clear();
                reportBatchQueryInfo.getCurrentBatchRows().add(row);
                try {
                    DataSet perDataSet = queryPlugin.query(queryParam, otherRealFields);
                    long pt2 = System.currentTimeMillis();
                    logger.warn("qing depre batch getMeta const1 = {}", (Object)(pt2 - pt1));
                    dataSet = dataSet == null ? perDataSet : dataSet.union(perDataSet);
                }
                catch (Throwable throwable) {
                    logger.error(ThrowableHelper.toString((Throwable)throwable));
                }
                long pt3 = System.currentTimeMillis();
                logger.warn("qing depre batch getMeta const2 = {}", (Object)(pt3 - pt1));
            }
            DataSet depAdjustDataSet = this.getDepAdjustDataSet(queryParam);
            if (dataSet == null) {
                throw new KDBizException("dataset is null");
            }
            dataSet = dataSet.leftJoin(depAdjustDataSet).on("period_1", "periodid").on("masterid", "realcardid").select(FaDepreciationListQuery.getFieldsByDataSet(dataSet).toArray(new String[0]), new String[]{"bfrdepreamount", "aftdepreamount"}).finish();
            dataSet = dataSet.addField("case when bfrdepreamount is null then actual_depreciation else bfrdepreamount end", "bef_adjust_depreciation").addField("case when aftdepreamount is null then actual_depreciation else aftdepreamount end", "aft_adjust_depreciation");
        }
        catch (Throwable e) {
            logger.info("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null == dataSet) {
            return qingMeta;
        }
        long l1 = System.currentTimeMillis();
        dataSet = FaReportQingUtils.getAssetLevelDs(dataSet, "FaQingDepreciationData", "realcard.assetcat", "assetcat.level", "org", columnList, columnMap);
        long l2 = System.currentTimeMillis();
        logger.warn("qing depre getMeta level const = {}", (Object)(l2 - l1));
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            kd.bos.entity.qing.Field qingField = new kd.bos.entity.qing.Field();
            String fieldName = field.getName().toLowerCase();
            ReportColumn reportColumn = (ReportColumn)columnMap.get(fieldName);
            if (reportColumn == null) continue;
            qingField.setKey(fieldName);
            qingField.setName(reportColumn.getCaption());
            qingField.setHide(reportColumn.isHide());
            if ("realcard".equals(fieldName)) {
                qingField.setHide(true);
            }
            if ("category".equals(fieldName)) {
                qingField.setHide(true);
            }
            if ("depreciation_method".equals(fieldName)) {
                qingField.setHide(true);
            }
            if ("period".equals(fieldName)) {
                qingField.setHide(true);
            }
            qingField.setFieldType(this.getQingTypeByAlgoType(field.getDataType()).toNumber());
            if (field.getDataType() instanceof TimestampType) {
                qingField.setFieldType(QingFieldType.String.toNumber());
            }
            qingMeta.addColumn(qingField);
        }
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        long t2 = System.currentTimeMillis();
        logger.warn("qing depre getMeta const = {}", (Object)(t2 - t1));
        return qingMeta;
    }

    private DataSet getDepAdjustDataSet(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        long startPeriodId = filterInfo.getLong("period_start");
        long endPeriodId = filterInfo.getLong("period_end");
        long depreUse = filterInfo.getLong("depreuse");
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("q_org");
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getPkValue());
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.frealcardid realcardid, a.fbfrdepreamount bfrdepreamount, a.faftdepreamount aftdepreamount, b.fperiodid periodid from t_fa_depreadjustentry a inner join t_fa_depreadjustbill b on a.fid = b.fid where b.fbillstatus = 'C'", new Object[0]);
        sqlBuilder.append(" and b.fperiodid >= ?", new Object[]{startPeriodId});
        sqlBuilder.append(" and b.fperiodid <= ?", new Object[]{endPeriodId});
        sqlBuilder.append(" and b.fdepreuseid = ?", new Object[]{depreUse});
        sqlBuilder.appendIn(" and b.forgid ", orgIds);
        return DB.queryDataSet((String)"kd.fi.fa.report.qing.FaQingDepreciationDataProvider", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
    }

    private QingFieldType getQingTypeByAlgoType(DataType algoType) {
        if (algoType instanceof FractionalType) {
            return QingFieldType.Number;
        }
        if (algoType instanceof IntegralType) {
            return QingFieldType.Int;
        }
        if (algoType instanceof DateType) {
            return QingFieldType.Date;
        }
        if (algoType instanceof TimestampType) {
            return QingFieldType.DateTime;
        }
        if (algoType instanceof BooleanType) {
            return QingFieldType.Boolean;
        }
        return QingFieldType.String;
    }

    private IPageCache getPageCache(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return (IPageCache)view.getService(IPageCache.class);
    }
}

