/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.report.util.Rpt;

public class FaReportQingUtils {
    protected static DataSet getAssetLevelDs(DataSet dataSet, String algoKey, String reportAssetField, String assetLevelField, String reportOrgField, List<AbstractReportColumn> columnLst, Map<String, ReportColumn> columnMap) {
        int x;
        DataSet assetDs = dataSet.copy();
        int reportLevel = 0;
        ArrayList<Long> assetList = new ArrayList<Long>(16);
        HashSet<Long> orgList = new HashSet<Long>(1);
        for (Row row : assetDs) {
            if (row.getLong(reportAssetField) == null || row.getLong(reportAssetField) == 0L) continue;
            long assetcat = row.getLong(reportAssetField);
            int level = row.getInteger(assetLevelField);
            long org = row.getLong(reportOrgField);
            assetList.add(assetcat);
            orgList.add(org);
            if (reportLevel > level) continue;
            reportLevel = level;
        }
        ArrayList<ReportColumn> columnListAssets = new ArrayList<ReportColumn>(3);
        columnListAssets.add(Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\u7ea7\u6b21", (String)"FaReportQingUtils_0", (String)"fi-fa-report", (Object[])new Object[0])), "assetcatLevel", "text"));
        columnListAssets.add(Rpt.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522bid", (String)"FaReportQingUtils_1", (String)"fi-fa-report", (Object[])new Object[0])), "asset_id", "text"));
        for (x = 1; x <= reportLevel; ++x) {
            columnListAssets.add(Rpt.createColumn(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7ea7\u8d44\u4ea7\u7c7b\u522b", (String)"FaReportQingUtils_2", (String)"fi-fa-report", (Object[])new Object[0]), x)), "asset_level" + x, "text"));
        }
        columnLst.addAll(columnListAssets);
        for (x = 0; x < columnLst.size(); ++x) {
            if (columnLst.get(x) instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)columnLst.get(x);
                if (column.getFieldKey().contains("asset_level")) {
                    columnMap.put(column.getFieldKey(), column);
                }
                if (column.getFieldKey().equals("asset_id")) {
                    columnMap.put("asset_id", column);
                }
                if (!column.getFieldKey().equals("assetcatLevel")) continue;
                columnMap.put("realcard.assetcat.level", column);
                continue;
            }
            ReportColumnGroup columnGroup = (ReportColumnGroup)columnLst.get(x);
            List groupColumns = columnGroup.getChildren();
            for (AbstractReportColumn groupColumn : groupColumns) {
                ReportColumn column = (ReportColumn)groupColumn;
                columnMap.put(column.getFieldKey(), column);
            }
        }
        ArrayList<Object[]> predictResult = new ArrayList<Object[]>(3);
        Algo algo = Algo.create((String)algoKey);
        ArrayList<Field> fieldList = new ArrayList<Field>(3);
        Field assetIdfield = new Field("asset_id", (DataType)DataType.LongType);
        fieldList.add(assetIdfield);
        for (int level = reportLevel; level > 0; --level) {
            Field field = new Field("asset_level" + level, (DataType)DataType.StringType);
            fieldList.add(field);
        }
        Field[] fieldArray = fieldList.toArray(new Field[0]);
        HashMap<Long, LinkedList<Long>> allAssets = new HashMap<Long, LinkedList<Long>>();
        QFilter qAssetcategory = BaseDataServiceHelper.getBaseDataFilter((String)"fa_assetcategory", new ArrayList(orgList), (boolean)Boolean.TRUE);
        if (qAssetcategory == null) {
            return dataSet;
        }
        DynamicObject[] categroys = BusinessDataServiceHelper.load((String)"fa_assetcategory", (String)"masterid", (QFilter[])qAssetcategory.toArray());
        HashSet<Long> assetMasterIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : categroys) {
            long masterid = dynamicObject.getLong("masterid");
            assetMasterIdSet.add(masterid);
        }
        QFilter qmasterid = new QFilter("masterid", "in", assetMasterIdSet);
        DynamicObject[] assetcategories = BusinessDataServiceHelper.load((String)"fa_assetcategory", (String)"id,parent.id", (QFilter[])qmasterid.toArray());
        for (Long l : assetList) {
            Map<Long, LinkedList<Long>> rootAssets = FaReportQingUtils.getRootCategorys(l, assetcategories);
            allAssets.putAll(rootAssets);
        }
        for (Map.Entry entry : allAssets.entrySet()) {
            LinkedList assetLevelList = (LinkedList)entry.getValue();
            if (null == assetLevelList) continue;
            if (assetLevelList.size() < reportLevel) {
                Long lastLevelAsset = (Long)assetLevelList.get(0);
                for (int x2 = assetLevelList.size(); x2 < reportLevel; ++x2) {
                    assetLevelList.add(0, lastLevelAsset);
                }
            }
            assetLevelList.add(0, entry.getKey());
            Object[] objects = assetLevelList.toArray();
            predictResult.add(objects);
        }
        for (Object[] objectArray : predictResult) {
            for (int x3 = 1; x3 < objectArray.length; ++x3) {
                Long id = Long.parseLong(objectArray[x3].toString());
                assetList.add(id);
            }
        }
        Map<Long, DynamicObject> categroyMap = FaReportQingUtils.getCategroy(assetList);
        for (Object[] obj : predictResult) {
            for (int x4 = 1; x4 < obj.length; ++x4) {
                Long id = Long.parseLong(obj[x4].toString());
                if (!categroyMap.containsKey(id)) continue;
                DynamicObject categroy = categroyMap.get(id);
                String number = categroy.getString("number");
                String name = categroy.getString("name");
                obj[x4] = number + ":" + name;
            }
        }
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(new RowMeta(fieldArray));
        for (Object[] row : predictResult) {
            dataSetBuilder.append(row);
        }
        DataSet predictDataSet = dataSetBuilder.build();
        dataSet = dataSet.join(predictDataSet, JoinType.LEFT).on(reportAssetField, "asset_id").select(dataSet.getRowMeta().getFieldNames(), predictDataSet.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private static Map<Long, LinkedList<Long>> getRootCategorys(Long assetId, DynamicObject[] categroys) {
        HashMap<Long, LinkedList<Long>> rootLeafs = new HashMap<Long, LinkedList<Long>>(12);
        HashMap<Long, Long> tempMap = new HashMap<Long, Long>(20);
        int length = categroys.length;
        for (int i = 0; i < length; ++i) {
            Long id = categroys[i].getLong("id");
            Long parent = categroys[i].getLong("parent.id");
            if (parent == null || parent == 0L) {
                parent = null;
            }
            tempMap.put(id, parent);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            LinkedList tempList;
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            if (!key.equals(assetId)) continue;
            if (value == null) {
                tempList = (LinkedList)rootLeafs.get(key);
                if (tempList != null) {
                    tempList.add(key);
                    continue;
                }
                tempList = new LinkedList();
                tempList.add(key);
                rootLeafs.put(key, tempList);
                continue;
            }
            tempList = (LinkedList)rootLeafs.get(assetId);
            if (tempList != null) {
                tempList.add(key);
            } else {
                tempList = new LinkedList();
                tempList.add(key);
                rootLeafs.put(assetId, tempList);
            }
            FaReportQingUtils.getRootCategory(key, tempMap, rootLeafs, assetId);
        }
        StringBuilder sBuilder = new StringBuilder();
        for (Map.Entry entry2 : rootLeafs.entrySet()) {
            Long id = (Long)entry2.getKey();
            LinkedList list = (LinkedList)entry2.getValue();
            int listlength = list.size();
            for (int j = 0; j < listlength; ++j) {
                sBuilder.append(id).append(':').append(list.get(j)).append(',').append('\n');
            }
        }
        return rootLeafs;
    }

    private static Long getRootCategory(Long nowid, Map<Long, Long> tempMap, Map<Long, LinkedList<Long>> rootLeafs, Long initId) {
        Long parent = tempMap.get(nowid);
        if (parent != null) {
            LinkedList<Long> templist = rootLeafs.get(initId);
            if (null != templist) {
                templist.add(parent);
            }
            return FaReportQingUtils.getRootCategory(parent, tempMap, rootLeafs, initId);
        }
        return nowid;
    }

    private static Map<Long, DynamicObject> getCategroy(List<Long> assetList) {
        QFilter qAssetId = new QFilter("id", "in", assetList);
        DynamicObjectCollection categroyList = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id,number,name", (QFilter[])qAssetId.toArray());
        HashMap<Long, DynamicObject> assetMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject categroy : categroyList) {
            assetMap.put(categroy.getLong("id"), categroy);
        }
        return assetMap;
    }
}

