/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.report.FaRptSortQueryService;

public class FaAssignListQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FaAssignListQuery.class);
    private final HashMap<String, String> type_showTypes = new HashMap();
    private final HashMap<String, String> dimNames = new HashMap();
    private final Set<String> assTypeSets = new HashSet<String>(12);
    public static final String CUSTOM_PARAM_PAGE_ID = "pageId";
    public static final String APP_CACHE_TOTAL_AMOUNT = "fa_rpt_depre_assgin.totalAmount";
    FaRptSortQueryService queryService = null;

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        this.prepareAssTypeColumns(this.getQueryParam());
        this.setAssTypeName(columns);
        ReportColumn childColumnMonthDepre = new ReportColumn();
        childColumnMonthDepre.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5206\u644a\u91d1\u989d", (String)"FaAssignListQuery_0", (String)"fi-fa-report", (Object[])new Object[0])));
        childColumnMonthDepre.setFieldKey("monthdepre");
        childColumnMonthDepre.setFieldType("amount");
        childColumnMonthDepre.setCurrencyField("currency");
        columns.add((AbstractReportColumn)childColumnMonthDepre);
        return columns;
    }

    private void setAssTypeName(List<AbstractReportColumn> columns) {
        DynamicObject[] basDimNames;
        LinkedList<String> baseDimIds = new LinkedList<String>();
        for (DynamicObject dynamicObject : basDimNames = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.assTypeSets.toArray(new String[0]))})) {
            this.dimNames.put(dynamicObject.getString("id"), dynamicObject.getLocaleString("name").toString());
            baseDimIds.add(dynamicObject.getString("id"));
        }
        this.assTypeSets.removeAll(baseDimIds);
        HashSet<Long> groupIds = new HashSet<Long>(this.assTypeSets.size(), 1.0f);
        for (String assType : this.assTypeSets) {
            if (StringUtils.isEmpty((CharSequence)assType) || "null".equals(assType)) continue;
            groupIds.add(Long.parseLong(assType));
        }
        DynamicObject[] assGroups = BusinessDataServiceHelper.load((String)"bos_assistantdatagroup", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", groupIds)});
        for (DynamicObject assGroup : assGroups) {
            String groupId = assGroup.getString("id");
            String groupName = assGroup.getLocaleString("name").toString();
            this.dimNames.put(groupId, groupName);
        }
        for (Map.Entry entry : this.type_showTypes.entrySet()) {
            String dimKey = (String)entry.getKey();
            ReportColumn childColumn = new ReportColumn();
            String dimName = this.dimNames.get(dimKey);
            childColumn.setCaption(new LocaleString(dimName));
            childColumn.setFieldKey((String)entry.getValue());
            childColumn.setFieldType("text");
            columns.add((AbstractReportColumn)childColumn);
        }
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        if (this.queryService == null) {
            this.queryService = new FaRptSortQueryService("fa_rpt_depre_assgin", queryParam, "q_org", "period_start", "period_end");
        }
        return this.queryService.queryBatchBy(true, "", null);
    }

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        ReportBatchQueryInfo byBatchInfo;
        List currentBatchRows;
        if (this.queryService == null) {
            this.queryService = new FaRptSortQueryService("fa_rpt_depre_assgin", queryParam, "q_org", "period_start", "period_end");
        }
        if ((currentBatchRows = (byBatchInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo()).getCurrentBatchRows()) == null || currentBatchRows.isEmpty()) {
            logger.info("\u6298\u65e7\u5206\u644a\u8868\u67e5\u8be2==>query\u65b9\u6cd5\u4e2d\u672a\u62ff\u5230\u5206\u6279\u4f9d\u636e\uff0c\u53ef\u80fd\u662f\u8fd9\u4e2a\u7ec4\u7ec7\u6ca1\u6570\u636e\uff0c\u6216\u8005\u6709\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7aDataSet");
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(new RowMeta(new Field[0])).build();
        }
        FilterInfo filterCondition = queryParam.getFilter();
        long orgId = filterCondition.getDynamicObject("q_org").getLong("id");
        long depreUseId = filterCondition.getDynamicObject("depreuse").getLong("id");
        Long batchPeriodId = ((Row)currentBatchRows.get(0)).getLong(FaRptSortQueryService.BATCH_PERIOD);
        Long assetCatId = ((Row)currentBatchRows.get(0)).getLong(FaRptSortQueryService.BATCH_ASSETCAT);
        boolean isLastBatch = ((Row)currentBatchRows.get(0)).getBoolean(FaRptSortQueryService.BATCH_PERIODLAST);
        DataSet entryDataSet = this.getAssignDetailEntryDataSet(orgId, depreUseId, batchPeriodId, assetCatId, filterCondition);
        if (!isLastBatch && !entryDataSet.copy().hasNext()) {
            return entryDataSet.addNullField(new String[]{"summarytype", "currency"});
        }
        entryDataSet = entryDataSet.orderBy(this.queryService.getUsedDetailBatchOrderString(assetCatId > 0L));
        DataSet dataSet = entryDataSet.addNullField("summarytype");
        BigDecimal totalAmount = this.getCacheTotalAmount(queryParam);
        if (totalAmount == null) {
            totalAmount = BigDecimal.ZERO;
        }
        DataSet sumDataSet = entryDataSet.groupBy().sum("monthdepre").finish();
        BigDecimal batchAmount = BigDecimal.ZERO;
        for (Row row : sumDataSet) {
            BigDecimal monthDepre = row.getBigDecimal("monthdepre");
            batchAmount = batchAmount.add(monthDepre);
        }
        totalAmount = totalAmount.add(batchAmount);
        if (isLastBatch) {
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"monthdepre"}, (DataType[])new DataType[]{DataType.BigDecimalType});
            DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
            dataSetBuilder.append(new Object[]{totalAmount});
            sumDataSet = dataSetBuilder.build();
            Set<String> allFields = this.getFieldsByDataSet(dataSet);
            for (String field : allFields) {
                if ("monthdepre".equalsIgnoreCase(field)) continue;
                if ("summarytype".equalsIgnoreCase(field)) {
                    sumDataSet = sumDataSet.addField("1", field);
                    continue;
                }
                sumDataSet = sumDataSet.addNullField(field);
            }
            sumDataSet = sumDataSet.select(allFields.toArray(new String[0]));
            dataSet = dataSet.union(sumDataSet);
            this.removeCacheTotalAmount(queryParam);
        } else {
            this.cacheTotalAmount(queryParam, totalAmount);
        }
        dataSet = dataSet.addField(this.queryBaseCurrencyIdFromCache(queryParam), "currency");
        return dataSet;
    }

    private Set<String> getFieldsByDataSet(DataSet dataSet) {
        Field[] fields;
        LinkedHashSet<String> selFields = new LinkedHashSet<String>(12);
        if (dataSet == null) {
            return selFields;
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            selFields.add(field.getAlias().toLowerCase());
        }
        return selFields;
    }

    private void prepareAssTypeColumns(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        long orgId = filterCondition.getDynamicObject("q_org").getLong("id");
        long depreUseId = filterCondition.getDynamicObject("depreuse").getLong("id");
        long periodStartId = filterCondition.getDynamicObject("period_start").getLong("id");
        long periodEndId = filterCondition.getDynamicObject("period_end").getLong("id");
        DataSet assignDimInfoDataSet = this.getAssignDimInfoDataSet(orgId, depreUseId, periodStartId, periodEndId);
        this.assTypeSets.clear();
        while (assignDimInfoDataSet.hasNext()) {
            Row row = assignDimInfoDataSet.next();
            String assType = row.getString("asstype");
            this.assTypeSets.add(assType);
        }
        int assTypeCount = this.assTypeSets.size();
        String[] oriAssTypes = this.assTypeSets.toArray(new String[0]);
        this.type_showTypes.clear();
        for (int i = 1; i <= assTypeCount; ++i) {
            this.type_showTypes.put(oriAssTypes[i - 1], "tp__" + oriAssTypes[i - 1]);
        }
    }

    private BigDecimal getCacheTotalAmount(ReportQueryParam queryParam) {
        Map customParam = queryParam.getCustomParam();
        String pageId = (String)customParam.get(CUSTOM_PARAM_PAGE_ID);
        if (pageId == null) {
            logger.error(String.format("\u6298\u65e7\u5206\u644a\u8868\u67e5\u8be2==>getDataFromAppCache\uff1a\u4eceAppCache\u4e2d\u53d6[%s]\uff0cqueryParam\u91cc\u6ca1\u62ff\u5230pageId", APP_CACHE_TOTAL_AMOUNT));
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\u540e\u518d\u67e5\u8be2\u3002", (String)"FaAssignListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        IAppCache appCache = AppCache.get((String)"fa");
        return (BigDecimal)appCache.get(pageId + APP_CACHE_TOTAL_AMOUNT, BigDecimal.class);
    }

    private void cacheTotalAmount(ReportQueryParam queryParam, Object value) {
        Map customParam = queryParam.getCustomParam();
        String pageId = (String)customParam.get(CUSTOM_PARAM_PAGE_ID);
        if (pageId == null) {
            logger.error(String.format("\u6298\u65e7\u5206\u644a\u8868\u67e5\u8be2==>setDataToAppCache\uff1a\u4eceAppCache\u4e2d\u53d6[%s]\uff0cqueryParam\u91cc\u6ca1\u62ff\u5230pageId", APP_CACHE_TOTAL_AMOUNT));
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\u540e\u518d\u67e5\u8be2\u3002", (String)"FaAssignListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        IAppCache appCache = AppCache.get((String)"fa");
        appCache.put(pageId + APP_CACHE_TOTAL_AMOUNT, value);
    }

    private void removeCacheTotalAmount(ReportQueryParam queryParam) {
        Map customParam = queryParam.getCustomParam();
        String pageId = (String)customParam.get(CUSTOM_PARAM_PAGE_ID);
        if (pageId == null) {
            logger.error("\u6298\u65e7\u5206\u644a\u8868\u67e5\u8be2==>removeCacheTotalAmount\uff1aqueryParam\u91cc\u6ca1\u62ff\u5230pageId");
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\u540e\u518d\u67e5\u8be2\u3002", (String)"FaAssignListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        IAppCache appCache = AppCache.get((String)"fa");
        appCache.remove(pageId + APP_CACHE_TOTAL_AMOUNT);
    }

    private String queryBaseCurrencyIdFromCache(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        long orgId = filterCondition.getDynamicObject("q_org").getLong("id");
        long depreUseId = filterCondition.getDynamicObject("depreuse").getLong("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreUseFilter = new QFilter("depreuse", "=", (Object)depreUseId);
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{orgFilter, depreUseFilter});
        if (assetBook == null) {
            logger.error(String.format("\u6298\u65e7\u5206\u644a\u8868\u67e5\u8be2==>\u6839\u636e\u6838\u7b97\u7ec4\u7ec7[%s]\u3001\u6298\u65e7\u7528\u9014[%s]\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\uff0c\u8fd4\u56de\u5e01\u522bid\u9ed8\u8ba4\u503c\uff1a0", orgId, depreUseId));
            return "0";
        }
        DynamicObject currency = assetBook.getDynamicObject("basecurrency");
        return currency.getString("id");
    }

    private DataSet getAssignDetailEntryDataSet(long orgId, long depreUseId, long periodId, long assetCatId, FilterInfo filterCondition) {
        QFilter filter;
        String selectFields = this.getSelectFields();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("assentry.copyorg", "=", (Object)orgId));
        filterList.add(new QFilter("assentry.copydepreuse", "=", (Object)depreUseId));
        filterList.add(new QFilter("assentry.copyperiod", "=", (Object)periodId));
        if (assetCatId > 0L) {
            filterList.add(new QFilter("assentry.copyassetcat", "=", (Object)assetCatId));
        }
        if (Objects.nonNull(filter = filterCondition.getCommFilter("fa_depresplitdetail"))) {
            filterList.add(filter);
        }
        return QueryServiceHelper.queryDataSet((String)"fa_depre_sum.depresplitsum", (String)"fa_depresplitdetail", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), (String)this.queryService.getUsedDetailBatchOrderString(true)[0]);
    }

    private String getSelectFields() {
        LinkedHashSet<String> selectFieldSet = new LinkedHashSet<String>(8);
        selectFieldSet.add("assentry as entryid");
        selectFieldSet.add("assentry.copyrealcard as realcard");
        selectFieldSet.add("assentry.copyrealcard.number");
        selectFieldSet.add("assentry.copyfincard as fid");
        selectFieldSet.add("assentry.copyfincard.assetcat.number as assetcat.number");
        selectFieldSet.add("assentry.orgduty as orgduty");
        selectFieldSet.add("assentry.splitamount as monthdepre");
        selectFieldSet.add("assentry.copyperiod as assperiod");
        selectFieldSet.add("assentry.copyorg as org");
        selectFieldSet.add("assentry.copydepreuse as depreuse");
        return String.join((CharSequence)",", selectFieldSet);
    }

    private DataSet getAssignDimInfoDataSet(long orgId, long depreUseId, long startPeriodId, long endPeriodId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fasstype as asstype ", new Object[0]);
        sqlBuilder.append("from t_fa_depresum_assentry a ", new Object[0]);
        sqlBuilder.append("left join t_fa_depre b on a.fid = b.fid ", new Object[0]);
        sqlBuilder.append("where b.forgid = ? and b.fdepreuseid = ? and b.fperiodid >= ? and b.fperiodid <= ?;", new Object[]{orgId, depreUseId, startPeriodId, endPeriodId});
        return DB.queryDataSet((String)"fa_depre_sum.depresplitsum", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
    }
}

