/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.report.SumFlagEnum;
import kd.fi.fa.business.report.FaRptSortQueryService;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.report.query.FaCardListQueryBase;
import kd.fi.fa.report.util.FaReportUtils;

public class FaCardListQuery
extends FaCardListQueryBase {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log logger = LogFactory.getLog(FaCardListQuery.class);
    private static final Long MERGE_CHANGE_ID = 21L;
    private FaRptSortQueryService queryService = null;

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        Object pageId = queryParam.getCustomParam().get("pageId");
        FaReportUtils.cleanRptCacheKey(pageId.toString());
        if (this.queryService == null) {
            this.queryService = new FaRptSortQueryService("fa_rpt_card", queryParam, "q_org", "q_period", null);
        }
        return this.queryService.queryBatchBy(true, "", null);
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object select) throws Throwable {
        if (this.queryService == null) {
            this.queryService = new FaRptSortQueryService("fa_rpt_card", queryParam, "q_org", "q_period", null);
        }
        return this.query(queryParam, new HashSet<String>());
    }

    public DataSet query(ReportQueryParam queryParam, Set<String> otherRealFields) {
        DataSet dataSet = null;
        if (queryParam == null) {
            return dataSet;
        }
        ReportBatchQueryInfo byBatchInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo();
        FilterInfo filterCondition = queryParam.getFilter();
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        Long curOrgId = null;
        long curAssetCatId = 0L;
        boolean orgLastBatch = false;
        boolean usedDetailBatch = false;
        if (byBatchInfo.isLargeData()) {
            List currentBatchRows = byBatchInfo.getCurrentBatchRows();
            for (Row row : currentBatchRows) {
                orgLastBatch = row.getBoolean(FaRptSortQueryService.BATCH_ORGLAST);
                curOrgId = row.getLong(FaRptSortQueryService.BATCH_ORG);
                curAssetCatId = row.getLong(FaRptSortQueryService.BATCH_ASSETCAT);
            }
        }
        QFilter qorg = new QFilter("org", "=", curOrgId);
        QFilter commFilter = filterCondition.getCommFilter("fa_card_fin");
        if (commFilter == null && curAssetCatId > 0L) {
            usedDetailBatch = true;
            finCardFilters.add(new QFilter("assetcat", "=", (Object)curAssetCatId));
        }
        DynamicObject depreUse = filterCondition.getDynamicObject("depreuse");
        DynamicObject period = null;
        period = queryParam.getFilter().containProp("q_period") ? filterCondition.getDynamicObject("q_period") : filterCondition.getDynamicObject("period_start");
        DynamicObject periodType = filterCondition.getDynamicObject("periodtype");
        Long periodPk = period.getLong("id");
        Object qdepreUsePk = depreUse.getPkValue();
        Object qperiodTypePk = periodType.getPkValue();
        QFilter qdepreUse = new QFilter("depreuse", "=", qdepreUsePk);
        QFilter qperiodType = new QFilter("periodtype", "=", qperiodTypePk);
        Object currencyPk = null;
        ArrayList<Object> assetBookIds = new ArrayList<Object>(10);
        String selectAssetBookField = Fa.join((String)",", (String[])new String[]{"id", "basecurrency", "periodtype", "curperiod", "org"});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectAssetBookField, (QFilter[])new QFilter[]{qorg, qdepreUse, qperiodType});
        DynamicObject[] assetBooks = objectDynamicObjectMap.values().toArray(new DynamicObject[0]);
        HashSet<String> currencyPks = new HashSet<String>();
        HashMap<Long, Long> assetBookOrg2FinalQueryPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> assetBookOrg2AssetBookMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject assetBook : assetBooks) {
            assetBookIds.add(assetBook.getPkValue());
            DynamicObject currency = assetBook.getDynamicObject("basecurrency");
            currencyPk = currency.getPkValue();
            currencyPks.add(String.valueOf(currencyPk));
            long orgId = (Long)assetBook.getDynamicObject("org").getPkValue();
            long curPeriod = (Long)assetBook.getDynamicObject("curperiod").getPkValue();
            long queryPeriodId = periodPk;
            assetBookOrg2FinalQueryPeriodMap.put(orgId, Math.min(queryPeriodId, curPeriod));
            assetBookOrg2AssetBookMap.put(orgId, assetBook);
        }
        Long finalQueryPeriodId = (Long)assetBookOrg2FinalQueryPeriodMap.get(curOrgId);
        finCardFilters.addAll(this.getFinCardFilters(filterCondition, finalQueryPeriodId));
        finCardFilters.add(qorg);
        finCardFilters.add(qdepreUse);
        finCardFilters.add(new QFilter("assetbook", "in", assetBookIds));
        long assetBookCurPeriodId = this.getAssetBookCurPeriodId(assetBookOrg2AssetBookMap, curOrgId);
        try {
            if (currencyPks.size() == 1) {
                dataSet = this.getDataSet(finCardFilters, true, otherRealFields, filterCondition, periodPk, usedDetailBatch, true);
                dataSet = dataSet.removeFields(new String[]{"currency"}).addField(String.valueOf(currencyPk), "currency");
                dataSet = dataSet.addField(String.valueOf(assetBookCurPeriodId), "assetbookcurperiod");
                if (!orgLastBatch && dataSet.isEmpty()) {
                    return dataSet;
                }
                Object enableSum = queryParam.getCustomParam().get("enableSum");
                if ("false".equals(enableSum)) {
                    return dataSet;
                }
                DataSet batchSum = this.getSumData(dataSet.copy(), otherRealFields);
                Row batchSumRow = null;
                if (batchSum.hasNext()) {
                    batchSumRow = batchSum.next();
                }
                Object pageId = queryParam.getCustomParam().get("pageId");
                String cacheKey = FaReportUtils.getRptCacheKey(pageId.toString());
                IAppCache appCache = AppCache.get((String)"fa");
                String cacheDataSetId = (String)appCache.get(cacheKey, String.class);
                if (orgLastBatch) {
                    DataSet build = null;
                    if (cacheDataSetId == null) {
                        DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(batchSum.getRowMeta());
                        if (batchSumRow != null) {
                            dataSetBuilder.append(batchSumRow);
                        }
                        build = dataSetBuilder.build();
                    } else {
                        build = this.mergeCurrentAndCache(otherRealFields, batchSumRow, cacheDataSetId);
                    }
                    build = build.removeFields(new String[]{"currency"}).addField(String.valueOf(currencyPk), "currency");
                    build = build.addNullField("assetbookcurperiod");
                    dataSet = dataSet.union(build);
                } else if (cacheDataSetId == null) {
                    DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(batchSum.getRowMeta());
                    if (batchSumRow != null) {
                        dataSetBuilder.append(batchSumRow);
                    }
                    CachedDataSet cacheDataSet = dataSetBuilder.build().cache(CacheHint.getDefault());
                    appCache.put(cacheKey, (Object)cacheDataSet.getCacheId());
                } else {
                    DataSet build = this.mergeCurrentAndCache(otherRealFields, batchSumRow, cacheDataSetId);
                    CachedDataSet newCacheDataSet = build.cache(CacheHint.getDefault());
                    appCache.put(cacheKey, (Object)newCacheDataSet.getCacheId());
                }
            } else {
                dataSet = this.getDataSet(finCardFilters, false, otherRealFields, filterCondition, periodPk, usedDetailBatch, true);
                dataSet = dataSet.addField(String.valueOf(assetBookCurPeriodId), "assetbookcurperiod");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\u201c%s\u201d\u3002", (String)"FaCardListQuery_0", (String)"fi-fa-report", (Object[])new Object[0]), e.getMessage()));
        }
        return dataSet;
    }

    private DataSet mergeCurrentAndCache(Set<String> otherRealFields, Row batchSumRow, String cacheDataSetId) {
        CachedDataSet lastCacheDataSet = Algo.getCacheDataSet((String)cacheDataSetId);
        List rowList = lastCacheDataSet.getList(0, lastCacheDataSet.getRowCount());
        DataSetBuilder sumDataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(lastCacheDataSet.getRowMeta());
        if (batchSumRow != null) {
            sumDataSetBuilder.append(batchSumRow);
        }
        if (rowList.size() > 0) {
            sumDataSetBuilder.append((Row)rowList.get(0));
        }
        DataSet build = sumDataSetBuilder.build();
        build = this.getSumData(build, otherRealFields);
        return build;
    }

    private DataSet getSumData(DataSet dataSet, Set<String> otherRealFields) {
        String[] groupFields = new String[]{};
        DataSet result = dataSet.groupBy(groupFields).sum("originalval").sum("accumdepre").sum("preresidualval").sum("networth").sum("decval").sum("netamount").sum("incometax").finish();
        List<String> addFieldList = this.getRptListField(otherRealFields);
        addFieldList.remove("originalval");
        addFieldList.remove("accumdepre");
        addFieldList.remove("preresidualval");
        addFieldList.remove("networth");
        addFieldList.remove("decval");
        addFieldList.remove("netamount");
        addFieldList.remove("incometax");
        addFieldList.remove("summarytype");
        result = result.addField(SumFlagEnum.TOTAL.getIndex() + "", "summarytype");
        for (String str : addFieldList) {
            if ("number".equals(str)) {
                result = result.addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"FaCardListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]), str);
                continue;
            }
            result = result.addNullField(str);
        }
        result = result.select(this.getRptListField(otherRealFields).toArray(new String[0]));
        return result;
    }

    private DataSet getDataSet(List<QFilter> finCardFilters, boolean isSum, Set<String> otherRealFields, FilterInfo filterCondition, Long periodPk, boolean usedDetailBatch, boolean isNotQingQuery) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_card_fin", (String)this.getCurSelectedFields(otherRealFields), (QFilter[])finCardFilters.toArray(new QFilter[0]), null);
        DataSet det = dataSet.select(this.getRptListField(otherRealFields).toArray(new String[0]));
        if (isNotQingQuery) {
            det = det.orderBy(this.queryService.getUsedDetailBatchOrderString(usedDetailBatch));
        }
        if (filterCondition.getBoolean("list_clearcard")) {
            DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
            LinkedList<Object> orgIds = new LinkedList<Object>();
            for (DynamicObject org : orgs) {
                orgIds.add(org.getPkValue());
            }
            QFilter qchgOrg = new QFilter("org", "in", orgIds);
            QFilter periodFilter = new QFilter("clearperiod", "<=", (Object)periodPk);
            QFilter changeModeFilter = new QFilter("changemode", "=", (Object)21L);
            DataSet clearDs = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_clearbill", (String)"detail_entry.fincard clearfincard", (QFilter[])new QFilter[]{qchgOrg, periodFilter, changeModeFilter}, null);
            det = det.join(clearDs, JoinType.LEFT).on("fid", "clearfincard").select(det.getRowMeta().getFieldNames(), clearDs.getRowMeta().getFieldNames()).finish();
            det = det.filter("clearfincard = null");
            det = det.removeFields(new String[]{"clearfincard"});
        }
        return det;
    }

    public DataSet qingQuery(ReportQueryParam queryParam, Set<String> otherRealFields) {
        DataSet dataSet = null;
        if (queryParam == null) {
            return dataSet;
        }
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        DynamicObject depreUse = filterCondition.getDynamicObject("depreuse");
        DynamicObject period = null;
        period = queryParam.getFilter().containProp("q_period") ? filterCondition.getDynamicObject("q_period") : filterCondition.getDynamicObject("period_start");
        DynamicObject periodType = filterCondition.getDynamicObject("periodtype");
        long periodPk = period.getLong("id");
        Object qdepreUsePk = depreUse.getPkValue();
        Object qperiodTypePk = periodType.getPkValue();
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getPkValue());
        }
        QFilter qorg = new QFilter("org", "in", orgIds);
        QFilter qdepreUse = new QFilter("depreuse", "=", qdepreUsePk);
        QFilter qperiodType = new QFilter("periodtype", "=", qperiodTypePk);
        DynamicObject[] assetBooks = null;
        Object currencypk = null;
        ArrayList<Object> assetBookIds = new ArrayList<Object>(10);
        List<QFilter> finCardFilters = this.getFinCardFilters(filterCondition, periodPk);
        assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,basecurrency,periodtype", (QFilter[])new QFilter[]{qorg, qdepreUse, qperiodType});
        HashSet<String> currencyPks = new HashSet<String>();
        for (DynamicObject assetbook : assetBooks) {
            assetBookIds.add(assetbook.getPkValue());
            DynamicObject currency = assetbook.getDynamicObject("basecurrency");
            currencypk = currency.getPkValue();
            currencyPks.add(String.valueOf(currencypk));
        }
        finCardFilters.add(qorg);
        finCardFilters.add(qdepreUse);
        finCardFilters.add(new QFilter("assetbook", "in", assetBookIds));
        try {
            if (currencyPks.size() == 1) {
                dataSet = this.getDataSet(finCardFilters, true, otherRealFields, filterCondition, periodPk, false, false);
                dataSet = dataSet.addField(String.valueOf(currencypk), "currency");
            } else {
                dataSet = this.getDataSet(finCardFilters, false, otherRealFields, filterCondition, periodPk, false, false);
            }
        }
        catch (Exception e) {
            logger.error("\u8d44\u4ea7\u6e05\u5355\u8f7b\u5206\u6790\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a" + ThrowableHelper.toString((Throwable)e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\u201c%s\u201d\u3002", (String)"FaCardListQuery_0", (String)"fi-fa-report", (Object[])new Object[0]), e.getMessage()));
        }
        return dataSet;
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return columns;
    }
}

