/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.enums.report.SumFlagEnum;

public class FaCardListQueryBase
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return null;
    }

    protected long getAssetBookCurPeriodId(Map<Long, DynamicObject> assetBookOrg2AssetBookMap, Long orgId) {
        if (Objects.isNull(orgId) || assetBookOrg2AssetBookMap == null || assetBookOrg2AssetBookMap.size() == 0) {
            return 0L;
        }
        DynamicObject dynamicObject = assetBookOrg2AssetBookMap.get(orgId);
        if (Objects.isNull(dynamicObject)) {
            return 0L;
        }
        return (Long)dynamicObject.getDynamicObject("curperiod").getPkValue();
    }

    protected List<QFilter> getFinCardFilters(FilterInfo filterCondition, Object periodPk) {
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        if (filterCondition.getBoolean("list_initcard")) {
            finCardFilters.add(new QFilter("bizperiod", "=", (Object)0L));
        } else {
            if (!filterCondition.getBoolean("list_unaduit")) {
                finCardFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
            }
            finCardFilters.add(new QFilter("endperiod", ">", periodPk));
            finCardFilters.add(new QFilter("bizperiod", "<=", periodPk));
            if (!filterCondition.getBoolean("list_clearcard")) {
                finCardFilters.add(new QFilter("bizperiod", "<", (Object)"clearperiod", true).or(new QFilter("clearperiod", "=", (Object)0L)));
            }
        }
        Map deFilterMap = filterCondition.getCommFilters();
        if (deFilterMap.get("fa_card_fin") != null) {
            List filters = (List)deFilterMap.get("fa_card_fin");
            for (QFilter filter : filters) {
                if (filter == null) continue;
                finCardFilters.add(filter);
            }
        }
        return finCardFilters;
    }

    protected List<String> getRptListField(Set<String> otherRealFields) {
        ArrayList<String> result = new ArrayList<String>(17);
        result.add("fid");
        result.add("assetbook");
        result.add("assetcat");
        result.add("assetcat.number");
        result.add("number");
        result.add("realcard");
        result.add("finaccountdate");
        result.add("depremethod");
        result.add("originalval");
        result.add("preusingamount");
        result.add("depredamount");
        result.add("accumdepre");
        result.add("preresidualval");
        result.add("networth");
        result.add("decval");
        result.add("netamount");
        result.add("summarytype");
        result.add("incometax");
        result.add("depreusename");
        result.add("currency");
        if (!otherRealFields.isEmpty()) {
            result.addAll(otherRealFields);
        }
        return result;
    }

    protected String getCurSelectedFields(Set<String> otherRealFields) {
        List<String> result = this.buildCurSelectFieldLst();
        if (!otherRealFields.isEmpty()) {
            result.addAll(otherRealFields);
        }
        return String.join((CharSequence)",", result);
    }

    private List<String> buildCurSelectFieldLst() {
        ArrayList<String> result = new ArrayList<String>(19);
        result.add(String.format("%s as %s", "id", "fid"));
        result.add(String.format("%s as %s", "org", "assetbook"));
        result.add("assetcat");
        result.add("assetcat.number");
        result.add(String.format("%s as %s", "assetcat.level", "level"));
        result.add("number");
        result.add("realcard");
        result.add(String.format("%s as %s", "finaccountdate", "finaccountdate"));
        result.add(String.format("%s as %s", "depremethod", "depremethod"));
        result.add(String.format("%s as %s", "originalval", "originalval"));
        result.add(String.format("%s as %s", "preusingamount", "preusingamount"));
        result.add(String.format("%s as %s", "depredamount", "depredamount"));
        result.add(String.format("%s as %s", "accumdepre", "accumdepre"));
        result.add(String.format("%s as %s", "preresidualval", "preresidualval"));
        result.add(String.format("%s as %s", "networth", "networth"));
        result.add(String.format("%s as %s", "decval", "decval"));
        result.add(String.format("%s as %s", "netamount", "netamount"));
        result.add(String.format("%s as %s", SumFlagEnum.NOT_SUM.getIndex(), "summarytype"));
        result.add(String.format("%s as %s", "clearperiod", "clearperiod"));
        result.add(String.format("%s as %s", "bizperiod", "bizperiod"));
        result.add(String.format("%s as %s", "incometax", "incometax"));
        result.add(String.format("%s as %s", "depreuse.name", "depreusename"));
        result.add(String.format("%s as %s", "basecurrency", "currency"));
        return result;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return columns;
    }
}

