/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.report.query.FaCardListQuery;
import kd.fi.fa.report.query.FaCardListQueryBase;

public class FaCardListTreeQuery
extends FaCardListQueryBase {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log logger = LogFactory.getLog(FaCardListQuery.class);

    @Override
    public DataSet query(ReportQueryParam queryParam, Object select) throws Throwable {
        return this.query(queryParam, new HashSet<String>());
    }

    private DataSet getEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new Field[0]);
        DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(rowMeta);
        return dataSetBuilder.build();
    }

    public DataSet query(ReportQueryParam queryParam, Set<String> otherRealFields) {
        DataSet allDataSet;
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObject depreUse = filterCondition.getDynamicObject("depreuse");
        DynamicObject period = queryParam.getFilter().containProp("q_period") ? filterCondition.getDynamicObject("q_period") : filterCondition.getDynamicObject("period_start");
        DynamicObject periodType = filterCondition.getDynamicObject("periodtype");
        Object periodPk = period.getPkValue();
        Object qDepreUsePk = depreUse.getPkValue();
        Object qPeriodTypePk = periodType.getPkValue();
        DynamicObjectCollection dynamicObjectCollectionOrg = filterCondition.getDynamicObjectCollection("q_org");
        List<Long> orgPks = dynamicObjectCollectionOrg.stream().map(v -> (Long)v.getPkValue()).collect(Collectors.toList());
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", orgPks, (boolean)Boolean.TRUE);
        ArrayList<TreeNode> orgTreeList = new ArrayList<TreeNode>();
        orgPks.forEach(orgId -> {
            OrgTreeParam param = new OrgTreeParam();
            param.setOrgViewType("10");
            param.setId(orgId.longValue());
            param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
            List treeNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
            TreeNode treeNode = new TreeNode();
            treeNode.setId(orgId.toString());
            treeNodeList = treeNodeList.stream().filter(node -> node.getParentid().equals(orgId.toString())).collect(Collectors.toList());
            treeNode.setChildren(treeNodeList);
            orgTreeList.add(treeNode);
        });
        ArrayList allSubordinateOrgObjectList = new ArrayList(allSubordinateOrgs);
        QFilter qOrg = new QFilter("org", "in", allSubordinateOrgObjectList);
        QFilter qDepreUse = new QFilter("depreuse", "=", qDepreUsePk);
        QFilter qPeriodType = new QFilter("periodtype", "=", qPeriodTypePk);
        Object currencyPk = null;
        String selectAssetBookField = Fa.join((String)",", (String[])new String[]{"id", "basecurrency", "periodtype", "curperiod", "org"});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectAssetBookField, (QFilter[])new QFilter[]{qOrg, qDepreUse, qPeriodType});
        DynamicObject[] assetBooks = objectDynamicObjectMap.values().toArray(new DynamicObject[0]);
        HashMap<Long, Long> assetBookOrg2FinalQueryPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> assetBookOrg2AssetBookMap = new HashMap<Long, DynamicObject>(16);
        HashSet<String> currencyPks = new HashSet<String>(assetBooks.length);
        for (DynamicObject assetBook : assetBooks) {
            long orgId2 = (Long)assetBook.getDynamicObject("org").getPkValue();
            long curPeriod = (Long)assetBook.getDynamicObject("curperiod").getPkValue();
            long queryPeriodId = (Long)periodPk;
            assetBookOrg2FinalQueryPeriodMap.put(orgId2, Math.min(queryPeriodId, curPeriod));
            assetBookOrg2AssetBookMap.put(orgId2, assetBook);
            DynamicObject currency = assetBook.getDynamicObject("basecurrency");
            currencyPk = currency.getPkValue();
            currencyPks.add(String.valueOf(currencyPk));
        }
        logger.info("\u6700\u7ec8\u67e5\u8be2\u671f\u95f4 map: {}", assetBookOrg2FinalQueryPeriodMap);
        logger.info("\u8d44\u4ea7\u8d26\u7c3f map: {}", assetBookOrg2AssetBookMap);
        ArrayList<DataSet> result = new ArrayList<DataSet>(16);
        for (Map.Entry map : assetBookOrg2FinalQueryPeriodMap.entrySet()) {
            Long orgId3 = (Long)map.getKey();
            Long finalQueryPeriodId = (Long)map.getValue();
            List<QFilter> finCardFilters = this.getFinCardFilters(filterCondition, finalQueryPeriodId);
            finCardFilters.add(new QFilter("org", "=", (Object)orgId3));
            finCardFilters.add(qDepreUse);
            Long assetBookId = (Long)((DynamicObject)assetBookOrg2AssetBookMap.get(orgId3)).getPkValue();
            finCardFilters.add(new QFilter("assetbook", "=", (Object)assetBookId));
            try {
                if (currencyPks.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u7ec7\u5e01\u522b\u4e0d\u4e00\u81f4", (String)"FaCardListTreeQuery_0", (String)"fi-fa-report", (Object[])new Object[0]));
                }
                DataSet faCardFinDataSet = this.getDataSet(finCardFilters, otherRealFields);
                faCardFinDataSet = faCardFinDataSet.addField(String.valueOf(currencyPk), "currency");
                result.add(faCardFinDataSet);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u6e05\u5355\u865a\u4f53\u67e5\u8be2\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b[%s]", (String)"FaCardListTreeQuery_1", (String)"fi-fa-report", (Object[])new Object[0]), e.getMessage()));
            }
        }
        if (result.size() == 0) {
            return this.getEmptyDataSet();
        }
        if (result.size() == 1) {
            allDataSet = (DataSet)result.get(0);
        } else {
            allDataSet = (DataSet)result.get(0);
            for (int i = 1; i < result.size(); ++i) {
                allDataSet = allDataSet.union((DataSet)result.get(i));
            }
        }
        return this.getSumData(allDataSet, otherRealFields, orgTreeList, assetBookOrg2AssetBookMap);
    }

    private DataSet getSumData(DataSet allDataSet, Set<String> otherRealFields, List<TreeNode> orgTreeList, Map<Long, DynamicObject> assetBookOrg2AssetBookMap) {
        String[] groupFields = new String[]{"assetbook", "currency"};
        DataSet result = allDataSet.groupBy(groupFields).sum("originalval").sum("incometax").sum("accumdepre").sum("preresidualval").sum("networth").sum("decval").sum("netamount").finish();
        for (Row row : result.copy()) {
            for (TreeNode treeNode : orgTreeList) {
                this.setTreeNodeData(row, treeNode);
            }
        }
        for (TreeNode treeNode : orgTreeList) {
            this.graduallySummaryAmount(treeNode);
        }
        for (TreeNode treeNode : orgTreeList) {
            this.setOtherAttr(treeNode, assetBookOrg2AssetBookMap);
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("rowid", (DataType)DataType.LongType), new Field("pid", (DataType)DataType.LongType), new Field("isgroupnode", (DataType)DataType.BooleanType), new Field("assetbook", (DataType)DataType.StringType), new Field("currency", (DataType)DataType.LongType), new Field("originalval", (DataType)DataType.BigDecimalType), new Field("incometax", (DataType)DataType.BigDecimalType), new Field("accumdepre", (DataType)DataType.BigDecimalType), new Field("preresidualval", (DataType)DataType.BigDecimalType), new Field("networth", (DataType)DataType.BigDecimalType), new Field("decval", (DataType)DataType.BigDecimalType), new Field("netamount", (DataType)DataType.BigDecimalType), new Field("assetbookcurperiod", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(rowMeta);
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : orgTreeList) {
            this.filterNullData(treeNodeList, treeNode);
        }
        for (TreeNode treeNode : treeNodeList) {
            Object data = treeNode.getData();
            dataSetBuilder.append((Object[])data);
        }
        DataSet dataSet = dataSetBuilder.build();
        List<String> addFieldList = this.getRptListField(otherRealFields);
        addFieldList.remove("assetbook");
        addFieldList.remove("currency");
        addFieldList.remove("originalval");
        addFieldList.remove("incometax");
        addFieldList.remove("accumdepre");
        addFieldList.remove("preresidualval");
        addFieldList.remove("networth");
        addFieldList.remove("decval");
        addFieldList.remove("netamount");
        addFieldList.remove("assetbookcurperiod");
        DataSet dataSet2 = dataSet.addNullField(addFieldList.toArray(new String[0]));
        List<String> rptListField = this.getRptListField(otherRealFields);
        rptListField.add("rowid");
        rptListField.add("pid");
        rptListField.add("isgroupnode");
        rptListField.add("assetbookcurperiod");
        DataSet dataSet3 = dataSet2.select(rptListField.toArray(new String[0]));
        return dataSet3;
    }

    private Object[] graduallySummaryAmount(TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (children == null || children.size() == 0) {
            Object data = treeNode.getData();
            if (Objects.isNull(data)) {
                return null;
            }
            return (Object[])data;
        }
        Object[] fatherData = treeNode.getData();
        for (TreeNode child : children) {
            Object[] childData = this.graduallySummaryAmount(child);
            if (Objects.isNull(childData)) continue;
            if (Objects.isNull(fatherData)) {
                Object[] data = new Object[childData.length];
                data[0] = treeNode.getId();
                System.arraycopy(childData, 1, data, 1, childData.length - 1);
                fatherData = data;
                continue;
            }
            for (int i = 2; i < ((Object[])fatherData).length; ++i) {
                ((Object[])fatherData)[i] = ((BigDecimal)((Object[])fatherData)[i]).add((BigDecimal)childData[i]);
            }
        }
        treeNode.setData((Object)fatherData);
        if (Objects.isNull(fatherData)) {
            return null;
        }
        return fatherData;
    }

    private void filterNullData(List<TreeNode> treeNodeList, TreeNode treeNode) {
        List children = treeNode.getChildren();
        Object data = treeNode.getData();
        if (Objects.nonNull(data)) {
            treeNodeList.add(treeNode);
        }
        if (children == null || children.size() == 0) {
            return;
        }
        for (TreeNode child : children) {
            this.filterNullData(treeNodeList, child);
        }
    }

    private void setOtherAttr(TreeNode treeNode, Map<Long, DynamicObject> assetBookOrg2AssetBookMap) {
        List children = treeNode.getChildren();
        Object data = treeNode.getData();
        if (children == null || children.size() == 0) {
            if (Objects.isNull(data)) {
                return;
            }
            String pId = treeNode.getParentid();
            long pIdLong = 0L;
            if (StringUtils.isNotEmpty((String)pId)) {
                pIdLong = Long.parseLong(pId);
            }
            String rowId = treeNode.getId();
            long rowIdLong = 0L;
            if (StringUtils.isNotEmpty((String)rowId)) {
                rowIdLong = Long.parseLong(rowId);
            }
            Object[] objects = (Object[])data;
            int len = objects.length;
            Object[] newValues = new Object[len + 4];
            newValues[0] = rowIdLong;
            newValues[1] = pIdLong;
            newValues[2] = Boolean.FALSE;
            newValues[3] = rowIdLong;
            newValues[4] = this.getAssetBookBaseCurrency(assetBookOrg2AssetBookMap, rowIdLong);
            System.arraycopy(objects, 2, newValues, 5, len - 2);
            long assetBookCurPeriodId = this.getAssetBookCurPeriodId(assetBookOrg2AssetBookMap, rowIdLong);
            newValues[newValues.length - 1] = assetBookCurPeriodId;
            treeNode.setData((Object)newValues);
            return;
        }
        if (Objects.isNull(data)) {
            return;
        }
        String pId = treeNode.getParentid();
        long pIdLong = 0L;
        if (StringUtils.isNotEmpty((String)pId)) {
            pIdLong = Long.parseLong(pId);
        }
        String rowId = treeNode.getId();
        long rowIdLong = 0L;
        if (StringUtils.isNotEmpty((String)rowId)) {
            rowIdLong = Long.parseLong(rowId);
        }
        Object[] objects = (Object[])data;
        int len = objects.length;
        Object[] newValues = new Object[len + 4];
        newValues[0] = rowIdLong;
        newValues[1] = pIdLong;
        newValues[2] = Boolean.TRUE;
        newValues[3] = rowIdLong;
        newValues[4] = this.getAssetBookBaseCurrency(assetBookOrg2AssetBookMap, rowIdLong);
        System.arraycopy(objects, 2, newValues, 5, len - 2);
        long assetBookCurPeriodId = this.getAssetBookCurPeriodId(assetBookOrg2AssetBookMap, rowIdLong);
        newValues[newValues.length - 1] = assetBookCurPeriodId;
        treeNode.setData((Object)newValues);
        for (TreeNode child : children) {
            this.setOtherAttr(child, assetBookOrg2AssetBookMap);
        }
    }

    private long getAssetBookBaseCurrency(Map<Long, DynamicObject> assetBookOrg2AssetBookMap, Long orgId) {
        if (Objects.isNull(orgId) || assetBookOrg2AssetBookMap == null || assetBookOrg2AssetBookMap.size() == 0) {
            return 0L;
        }
        DynamicObject dynamicObject = assetBookOrg2AssetBookMap.get(orgId);
        if (Objects.isNull(dynamicObject)) {
            return 0L;
        }
        return (Long)dynamicObject.getDynamicObject("basecurrency").getPkValue();
    }

    private void sumByTreeNode(TreeNode father, TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (children == null || children.size() == 0) {
            Object data = treeNode.getData();
            if (Objects.isNull(data) || Objects.isNull(father)) {
                return;
            }
            Object[] sonObjectArray = (Object[])data;
            if (father.getData() != null) {
                Object[] fatherObjectArray = (Object[])father.getData();
                for (int i = 1; i < fatherObjectArray.length; ++i) {
                    fatherObjectArray[i] = ((BigDecimal)fatherObjectArray[i]).add((BigDecimal)sonObjectArray[i]);
                }
                father.setData((Object)fatherObjectArray);
            } else {
                String id = father.getId();
                Object[] newValues = new Object[sonObjectArray.length];
                newValues[0] = id;
                System.arraycopy(sonObjectArray, 1, newValues, 1, sonObjectArray.length - 1);
                father.setData((Object)newValues);
            }
            return;
        }
        for (TreeNode child : children) {
            this.sumByTreeNode(treeNode, child);
        }
    }

    private void setTreeNodeData(Row row, TreeNode treeNode) {
        String id = treeNode.getId();
        List children = treeNode.getChildren();
        if (id.equals(row.getString("assetbook"))) {
            treeNode.setData((Object)RowUtil.toArray((Row)row));
            return;
        }
        if (children == null || children.size() == 0) {
            return;
        }
        for (TreeNode child : children) {
            this.setTreeNodeData(row, child);
        }
    }

    private DataSet getDataSet(List<QFilter> finCardFilters, Set<String> otherRealFields) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_card_fin", (String)this.getCurSelectedFields(otherRealFields), (QFilter[])finCardFilters.toArray(new QFilter[0]), null);
        dataSet = dataSet.select(this.getRptListField(otherRealFields).toArray(new String[0]));
        return dataSet.top(100000).orderBy(new String[]{"assetbook ", "assetcat desc", "number"});
    }
}

