/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.Tips;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaDataSetUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaCostListQuery
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log logger = LogFactory.getLog(FaCostListQuery.class);
    private static final ThreadLocal<HashMap<String, BigDecimal>> RANGE_VALUES = new ThreadLocal();
    public static final String DIM_VALUE_CACHE = "fa_rpt_amortisedCost.dim_values";
    public static final String CUSTOM_PARAM_PAGE_ID = "pageId";

    public DataSet query(ReportQueryParam queryParam, Object select) throws Throwable {
        return this.query(queryParam, new ArrayList<String>());
    }

    public DataSet query(ReportQueryParam queryParam, List<String> otherContractFields) {
        Date enddate;
        if (queryParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\u67e5\u8be2", (String)"FaCostListQuery_0", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObjectCollection org = filterCondition.getDynamicObjectCollection("q_org");
        List<Object> orgIds = org.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter commFilter = filterCondition.getCommFilter("fa_lease_contract");
        boolean includeTermination = filterCondition.getBoolean("q_includetermination");
        boolean includeExpiration = filterCondition.getBoolean("q_includeexpiration");
        DynamicObject queryPeriod = filterCondition.getDynamicObject("q_period_select");
        queryPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate,periodtype,periodnumber,periodyear", (QFilter[])new QFilter("id", "=", (Object)queryPeriod.getLong("id")).toArray());
        Date monthEndDate = enddate = queryPeriod.getDate("enddate");
        ArrayList<QFilter> leaseContractFilter = new ArrayList<QFilter>(4);
        leaseContractFilter.add(new QFilter("org", "in", orgIds));
        leaseContractFilter.add(new QFilter("isexempt", "=", (Object)Boolean.FALSE));
        leaseContractFilter.add(new QFilter("status", "=", (Object)BillStatus.C.name()));
        QFilter newContractFilter = new QFilter("sourcetype", "=", (Object)LeaseContractSourceType.A.name()).and(new QFilter("initconfirmdate", "<=", (Object)monthEndDate));
        QFilter initContractFilter = new QFilter("sourcetype", "=", (Object)LeaseContractSourceType.B.name()).and(new QFilter("sysswitchdate", "<=", (Object)monthEndDate));
        leaseContractFilter.add(newContractFilter.or(initContractFilter));
        String selectContractFields = Fa.comma((String[])new String[]{"id", "masterid", "settlesharesrcid", "isbak", "version", "leaseterminationdate", "leaseenddate"});
        String order = "masterid, isbak asc, version desc";
        DataSet leaseContracts = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_lease_contract", (String)selectContractFields, (QFilter[])leaseContractFilter.toArray(new QFilter[0]), (String)order);
        HashSet<Long> excludeMasterId = new HashSet<Long>(32);
        HashSet<Long> allContractIds = new HashSet<Long>(32);
        HashSet<Long> contractId4LeaseLiab = new HashSet<Long>(32);
        HashSet<Long> contractId4UseRight = new HashSet<Long>(32);
        HashSet<Long> contractId4Range = new HashSet<Long>(32);
        HashSet<Long> leaseContractSet = new HashSet<Long>(16);
        for (Object row : leaseContracts.copy()) {
            Long masterId = row.getLong("masterid");
            leaseContractSet.add(masterId);
        }
        Map terminaPeriodMap = LeaseUtil.calTerminationAmortizationPeriodId(leaseContractSet);
        for (Row row : leaseContracts) {
            String version;
            Boolean isBak = row.getBoolean("isbak");
            Long masterId = row.getLong("masterid");
            if (!isBak.booleanValue()) {
                Date terminationDate = row.getDate("leaseterminationdate");
                Long terminaPeriodId = (Long)terminaPeriodMap.get(masterId);
                Long queryPeriodId = queryPeriod.getLong("id");
                if (!includeTermination && terminationDate != null && queryPeriodId.compareTo(terminaPeriodId) >= 0) {
                    excludeMasterId.add(masterId);
                    continue;
                }
            }
            if (excludeMasterId.contains(masterId) || this.compareVersion(version = row.getString("version"), monthEndDate) > 0) continue;
            Date leaseEndDate = row.getDate("leaseenddate");
            if (!includeExpiration && DateUtil.compareDate((Date)leaseEndDate, (Date)monthEndDate) <= 0) {
                excludeMasterId.add(masterId);
                continue;
            }
            Long id = row.getLong("id");
            Long shareId = row.getLong("settlesharesrcid");
            Long id4LeaseLiab = shareId == null || shareId == 0L ? id : shareId;
            allContractIds.add(id);
            contractId4Range.add(id4LeaseLiab);
            contractId4LeaseLiab.add(id4LeaseLiab);
            contractId4UseRight.add(masterId);
            excludeMasterId.add(masterId);
        }
        DataSet dataSet = this.query(orgIds, queryPeriod, commFilter, allContractIds, contractId4LeaseLiab, contractId4UseRight, otherContractFields);
        if (!allContractIds.isEmpty()) {
            this.prepareRangeData(queryParam, orgIds, contractId4Range);
        }
        return dataSet.orderBy(new String[]{"org"});
    }

    private DataSet query(List<Object> orgIds, DynamicObject queryPeriod, QFilter commFilter, Set<Long> allContractIds, Set<Long> contractId4LeaseLiab, Set<Long> contractId4UseRight, List<String> otherContractFields) {
        Set contractFields;
        HashSet<String> select = new HashSet<String>(4);
        select.add("id leasecontract");
        select.add("masterid");
        select.add("org");
        select.add("currency");
        select.addAll(otherContractFields);
        String selectStr = String.join((CharSequence)", ", select);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("id", "in", allContractIds));
        if (commFilter != null) {
            filters.add(commFilter);
        }
        DataSet allContractDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_lease_contract", (String)selectStr, (QFilter[])filters.toArray(new QFilter[0]), null);
        Map<Long, DynamicObject> mainBookMap = this.getMainBook(orgIds);
        if (!contractId4LeaseLiab.isEmpty()) {
            DataSet leaseLiabDataSet = this.queryLeaseLiabData(contractId4LeaseLiab, queryPeriod);
            leaseLiabDataSet = this.joinYearInitVal(leaseLiabDataSet, contractId4LeaseLiab, queryPeriod, orgIds);
            leaseLiabDataSet = this.joinAccumInitVal(leaseLiabDataSet, contractId4LeaseLiab);
            contractFields = FaDataSetUtils.getFieldsByDataSet((DataSet)allContractDataSet);
            Set leaseLiabFields = FaDataSetUtils.getFieldsByDataSet((DataSet)leaseLiabDataSet);
            leaseLiabFields.remove("masterid");
            allContractDataSet = allContractDataSet.leftJoin(leaseLiabDataSet).on("masterid", "masterid").select(contractFields.toArray(new String[0]), leaseLiabFields.toArray(new String[0])).finish();
        }
        if (!contractId4UseRight.isEmpty()) {
            DataSet useRightDataSet = this.queryUseRightData(orgIds, contractId4UseRight, mainBookMap, queryPeriod);
            contractFields = FaDataSetUtils.getFieldsByDataSet((DataSet)allContractDataSet);
            Set useRightFields = FaDataSetUtils.getFieldsByDataSet((DataSet)useRightDataSet);
            useRightFields.remove("srcbillid");
            allContractDataSet = allContractDataSet.leftJoin(useRightDataSet).on("masterid", "srcbillid").select(contractFields.toArray(new String[0]), useRightFields.toArray(new String[0])).finish();
        }
        return allContractDataSet.orderBy(new String[]{"org"});
    }

    private DataSet queryLeaseLiabData(Set<Long> contractIds, DynamicObject queryPeriod) {
        long periodId = queryPeriod.getLong("id");
        DynamicObject firstYearPeriod = FaPeriodUtils.getFirstYearPeriod((DynamicObject)queryPeriod);
        long firstYearPeriodId = firstYearPeriod.getLong("id");
        SqlBuilder queryRentSettle = new SqlBuilder();
        queryRentSettle.append("select fleasecontractid leasecontract, ", new Object[0]);
        queryRentSettle.append(" sum(case when famortizationperiodid = ? then frent else 0 end) rent, ", new Object[]{periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid >= ? and famortizationperiodid <= ? then frent else 0 end) rptaddupyearrent, ", new Object[]{firstYearPeriodId, periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid <= ? then frent else 0 end) rptaccumrent, ", new Object[]{periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid = ? then finterest else 0 end) interest, ", new Object[]{periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid >= ? and famortizationperiodid <= ? then finterest else 0 end) rptaddupyearinterest, ", new Object[]{firstYearPeriodId, periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid <= ? then finterest else 0 end) rptaccuminterest, ", new Object[]{periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid = ? then fendleaseliab else 0 end) endleaseliab, ", new Object[]{periodId});
        queryRentSettle.append(" sum(case when famortizationperiodid = ? and fsourcetype != 'B' then finterestdays else 0 end) finterestdays ", new Object[]{periodId});
        queryRentSettle.append(" from t_fa_lease_rent_settle where ", new Object[0]);
        queryRentSettle.appendIn(" fleasecontractid ", new ArrayList<Long>(contractIds));
        queryRentSettle.append(" group by forgid, fleasecontractid ", new Object[0]);
        return DB.queryDataSet((String)this.algoKey, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryRentSettle);
    }

    private DataSet joinYearInitVal(DataSet leaseLiabData, Set<Long> contractIds, DynamicObject queryPeriod, List<Object> orgIds) {
        int queryYear = queryPeriod.getInt("periodyear");
        ArrayList<Long> curYearStartOrgIds = new ArrayList<Long>(orgIds.size());
        QFilter leaseInitFilter = new QFilter("org", "in", orgIds);
        String selectLeaseInitFields = Fa.comma((String[])new String[]{"org", "systemswitchday"});
        DynamicObjectCollection leaseInitList = QueryServiceHelper.query((String)"fa_lease_init", (String)selectLeaseInitFields, (QFilter[])leaseInitFilter.toArray());
        Map<Long, Date> sysSwitchDateMap = leaseInitList.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getDate("systemswitchday")));
        for (Map.Entry<Long, Date> entry : sysSwitchDateMap.entrySet()) {
            Long orgId = entry.getKey();
            Date sysSwitchDay = entry.getValue();
            if (sysSwitchDay == null) {
                logger.error("\u6838\u7b97\u7ec4\u7ec7[{}]\u901a\u8fc7\u79df\u8d41\u521d\u59cb\u5316\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u7cfb\u7edf\u5207\u6362\u65e5", (Object)orgId);
                continue;
            }
            int sysSwitchYear = DateUtil.getDateField((Date)sysSwitchDay, (int)1);
            if (sysSwitchYear != queryYear) continue;
            curYearStartOrgIds.add(orgId);
        }
        String selectFields = "id, addupyearrent inityearrent, addupyearinterest inityearinterest";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractIds), new QFilter("org", "in", curYearStartOrgIds)};
        DataSet contractInitVal = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_lease_contract", (String)selectFields, (QFilter[])filters, null);
        Set leaseLiabFields = FaDataSetUtils.getFieldsByDataSet((DataSet)leaseLiabData);
        leaseLiabFields.remove("rptaddupyearrent");
        leaseLiabFields.add("rptaddupyearrent + inityearrent rptaddupyearrent");
        leaseLiabFields.remove("rptaddupyearinterest");
        leaseLiabFields.add("rptaddupyearinterest + inityearinterest rptaddupyearinterest");
        return leaseLiabData.leftJoin(contractInitVal).on("leasecontract", "id").select(leaseLiabFields.toArray(new String[0])).finish();
    }

    private DataSet joinAccumInitVal(DataSet leaseLiabData, Set<Long> contractIds) {
        String selectFields = "id, masterid, accumrent initaccumrent, accuminterest initaccuminterest";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractIds)};
        DataSet contractInitVal = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_lease_contract", (String)selectFields, (QFilter[])filters, null);
        Set leaseLiabFields = FaDataSetUtils.getFieldsByDataSet((DataSet)leaseLiabData);
        leaseLiabFields.remove("rptaccumrent");
        leaseLiabFields.add("rptaccumrent + initaccumrent rptaccumrent");
        leaseLiabFields.remove("rptaccuminterest");
        leaseLiabFields.add("rptaccuminterest + initaccuminterest rptaccuminterest");
        leaseLiabFields.remove("leasecontract");
        leaseLiabFields.add("masterid");
        return leaseLiabData.leftJoin(contractInitVal).on("leasecontract", "id").select(leaseLiabFields.toArray(new String[0])).finish();
    }

    private DataSet queryUseRightData(List<Object> orgIds, Set<Long> contractIds, Map<Long, DynamicObject> mainBookMap, DynamicObject queryPeriod) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("srcbillid", "in", contractIds)};
        String selectCardFields = Fa.comma((String[])new String[]{"org", "number", "srcbillid"});
        DataSet realCards = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"fa_card_real", (String)selectCardFields, (QFilter[])filters, null);
        HashMap<Long, Set> cardNumberMap = new HashMap<Long, Set>(mainBookMap.size());
        for (Object row : realCards.copy()) {
            Long l = row.getLong("org");
            Set numberSet = cardNumberMap.computeIfAbsent(l, v -> new HashSet(32));
            String number = row.getString("number");
            numberSet.add(number);
        }
        HashMap<String, Map> predictResultMap = new HashMap<String, Map>(mainBookMap.size());
        for (Map.Entry entry : mainBookMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Set numberSet = (Set)cardNumberMap.get(orgId);
            if (numberSet == null || numberSet.isEmpty()) continue;
            DynamicObject mainBok = (DynamicObject)entry.getValue();
            long periodTypeId = mainBok.getLong("periodtype");
            long curPeriodId = mainBok.getLong("curperiod");
            long queryPeriodId = queryPeriod.getLong("id");
            long depreUseId = mainBok.getLong("depreuse");
            if (queryPeriodId < curPeriodId) {
                Map hisDepredData = FaDepreUtil.depreHisCardHandle((Long)orgId, (Long)depreUseId, (Long)queryPeriodId, (Set)numberSet);
                String key = orgId + "_" + depreUseId + "_" + queryPeriodId;
                predictResultMap.put(key, hisDepredData);
                continue;
            }
            DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_amortised_cost_report");
            Map orgPredictResult = dailyDepreImpl.predictPeriodDepe((Object)orgId, Long.valueOf(depreUseId), queryPeriod, false, true, numberSet);
            predictResultMap.putAll(orgPredictResult);
        }
        Algo algoPredictFin = Algo.create((String)"FaCostListQuery.predictFinDataset");
        Field[] fieldArray = new Field[]{new Field("number", (DataType)DataType.StringType), new Field("startnetamount", (DataType)DataType.BigDecimalType), new Field("monthdepre", (DataType)DataType.BigDecimalType), new Field("endnetamount", (DataType)DataType.BigDecimalType), new Field("addupyeardepre", (DataType)DataType.BigDecimalType), new Field("accumdepre", (DataType)DataType.BigDecimalType)};
        DataSetBuilder builderPredictFin = algoPredictFin.createDataSetBuilder(new RowMeta(fieldArray));
        for (Map predictRsList : predictResultMap.values()) {
            for (Map predictRs : predictRsList.values()) {
                Object number = predictRs.get("number");
                Object[] row = new Object[fieldArray.length];
                row[0] = number;
                BigDecimal netAmount = (BigDecimal)predictRs.get("netamount");
                BigDecimal monthDepre = (BigDecimal)predictRs.get("monthdepre");
                row[1] = netAmount.add(monthDepre);
                row[2] = predictRs.get("monthdepre");
                row[3] = predictRs.get("netamount");
                row[4] = predictRs.get("addupyeardepre");
                row[5] = predictRs.get("accumdepre");
                builderPredictFin.append(row);
            }
        }
        DataSet predictFinDataSet = builderPredictFin.build();
        return realCards.leftJoin(predictFinDataSet).on("number", "number").select(new String[]{"srcbillid"}, new String[]{"startnetamount", "monthdepre", "endnetamount", "addupyeardepre", "accumdepre"}).finish();
    }

    private int compareVersion(String version, Date date) {
        if (!StringUtils.isNumeric((CharSequence)version)) {
            KDBizException e = new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7248\u672c\u53f7\u5f02\u5e38\u7684\u5408\u540c\uff0c\u5f02\u5e38\u7248\u672c\u53f7[%s]", (String)"FaCostListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]), version));
            throw e;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String dateStr = format.format(date);
        int dateInt = Integer.parseInt(dateStr);
        int versionInt = Integer.parseInt(version);
        return versionInt - dateInt;
    }

    private Map<Long, DynamicObject> getMainBook(List<Object> orgIds) {
        String selectFields = Fa.comma((String[])new String[]{"org", "depreuse", "startperiod.periodyear", "periodtype", "curperiod"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)true)};
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        return books.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v, (v1, v2) -> v2));
    }

    private int formatSettleMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        return year * 10000 + month * 100;
    }

    private void prepareRangeData(ReportQueryParam queryParam, List<Object> orgIds, Set<Long> allContractIds) {
        RANGE_VALUES.remove();
        RANGE_VALUES.set(new HashMap(16));
        FilterInfo filterCondition = queryParam.getFilter();
        DynamicObject queryPeriod = filterCondition.getDynamicObject("q_period_select");
        queryPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate,periodtype,periodnumber,periodyear", (QFilter[])new QFilter("id", "=", (Object)queryPeriod.getLong("id")).toArray());
        int periodYear = queryPeriod.getInt("periodyear");
        List overduerange = (List)filterCondition.getFilterItem("OVERDUERANGE").getValue();
        QFilter filter = new QFilter("id", "in", allContractIds);
        String select = Fa.comma((String[])new String[]{"id", "masterid"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)select, (QFilter[])filter.toArray());
        Map<Long, Long> masterIdMap = contracts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("masterid")));
        String[] beginSplit = ((String)overduerange.get(0)).split(" - ");
        int beginYear = Integer.parseInt(beginSplit[0]) + periodYear;
        this.queryRangePeriod(queryPeriod, beginYear);
        DynamicObject beginPeriodDy = this.queryRangePeriod(queryPeriod, beginYear);
        long beginPeriod = beginPeriodDy.getLong("id");
        String[] endSplit = ((String)overduerange.get(overduerange.size() - 1)).split(" - ");
        String endYear = endSplit[1];
        long endPeriod = 99999999999L;
        if (!ResManager.loadKDString((String)"\u4e0d\u8bbe\u7f6e", (String)"FaCostListQuery_2", (String)"fi-fa-report", (Object[])new Object[0]).equals(endYear)) {
            int endPeriodYear = Integer.parseInt(endYear) + periodYear;
            DynamicObject endPeriodDy = this.queryRangePeriod(queryPeriod, endPeriodYear);
            endPeriod = endPeriodDy.getLong("id");
        }
        this.setRangeValues(beginPeriod, endPeriod, overduerange, orgIds, new ArrayList<Object>(allContractIds), masterIdMap, queryPeriod, queryParam);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return this.getColumns(columns, this.getQueryParam());
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns, ReportQueryParam queryParam) throws Throwable {
        FilterInfo filterCondition = queryParam.getFilter();
        List overduerange = (List)filterCondition.getFilterItem("OVERDUERANGE").getValue();
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u79df\u8d41\u8d1f\u503a\u5230\u671f\u4f59\u989d", (String)"FaCostListQuery_3", (String)"fi-fa-report", (Object[])new Object[0])));
        group.setFieldKey("undue_group");
        for (String range : overduerange) {
            ReportColumn childColumn = new ReportColumn();
            childColumn.setCaption(new LocaleString(range));
            childColumn.setFieldType("amount");
            childColumn.setCurrencyField("currency");
            childColumn.setFieldKey(range);
            childColumn.setCtlTips(new Tips("text", null, new LocaleString(ResManager.loadKDString((String)"x-y\u8868\u793a\u7b2cx\u5e74\u5230\u7b2cy\u5e74\u5185\u5230\u671f\u7684\u79df\u8d41\u8d1f\u503a\u91d1\u989d\uff0c\u5982\u679c\u662f0-1\u5219\u4e3a1\u5e74\u4ee5\u5185\u5230\u671f\u7684\u79df\u8d41\u8d1f\u503a\u91d1\u989d\u3002", (String)"FaCostListQuery_4", (String)"fi-fa-report", (Object[])new Object[0])), false, new ArrayList(1)));
            group.getChildren().add(childColumn);
        }
        columns.add((AbstractReportColumn)group);
        return columns;
    }

    private void setRangeValues(Long beginPeriod, Long endPeriod, List<String> overduerange, List<Object> orgIds, List<Object> leasecontractIds, Map<Long, Long> masterIdMap, DynamicObject queryPeriod, ReportQueryParam queryParam) {
        SqlBuilder selectRentSettleRangeSqlSb = new SqlBuilder();
        selectRentSettleRangeSqlSb.append("SELECT t.fendleaseliab as endleaseliab,t.fleasecontractid as leasecontract ,B.fleaseterminationdate,t.fsettledatemonth,t.famortizationperiodid FROM t_fa_lease_rent_settle t left join t_fa_lease_contract_new B on  t.fleasecontractid = B.fid WHERE ", new Object[0]);
        selectRentSettleRangeSqlSb.appendIn("t.forgid", orgIds);
        selectRentSettleRangeSqlSb.append("AND t.famortizationperiodid <= ? ", new Object[]{endPeriod});
        selectRentSettleRangeSqlSb.append("AND t.famortizationperiodid >= ? ", new Object[]{beginPeriod});
        selectRentSettleRangeSqlSb.appendIn("AND t.fleasecontractid", leasecontractIds);
        DataSet rentSettleRangeDs = DB.queryDataSet((String)"fa_lease_rent_settle", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)selectRentSettleRangeSqlSb);
        this.setSettleMap(rentSettleRangeDs, masterIdMap, overduerange, queryPeriod, queryParam);
    }

    private void setSettleMap(DataSet rentSettleRangeDs, Map<Long, Long> masterIdMap, List<String> overduerange, DynamicObject queryPeriod, ReportQueryParam queryParam) {
        HashMap<Long, Map<Long, BigDecimal>> periodLeaseliabMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
        DataSet rentSettleRangeDsCopy = rentSettleRangeDs.copy();
        HashSet<Long> leaseContractSet = new HashSet<Long>(16);
        long queryPeriodId = queryPeriod.getLong("id");
        for (Object row : rentSettleRangeDsCopy) {
            Long leasecontract = row.getLong("leasecontract");
            leaseContractSet.add(leasecontract);
        }
        Map terminaPeriodMap = LeaseUtil.calTerminationAmortizationPeriodId(leaseContractSet);
        for (Row row : rentSettleRangeDs) {
            Long amortizationPeriodId = row.getLong("famortizationperiodid");
            Map<Long, BigDecimal> leaseliabMap = new HashMap(16);
            if (periodLeaseliabMap.containsKey(amortizationPeriodId)) {
                leaseliabMap = (Map)periodLeaseliabMap.get(amortizationPeriodId);
            }
            Long leasecontract = row.getLong("leasecontract");
            BigDecimal endleaseliab = row.getBigDecimal("endleaseliab");
            Long masterId = masterIdMap.get(leasecontract);
            Date fleaseterminationdate = row.getDate("fleaseterminationdate");
            Long terminaPeriodId = (Long)terminaPeriodMap.get(leasecontract);
            if (null != fleaseterminationdate) {
                if (null == terminaPeriodId) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540cid:[%s]\u6709\u79df\u8d41\u7ec8\u6b62\u65e5\u4f46\u662f\u65e0\u5bf9\u5e94\u6e05\u7406\u5355\uff0c\u8bf7\u68c0\u67e5", (String)"FaCostListQuery_5", (String)"fi-fa-report", (Object[])new Object[0]), leasecontract));
                }
                if (queryPeriodId >= terminaPeriodId) {
                    leaseliabMap.put(masterId, BigDecimal.ZERO);
                } else {
                    leaseliabMap.put(masterId, endleaseliab);
                }
            } else {
                leaseliabMap.put(masterId, endleaseliab);
            }
            periodLeaseliabMap.put(amortizationPeriodId, leaseliabMap);
        }
        Map customParam = queryParam.getCustomParam();
        String pageId = (String)customParam.get(CUSTOM_PARAM_PAGE_ID);
        String dimValueCacheKey = pageId + DIM_VALUE_CACHE;
        IAppCache appCache = AppCache.get((String)"fa");
        int periodYear = queryPeriod.getInt("periodyear");
        for (String range : overduerange) {
            int endPeriodYear;
            DynamicObject endPeriodDy;
            String[] split = range.split(" - ");
            String beginYear = split[0];
            String endYear = split[1];
            long endPeriod = 99999999999L;
            if (!ResManager.loadKDString((String)"\u4e0d\u8bbe\u7f6e", (String)"FaCostListQuery_2", (String)"fi-fa-report", (Object[])new Object[0]).equals(endYear) && null != (endPeriodDy = this.queryRangePeriod(queryPeriod, endPeriodYear = Integer.parseInt(endYear) + periodYear))) {
                endPeriod = endPeriodDy.getLong("id");
            }
            int bYear = Integer.parseInt(beginYear) + periodYear;
            DynamicObject beginPeriodDy = this.queryRangePeriod(queryPeriod, bYear);
            long beginPeriod = 0L;
            if (null != beginPeriodDy) {
                beginPeriod = beginPeriodDy.getLong("id");
            }
            if ("".equals(beginYear)) continue;
            Map beginPeriodMap = new HashMap(16);
            if (periodLeaseliabMap.containsKey(beginPeriod)) {
                beginPeriodMap = (Map)periodLeaseliabMap.get(beginPeriod);
            }
            Map endPeriodMap = new HashMap(16);
            if (periodLeaseliabMap.containsKey(endPeriod)) {
                endPeriodMap = (Map)periodLeaseliabMap.get(endPeriod);
            }
            for (Map.Entry begin : beginPeriodMap.entrySet()) {
                BigDecimal sumliab;
                if (endPeriodMap.containsKey(begin.getKey())) {
                    sumliab = ((BigDecimal)begin.getValue()).subtract((BigDecimal)endPeriodMap.get(begin.getKey()));
                    RANGE_VALUES.get().put(((Long)begin.getKey()).toString() + "_split_" + range, sumliab);
                    continue;
                }
                sumliab = (BigDecimal)begin.getValue();
                RANGE_VALUES.get().put(((Long)begin.getKey()).toString() + "_split_" + range, sumliab);
            }
            if (RANGE_VALUES.get() == null) continue;
            String dimValueStr = SerializationUtils.serializeToBase64(RANGE_VALUES.get());
            appCache.put(dimValueCacheKey, (Object)dimValueStr);
        }
    }

    private DynamicObject queryRangePeriod(DynamicObject queryPeriod, Integer queryYear) {
        long periodType = queryPeriod.getLong("periodtype_id");
        int periodNumber = queryPeriod.getInt("periodnumber");
        QFilter qPeriodType = new QFilter("periodtype", "=", (Object)periodType);
        QFilter qBeginPeriodYear = new QFilter("periodyear", "=", (Object)queryYear);
        QFilter qPeriodNumber = new QFilter("periodnumber", "=", (Object)periodNumber);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodnumber", (QFilter[])new QFilter[]{qPeriodType, qBeginPeriodYear, qPeriodNumber});
    }
}

