/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.report.query.FaBlocListQuery;

public class Rpt {
    private static final Log logger = LogFactory.getLog(FaBlocListQuery.class);
    private static final String FILTER_ORG = "q_org";
    private static final String FILTER_DEPRE_USE = "depreuse";
    private static final String FILTER_PERIOD = "q_period";
    private static final String FILTER_PERIOD_START = "period_start";
    private static final String FILTER_PERIOD_END = "period_end";

    public static List<Long> getPermissionLeafOrgs(Long orgId, String formId) {
        List<Long> temps = new ArrayList<Long>();
        temps.add(orgId);
        temps = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)9L, temps, (boolean)false);
        List leafOrgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgs((String)formId);
        temps.retainAll(leafOrgs);
        return temps;
    }

    public static void getRowMetaLog(DataSet dataSet1, DataSet dataSet2, Log logger) {
        Field[] fields1 = null;
        Field[] fields2 = null;
        int length = 0;
        if (dataSet1 != null) {
            fields1 = dataSet1.getRowMeta().getFields();
            length = fields1.length;
        }
        if (dataSet2 != null) {
            fields2 = dataSet2.getRowMeta().getFields();
        }
        StringBuilder sBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (fields1 != null) {
                sBuilder.append(fields1[i].getName()).append(':').append(fields1[i].getDataType()).append("----1----").append('\n');
            }
            if (fields2 == null) continue;
            sBuilder.append(fields2[i].getName()).append(':').append(fields2[i].getDataType()).append("----2----").append('\n');
        }
        logger.info(sBuilder.toString());
    }

    public static ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    public static Map<Long, String> getBaseDataMap(String entityId, Set<Long> ids) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", ids)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(Rpt.class.getName() + ".getIdNameMap"), (String)entityId, (String)"id,name", (QFilter[])filter, null);){
            for (Row row : dataSet) {
                result.put(row.getLong("id"), row.getString("name"));
            }
        }
        return result;
    }
}

