/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InventoryTaskQuery
implements IBillWebApiPlugin {
    private static final String ALGO = "kd.fi.fa.api.InventoryTaskQuery";
    private static final String ISMERGEGEN = "ismergegen";

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            String errMsg = null;
            String errorCode = "1";
            if (params.containsKey("select")) {
                QFilter filter = new QFilter("status", "=", (Object)"C");
                DynamicObjectCollection tasks = QueryServiceHelper.query((String)"fa_inventory_task", (String)"id", (QFilter[])filter.toArray());
                if (tasks.isEmpty()) {
                    return ApiResult.success((Object)tasks);
                }
                String taskIdStr = tasks.stream().map(v -> v.get("id").toString()).collect(Collectors.joining(","));
                if ("1".equals(params.get(ISMERGEGEN))) {
                    String sqlTask = "  select finventschemeid,a.fdetailid,fentryid,finventperson,fbasedataid  from t_fa_invent_taskrule a  left join t_fa_invent_taskrule_chk c on a.fdetailid = c.fdetailid where a.fdetailid in (" + taskIdStr + ") ";
                    DataSet taskAll = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)sqlTask);
                    HashMap<String, Map<Long, Long>> schemeMap = new HashMap<String, Map<Long, Long>>();
                    while (taskAll.hasNext()) {
                        Row task = taskAll.next();
                        Long schemeid = task.getLong("finventschemeid");
                        Long l = task.getLong("fdetailid");
                        Long entryid = task.getLong("fentryid");
                        Long inventperson = task.getLong("finventperson");
                        Long inventorychecker = task.getLong("fbasedataid");
                        this.buildTaskMegerMap(schemeMap, schemeid, inventperson, l, entryid);
                        this.buildTaskMegerMap(schemeMap, schemeid, inventorychecker, l, entryid);
                    }
                    ArrayList<DynamicObject> mergelst = new ArrayList<DynamicObject>(10);
                    for (Map.Entry entry : schemeMap.entrySet()) {
                        DynamicObject dyTask = this.buildMergeTask((String)entry.getKey(), (Map)entry.getValue());
                        mergelst.add(dyTask);
                    }
                    Object[] result = SaveServiceHelper.save((DynamicObject[])mergelst.toArray(new DynamicObject[0]));
                    List list = Arrays.stream(result).map(v -> ((DynamicObject)v).getPkValue()).collect(Collectors.toList());
                    String select = (String)params.get("select");
                    QFilter qFilter = new QFilter("id", "in", list);
                    tasks = QueryServiceHelper.query((String)"fa_inv_task_merge", (String)select, (QFilter[])new QFilter[]{qFilter});
                } else {
                    String sql = "select fdetailid from t_fa_invent_taskrule t1 where fdetailid in (" + taskIdStr + ") and exists (select 1 from t_fa_inventory_record t2 where t2.finventorytaskid = t1.fdetailid and t2.finventorystate = 'B')";
                    DataSet dataSet = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"fa"), (String)sql);
                    HashSet<Object> taskIdSet = new HashSet<Object>();
                    for (Row row : dataSet) {
                        taskIdSet.add(row.get("fdetailid"));
                    }
                    String select = (String)params.get("select");
                    tasks = QueryServiceHelper.query((String)"fa_inventory_task", (String)select, (QFilter[])new QFilter("id", "in", taskIdSet).toArray());
                }
                return ApiResult.success((Object)tasks);
            }
            errorCode = "2";
            errMsg = ResManager.loadKDString((String)"\u7f3a\u5c11 select \u53c2\u6570", (String)"InventoryTaskQuery_0", (String)"fi-fa-webapi", (Object[])new Object[0]);
            return ApiResult.fail((String)errMsg, (String)errorCode);
        }
        catch (Exception e) {
            return ApiResult.ex((Throwable)e);
        }
    }

    private void buildTaskMegerMap(Map<String, Map<Long, Long>> schemeMap, Long schemeid, Long inventperson, Long taskid, Long entryid) {
        String key = String.format("%s_%s", schemeid, inventperson);
        Map<Long, Long> taskMap = schemeMap.get(key);
        if (StringUtils.isBlank(taskMap)) {
            taskMap = new HashMap<Long, Long>(10);
        }
        if (inventperson != null && inventperson > 0L) {
            taskMap.put(taskid, entryid);
            schemeMap.put(key, taskMap);
        }
    }

    private DynamicObject buildMergeTask(String key, Map<Long, Long> vaules) {
        String checker;
        QFilter qfCheckId;
        String[] keys = key.split("_");
        String schemeid = keys[0];
        QFilter qfSchemeId = new QFilter("inventschemeid", "=", (Object)schemeid);
        DynamicObject mergeDy = BusinessDataServiceHelper.loadSingle((String)"fa_inv_task_merge", (String)"id", (QFilter[])new QFilter[]{qfSchemeId, qfCheckId = new QFilter("inventorychecker", "=", (Object)(checker = keys[1]))});
        if (mergeDy == null) {
            mergeDy = BusinessDataServiceHelper.newDynamicObject((String)"fa_inv_task_merge");
            mergeDy.set("inventorychecker", (Object)checker);
            mergeDy.set("inventschemeid", (Object)schemeid);
        } else {
            mergeDy = BusinessDataServiceHelper.loadSingle((Object)mergeDy.getPkValue(), (String)"fa_inv_task_merge");
        }
        DynamicObjectCollection entryentity = mergeDy.getDynamicObjectCollection("entryentity");
        for (Map.Entry<Long, Long> taskMap : vaules.entrySet()) {
            boolean flag = true;
            for (DynamicObject row : entryentity) {
                if (row.getLong("inventorytask.id") != taskMap.getKey().longValue() || row.getLong("inventsscope.id") != taskMap.getValue().longValue()) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            DynamicObject entry = entryentity.addNew();
            entry.set("inventorytask", (Object)taskMap.getKey());
            entry.set("inventsscope", (Object)taskMap.getValue());
        }
        return mergeDy;
    }
}

