/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.api.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.api.bean.DepreForcastModel;
import kd.fi.fa.api.bean.DepreForcastQueryParam;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.mservice.query.FaCardListServiceImpl;
import kd.fi.fa.service.FaCardListService;

@ApiController(value="/", desc="\u8d44\u4ea7\u5361\u7247\u67e5\u8be2")
public class AssetCardQueryController {
    private static final Log logger = LogFactory.getLog(AssetCardQueryController.class);
    private FaCardListService cardListService = new FaCardListServiceImpl();

    @ApiPostMapping(value="/asset/query/depreForcast")
    public CustomApiResult<List<DepreForcastModel>> cardDepreForcastData(@ApiParam(value="\u67e5\u8be2\u53c2\u6570", required=true) @ApiParam(value="\u67e5\u8be2\u53c2\u6570", required=true) DepreForcastQueryParam queryParam) {
        try {
            HashMap<String, Object> queryParaMap = new HashMap<String, Object>();
            queryParaMap.put("orgNumber", queryParam.getOrgNumber());
            queryParaMap.put("depreUseNumber", queryParam.getDepreUseNumber());
            queryParaMap.put("startPeriodNumber", queryParam.getStartPeriodNumber());
            queryParaMap.put("endPeriodNumber", queryParam.getEndPeriodNumber());
            queryParaMap.put("containsDetail", queryParam.isContainsDetail());
            queryParaMap.put("extBaseField", queryParam.getExtBaseField());
            queryParaMap.put("extPredictField", queryParam.getExtPredictField());
            queryParaMap.put("otherFilters", queryParam.getOtherFilters());
            queryParaMap.put("ignoreUseStatus", queryParam.isIgnoreUseStatus());
            List datas = this.cardListService.queryCardDepreForecast(queryParaMap);
            List<DepreForcastModel> modelList = this.transMapToModel(datas, queryParam.getExtPredictField(), queryParam.isContainsDetail());
            return CustomApiResult.success(modelList);
        }
        catch (Exception e) {
            logger.error("\u6298\u65e7\u9884\u6d4b\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return CustomApiResult.fail((String)"fail", (String)ThrowableHelper.toString((Throwable)e));
        }
    }

    private List<DepreForcastModel> transMapToModel(List<Map<String, Object>> datas, List<String> extPredictField, boolean containsDetail) {
        if (CollectionUtils.isEmpty(datas)) {
            return Collections.emptyList();
        }
        Map<Object, List<Map>> assetCardPredicts = datas.stream().collect(Collectors.groupingBy(data -> data.get("number")));
        ArrayList<DepreForcastModel> modelList = new ArrayList<DepreForcastModel>(assetCardPredicts.size());
        assetCardPredicts.forEach((number, periodCards) -> {
            DepreForcastModel model = new DepreForcastModel();
            model.setNumber(number.toString());
            Map firstCard = (Map)periodCards.get(0);
            model.setAssetName(String.valueOf(firstCard.get("assetname")));
            model.setUsedeptNumber(String.valueOf(firstCard.get("headusedeptnumber")));
            model.setUsedeptName(String.valueOf(firstCard.get("headusedeptname")));
            model.setAssetcatNumber(String.valueOf(firstCard.get("usedeptnumber")));
            model.setAssetcatName(String.valueOf(firstCard.get("assetcatname")));
            model.setCurrencyName(String.valueOf(firstCard.get("currencyname")));
            model.setCurrencyNumber(String.valueOf(firstCard.get("currencynumber")));
            model.setExtBaseFieldMap((Map)firstCard.get("extBaseFieldMap"));
            ArrayList<Map<String, Object>> periodDatas = new ArrayList<Map<String, Object>>(periodCards.size());
            for (Map periodCard : periodCards) {
                model.setAssetcatNumber(String.valueOf(periodCard.get("assetcatnumber")));
                HashMap extPredictMap = new HashMap();
                extPredictMap.put("periodNumber", periodCard.get("periodnumber"));
                extPredictMap.put("predictdepre", periodCard.get("predictdepre"));
                if (containsDetail) {
                    extPredictMap.put("monthdepre", periodCard.get("monthdepre"));
                }
                for (String extKey : extPredictField) {
                    if (!periodCard.containsKey(extKey)) continue;
                    extPredictMap.put(extKey, periodCard.get(extKey));
                }
                periodDatas.add(extPredictMap);
            }
            periodCards.sort(Comparator.comparing(period -> (String)period.get("periodnumber")));
            model.setPredictDatas(periodDatas);
            modelList.add(model);
        });
        return modelList;
    }
}

