/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.gl.util.GLUtil;

public class AccountBookUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(AccountBookUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                AccountBookUpgradeService.upgrade();
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private static void upgrade() {
        DBRoute fi = DBRoute.of((String)"fi");
        DataSet bookDS = DB.queryDataSet((String)AccountBookUpgradeService.class.getName(), (DBRoute)fi, (String)"select fid, forgid from t_bd_accountbooks");
        HashMap<Long, Long> id2org = new HashMap<Long, Long>();
        for (Row row : bookDS) {
            id2org.put(row.getLong("fid"), row.getLong("forgid"));
        }
        if (id2org.isEmpty()) {
            return;
        }
        DataSet refApOrgDS = DB.queryDataSet((String)AccountBookUpgradeService.class.getName(), (DBRoute)fi, (String)"select fid, fbasedataid from t_bd_glrefaporgs");
        HashMap<Long, Set> id2apOrgs = new HashMap<Long, Set>();
        for (Row row : refApOrgDS) {
            id2apOrgs.compute(row.getLong("fid"), (k, v) -> {
                if (null == v) {
                    v = new HashSet<Long>();
                }
                v.add(row.getLong("fbasedataid"));
                return v;
            });
        }
        DataSet refCasOrgDS = DB.queryDataSet((String)AccountBookUpgradeService.class.getName(), (DBRoute)fi, (String)"select fid, fbasedataid from t_bd_glrefcasorgs");
        HashMap<Long, Set> id2casOrgs = new HashMap<Long, Set>();
        for (Row row : refCasOrgDS) {
            id2casOrgs.compute(row.getLong("fid"), (k, v) -> {
                if (null == v) {
                    v = new HashSet<Long>();
                }
                v.add(row.getLong("fbasedataid"));
                return v;
            });
        }
        HashSet orgIds = new HashSet(id2org.values());
        if (orgIds.isEmpty()) {
            return;
        }
        logger.info("kd.fi.gl.upgradeservice.AccountBookUpgradeService#upgrade:\u6267\u884csql\uff1a[select fbizorgid, fbizacctorgid from t_bd_accountingsys_bizorg where fbizacctorgid in (" + StringUtils.join((Object[])orgIds.toArray(), (String)",") + ")]");
        DataSet bizOrgDS = DB.queryDataSet((String)AccountBookUpgradeService.class.getName(), (DBRoute)fi, (String)("select fbizorgid, fbizacctorgid from t_bd_accountingsys_bizorg where fbizacctorgid in (" + StringUtils.join((Object[])orgIds.toArray(), (String)",") + ")"));
        HashMap<Long, Set> org2bizOrgs = new HashMap<Long, Set>();
        for (Row row : bizOrgDS) {
            org2bizOrgs.compute(row.getLong("fbizacctorgid"), (k, v) -> {
                if (null == v) {
                    v = new HashSet<Long>();
                }
                v.add(row.getLong("fbizorgid"));
                return v;
            });
        }
        ArrayList<Object[]> apParams = new ArrayList<Object[]>();
        ArrayList<Object[]> casParams = new ArrayList<Object[]>();
        HashSet ap = new HashSet();
        HashSet cas = new HashSet();
        for (Map.Entry row : id2org.entrySet()) {
            Set apOrgs;
            Set casOrgs;
            ap.clear();
            cas.clear();
            Long id = (Long)row.getKey();
            Long orgId = (Long)row.getValue();
            cas.addAll(OrgUnitServiceHelper.getFromOrgs((String)"10", (Long)orgId, (String)"08", (boolean)false));
            cas.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)orgId, (boolean)false));
            if (!cas.isEmpty() && !Objects.isNull(casOrgs = (Set)id2casOrgs.get(id))) {
                cas.removeAll(casOrgs);
            }
            ap.addAll(OrgUnitServiceHelper.getFromOrgs((String)"10", (Long)orgId, (String)"10", (boolean)false));
            ap.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"10", (Long)orgId, (boolean)false));
            Set bizOrgs = (Set)org2bizOrgs.get(orgId);
            if (!Objects.isNull(bizOrgs)) {
                ap.addAll(bizOrgs);
            }
            if (!ap.isEmpty() && !Objects.isNull(apOrgs = (Set)id2apOrgs.get(id))) {
                ap.removeAll(apOrgs);
            }
            for (Long casOrgId : cas) {
                casParams.add(new Object[]{null, id, casOrgId});
            }
            for (Long apOrgId : ap) {
                apParams.add(new Object[]{null, id, apOrgId});
            }
        }
        if (!apParams.isEmpty()) {
            long[] apPks = DB.genLongIds((String)"t_bd_glrefaporgs", (int)apParams.size());
            for (int i = 0; i < apParams.size(); ++i) {
                ((Object[])apParams.get((int)i))[0] = apPks[i];
            }
            DB.executeBatch((DBRoute)fi, (String)"insert t_bd_glrefaporgs values(?,?,?)", apParams);
        }
        if (!casParams.isEmpty()) {
            long[] casPks = DB.genLongIds((String)"t_bd_glrefcasorgs", (int)casParams.size());
            for (int i = 0; i < casParams.size(); ++i) {
                ((Object[])casParams.get((int)i))[0] = casPks[i];
            }
            DB.executeBatch((DBRoute)fi, (String)"insert t_bd_glrefcasorgs values(?,?,?)", casParams);
        }
    }
}

