/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.balcal.acctpullupbalupdate.AcctBalUpdateProcess;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.service.GLThreadService;

public class AcctBalanceUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(AcctBalanceUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            logger.info("AcctBalanceUpgradeService upgrade begin");
            result.setSuccess(this.doUpgrade());
        }
        catch (Exception e) {
            logger.error("AcctBalanceUpgradeService error: " + e.getMessage(), (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        logger.info("AcctBalanceUpgradeService upgrade end");
        return result;
    }

    private boolean doUpgrade() {
        boolean isUpgradeSuccess = true;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid,fbookstypeid from t_bd_accountbooks where ", new Object[0]);
        sqlBuilder.append(" fisbizunit =?", new Object[]{"1"});
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        ArrayList<Future> resultList = new ArrayList<Future>();
        for (Row row : ds) {
            long org = row.getLong("forgid");
            long booktype = row.getLong("fbookstypeid");
            Future future = GLThreadService.submitAndGetResult((String)"AcctBalanceUpgradeService", (Callable)new AcctbalThread(org, booktype));
            resultList.add(future);
        }
        ArrayList<Object> errInfo = new ArrayList<Object>();
        for (Future task : resultList) {
            try {
                if (((Boolean)((Tuple)task.get()).item1).booleanValue()) continue;
                errInfo.add(((Tuple)task.get()).item2);
                isUpgradeSuccess = false;
            }
            catch (Exception e) {
                logger.error("AcctBalanceUpgradeService_upgrade_failed on " + e.getMessage(), (Throwable)e);
                isUpgradeSuccess = false;
            }
        }
        if (!isUpgradeSuccess) {
            logger.error("upgrade_error:" + ((Object)errInfo).toString());
        }
        return isUpgradeSuccess;
    }

    static class AcctbalThread
    implements Callable<Tuple<Boolean, String>> {
        private long orgId;
        private long booktypeId;

        AcctbalThread(long orgId, long booktypeId) {
            this.orgId = orgId;
            this.booktypeId = booktypeId;
        }

        @Override
        public Tuple<Boolean, String> call() throws Exception {
            try {
                if (!Lock.tryLock((long)this.orgId, (long)this.booktypeId, (LockKey)LockKey.BalanceCal, () -> {
                    AcctBalUpdateProcess process = new AcctBalUpdateProcess(this.orgId, this.booktypeId);
                    process.update();
                })) {
                    logger.error("getLock_failed:{},{}", (Object)this.orgId, (Object)this.booktypeId);
                    return new Tuple((Object)false, (Object)(this.orgId + "-" + this.booktypeId));
                }
                return new Tuple((Object)true, (Object)(this.orgId + "-" + this.booktypeId));
            }
            catch (Exception e) {
                return new Tuple((Object)false, (Object)(this.orgId + "-" + this.booktypeId));
            }
        }
    }
}

