/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;

public class CashFlowItemWrongAsstUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            this.reCalCashflow();
        }
        catch (Exception e) {
            String traceMessage = this.getStackTraceMessage(e);
            result.setErrorInfo(traceMessage);
            result.setLog(traceMessage);
        }
        return result;
    }

    private void reCalCashflow() throws ParseException {
        SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd");
        String nov = "2020-11-10";
        String dec = "2020-12-10";
        HashMap<Long, Long> period11Map = new HashMap<Long, Long>();
        HashMap<Long, Long> period12Map = new HashMap<Long, Long>();
        Date novD = simple.parse(nov);
        Date decD = simple.parse(dec);
        QFilter begin = new QFilter("begindate", "<=", (Object)novD);
        QFilter end = new QFilter("enddate", ">=", (Object)novD);
        DynamicObjectCollection period1 = QueryServiceHelper.query((String)"bd_period", (String)"id, periodtype", (QFilter[])new QFilter[]{begin, end});
        for (Object obj : period1) {
            period11Map.put(obj.getLong("periodtype"), obj.getLong("id"));
        }
        begin = new QFilter("begindate", "<=", (Object)decD);
        end = new QFilter("enddate", ">=", (Object)decD);
        DynamicObjectCollection period2 = QueryServiceHelper.query((String)"bd_period", (String)"id, periodtype", (QFilter[])new QFilter[]{begin, end});
        for (DynamicObject obj : period2) {
            period12Map.put(obj.getLong("periodtype"), obj.getLong("id"));
        }
        QFilter fisbizunit = new QFilter("isbizunit", "=", (Object)"1");
        QFilter fenable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype,periodtype", (QFilter[])new QFilter[]{fisbizunit, fenable});
        for (DynamicObject obj : col) {
            this.calculate(obj.getLong("org"), obj.getLong("bookstype"), (Long)period11Map.get(obj.getLong("periodtype")));
            this.calculate(obj.getLong("org"), obj.getLong("bookstype"), (Long)period12Map.get(obj.getLong("periodtype")));
        }
    }

    private void calculate(long orgId, long bookTypeId, long periodId) {
        LockKey lockKey = LockKey.CashflowCal;
        Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)lockKey, () -> {
            Throwable throwable;
            TXHandle txh;
            int count = 0;
            do {
                txh = TX.requiresNew();
                throwable = null;
                try {
                    try {
                        count = CalculatorFactory.createCashflowCalculator().calculate(orgId, bookTypeId);
                    }
                    catch (Exception e) {
                        txh.markRollback();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (txh != null) {
                        if (throwable != null) {
                            try {
                                txh.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            txh.close();
                        }
                    }
                }
            } while (count > 0);
            txh = TX.requiresNew();
            throwable = null;
            try {
                try {
                    CalculatorFactory.createCashflowCalculator().reCalculate(orgId, bookTypeId, periodId);
                }
                catch (Exception ex) {
                    txh.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        });
    }

    private String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

