/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class GLAcccurrentUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo("gl_acccurrent:" + GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)"select a.fid,c.fcreatorid,b.fentryid ,b.fentrydc from t_gl_acccurrent a , T_GL_VOUCHERENTRY b,T_GL_VOUCHER c where a.fvchentryid  = b.fentryid and b.fid = c.fid ");){
            Iterator iterRow = ds.iterator();
            ArrayList<Object[]> batchParams = new ArrayList<Object[]>(1024);
            String updateSql = "update t_gl_acccurrent set fcreatorid = ? , fentrydc = ? where fvchentryid = ? ";
            while (iterRow.hasNext()) {
                Row row = (Row)iterRow.next();
                Long entryid = row.getLong("fentryid");
                Long createId = row.getLong("fcreatorid");
                String entryDc = row.getString("fentrydc");
                batchParams.add(new Object[]{createId, entryDc, entryid});
                if (batchParams.size() != 1024) continue;
                this.executeBatch(updateSql, batchParams);
                batchParams.clear();
            }
            if (batchParams.size() > 0) {
                this.executeBatch(updateSql, batchParams);
            }
        }
    }

    private void executeBatch(String sql, List<Object[]> batchParams) {
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)sql, batchParams);
    }
}

