/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;

public class GLBaseDataInitService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog(GLBaseDataInitService.class);
    private static final DBRoute FI = DBRoute.of((String)"fi");
    private static final String DIR = "glbasedata";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            if (this.alreadyInitAssistItem() && !this.existCFItem()) {
                this.doInitCFItem();
                result.setLog("init success");
            } else {
                result.setLog("is not new user, skip init");
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setSuccess(false);
            LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void doInitCFItem() {
        try (TXHandle handle = TX.requiresNew();){
            try {
                Stream.of("t_gl_cashflowitem", "t_gl_cashflowitem_l", "t_gl_cashflowitemacttype").map(this::getSqlList).flatMap(Collection::stream).forEach(sql -> DB.execute((DBRoute)FI, (String)sql.replace("100000", String.valueOf(OrgUnitServiceHelper.getRootOrgId()))));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }

    private boolean alreadyInitAssistItem() {
        Map<Long, Boolean> assistToExists = Stream.of(251805847271815168L, 1318155972065102848L, 1318156698132679680L, 1318157205878344704L, 1318157720443948032L, 1318158015420959744L, 1318158300910454784L, 1318162825901770752L, 1318158552140875776L, 1318156985559944192L).collect(Collectors.toMap(x -> x, x -> Boolean.FALSE));
        try (DataSet assists = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.upgradeservice.GLBaseDataInitService.alreadyInitAssistItem", (String)"bd_asstacttype", (String)"id", (QFilter[])new QFilter[0], (String)"id");){
            while (assists.hasNext()) {
                assistToExists.computeIfPresent(assists.next().getLong("id"), (k, v) -> Boolean.TRUE);
            }
        }
        return !assistToExists.containsValue(Boolean.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getSqlList(String tableName) {
        ArrayList<String> result = new ArrayList<String>(100);
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("%s/%s_init.sql", DIR, tableName));){
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean existCFItem() {
        return QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])new QFilter[0]);
    }
}

