/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class GLBlancesheetUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo("gl_balancesheet:" + GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        Throwable throwable;
        block72: {
            throwable = null;
            try (DataSet ds1 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)" select fid from t_gl_balancesheetassentry");){
                String frowid;
                String fseq;
                Long fbooktypeid;
                Long faccounttableid;
                Long faccountorgid;
                String updateSql;
                Row row;
                ArrayList<Object> batchParams;
                Iterator iterRow;
                if (!ds1.isEmpty()) break block72;
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)" select fid ,fentryid ,fseq ,fassetid,fequityid from t_gl_balancesheetentry");){
                    iterRow = ds.iterator();
                    batchParams = new ArrayList<Object[]>(1024);
                    ArrayList<Object[]> batchParams1 = new ArrayList<Object[]>(1024);
                    String updateSql2 = "insert into t_gl_balancesheetassentry(fid,fentryid,fseq,fassetid,frowid) values (?,?,?,?,?) ";
                    String updateSql1 = "insert into t_gl_balancesheeteqentry(fid,fentryid,fseq,fequityid,frowid) values (?,?,?,?,?) ";
                    while (iterRow.hasNext()) {
                        row = (Row)iterRow.next();
                        Long fid = row.getLong("fid");
                        Long fentryId = row.getLong("fentryid");
                        Long seq = row.getLong("fseq");
                        Long fassetid = row.getLong("fassetid");
                        Long fequityid = row.getLong("fequityid");
                        batchParams.add(new Object[]{fid, fentryId, seq, fassetid, UUID.randomUUID().toString()});
                        batchParams1.add(new Object[]{fid, fentryId, seq, fequityid, UUID.randomUUID().toString()});
                        if (batchParams.size() == 1024) {
                            this.executeBatch(updateSql2, batchParams);
                            batchParams.clear();
                        }
                        if (batchParams1.size() != 1024) continue;
                        this.executeBatch(updateSql1, batchParams1);
                        batchParams1.clear();
                    }
                    if (batchParams.size() > 0) {
                        this.executeBatch(updateSql2, batchParams);
                    }
                    if (batchParams1.size() > 0) {
                        this.executeBatch(updateSql1, batchParams1);
                    }
                }
                ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)" select a.faccountorgid, a.fbooktypeid,a.faccounttableid,a.forgviewid ,b.fseq ,b.frowid from T_GL_BALANCESHEET a, t_gl_balancesheetassentry b where a.fid = b.fid");
                var4_8 = null;
                try {
                    iterRow = ds.iterator();
                    batchParams = new ArrayList(1024);
                    updateSql = "update t_gl_balancesheetexpmain set frowtag = ? where forgid = ? and faccounttableid = ? and fbooktypeid = ? and forwid = ? and (fcolumnkey = '1' or fcolumnkey = '2') ";
                    while (iterRow.hasNext()) {
                        row = (Row)iterRow.next();
                        faccountorgid = row.getLong("faccountorgid");
                        faccounttableid = row.getLong("faccounttableid");
                        fbooktypeid = row.getLong("fbooktypeid");
                        fseq = row.getInteger("fseq").toString();
                        frowid = row.getString("frowid");
                        batchParams.add(new Object[]{frowid, faccountorgid, faccounttableid, fbooktypeid, fseq});
                        if (batchParams.size() != 1024) continue;
                        this.executeBatch(updateSql, batchParams);
                        batchParams.clear();
                    }
                    if (batchParams.size() > 0) {
                        this.executeBatch(updateSql, batchParams);
                    }
                }
                catch (Throwable iterRow2) {
                    var4_8 = iterRow2;
                    throw iterRow2;
                }
                finally {
                    if (ds != null) {
                        if (var4_8 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable iterRow2) {
                                var4_8.addSuppressed(iterRow2);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)" select a.faccountorgid, a.fbooktypeid,a.faccounttableid ,b.fseq ,b.frowid from T_GL_BALANCESHEET a, t_gl_balancesheeteqentry b where a.fid = b.fid");
                var4_8 = null;
                try {
                    iterRow = ds.iterator();
                    batchParams = new ArrayList(1024);
                    updateSql = "update t_gl_balancesheetexpmain set frowtag = ? where forgid = ? and faccounttableid = ? and fbooktypeid = ? and forwid = ? and (fcolumnkey = '3' or fcolumnkey = '4') ";
                    while (iterRow.hasNext()) {
                        row = (Row)iterRow.next();
                        faccountorgid = row.getLong("faccountorgid");
                        faccounttableid = row.getLong("faccounttableid");
                        fbooktypeid = row.getLong("fbooktypeid");
                        fseq = row.getInteger("fseq").toString();
                        frowid = row.getString("frowid");
                        batchParams.add(new Object[]{frowid, faccountorgid, faccounttableid, fbooktypeid, fseq});
                        if (batchParams.size() != 1024) continue;
                        this.executeBatch(updateSql, batchParams);
                        batchParams.clear();
                    }
                    if (batchParams.size() > 0) {
                        this.executeBatch(updateSql, batchParams);
                    }
                }
                catch (Throwable iterRow3) {
                    var4_8 = iterRow3;
                    throw iterRow3;
                }
                finally {
                    if (ds != null) {
                        if (var4_8 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable iterRow3) {
                                var4_8.addSuppressed(iterRow3);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            catch (Throwable ds) {
                throwable = ds;
                throw ds;
            }
        }
        throwable = null;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (String)"  select a.faccountorgid, a.fbooktypeid,a.faccounttableid ,a.ftype,b.fentryid,b.findex,b.fseq from T_GL_INCOMEEDIT a, T_GL_INCOMEEDIT_PRO b where a.fid = b.fid order by b.findex desc");){
            Iterator iterRow = ds.iterator();
            ArrayList<Object[]> batchParams = new ArrayList<Object[]>(1024);
            ArrayList<Object[]> batchParams1 = new ArrayList<Object[]>(1024);
            String updateSql = "update T_GL_INCOMEEDIT_PRO set frowid = ? where fentryid = ? ";
            String updateSql1 = "update T_GL_INCOMEEXP set frowtag = ?,forwid = ? where  forgid = ? and faccounttableid = ? and fbooktypeid = ? and forwid = ? and ftype = ?  ";
            while (iterRow.hasNext()) {
                Row row = (Row)iterRow.next();
                Long fentryid = row.getLong("fentryid");
                Long forgid = row.getLong("faccountorgid");
                Long faccounttableid = row.getLong("faccounttableid");
                Long fbooktypeid = row.getLong("fbooktypeid");
                String findex = row.getString("findex");
                String ftype = row.getString("ftype");
                String fseq = row.getString("fseq");
                String uuid = UUID.randomUUID().toString();
                batchParams.add(new Object[]{uuid, fentryid});
                batchParams1.add(new Object[]{uuid, fseq, forgid, faccounttableid, fbooktypeid, findex, ftype});
                if (batchParams.size() == 1024) {
                    this.executeBatch(updateSql, batchParams);
                    batchParams.clear();
                }
                if (batchParams1.size() != 1024) continue;
                this.executeBatch(updateSql1, batchParams1);
                batchParams1.clear();
            }
            if (batchParams.size() > 0) {
                this.executeBatch(updateSql, batchParams);
            }
            if (batchParams1.size() > 0) {
                this.executeBatch(updateSql1, batchParams1);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void executeBatch(String sql, List<Object[]> batchParams) {
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)sql, batchParams);
    }
}

