/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.util.GLUtil;

public class NoticeDescUpgradeService
implements IUpgradeService {
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_TIMES_RETRY = 5;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade("t_gl_cfnotice");
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo("gl_cfnotice:" + GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        try {
            this.doUpgrade("t_gl_acnotice");
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo("gl_acnotice:" + GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade(String noticeTable) {
        long maxNoticeIDInPreBatch = this.getMinimumIDOfNotice(noticeTable) - 1L;
        int timesRetryOnException = 0;
        int batchCount = 0;
        StringBuilder expMsgBuilder = new StringBuilder();
        while (batchCount < BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"prop.fi.gl.acnotice.upgrade.maxbatch", (int)50000)) {
            try {
                TXHandle txHandle = TX.requiresNew();
                Throwable throwable = null;
                try {
                    ++batchCount;
                    if ((maxNoticeIDInPreBatch = this.doABatchUpgrade(maxNoticeIDInPreBatch, noticeTable)) >= 0L) continue;
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (txHandle == null) continue;
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    txHandle.close();
                }
            }
            catch (Exception e) {
                expMsgBuilder.append(maxNoticeIDInPreBatch).append(" :\n").append(GLUtil.printError((Throwable)e)).append("\n");
                if (timesRetryOnException > 5) {
                    throw new IllegalStateException(expMsgBuilder.append("exception for retry-times-out with msg : \n").toString(), e);
                }
                ++timesRetryOnException;
            }
        }
    }

    private long doABatchUpgrade(long minNoticeIDExclusive, String noticeTable) {
        HashMap<String, List> voucherEntry2NoticeListMap = new HashMap<String, List>();
        minNoticeIDExclusive = (Long)DB.query((DBRoute)new DBRoute("fi"), (String)String.format("select top %s fid, fvoucherentryid from %s where fid > %s order by fid asc", 1000, noticeTable, minNoticeIDExclusive), (Object[])new Object[0], resultSet -> {
            long noticeID = 0L;
            while (resultSet.next()) {
                noticeID = resultSet.getLong("fid");
                String voucherEntryID = resultSet.getString("fvoucherentryid");
                List noticeList = voucherEntry2NoticeListMap.getOrDefault(voucherEntryID, new LinkedList());
                noticeList.add(noticeID);
                voucherEntry2NoticeListMap.put(voucherEntryID, noticeList);
            }
            return noticeID;
        });
        if (voucherEntry2NoticeListMap.isEmpty()) {
            return -1L;
        }
        HashMap entryID2DescMap = new HashMap();
        DB.query((DBRoute)new DBRoute("fi"), (String)String.format("select fentryid, fdescription from t_gl_voucherentry where fentryid in (%s)", String.join((CharSequence)", ", voucherEntry2NoticeListMap.keySet())), (Object[])new Object[0], resultSet -> {
            while (resultSet.next()) {
                String entryID = resultSet.getString("fentryid");
                String desc = resultSet.getString("fdescription");
                entryID2DescMap.put(entryID, desc);
            }
            return null;
        });
        if (entryID2DescMap.isEmpty()) {
            return minNoticeIDExclusive;
        }
        String batchSql = String.format("update %s set fdesc=? where fid=?", noticeTable);
        ArrayList batchParams = new ArrayList(voucherEntry2NoticeListMap.size() * 2);
        voucherEntry2NoticeListMap.forEach((voucherEntry, noticeList) -> {
            String desc = (String)entryID2DescMap.get(voucherEntry);
            if (!StringUtils.isEmpty((CharSequence)desc)) {
                noticeList.stream().map(noticeID -> new Object[]{desc, noticeID}).forEach(batchParams::add);
            }
        });
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)batchSql, batchParams);
        return minNoticeIDExclusive;
    }

    private long getMinimumIDOfNotice(String noticeTable) {
        return (Long)DB.query((DBRoute)new DBRoute("fi"), (String)String.format("select top 1 fid from %s order by fvoucherentryid asc;", noticeTable), resultSet -> resultSet.next() ? resultSet.getLong("fid") : 0L);
    }
}

