/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PresetCashFlowItemUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String selectFields = "debitacct, creditacct, entryentity.account, entryentity.assgrp, entryentity.dc";
        DynamicObject[] presetCFArray = null;
        try {
            presetCFArray = BusinessDataServiceHelper.load((String)"gl_presetcashflowitem", (String)selectFields, null);
        }
        catch (Exception e) {
            result.setSuccess(true);
            result.setLog("gl_presetcashflowitem doesn't exist, don't need update");
            return result;
        }
        for (DynamicObject presetCF : presetCFArray) {
            DynamicObjectCollection entry = presetCF.getDynamicObjectCollection("entryentity");
            if (entry.size() > 0) {
                result.setLog(String.format("id:%s PresetCashFlowItem is not empty,do not need update", presetCF.getPkValue()));
                continue;
            }
            DynamicObjectCollection debitAccts = presetCF.getDynamicObjectCollection("debitacct");
            for (DynamicObject debitAcct : debitAccts) {
                DynamicObject row = entry.addNew();
                row.set("account", (Object)debitAcct);
                row.set("dc", (Object)"1");
            }
            DynamicObjectCollection creditAccts = presetCF.getDynamicObjectCollection("creditacct");
            for (DynamicObject creditAcct : creditAccts) {
                DynamicObject row = entry.addNew();
                row.set("account", (Object)creditAcct);
                row.set("dc", (Object)"-1");
            }
        }
        SaveServiceHelper.save((DynamicObject[])presetCFArray);
        result.setSuccess(true);
        result.setLog("PresetCashFlowItem update success");
        return result;
    }
}

