/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.Arrays;
import kd.bos.context.RequestContextCreator;
import kd.bos.ext.permission.mservice.PermissionUpgradeServiceImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ReportPermissionUpgradeService
implements IUpgradeService {
    private static final String PERM_EXPORT = "4730fc9f000004ae";
    private static final String PERM_VIEW = "47150e89000000ac";
    private static final String GL = "83bfebc8000017ac";
    private static final String BALANCE_ACCOUNT_REF = "gl_rpt_balance_accountref";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"ReportPermissionUpgradeService", (int)3);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            THREAD_POOL.submit(() -> {
                PermissionUpgradeServiceImpl permissionUpgradeService = new PermissionUpgradeServiceImpl();
                this.addPermission(permissionUpgradeService, PERM_VIEW, BALANCE_ACCOUNT_REF, BALANCE_ACCOUNT_REF, PERM_EXPORT);
                return Boolean.TRUE;
            }, RequestContextCreator.createForThreadPool());
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
        }
        return result;
    }

    private void addPermission(PermissionUpgradeServiceImpl permissionUpgradeService, String existPermItemID, String existEntityTypeID, String newEntityTypeID, String ... newPermItemIds) {
        if (newPermItemIds == null || newPermItemIds.length == 0) {
            return;
        }
        permissionUpgradeService.addPermItemsByExistPermItem(existPermItemID, existEntityTypeID, GL, newEntityTypeID, GL, Arrays.asList(newPermItemIds));
    }
}

