/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.sql.ResultSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.fi.gl.util.VoucherEntryInitProducer;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.threads.Producer;

public class VoucherEntryOrgPeriodUpgradeService
implements IUpgradeService {
    private static final Log LOG = LogFactory.getLog(VoucherEntryOrgPeriodUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Class<VoucherEntryOrgPeriodUpgradeService> clazz = VoucherEntryOrgPeriodUpgradeService.class;
        synchronized (VoucherEntryOrgPeriodUpgradeService.class) {
            UpgradeResult result = new UpgradeResult();
            if (!DB.exitsIndex((DBRoute)DBRoute.of((String)"fi"), (String)"t_gl_voucherentry", (String)"IDX_GL_VOUCHERENTRY")) {
                LOG.error("missing voucherentry index:IDX_GL_VOUCHERENTRY");
                result.setSuccess(false);
                result.setLog(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u5347\u7ea7\u7ec4\u7ec7\u548c\u671f\u95f4\u5b57\u6bb5\u5931\u8d25 on missing voucher index.", (String)"VoucherEntryOrgPeriodUpgradeService_3", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return result;
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select TOP 1 fid from t_gl_voucherentry where forgid = 0", new Object[0]);
            boolean isNeedUpgrade = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    return rs.next();
                }
            });
            if (isNeedUpgrade) {
                try {
                    int threadParallelism = 8;
                    ArrayBlockingQueue taskQueue = new ArrayBlockingQueue(threadParallelism * 8, true);
                    AtomicBoolean isAbort = new AtomicBoolean(false);
                    String taskIdentifier = "upgradeUpgradeVoucherEntryOrgAndPeriod " + RequestContext.getOrCreate().getRequestId();
                    VoucherEntryInitProducer producer = new VoucherEntryInitProducer(taskQueue, taskIdentifier, isAbort);
                    Consumer consumer = new Consumer(taskQueue, taskIdentifier, threadParallelism, (Producer)producer, isAbort);
                    producer.setConsumer(consumer);
                    ThreadPools.executeOnceIncludeRequestContext((String)"fi-gl-updateEntryRedundant-producer", (Runnable)producer, (OperationContext)OperationContext.get());
                    ThreadPools.executeOnceIncludeRequestContext((String)"fi-gl-updateEntryRedundant-consumer", (Runnable)consumer, (OperationContext)OperationContext.get());
                    try {
                        consumer.getFinishLatch().await();
                        LOG.info(taskIdentifier + " upgrade success");
                    }
                    catch (InterruptedException e) {
                        LOG.error(taskIdentifier + " failed to upgrade on " + e.getMessage(), (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                    if (consumer.getIsAbort().get()) {
                        LOG.error("upgrade failed on abort.");
                        result.setSuccess(false);
                        result.setLog(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u5347\u7ea7\u7ec4\u7ec7\u548c\u671f\u95f4\u5b57\u6bb5\u5931\u8d25", (String)"VoucherEntryOrgPeriodUpgradeService_5", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
                    }
                    result.setSuccess(true);
                    result.setLog(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u5347\u7ea7\u7ec4\u7ec7\u548c\u671f\u95f4\u5b57\u6bb5\u6210\u529f, \u66f4\u65b0\u5206\u5f55\u6570:%s", (String)"VoucherEntryOrgPeriodUpgradeService_4", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), consumer.getTotalHandleItemCnt()));
                }
                catch (Throwable e) {
                    result.setSuccess(false);
                    result.setErrorInfo(e.getMessage());
                    result.setLog(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u5347\u7ea7\u7ec4\u7ec7\u548c\u671f\u95f4\u5b57\u6bb5\u5931\u8d25%s", (String)"VoucherEntryOrgPeriodUpgradeService_1", (String)"fi-gl-upgradeservice", (Object[])new Object[]{e.getMessage()}));
                    LOG.error("VoucherEntryOrgPeriodUpgradeService upgrade failed:" + e.getMessage(), e);
                    throw e;
                }
            } else {
                LOG.info("VoucherEntryOrgPeriodUpgradeService upgrade no need.");
                result.setSuccess(true);
                result.setLog(ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u5347\u7ea7\u201c\u7ec4\u7ec7\u201d\u548c\u201c\u671f\u95f4\u201d\u5b57\u6bb5\u6210\u529f\u3002", (String)"VoucherEntryOrgPeriodUpgradeService_2", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }
}

