/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.util.ACAccountCheckHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class ACAccountCheckLeftQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log LOG = LogFactory.getLog(ACAccountCheckLeftQueryRpt.class);
    private FilterInfo filterInfo;

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        try {
            this.filterInfo = param.getFilter();
            PerformanceWatch watch = new PerformanceWatch(ACAccountCheckLeftQueryRpt.class, "ACAccountCheckLeftQueryRpt_query", false);
            watch.start("=====queryLeftHgIDsFast==");
            DataSet dataSet = this.queryLeftHgIDsFast(param);
            List dataSetCols = GLUtil.getDataSetCols((DataSet)dataSet);
            StringBuilder colFilter = new StringBuilder();
            int colSize = dataSetCols.size();
            for (int i = 0; i < colSize; ++i) {
                colFilter.append((String)dataSetCols.get(i)).append(" !=0 ");
                if (i == colSize - 1) continue;
                colFilter.append(" or ");
            }
            watch.stop();
            String show = watch.show();
            LOG.info("======ACAccountCheckLeftQueryRpt_watchShorw:{}======", (Object)show);
            return dataSet.filter(colFilter.toString());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("totalRow", (DataType)DataType.BooleanType)});
        DataSetBuilder batchByDSBuilder = Algo.create((String)"").createDataSetBuilder(rowMeta);
        return batchByDSBuilder.build();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ACAccountCheckHelper.createAccountancyTypeColumns(columns == null ? new ArrayList<AbstractReportColumn>() : columns, (FilterInfo)this.filterInfo);
        return columns;
    }

    private DataSet queryLeftHgIDsFast(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        long org = filter.getLong("org");
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>(8);
        queryFilters.add(new QFilter("org", "=", (Object)org));
        queryFilters.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        queryFilters.add(new QFilter("accounttable", "=", (Object)filter.getLong("accounttable")));
        queryFilters.add(new QFilter("period", "<=", (Object)filter.getLong("endperiod")));
        String currencyId = filter.getString("currency");
        if (!"allcurrency".equals(currencyId) && !"basecurrency".equals(currencyId)) {
            queryFilters.add(new QFilter("currency", "=", (Object)Long.valueOf(currencyId)));
        }
        QFilter idF = new QFilter("id", "in", (Object)SubsiDiaryHelper.getAcctIDs((FilterInfo)filter));
        Set acctMasterIDs = QueryServiceHelper.query((String)"bd_accountview", (String)"masterid", (QFilter[])idF.toArray()).stream().map(accountDyo -> accountDyo.getLong("masterid")).collect(Collectors.toSet());
        queryFilters.add(new QFilter("account", "in", acctMasterIDs));
        int groupSizeLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"kd.fi.gl.report.acaccountcheck.groupsizelimit", (int)10000);
        Triple ormInfos = FlexUtils.buildDynamicORMAssistOnBalance((ReportQueryParam)param, (String)"gl_balance", (boolean)true);
        List selectList = (List)ormInfos.getRight();
        String orderby = selectList.stream().map(s -> s.split(" ")[0]).map(assval -> assval + " desc").collect(Collectors.joining(", "));
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_balance", (IDataEntityType)ormInfos.getLeft());
        queryFilters.addAll((Collection)ormInfos.getMiddle());
        return orm.queryDataSet(ACAccountCheckLeftQueryRpt.class.getName(), "gl_balance", String.join((CharSequence)",", selectList), queryFilters.toArray(new QFilter[0]), orderby, groupSizeLimit, (Distinctable)WithDistinctable.get());
    }
}

