/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.AccBalanceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.accbalance.AccBalParallelQuery;
import kd.fi.gl.report.accbalance.treelist.TreeReportHelper;
import kd.fi.gl.util.DataSetHelper;

public class AccBalanceQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(AccBalanceQueryRpt.class);
    private MulOrgQPRpt qpRpt;

    public AccBalanceQueryRpt() {
    }

    public AccBalanceQueryRpt(MulOrgQPRpt qpRpt) {
        this.qpRpt = qpRpt;
    }

    public DataSet query(ReportQueryParam param, Object o) {
        try {
            if (this.qpRpt == null) {
                this.qpRpt = new MulOrgQPRpt(param.getFilter(), "gl_rpt_accountbalance");
            }
            DataSet rawDs = new AccBalParallelQuery(this.qpRpt).execute();
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)"accbalance original data", (DataSet)rawDs);
            }
            if (Objects.nonNull(this.qpRpt.getShowOrgTree())) {
                long start = System.currentTimeMillis();
                rawDs = Objects.equals(this.qpRpt.getShowOrgTree(), "1") ? TreeReportHelper.rebuildDataBySumUpView(rawDs, this.qpRpt) : rawDs.addFields(new String[]{"'0'", TreeReportHelper.getRowidExpr(rawDs), "false"}, new String[]{"pid", "rowid", "isgroupnode"});
                logger.info("rebulddataset finished,cost:{}ms", (Object)(System.currentTimeMillis() - start));
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"accbalance tree data", (DataSet)rawDs);
                }
            }
            rawDs = new AccBalanceHelper(this.qpRpt).addPersonalizeFields(rawDs);
            return rawDs;
        }
        catch (Exception e) {
            logger.error("accbalance query report failed", (Throwable)e);
            throw new KDBizException((Throwable)e, GLErrorCode.SYS_ERR, new Object[0]);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        List<AbstractReportColumn> reportCols = new AccBalanceHelper(this.qpRpt).getReportColumn(columns);
        Map<String, ReportColumn> columnMap = reportCols.stream().filter(x -> x instanceof ReportColumn).map(ReportColumn.class::cast).collect(Collectors.toMap(ReportColumn::getFieldKey, column -> column, (original, current) -> original));
        ReportColumn accountNumberColumn = columnMap.get("number");
        if (Objects.nonNull(accountNumberColumn)) {
            accountNumberColumn.setHyperlink(true);
        }
        if (this.qpRpt.isShowOrgTree()) {
            ReportColumn currencyIdColumn;
            if (Objects.nonNull(accountNumberColumn)) {
                accountNumberColumn.setHyperlink(false);
            }
            if (Objects.nonNull(currencyIdColumn = columnMap.get("currencyid"))) {
                currencyIdColumn.setHyperlink(false);
            }
            ReportColumn orgnameColumn = new ReportColumn();
            orgnameColumn.setHyperlink(true);
            orgnameColumn.setFreeze(true);
            orgnameColumn.setHide(false);
            orgnameColumn.setFieldKey("orgname");
            orgnameColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
            orgnameColumn.setFieldType("text");
            reportCols.add(3, (AbstractReportColumn)orgnameColumn);
            ReportColumn forgnameColumn = new ReportColumn();
            forgnameColumn.setHide(true);
            forgnameColumn.setFieldKey("forgname");
            forgnameColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
            forgnameColumn.setFieldType("text");
            reportCols.add((AbstractReportColumn)forgnameColumn);
            ReportColumn orgIdColumn = columnMap.get("orgid");
            if (Objects.nonNull(orgIdColumn)) {
                orgIdColumn.setHide(true);
            }
        }
        columns.add((AbstractReportColumn)ReportHelper.createFlexOrgidColumn());
        this.createComAssistColumns(columns);
        return reportCols;
    }

    private void createComAssistColumns(List<AbstractReportColumn> columns) {
        FilterInfo filter = this.qpRpt.getFilterInfo();
        if (filter != null && !filter.getBoolean("showcomassist")) {
            return;
        }
        String comAssistValsListStr = (String)this.qpRpt.getCustomParam("ComAssistEntityListStr");
        if (comAssistValsListStr == null) {
            return;
        }
        ArrayList<ReportColumn> comAssistColumns = new ArrayList<ReportColumn>(8);
        List comAssistList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
        if (!comAssistList.isEmpty()) {
            for (int i = 0; i < comAssistList.size(); ++i) {
                List tuplMap = (List)comAssistList.get(i);
                String comFieldKey = (String)tuplMap.get(0);
                String entityId = (String)tuplMap.get(1);
                LocaleString nameLocal = new LocaleString();
                LinkedHashMap nameMap = (LinkedHashMap)tuplMap.get(2);
                for (Map.Entry map : nameMap.entrySet()) {
                    String key = (String)map.getKey();
                    String val = (String)map.getValue();
                    nameLocal.setItem(key, (Object)val);
                }
                comAssistColumns.add(this.createComAssist(comFieldKey, entityId, nameLocal));
            }
        }
        if (!comAssistColumns.isEmpty()) {
            int index = 0;
            for (AbstractReportColumn x : columns) {
                String fieldKey;
                ++index;
                if (!(x instanceof ReportColumn) || !"org".equals(fieldKey = ((ReportColumn)x).getFieldKey()) && !"orgid".equals(fieldKey)) continue;
                break;
            }
            for (int i = comAssistColumns.size() - 1; i >= 0; --i) {
                columns.add(index, (AbstractReportColumn)comAssistColumns.get(i));
            }
        }
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        String columnType = "basedata";
        if (Objects.equals(this.qpRpt.getEntityId(), "gl_rpt_accbalance_qing")) {
            columnType = "text";
        }
        ReportColumn reportColumn = ReportHelper.createColumn(nameLocal, fieldKey, columnType);
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    public MulOrgQPRpt getQpRpt() {
        return this.qpRpt;
    }
}

