/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AdjustRateQueryRpt
extends AbstractReportListDataPlugin {
    private static final String startPeriod = "startperiod";
    private static final String period = "period";
    private static final String endPeriod = "endperiod";
    private static final String includeUnpost = "includeunpost";
    private static final String account = "account";
    private static final String billStatus = "billstatus";
    private static final String assistDb = "gl_assist_bd";
    private static final String acctKey = "bd_accountview";

    public DataSet query(ReportQueryParam param, Object obj) {
        QFilter[] filters = this.filterVoucher(param.getFilter());
        DataSet voucherSet = this.queryVoucher(filters);
        return voucherSet;
    }

    private DataSet queryVoucher(QFilter[] filters) {
        String voucherSel = "id voucherid,entries.account number,bookeddate datefield,entries.currency currencycolumn,billno,entries.debitori debitfor,entries.creditori creditfor,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.assgrp assgrpid";
        DataSet queryVoucher = VoucherQueryUtils.queryDataSet((String)voucherSel, (QFilter[])filters, null, (int)-1);
        return queryVoucher;
    }

    public QFilter[] filterVoucher(FilterInfo filter) {
        String currencyVal;
        AbstractCollection ids;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject periodFrom = filter.getDynamicObject(startPeriod);
        DynamicObject periodTo = filter.getDynamicObject(endPeriod);
        QFilter fperiod = new QFilter(period, ">=", periodFrom.getPkValue()).and(new QFilter(period, "<=", periodTo.getPkValue()));
        filters.add(fperiod);
        String[] fBillStatus = "B,C".split(",");
        QFilter billFilter = new QFilter(billStatus, "in", (Object)fBillStatus);
        filters.add(billFilter);
        QFilter orgf = new QFilter("org", "=", (Object)filter.getLong("org"));
        filters.add(orgf);
        filters.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        QFilter assgrpFilter = null;
        if (filter.getDynamicObjectCollection(account) != null) {
            HashSet<Long> masterIds = new HashSet<Long>();
            for (Object accDynamic : filter.getDynamicObjectCollection(account)) {
                masterIds.add(accDynamic.getLong("id"));
            }
            ids = new HashSet();
            SubsiDiaryHelper.getLeafIds(masterIds, ids);
            ids.addAll(SubsiDiaryHelper.getLeafAcct(masterIds));
            assgrpFilter = new QFilter("entries.account", "in", (Object)((HashSet)ids).toArray());
        }
        if (filter.getString("currency") != null && !"allcurrency".equals(currencyVal = filter.getString("currency"))) {
            QFilter fcurrency = new QFilter("entries.currency", "=", (Object)Long.parseLong(filter.getString("currency")));
            QFilter qFilter = assgrpFilter = assgrpFilter == null ? fcurrency : assgrpFilter.and(fcurrency);
        }
        if (filter.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filter.getDynamicObjectCollection("measureunits");
            ids = new ArrayList();
            for (DynamicObject dyn : unitsDynColl) {
                ids.add(dyn.getLong("id"));
            }
            QFilter funits = new QFilter("entries.measureunit", "in", (Object)ids.toArray());
            assgrpFilter = assgrpFilter == null ? funits : assgrpFilter.and(funits);
        }
        filters.add(assgrpFilter);
        Map deFilterMap = filter.getCommFilters();
        if (deFilterMap.get("gl_voucher") != null) {
            filters.addAll((Collection)deFilterMap.get("gl_voucher"));
        }
        return filters.toArray(new QFilter[filters.size()]);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        return columns;
    }
}

