/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.DataSetUtils;
import kd.fi.gl.util.GLUtil;

public class AgingScheduleRightPlugin
extends AbstractReportListDataPlugin {
    private static final Log LOG = LogFactory.getLog(AgingScheduleRightPlugin.class);
    private static final String UNDUE = "undue";
    private static final String OVERDUE = "overdue";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    protected static final String COLKEY_BALTOTAL_GROUP = "baltotalgroup";
    protected static final String COLKEY_BALTOTAL = "baltotal";
    protected static final String COLKEY_BALTOTAL_LOCAL = "localbaltotal";
    protected static final String COLKEY_UNDUETOTAL_GROUP = "unduetotalgroup";
    protected static final String COLKEY_UNDUETOTAL = "unduetotal";
    protected static final String COLKEY_UNDUETOTAL_LOCAL = "unduetotallocal";
    private static final String COLKEY_OVERDUETOTAL_GROUP = "overduetotalgroup";
    protected static final String COLKEY_OVERDUETOTAL = "overduetotal";
    protected static final String COLKEY_OVERDUETOTAL_LOCAL = "overduetotallocal";
    private static final String COLKEY_UNDUERANGE_GROUP = "unduerangegroup";
    private static final String COLKEY_OVERDUERANGE_GROUP = "overduerangegroup";
    protected static final String COLKEY_CUR = "currencyid";
    private static final String COLKEY_LOCAL_CUR = "currencylocal";
    private static final String COLKEY_ORG = "orgname";
    private static final String COLKEY_ACCOUNT = "accountid";
    protected static final String COLKEY_EXPIREDATE = "expiredate";
    protected static final String COLKEY_ROWTYPE = "rowtype";
    private static final String COLKEY_UNDUE_GROUP = "undue_group";
    private static final String COLKEY_OVERDUE_GROUP = "overdue_group";
    private static final String AGINGDETAILORG = "agingdetailorg";
    private static final String CENTER = "center";
    protected Map<String, AssistVO> assistVOMap = new LinkedHashMap<String, AssistVO>(8);
    protected Map<String, Tuple<Integer, Integer>> overDueRangeMap = new LinkedHashMap<String, Tuple<Integer, Integer>>();
    protected Map<String, Tuple<Integer, Integer>> unDueRangeMap = new LinkedHashMap<String, Tuple<Integer, Integer>>();
    protected MulOrgQPRpt qParam;
    private Set<Long> accounts;
    private boolean isExportAll;
    private Map<Long, Set<Long>> accountGroup;
    private static final Log logger = LogFactory.getLog(AgingScheduleRightPlugin.class);

    private static LocaleString getCurrency() {
        return ResManager.getLocaleString((String)"\u5e01\u79cd", (String)"AgingScheduleRightPlugin_0", (String)"fi-gl-report");
    }

    private static LocaleString getBal() {
        return ResManager.getLocaleString((String)"\u4f59\u989d", (String)"AgingScheduleRightPlugin_1", (String)"fi-gl-report");
    }

    private static LocaleString getUnDueTotal() {
        return ResManager.getLocaleString((String)"\u672a\u5230\u671f\u5408\u8ba1", (String)"AgingScheduleRightPlugin_2", (String)"fi-gl-report");
    }

    private static LocaleString getOverDueTotal() {
        return ResManager.getLocaleString((String)"\u8fc7\u671f\u5408\u8ba1", (String)"AgingScheduleRightPlugin_3", (String)"fi-gl-report");
    }

    private static LocaleString getUnDue() {
        return ResManager.getLocaleString((String)"\u672a\u5230\u671f", (String)"AgingScheduleRightPlugin_4", (String)"fi-gl-report");
    }

    private static LocaleString getOverDue() {
        return ResManager.getLocaleString((String)"\u8fc7\u671f", (String)"AgingScheduleRightPlugin_5", (String)"fi-gl-report");
    }

    private static LocaleString getCurOri() {
        return ResManager.getLocaleString((String)"\u539f\u5e01", (String)"AgingScheduleRightPlugin_8", (String)"fi-gl-report");
    }

    private static LocaleString getCurLocal() {
        return ResManager.getLocaleString((String)"\u672c\u4f4d\u5e01", (String)"AgingScheduleRightPlugin_9", (String)"fi-gl-report");
    }

    private static LocaleString getTotal() {
        return ResManager.getLocaleString((String)"\u5408\u8ba1", (String)"AgingScheduleRightPlugin_10", (String)"fi-gl-report");
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        param.setCustomParam((Map)ImmutableMap.of((Object)"curSelectNode", (Object)obj));
        FilterInfo filterInfo = param.getFilter();
        this.setQueryType(filterInfo);
        if (obj == null) {
            return this.createEmptyData();
        }
        DataSet dsRst = null;
        try {
            this.init(param, obj, "gl_rpt_agingschedule");
            this.initAgingRange(param);
            DataSet dsRcpBal = this.queryReciprocalBal(filterInfo);
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)"==kd.fi.gl.report.AgingScheduleRightPlugin.query#dsRcpBal", (DataSet)dsRcpBal);
            }
            if (this.isExportAll) {
                for (Map.Entry<Long, Set<Long>> longSetEntry : this.accountGroup.entrySet()) {
                    DataSet accountData = dsRcpBal.copy().filter("accountid in " + longSetEntry.getValue().toString().replace("[", "(").replace("]", ")"));
                    accountData = this.getResult(accountData);
                    accountData = accountData.removeFields(new String[]{COLKEY_ACCOUNT}).addField(String.valueOf(longSetEntry.getKey()), COLKEY_ACCOUNT);
                    dsRst = dsRst == null ? accountData : dsRst.union(accountData);
                }
            } else {
                dsRst = this.getResult(dsRcpBal);
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"==kd.fi.gl.report.AgingScheduleRightPlugin.query#dsRst", (DataSet)dsRst);
                }
            }
            dsRst = this.sort(dsRst, filterInfo);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            if (Strings.isNullOrEmpty((String)e.getMessage())) {
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            throw new KDBizException(e.getMessage());
        }
        return dsRst;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportColumn column;
        ReportColumn orgColumn = null;
        for (AbstractReportColumn col : columns) {
            ReportColumn rptColumn = (ReportColumn)col;
            if (!COLKEY_ORG.equals(rptColumn.getFieldKey())) continue;
            orgColumn = rptColumn;
            break;
        }
        if (orgColumn != null) {
            columns.remove(orgColumn);
        }
        ArrayList<Object> list = new ArrayList<Object>(this.assistVOMap.size());
        for (Map.Entry entry : this.assistVOMap.entrySet()) {
            AssistVO assistVO = (AssistVO)entry.getValue();
            String assVal = assistVO.getFlexField();
            LocaleString assName = new LocaleString(assistVO.getName());
            String displayProperty = assistVO.getDispprop();
            column = ReportColumn.createBaseDataColumn((String)assVal, (String)assistVO.getValueSource());
            column.setHide(true);
            list.add(column);
            String assValNumber = assVal + ".number";
            String accValName = assVal + ".name";
            if ("1".equals(displayProperty)) {
                column = this.createColumn(assName, assValNumber, null, Boolean.FALSE);
                column.setRefBasedataProp(assVal);
                column.setDisplayProp("number");
                list.add(column);
                continue;
            }
            if ("3".equals(displayProperty)) {
                column = this.createColumn(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"AgingScheduleRightPlugin_6", (String)"fi-gl-report", (Object[])new Object[0]), assName)), assValNumber, null, Boolean.FALSE);
                column.setRefBasedataProp(assVal);
                column.setDisplayProp("number");
                list.add(column);
                column = this.createColumn(assName, accValName, null, Boolean.FALSE);
                column.setRefBasedataProp(assVal);
                column.setDisplayProp("name");
                list.add(column);
                continue;
            }
            column = this.createColumn(assName, accValName, null, Boolean.FALSE);
            column.setRefBasedataProp(assVal);
            column.setDisplayProp("name");
            list.add(column);
        }
        column = this.createColumn(AgingScheduleRightPlugin.getCurrency(), COLKEY_CUR, "basedata", Boolean.FALSE);
        column.setEntityId("bd_currency");
        column.setHide(true);
        list.add(column);
        column = this.createColumn(AgingScheduleRightPlugin.getCurrency(), "currencyname", "text", Boolean.FALSE);
        list.add(column);
        column = this.createColumn(AgingScheduleRightPlugin.getCurrency(), COLKEY_LOCAL_CUR, "basedata", Boolean.FALSE);
        column.setEntityId("bd_currency");
        column.setHide(true);
        list.add(column);
        if (orgColumn != null && this.qParam.showOrg) {
            list.add(orgColumn);
        }
        if (!this.qParam.isSynCurrency()) {
            ReportColumnGroup balTotalGroupColumn = this.createBalTotalGroupColumn();
            list.add(balTotalGroupColumn);
            ReportColumnGroup reportColumnGroup = this.getUndueGroupColumn();
            list.add(reportColumnGroup);
            ReportColumnGroup overdueGroupColumn = this.getOverdueGroupColumn();
            list.add(overdueGroupColumn);
            columns.addAll(list);
            return columns;
        }
        column = this.createColumn(AgingScheduleRightPlugin.getBal(), COLKEY_BALTOTAL_LOCAL, "amount", Boolean.TRUE);
        list.add(column);
        ReportColumn unDueTotalCol = this.createColumn(AgingScheduleRightPlugin.getUnDueTotal(), COLKEY_UNDUETOTAL_LOCAL, "amount", Boolean.TRUE);
        list.add(unDueTotalCol);
        ReportColumnGroup reportColumnGroup = this.createAgingGroup(COLKEY_UNDUE_GROUP, this.unDueRangeMap, AgingScheduleRightPlugin.getUnDue());
        list.add(reportColumnGroup);
        ReportColumn overDueTotalCol = this.createColumn(AgingScheduleRightPlugin.getOverDueTotal(), COLKEY_OVERDUETOTAL_LOCAL, "amount", Boolean.TRUE);
        list.add(overDueTotalCol);
        ReportColumnGroup overDueGroup = this.createAgingGroup(COLKEY_OVERDUE_GROUP, this.overDueRangeMap, AgingScheduleRightPlugin.getOverDue());
        list.add(overDueGroup);
        columns.addAll(list);
        return columns;
    }

    private ReportColumnGroup createAgingGroup(String columnKey, Map<String, Tuple<Integer, Integer>> map, LocaleString caption) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption(caption);
        group.setFieldKey(columnKey);
        for (Map.Entry<String, Tuple<Integer, Integer>> entry : map.entrySet()) {
            Tuple<Integer, Integer> range = entry.getValue();
            String colName = "";
            colName = (Integer)range.item2 == 0 ? String.format("%s- ", range.item1) : String.format("%s-%s", range.item1, range.item2);
            ReportColumn amtCol = this.createColumn(new LocaleString(colName), entry.getKey().concat("local"), "amount", Boolean.TRUE);
            group.getChildren().add(amtCol);
        }
        return group;
    }

    private ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType, Boolean hyperLink) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            column.setCurrencyField(COLKEY_CUR);
        }
        column.setHyperlink(hyperLink.booleanValue());
        return column;
    }

    private DataSet createEmptyData() {
        RowMeta meta = RowMetaFactory.createRowMeta((String[])new String[]{COLKEY_ACCOUNT}, (DataType[])new DataType[]{DataType.LongType});
        DataSetBuilder builder = Algo.create((String)"fi.gl.createEmptyData").createDataSetBuilder(meta);
        return builder.build();
    }

    protected void init(ReportQueryParam param, Object obj, String entityId) {
        FilterInfo filter = param.getFilter();
        this.qParam = new MulOrgQPRpt(filter, entityId);
        this.accounts = new HashSet<Long>();
        DynamicObject[] accountObjects = null;
        if (obj instanceof DynamicObject[]) {
            accountObjects = (DynamicObject[])obj;
        } else if (obj instanceof DynamicObjectCollection) {
            accountObjects = (DynamicObject[])((DynamicObjectCollection)obj).toArray((Object[])new DynamicObject[0]);
        } else {
            accountObjects = new DynamicObject[]{(DynamicObject)obj};
            this.accountGroup = new HashMap<Long, Set<Long>>();
        }
        FilterItemInfo acctFilterItem = filter.getFilterItem("account");
        for (DynamicObject account : accountObjects) {
            DynamicObjectCollection acctDyns;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
            HashSet acts = Sets.newHashSet((Object[])new Long[]{account.getLong("masterid")});
            Set masterIds = ReciprocalUtils.getAllLeafAccount((Set)acts);
            if (account.getBoolean("isleaf")) {
                masterIds.add(account.getLong("masterid"));
            }
            if (Objects.nonNull(acctDyns = (DynamicObjectCollection)acctFilterItem.getValue())) {
                HashSet<Long> fAcctMIdSet = new HashSet<Long>(acctDyns.size());
                for (DynamicObject dynAcct : acctDyns) {
                    fAcctMIdSet.add(dynAcct.getLong("masterid"));
                    fAcctMIdSet.addAll(ReciprocalUtils.getAllLeafAccount((Set)Sets.newHashSet((Object[])new Long[]{dynAcct.getLong("masterid")})));
                }
                masterIds.retainAll(fAcctMIdSet);
            }
            filters.add(new QFilter("masterid", "in", (Object)masterIds));
            filters.add(new QFilter("isleaf", "=", (Object)"1"));
            filters.add(new QFilter("accounttable", "=", (Object)this.qParam.getAccountTable()));
            filters.add(new QFilter("accheck", "=", (Object)"1"));
            filters.add(ReciprocalUtils.queryEndInitActFilter((Set)this.qParam.getChildOrg(), (Long)this.qParam.getBookType()));
            DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"masterid", (QFilter[])filters.toArray(new QFilter[0]), null);
            Object object = null;
            try {
                while (dSet.hasNext()) {
                    Row row = dSet.next();
                    this.accounts.add(row.getLong("masterid"));
                    this.addAccoutToGroup(account.getLong("masterid"), row.getLong("masterid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dSet != null) {
                    if (object != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
        }
        HashMap<String, Set> flexfieldAcctMap = new HashMap<String, Set>(8);
        HashSet<String> valueTypes = new HashSet<String>();
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", this.accounts), new QFilter("checkitementry.enaccheck", "=", (Object)"1")};
        DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"checkitementry.asstactitem.flexfield assist, masterid", (QFilter[])filters, null);
        Object object = null;
        try {
            while (dSet.hasNext()) {
                Row row = dSet.next();
                String flexfield = row.getString("assist");
                valueTypes.add(flexfield);
                Long accountId = row.getLong("masterid");
                flexfieldAcctMap.computeIfAbsent(flexfield, k -> new HashSet(8)).add(accountId);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dSet != null) {
                if (object != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dSet.close();
                }
            }
        }
        List items = filter.getFlexFilterItems();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            if (!valueTypes.contains(propName)) continue;
            this.fillAssistTypeName(propName, filterItemInfo);
        }
    }

    private void initAgingRange(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        List overDueRange = (List)filter.getFilterItem("OVERDUERANGE").getValue();
        this.fillRangeMap(overDueRange, this.overDueRangeMap, OVERDUE);
        List unDueRange = (List)filter.getFilterItem("UNDUERANGE").getValue();
        this.fillRangeMap(unDueRange, this.unDueRangeMap, UNDUE);
    }

    private void fillRangeMap(List<Integer> range, Map<String, Tuple<Integer, Integer>> map, String colFieldName) {
        int curDay = OVERDUE.equals(colFieldName) ? 0 : -1;
        Integer tag = OVERDUE.equals(colFieldName) ? 1 : -1;
        for (int i = 0; i < range.size(); ++i) {
            int day = range.get(i);
            String colKey = colFieldName + i;
            map.put(colKey, (Tuple<Integer, Integer>)new Tuple((Object)(tag * (curDay + 1)), (Object)(tag * day)));
            curDay = day;
            if (i != range.size() - 1) continue;
            String lastColKey = colFieldName + ++i;
            map.put(lastColKey, (Tuple<Integer, Integer>)new Tuple((Object)(tag * (curDay + 1)), (Object)0));
        }
    }

    private void fillAssistTypeName(String flexfield, FilterItemInfo filterItemInfo) {
        QFilter qFilter = new QFilter("flexfield", "=", (Object)flexfield);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"name,valuesource,valuetype,disprops", (QFilter[])new QFilter[]{qFilter});
        String disprops = queryOne.getString("disprops");
        String dispprop = null;
        if (StringUtils.isNotEmpty((String)disprops)) {
            JSONObject jsonObject = JSONObject.parseObject((String)disprops);
            dispprop = jsonObject.getJSONObject("disp").getString("dispprop");
        }
        HashSet value = (HashSet)filterItemInfo.getValue();
        if ("2".equals(queryOne.getString("valuetype"))) {
            this.assistVOMap.put(flexfield, new AssistVO(flexfield, queryOne.getString("name"), "bos_assistantdata_detail", dispprop, (Set)value));
        } else {
            this.assistVOMap.put(flexfield, new AssistVO(flexfield, queryOne.getString("name"), queryOne.getString("valuesource"), dispprop, (Set)value));
        }
    }

    protected DataSet queryReciprocalBal(FilterInfo filterInfo) {
        List<ReciprocalScheme> schemes = this.buildReciprocalScheme(filterInfo);
        DataSet ds = WriteOff.getWriteOffInstance().schemeSimulateWriteOffSummary(schemes);
        Set<String> dsFields = Arrays.stream(ds.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        StringBuilder filter = this.fileterDataSet(dsFields);
        if (filter.length() > 0) {
            ds = ds.filter(filter.toString());
        }
        return ds;
    }

    protected StringBuilder fileterDataSet(Set<String> dsFields) {
        StringBuilder filter = new StringBuilder();
        this.assistVOMap.forEach((k, v) -> {
            if (dsFields.contains(k)) {
                Set assValue;
                if (filter.length() > 0) {
                    filter.append(" or ");
                }
                if ((assValue = this.assistVOMap.get(k).getAssValue()).size() > 0) {
                    filter.append((String)k).append(" in (").append(String.join((CharSequence)",", assValue.stream().map(String::valueOf).collect(Collectors.toSet()))).append(")");
                } else {
                    filter.append((String)k).append(" is not null ");
                }
            }
        });
        return filter;
    }

    protected List<ReciprocalScheme> buildReciprocalScheme(FilterInfo filterInfo) {
        long pOrgId = this.qParam.getPorg();
        HashSet<Long> childOrgs = ReciprocalUtils.queryEndInitOrgs((Set)this.qParam.getChildOrg(), (Long)this.qParam.getBookType(), this.accounts);
        if (filterInfo.containProp(AGINGDETAILORG)) {
            childOrgs = new HashSet<Long>(1);
            childOrgs.add(filterInfo.getLong(AGINGDETAILORG));
        }
        Long currencyId = this.qParam.getCurrency();
        Long accountTableId = this.qParam.getAccountTable();
        ArrayList<ReciprocalScheme> schemes = new ArrayList<ReciprocalScheme>();
        schemes.addAll(ReciprocalUtils.loadRcpSchemes((Long)pOrgId, (Long)accountTableId, new ArrayList<Long>(this.accounts), (Long)currencyId));
        Date bookedDate = filterInfo.getDate("bookeddate");
        boolean showbyamount = filterInfo.getBoolean("showbyamount");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bookedDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        bookedDate = calendar.getTime();
        Date expiredate = filterInfo.getDate(COLKEY_EXPIREDATE);
        boolean showByExpireDate = filterInfo.getBoolean("showbyexpiredate");
        for (ReciprocalScheme scheme : schemes) {
            scheme.setBookType(Long.valueOf(this.qParam.getBookType()));
            scheme.setAccountTableId(accountTableId);
            scheme.setPeriodType(Long.valueOf(this.qParam.getPeriodType()));
            scheme.setChildOrgs(childOrgs);
            scheme.setBookedDate(bookedDate);
            scheme.setShowByamount(showbyamount);
            scheme.setExpiredate(expiredate);
            scheme.setShowByExpireDate(showByExpireDate);
            scheme.setAssistVOMap(new HashMap<String, AssistVO>(this.assistVOMap));
            scheme.setOverDueRangeMap(this.overDueRangeMap);
            scheme.setUnDueRangeMap(this.unDueRangeMap);
            scheme.setSynCurrency(this.qParam.isSynCurrency());
        }
        return schemes;
    }

    private DataSet getResult(DataSet ds) {
        DataSet dsGroupBy = this.caculateDetailCol(ds);
        return this.caculateSubTotal(dsGroupBy);
    }

    private DataSet caculateDetailCol(DataSet ds) {
        ArrayList<String> groupFields = new ArrayList<String>();
        List fields = GLUtil.getDataSetCols((DataSet)ds);
        for (Object field : fields) {
            if (!Objects.nonNull(this.assistVOMap.get(field))) continue;
            groupFields.add((String)field);
        }
        groupFields.add(COLKEY_CUR);
        groupFields.add(COLKEY_LOCAL_CUR);
        if (this.qParam.showOrg) {
            groupFields.add(COLKEY_ORG);
        }
        ArrayList<String> sumFields = new ArrayList<String>();
        for (String field : fields) {
            if (field.endsWith("total")) {
                sumFields.add(field);
                continue;
            }
            if (!field.startsWith(OVERDUE) && !field.startsWith(UNDUE)) continue;
            sumFields.add(field);
        }
        DataSet dsRst = MulOrgQPRpt.gainSumSet((DataSet)ds, (String[])groupFields.toArray(new String[0]), (String[])sumFields.toArray(new String[0]));
        return dsRst.addField("1", COLKEY_ROWTYPE);
    }

    private DataSet caculateSubTotal(DataSet ds) {
        String[] groupFields = new String[]{COLKEY_CUR, COLKEY_LOCAL_CUR};
        ArrayList<String> sumFields = new ArrayList<String>();
        ArrayList<String> nullFields = new ArrayList<String>();
        List fields = GLUtil.getDataSetCols((DataSet)ds);
        for (String field : fields) {
            if (field.endsWith("total")) {
                sumFields.add(field);
                continue;
            }
            if (field.startsWith(OVERDUE) || field.startsWith(UNDUE)) {
                sumFields.add(field);
                continue;
            }
            if (field.equals(COLKEY_ROWTYPE) || field.equals(COLKEY_CUR) || field.equals(COLKEY_LOCAL_CUR)) continue;
            nullFields.add(field);
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add(COLKEY_CUR);
        selectFields.add(COLKEY_LOCAL_CUR);
        selectFields.addAll(sumFields);
        DataSet dsTmp = ds.copy().select(selectFields.toArray(new String[0]));
        DataSet sum = MulOrgQPRpt.gainSumSet((DataSet)dsTmp, (String[])groupFields, (String[])sumFields.toArray(new String[0]));
        DataSet dsSubTotal = sum.addNullField(nullFields.toArray(new String[0])).addField("2", COLKEY_ROWTYPE);
        return ds.union(dsSubTotal.select(fields.toArray(new String[0])));
    }

    private DataSet sort(DataSet ds, FilterInfo filterInfo) {
        ArrayList<String> orderByString = new ArrayList<String>();
        if (this.isExportAll) {
            HashSet<Long> acctMasterId = new HashSet<Long>(this.accountGroup.size());
            for (Map.Entry<Long, Set<Long>> entry : this.accountGroup.entrySet()) {
                acctMasterId.add(entry.getKey());
                acctMasterId.addAll((Collection)entry.getValue());
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("masterid", "in", acctMasterId));
            Date bookeddate = (Date)filterInfo.getFilterItem("bookeddate").getValue();
            filters.add(new QFilter("startdate", "<=", (Object)bookeddate));
            filters.add(new QFilter("enddate", ">=", (Object)bookeddate));
            DataSet acctDs = AccountUtils.queryAccountDataSet((long)((Long)this.qParam.getOrgs().get(0)), (long)this.qParam.getAccountTable(), (String)"id accountid, masterid, longnumber", filters);
            List fields = DataSetUtils.getFields((DataSet)ds);
            fields.remove(COLKEY_ACCOUNT);
            ds = ds.join(acctDs, JoinType.LEFT).on(COLKEY_ACCOUNT, "masterid").select(fields.toArray(new String[0]), new String[]{COLKEY_ACCOUNT, "longnumber"}).finish();
            orderByString.add("longnumber");
        }
        orderByString.add(COLKEY_CUR);
        orderByString.add(COLKEY_ROWTYPE);
        List cols = GLUtil.getDataSetCols((DataSet)ds);
        for (String col : cols) {
            if (!this.assistVOMap.containsKey(col)) continue;
            orderByString.add(col);
        }
        orderByString.add(COLKEY_ORG);
        return ds.orderBy(orderByString.toArray(new String[0]));
    }

    private void setQueryType(FilterInfo filterInfo) {
        if (null != filterInfo) {
            int queryType = filterInfo.getInt("QUERY_TYPE");
            if (queryType == 1) {
                this.isExportAll = Boolean.TRUE;
            }
        } else {
            this.isExportAll = Boolean.FALSE;
        }
    }

    private void addAccoutToGroup(Long key, Long value) {
        Set<Long> valueList;
        if (null == this.accountGroup) {
            this.accountGroup = new HashMap<Long, Set<Long>>();
        }
        if (null == (valueList = this.accountGroup.get(key))) {
            valueList = new HashSet<Long>();
            this.accountGroup.put(key, valueList);
        }
        valueList.add(value);
    }

    public ReportColumnGroup getOverdueGroupColumn() {
        ReportColumnGroup overdueGroup = new ReportColumnGroup();
        overdueGroup.setCaption(AgingScheduleRightPlugin.getOverDue());
        overdueGroup.setFieldKey(COLKEY_OVERDUE_GROUP);
        overdueGroup.setTextAlign(CENTER);
        ReportColumnGroup dueTotalGroupColumn = this.getDueTotalGroupColumn(COLKEY_OVERDUETOTAL_GROUP, COLKEY_OVERDUETOTAL, COLKEY_OVERDUETOTAL_LOCAL);
        overdueGroup.getChildren().add(dueTotalGroupColumn);
        this.getDueRangeGroupColumn(overdueGroup, this.overDueRangeMap, COLKEY_OVERDUERANGE_GROUP);
        return overdueGroup;
    }

    public ReportColumnGroup getDueTotalGroupColumn(String colkeyDuetotalGroup, String colkeyDuetotal, String colkeyDuetotalLocal) {
        ReportColumnGroup overduetotalgroup = new ReportColumnGroup();
        overduetotalgroup.setCaption(AgingScheduleRightPlugin.getTotal());
        overduetotalgroup.setFieldKey(colkeyDuetotalGroup);
        overduetotalgroup.setTextAlign(CENTER);
        ReportColumn overdueTotalOriCol = this.createColumn(new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01", (String)"AgingScheduleRightPlugin_8", (String)"fi-gl-report", (Object[])new Object[0])), colkeyDuetotal, "amount", Boolean.TRUE);
        ReportColumn overdueTotalLocalCol = this.createCurLocalColumn(new LocaleString(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"AgingScheduleRightPlugin_9", (String)"fi-gl-report", (Object[])new Object[0])), colkeyDuetotalLocal, "amount", Boolean.FALSE);
        overduetotalgroup.getChildren().add(overdueTotalOriCol);
        overduetotalgroup.getChildren().add(overdueTotalLocalCol);
        return overduetotalgroup;
    }

    public ReportColumnGroup getUndueGroupColumn() {
        ReportColumnGroup undueGroup = new ReportColumnGroup();
        undueGroup.setCaption(AgingScheduleRightPlugin.getUnDue());
        undueGroup.setFieldKey(COLKEY_UNDUE_GROUP);
        undueGroup.setTextAlign(CENTER);
        ReportColumnGroup dueTotalGroupColumn = this.getDueTotalGroupColumn(COLKEY_UNDUETOTAL_GROUP, COLKEY_UNDUETOTAL, COLKEY_UNDUETOTAL_LOCAL);
        undueGroup.getChildren().add(dueTotalGroupColumn);
        this.getDueRangeGroupColumn(undueGroup, this.unDueRangeMap, COLKEY_UNDUERANGE_GROUP);
        return undueGroup;
    }

    public void getDueRangeGroupColumn(ReportColumnGroup dueGroup, Map<String, Tuple<Integer, Integer>> dueRangeMap, String colkeyDuerangeGroup) {
        int i = 0;
        for (Map.Entry<String, Tuple<Integer, Integer>> entry : dueRangeMap.entrySet()) {
            Tuple<Integer, Integer> range = entry.getValue();
            String colName = "";
            colName = (Integer)range.item2 == 0 ? String.format("%s- ", range.item1) : String.format("%s-%s", range.item1, range.item2);
            ReportColumnGroup dueRangeGroup = new ReportColumnGroup();
            dueRangeGroup.setCaption(new LocaleString(colName));
            dueRangeGroup.setFieldKey(colkeyDuerangeGroup + i);
            dueRangeGroup.setTextAlign(CENTER);
            ReportColumn dueRangeOriCol = this.createColumn(new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01", (String)"AgingScheduleRightPlugin_8", (String)"fi-gl-report", (Object[])new Object[0])), entry.getKey(), "amount", Boolean.TRUE);
            ReportColumn dueRangeLocalCol = this.createCurLocalColumn(new LocaleString(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"AgingScheduleRightPlugin_9", (String)"fi-gl-report", (Object[])new Object[0])), entry.getKey() + "local", "amount", Boolean.FALSE);
            dueRangeGroup.getChildren().add(dueRangeOriCol);
            dueRangeGroup.getChildren().add(dueRangeLocalCol);
            dueGroup.getChildren().add(dueRangeGroup);
            ++i;
        }
    }

    public ReportColumnGroup createBalTotalGroupColumn() {
        ReportColumnGroup balTotalGroup = new ReportColumnGroup();
        balTotalGroup.setCaption(AgingScheduleRightPlugin.getBal());
        balTotalGroup.setFieldKey(COLKEY_BALTOTAL_GROUP);
        balTotalGroup.setTextAlign(CENTER);
        ReportColumn column = this.createColumn(AgingScheduleRightPlugin.getCurOri(), COLKEY_BALTOTAL, "amount", Boolean.TRUE);
        balTotalGroup.getChildren().add(column);
        column = this.createCurLocalColumn(AgingScheduleRightPlugin.getCurLocal(), COLKEY_BALTOTAL_LOCAL, "amount", Boolean.FALSE);
        balTotalGroup.getChildren().add(column);
        return balTotalGroup;
    }

    private ReportColumn createCurLocalColumn(LocaleString caption, String fieldKey, String fieldType, Boolean hyperLink) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            column.setCurrencyField(COLKEY_LOCAL_CUR);
        }
        column.setHyperlink(hyperLink.booleanValue());
        return column;
    }
}

