/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.balancecarryover.AssistDifferentMsgContext;
import kd.fi.gl.balancecarryover.BalanceCarryOverContext;
import kd.fi.gl.balancecarryover.BalanceCarryOverParam;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.DataSetHelper;

public class BalanceCarryOverQueryRpt
extends AbstractReportListDataPlugin {
    private static final String balanceField = "id,org,%1$s booktype,accounttable,account,assgrp,assgrp.value value,currency,measureunit,period,endqty,endfor,endlocal";
    private static final String accountField = "number,longnumber,startdate,enddate,id,masterid,dc,checkitementry.asstactitem,checkitementry.asstactitem.flexfield,checkitementry.isdetail,checkitementry.isrequire,checkitementry.enaccheck";
    private static final String assistType = "bd_asstacttype";
    private static final long INIT_VERSION_DATE = -2209017600000L;
    private static final long day = 86400000L;
    private List<String> allAssist = new ArrayList<String>(4);
    private List<String> treeAssists = new ArrayList<String>(4);
    private Map<String, String> flexfield2entyrId = new HashMap<String, String>(4);
    private Map<String, String> flexfield2name = new HashMap<String, String>(4);
    private Set<DynamicObject> leafAccounts = new HashSet<DynamicObject>(16);
    private Map<Long, DynamicObject> masterid2leafAccounts = new HashMap<Long, DynamicObject>(16);
    Set<DynamicObject> pendingTreeTypeAccount = new HashSet<DynamicObject>(16);
    private Map<Long, Map<String, Object>> assgrpId2Value = new HashMap<Long, Map<String, Object>>(16);
    private BalanceCarryOverParam param = new BalanceCarryOverParam();
    private List<CommonAssist> comassist = new ArrayList<CommonAssist>(2);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        Map<Long, BalanceCarryOverContext> finalContext = new HashMap<Long, BalanceCarryOverContext>(16);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.initParam(filterInfo);
        this.initAccount(filterInfo);
        this.initAssist(filterInfo);
        if (this.param.isHasTreeBaseAddLeafType()) {
            ArrayList<Long> otherTypeHasVersionAccounts = new ArrayList<Long>(16);
            for (DynamicObject account : this.leafAccounts) {
                boolean hasTreeAssist = false;
                boolean containAssist = false;
                DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
                if (assistEntries != null) {
                    for (DynamicObject assistRow : assistEntries) {
                        DynamicObject assist = assistRow.getDynamicObject("asstactitem");
                        if (this.treeAssists.contains(assist.getString("flexfield"))) {
                            this.pendingTreeTypeAccount.add(account);
                            hasTreeAssist = true;
                            containAssist = true;
                            break;
                        }
                        if (!this.allAssist.contains(assist.getString("flexfield"))) continue;
                        containAssist = true;
                    }
                }
                if (hasTreeAssist || !this.param.isHasAddMustInputAssType() && !this.param.isHasDeleteAssType() || !containAssist || !this.isVersion(account.getDate("startdate").getTime())) continue;
                otherTypeHasVersionAccounts.add(account.getLong("masterid"));
            }
            finalContext = this.handleTreeTypeAccBalance();
            if (otherTypeHasVersionAccounts.size() > 0) {
                finalContext.putAll(this.handleAddMustInputAndDeleteAssTypeAccBalance(otherTypeHasVersionAccounts));
            }
        } else if (this.param.isHasAddMustInputAssType() || this.param.isHasDeleteAssType()) {
            ArrayList<Long> versionAccountMasterids = new ArrayList<Long>(this.leafAccounts.size());
            for (DynamicObject account : this.leafAccounts) {
                if (!this.isVersion(account.getDate("startdate").getTime())) continue;
                if (this.allAssist.isEmpty()) {
                    versionAccountMasterids.add(account.getLong("masterid"));
                    continue;
                }
                DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
                for (DynamicObject assistRow : assistEntries) {
                    DynamicObject assist = assistRow.getDynamicObject("asstactitem");
                    if (!this.allAssist.contains(assist.getString("flexfield"))) continue;
                    versionAccountMasterids.add(account.getLong("masterid"));
                }
            }
            finalContext = this.handleAddMustInputAndDeleteAssTypeAccBalance(versionAccountMasterids);
        }
        return this.generateResult(finalContext);
    }

    private boolean isVersion(long time) {
        return (time - -2209017600000L) / 86400000L != 0L;
    }

    private Map<Long, BalanceCarryOverContext> handleAddMustInputAndDeleteAssTypeAccBalance(List<Long> versionAccountMasterids) {
        HashMap<Long, BalanceCarryOverContext> finalCotext = new HashMap<Long, BalanceCarryOverContext>(16);
        try (DataSet balance = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_balance", (String)this.getBalanceField(), (QFilter[])this.getBalanceFilter(versionAccountMasterids), (String)"account");){
            for (Row row : balance) {
                HashSet<String> addMustInputAssists = new HashSet<String>(4);
                HashSet<String> deleteAssists = new HashSet<String>(4);
                long assgrpId = row.getLong("assgrp");
                String assgrpValue = row.getString("value");
                Map<String, Object> assgrpValueMap = this.getAssgrpValueMap(assgrpId, assgrpValue);
                DynamicObject account = this.masterid2leafAccounts.get(row.getLong("account"));
                DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
                HashMap<String, Object[]> accountAssists = new HashMap<String, Object[]>(assistEntries.size());
                for (DynamicObject assistRow : assistEntries) {
                    String flexfield = assistRow.getDynamicObject("asstactitem").getString("flexfield");
                    accountAssists.put(flexfield, new Object[]{assistRow.getDynamicObject("asstactitem").getString("name"), assistRow.getBoolean("isrequire"), assistRow.getBoolean("isdetail")});
                    if (!assistRow.getBoolean("isrequire") || assgrpValueMap != null && assgrpValueMap.get(flexfield) != null) continue;
                    addMustInputAssists.add(flexfield);
                }
                if (assgrpValueMap != null) {
                    for (Map.Entry<String, Object> entry : assgrpValueMap.entrySet()) {
                        if (accountAssists.containsKey(entry.getKey())) continue;
                        deleteAssists.add(entry.getKey());
                    }
                }
                if ((!this.param.isHasAddMustInputAssType() || addMustInputAssists.size() <= 0) && (!this.param.isHasDeleteAssType() || deleteAssists.size() <= 0)) continue;
                finalCotext.put(row.getLong("id"), this.createBalanceCarryOver(row, addMustInputAssists, deleteAssists, accountAssists));
            }
        }
        return finalCotext;
    }

    private Map<Long, BalanceCarryOverContext> handleTreeTypeAccBalance() {
        HashMap<Long, BalanceCarryOverContext> finalCotext = new HashMap<Long, BalanceCarryOverContext>(16);
        ArrayList<Long> pendingAccMasterIds = new ArrayList<Long>(this.pendingTreeTypeAccount.size());
        for (DynamicObject account : this.pendingTreeTypeAccount) {
            pendingAccMasterIds.add(account.getLong("masterid"));
        }
        HashMap<String, ArrayList<Long>> detailValueId2Balance = new HashMap<String, ArrayList<Long>>(16);
        HashMap<String, ArrayList<Long>> flexfield2ValueIds = new HashMap<String, ArrayList<Long>>(16);
        HashMap<Long, BalanceCarryOverContext> balanceCarryOverContextMap = new HashMap<Long, BalanceCarryOverContext>(16);
        DataSet balance = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_balance", (String)this.getBalanceField(), (QFilter[])this.getBalanceFilter(pendingAccMasterIds), (String)"account");
        Iterator iterator = null;
        try {
            for (Row row : balance) {
                HashSet addMustInputAssists = new HashSet(4);
                HashSet<String> deleteAssists = new HashSet<String>(4);
                long assgrpId = row.getLong("assgrp");
                String assgrpValue = row.getString("value");
                Map<String, Object> assgrpValueMap = this.getAssgrpValueMap(assgrpId, assgrpValue);
                DynamicObject account = this.masterid2leafAccounts.get(row.getLong("account"));
                DynamicObjectCollection assistEntries = account.getDynamicObjectCollection("checkitementry");
                HashMap<String, Object[]> accountAssists = new HashMap<String, Object[]>(assistEntries.size());
                for (DynamicObject assistRow : assistEntries) {
                    Object value;
                    String flexfield = assistRow.getDynamicObject("asstactitem").getString("flexfield");
                    accountAssists.put(flexfield, new Object[]{assistRow.getDynamicObject("asstactitem").getString("name"), assistRow.getBoolean("isrequire"), assistRow.getBoolean("isdetail")});
                    if (assgrpValueMap != null && this.treeAssists.contains(flexfield) && assistRow.getBoolean("isdetail") && (value = assgrpValueMap.get(flexfield)) != null) {
                        long valueId = Long.parseLong(value.toString());
                        ArrayList<Long> balanceIds = (ArrayList<Long>)detailValueId2Balance.get(this.getKey(flexfield, valueId));
                        if (balanceIds == null) {
                            balanceIds = new ArrayList<Long>(16);
                            detailValueId2Balance.put(this.getKey(flexfield, valueId), balanceIds);
                        }
                        balanceIds.add(row.getLong("id"));
                        ArrayList<Long> valueIds = (ArrayList<Long>)flexfield2ValueIds.get(flexfield);
                        if (valueIds == null) {
                            valueIds = new ArrayList<Long>(16);
                            flexfield2ValueIds.put(flexfield, valueIds);
                        }
                        valueIds.add(valueId);
                    }
                    if (!assistRow.getBoolean("isrequire") || assgrpValueMap != null && assgrpValueMap.get(flexfield) != null) continue;
                    addMustInputAssists.add(flexfield);
                }
                if (assgrpValueMap != null) {
                    for (Map.Entry<String, Object> entry : assgrpValueMap.entrySet()) {
                        if (accountAssists.containsKey(entry.getKey())) continue;
                        deleteAssists.add(entry.getKey());
                    }
                }
                balanceCarryOverContextMap.put(row.getLong("id"), this.createBalanceCarryOver(row, addMustInputAssists, deleteAssists, accountAssists));
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (balance != null) {
                if (iterator != null) {
                    try {
                        balance.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    balance.close();
                }
            }
        }
        HashMap flexfield2UnLeafValues = new HashMap(flexfield2ValueIds.size());
        for (Map.Entry entry : flexfield2ValueIds.entrySet()) {
            List<Long> unLeafValues = this.getUnleafeValue((String)entry.getKey(), (List)entry.getValue());
            if (unLeafValues.size() <= 0) continue;
            flexfield2UnLeafValues.put(entry.getKey(), unLeafValues);
        }
        for (Map.Entry entry : flexfield2UnLeafValues.entrySet()) {
            String Flexfield = (String)entry.getKey();
            for (Long detailAssistId : (List)entry.getValue()) {
                for (Long balanceId : (List)detailValueId2Balance.get(this.getKey(Flexfield, detailAssistId))) {
                    HashSet<String> treeBaseAddLeaf;
                    AssistDifferentMsgContext assistDiff;
                    BalanceCarryOverContext fianlBalanceCarrOverContext = (BalanceCarryOverContext)finalCotext.get(balanceId);
                    if (fianlBalanceCarrOverContext == null) {
                        fianlBalanceCarrOverContext = (BalanceCarryOverContext)balanceCarryOverContextMap.remove(balanceId);
                    }
                    if ((assistDiff = fianlBalanceCarrOverContext.getAssistDifferentMsg()) == null) {
                        assistDiff = new AssistDifferentMsgContext();
                    }
                    if ((treeBaseAddLeaf = assistDiff.getTreeBaseAddLeaf()) == null) {
                        treeBaseAddLeaf = new HashSet<String>(4);
                    }
                    treeBaseAddLeaf.add(Flexfield);
                    assistDiff.setTreeBaseAddLeaf(treeBaseAddLeaf);
                    fianlBalanceCarrOverContext.setAssistDifferentMsg(assistDiff);
                    finalCotext.put(balanceId, fianlBalanceCarrOverContext);
                }
            }
        }
        if (this.param.isHasAddMustInputAssType() || this.param.isHasDeleteAssType()) {
            for (Map.Entry entry : balanceCarryOverContextMap.entrySet()) {
                AssistDifferentMsgContext assistDiff;
                BalanceCarryOverContext balanceCarryOverContext = (BalanceCarryOverContext)entry.getValue();
                if (this.param.isHasAddMustInputAssType() && (assistDiff = balanceCarryOverContext.getAssistDifferentMsg()) != null && assistDiff.getAddMustInputAssists() != null && assistDiff.getAddMustInputAssists().size() > 0) {
                    finalCotext.compute((Long)entry.getKey(), (k, v) -> {
                        if (v == null) {
                            return balanceCarryOverContext;
                        }
                        return v;
                    });
                }
                if (!this.param.isHasDeleteAssType() || (assistDiff = balanceCarryOverContext.getAssistDifferentMsg()) == null || assistDiff.getDeleteAssists() == null || assistDiff.getDeleteAssists().size() <= 0) continue;
                finalCotext.compute((Long)entry.getKey(), (k, v) -> {
                    if (v == null) {
                        return balanceCarryOverContext;
                    }
                    return v;
                });
            }
        }
        return finalCotext;
    }

    private BalanceCarryOverContext createBalanceCarryOver(Row row, Set<String> addMustInputAssists, Set<String> deleteAssists, Map<String, Object[]> accountAssists) {
        BalanceCarryOverContext balanceCarryOver = new BalanceCarryOverContext();
        balanceCarryOver.setBalanceId(row.getLong("id").longValue());
        balanceCarryOver.setOrgId(row.getLong("org").longValue());
        balanceCarryOver.setBookTypeId(row.getLong("booktype").longValue());
        balanceCarryOver.setAccountTableId(row.getLong("accounttable").longValue());
        balanceCarryOver.setAccountMasterId(row.getLong("account").longValue());
        balanceCarryOver.setAccountNumber(this.masterid2leafAccounts.get(row.getLong("account")).getString("number"));
        balanceCarryOver.setAssgrpId(row.getLong("assgrp").longValue());
        balanceCarryOver.setPeriodId(row.getLong("period").longValue());
        balanceCarryOver.setCurrencyId(row.getLong("currency").longValue());
        balanceCarryOver.setCurAccountAssist(accountAssists);
        balanceCarryOver.setLocalCurrencyId(this.param.getCurrencyLocal());
        balanceCarryOver.setSearchPeriodId(this.param.getPeriod());
        balanceCarryOver.setMeasureunit(row.getLong("measureunit").longValue());
        balanceCarryOver.setEndqty(row.getBigDecimal("endqty"));
        BigDecimal endfor = row.getBigDecimal("endfor");
        BigDecimal endlocal = row.getBigDecimal("endlocal");
        if (this.param.isShowByActDC()) {
            String dc = this.masterid2leafAccounts.get(row.getLong("account")).getString("dc");
            if ("1".equals(dc)) {
                balanceCarryOver.setDebitFor(endfor);
                balanceCarryOver.setCreditFor(BigDecimal.ZERO);
                balanceCarryOver.setDebitLocal(endlocal);
                balanceCarryOver.setCreditLocal(BigDecimal.ZERO);
            } else {
                balanceCarryOver.setDebitFor(BigDecimal.ZERO);
                balanceCarryOver.setCreditFor(endfor.negate());
                balanceCarryOver.setDebitLocal(BigDecimal.ZERO);
                balanceCarryOver.setCreditLocal(endfor.negate());
            }
        } else if (endfor.compareTo(BigDecimal.ZERO) > 0) {
            balanceCarryOver.setDebitFor(endfor);
            balanceCarryOver.setCreditFor(BigDecimal.ZERO);
            balanceCarryOver.setDebitLocal(endlocal);
            balanceCarryOver.setCreditLocal(BigDecimal.ZERO);
        } else {
            balanceCarryOver.setDebitFor(BigDecimal.ZERO);
            balanceCarryOver.setCreditFor(endfor.negate());
            balanceCarryOver.setDebitLocal(BigDecimal.ZERO);
            balanceCarryOver.setCreditLocal(endlocal.negate());
        }
        if (addMustInputAssists.size() > 0 || deleteAssists.size() > 0) {
            AssistDifferentMsgContext assistDif = new AssistDifferentMsgContext();
            assistDif.setAddMustInputAssists(addMustInputAssists);
            assistDif.setDeleteAssists(deleteAssists);
            balanceCarryOver.setAssistDifferentMsg(assistDif);
        }
        for (int i = 1; i <= this.comassist.size(); ++i) {
            balanceCarryOver.addComassistId(row.getLong("comassist" + i + "id"));
        }
        return balanceCarryOver;
    }

    private void setAmount() {
    }

    private QFilter[] getBalanceFilter(List<Long> pendingAccMasterIds) {
        ArrayList<QFilter> balanceFilters = new ArrayList<QFilter>(10);
        balanceFilters.add(new QFilter("org", "=", (Object)this.param.getOrg()));
        balanceFilters.add(new QFilter("booktype", "=", (Object)this.param.getBookType()));
        balanceFilters.add(new QFilter("accounttable", "=", (Object)this.param.getAccountTable()));
        balanceFilters.add(new QFilter("account", "in", pendingAccMasterIds));
        balanceFilters.add(new QFilter("period", "<=", (Object)this.param.getPeriod()));
        balanceFilters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)this.param.getPeriod(), (Long[])new Long[]{this.param.getOrg()})));
        balanceFilters.add(new QFilter("endfor", "!=", (Object)BigDecimal.ZERO).or("endlocal", "!=", (Object)BigDecimal.ZERO));
        balanceFilters.addAll(this.param.getComAssistFiltersForBal());
        return balanceFilters.toArray(new QFilter[0]);
    }

    private List<Long> getUnleafeValue(String flexfield, List<Long> leafeValues) {
        ArrayList<Long> unLeafValues = new ArrayList(leafeValues.size());
        String entryId = this.flexfield2entyrId.get(flexfield);
        QFilter leavF = new QFilter("isleaf", "=", (Object)false);
        if (entryId.startsWith("bos_org+")) {
            String view = entryId.substring(8);
            unLeafValues = this.queryOrgParentData(Long.parseLong(view), leafeValues);
        } else if ("bos_adminorg".equals(entryId)) {
            unLeafValues = this.queryOrgParentData(1L, leafeValues);
        } else {
            QFilter idF = new QFilter("id", "in", leafeValues);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entryId, (String)"id", (QFilter[])new QFilter[]{idF, leavF}, null);){
                for (Row row : ds) {
                    unLeafValues.add(row.getLong("id"));
                }
            }
        }
        return unLeafValues;
    }

    private List<Long> queryOrgParentData(Long viewId, List<Long> leafValues) {
        ArrayList<Long> unLeafValues = new ArrayList<Long>(16);
        QFilter parentFilter = new QFilter("isleaf", "=", (Object)false);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)viewId), parentFilter, new QFilter("org", "in", leafValues)}, null);){
            for (Row row : ds) {
                unLeafValues.add(row.getLong("org"));
            }
        }
        return unLeafValues;
    }

    private Map<String, Object> getAssgrpValueMap(long assgrpId, String assgrpValue) {
        Map assgrpValueMap = this.assgrpId2Value.get(assgrpId);
        if (assgrpValueMap != null) {
            return assgrpValueMap;
        }
        if (assgrpValue == null || assgrpValue.trim().equals("")) {
            return null;
        }
        try {
            assgrpValueMap = (Map)JSONUtils.cast((String)assgrpValue, Map.class);
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u89e3\u6790\u5f02\u5e38\uff1aassgrp:%1$sassval:%2$s\u3002", (String)"BalanceCarryOverQueryRpt_14", (String)"fi-gl-report", (Object[])new Object[0]), assgrpId, assgrpValue));
        }
        this.assgrpId2Value.put(assgrpId, assgrpValueMap);
        return assgrpValueMap;
    }

    private void initParam(FilterInfo filterInfo) {
        FilterItemInfo bizTypeInfo = filterInfo.getFilterItem("biztype");
        Object bizType = bizTypeInfo.getValue();
        List<String> bizTypes = this.getBizType(bizType.toString());
        for (String type : bizTypes) {
            if ("1".equals(type)) {
                this.param.setHasAddMustInputAssType(true);
            }
            if ("2".equals(type)) {
                this.param.setHasDeleteAssType(true);
            }
            if (!"3".equals(type)) continue;
            this.param.setHasTreeBaseAddLeafType(true);
        }
        DynamicObject org = (DynamicObject)filterInfo.getFilterItem("org").getValue();
        DynamicObject bookType = (DynamicObject)filterInfo.getFilterItem("booktype").getValue();
        DynamicObject startPeriod = (DynamicObject)filterInfo.getFilterItem("startperiod").getValue();
        DynamicObject accountTable = (DynamicObject)filterInfo.getFilterItem("accounttable").getValue();
        this.param.setOrg(org.getLong("id"));
        this.param.setBookType(bookType.getLong("id"));
        this.param.setPeriod(startPeriod.getLong("id"));
        this.param.setAccountTable(accountTable.getLong("id"));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)org.getLong("id"), (long)bookType.getLong("id"));
        this.param.setCurrencyLocal(bookInfo.getBaseCurrencyId());
        this.param.setShowByActDC(ReportUtils.getShowByActDCSysParam((Long)org.getLong("id")).booleanValue());
        this.param.setFilterInfo(filterInfo);
        Optional assistTable = ComAssistTable.get((Long)this.param.getOrg(), (Long)this.param.getBookType());
        this.comassist = ((ComAssistTable)assistTable.get()).getCommonAssists();
    }

    private List<String> getBizType(String biztype) {
        String[] typeArray = biztype.split(",");
        List<String> bizTypes = Arrays.asList(typeArray);
        return bizTypes;
    }

    private void initAccount(FilterInfo filterInfo) {
        FilterItemInfo accountInfo = filterInfo.getFilterItem("account");
        FilterItemInfo orgInfo = filterInfo.getFilterItem("org");
        FilterItemInfo periodInfo = filterInfo.getFilterItem("startperiod");
        FilterItemInfo accountTableInfo = filterInfo.getFilterItem("accounttable");
        DynamicObjectCollection accountInfos = (DynamicObjectCollection)accountInfo.getValue();
        DynamicObject org = (DynamicObject)orgInfo.getValue();
        long orgId = org.getLong("id");
        DynamicObject period = (DynamicObject)periodInfo.getValue();
        DynamicObject accountTable = (DynamicObject)accountTableInfo.getValue();
        QFilter accountF = AccountUtils.getAccountDataFilter((long)orgId, (long)accountTable.getLong("id"));
        QFilter startF = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        QFilter endF = new QFilter("enddate", ">", (Object)period.getDate("enddate"));
        QFilter leafF = new QFilter("isleaf", "=", (Object)true);
        QFilter accountTableF = new QFilter("accounttable", "=", (Object)accountTable.getLong("id"));
        Map accountDyns = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)accountField, (QFilter[])new QFilter[]{accountF, accountTableF, startF, endF, leafF});
        if (CollectionUtils.isEmpty((Collection)accountInfos)) {
            for (Map.Entry entry : accountDyns.entrySet()) {
                DynamicObject account = (DynamicObject)entry.getValue();
                this.leafAccounts.add(account);
                this.masterid2leafAccounts.put(account.getLong("masterid"), account);
            }
        } else {
            HashSet<String> accountLongNumbers = new HashSet<String>(16);
            for (DynamicObject account : accountInfos) {
                accountLongNumbers.add(account.getString("longnumber"));
            }
            for (Map.Entry entry : accountDyns.entrySet()) {
                DynamicObject account = (DynamicObject)entry.getValue();
                String longNumber = account.getString("longnumber");
                for (String parentLongNumber : accountLongNumbers) {
                    if (!longNumber.startsWith(parentLongNumber)) continue;
                    this.leafAccounts.add(account);
                    this.masterid2leafAccounts.put(account.getLong("masterid"), account);
                }
            }
        }
    }

    private void initAssist(FilterInfo filter) {
        List items = filter.getFlexFilterItems();
        this.fillAssistTypeName();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            this.allAssist.add(propName);
            String entityId = this.flexfield2entyrId.get(propName);
            if (entityId == null) continue;
            if (entityId.startsWith("bos_org+") || "bos_adminorg".equals(entityId) || "bd_admindivision".equals(entityId)) {
                this.treeAssists.add(propName);
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            Map fields = dataEntityType.getFields();
            IDataEntityProperty parent = (IDataEntityProperty)fields.get("parent");
            IDataEntityProperty isleaf = (IDataEntityProperty)fields.get("isleaf");
            if (parent == null || isleaf == null || !StringUtils.isNotBlank((CharSequence)isleaf.getAlias())) continue;
            this.treeAssists.add(propName);
        }
    }

    private void fillAssistTypeName() {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)assistType, (String)"name,valuesource,valuetype,flexfield,orgfunc", null, null);){
            for (Row row : ds) {
                String valType;
                this.flexfield2name.put(row.getString("flexfield"), row.getString("name"));
                switch (valType = row.getString("valuetype")) {
                    case "1": {
                        String valueSource = row.getString("valuesource");
                        if ("bos_org".equals(valueSource)) {
                            String func = "15";
                            StringBuilder baseType = new StringBuilder(valueSource);
                            long orgfunc = row.getLong("orgfunc");
                            if (orgfunc != 0L) {
                                func = String.valueOf(orgfunc);
                            }
                            baseType.append("+").append(func);
                            valueSource = baseType.toString();
                        }
                        this.flexfield2entyrId.put(row.getString("flexfield"), valueSource);
                        break;
                    }
                    case "2": {
                        this.flexfield2entyrId.put(row.getString("flexfield"), "bos_assistantdata_detail");
                    }
                }
            }
        }
    }

    private DataSet generateResult(Map<Long, BalanceCarryOverContext> finalContext) {
        int size = this.comassist.size();
        ArrayList<String> field = new ArrayList<String>(16);
        field.add("id");
        field.add("orgid");
        field.add("booktypeid");
        field.add("accountnumber");
        field.add("curassgrp");
        field.add("flexfield");
        field.add("debitlocal");
        field.add("creditlocal");
        field.add("debitfor");
        field.add("creditfor");
        field.add("differentmsg");
        field.add("currencyid");
        field.add("currencylocalid");
        field.add("assistdifferentmsg");
        field.add("periodid");
        field.add("accountnum");
        field.add("measureunit");
        field.add("endqty");
        ArrayList<Object> dataTypes = new ArrayList<Object>(16);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.StringType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.BigDecimalType);
        dataTypes.add(DataType.BigDecimalType);
        dataTypes.add(DataType.BigDecimalType);
        dataTypes.add(DataType.BigDecimalType);
        dataTypes.add(DataType.StringType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.StringType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.StringType);
        dataTypes.add(DataType.LongType);
        dataTypes.add(DataType.BigDecimalType);
        for (int i = 1; i <= size; ++i) {
            field.add("comassist" + i + "id");
            dataTypes.add(DataType.LongType);
        }
        ArrayList values = new ArrayList(16);
        for (Map.Entry<Long, BalanceCarryOverContext> entry : finalContext.entrySet()) {
            Set treeBastAddLeaf;
            Set deleteAssist;
            BalanceCarryOverContext balanceCarryOverContext = entry.getValue();
            ArrayList<Object> row = new ArrayList<Object>(10);
            row.add(balanceCarryOverContext.getBalanceId());
            row.add(balanceCarryOverContext.getOrgId());
            row.add(balanceCarryOverContext.getBookTypeId());
            row.add(this.masterid2leafAccounts.get(balanceCarryOverContext.getAccountMasterId()).getLong("id"));
            Map cruaccoiuntAss = balanceCarryOverContext.getCurAccountAssist();
            StringBuilder curAssStr = new StringBuilder(3);
            for (Map.Entry assEntry : cruaccoiuntAss.entrySet()) {
                curAssStr.append(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff0c%3$s\uff09\uff1b", (String)"BalanceCarryOverQueryRpt_6", (String)"fi-gl-report", (Object[])new Object[]{((Object[])assEntry.getValue())[0], (Boolean)((Object[])assEntry.getValue())[1] != false ? ResManager.loadKDString((String)"\u5fc5\u5f55", (String)"BalanceCarryOverQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u5fc5\u5f55", (String)"BalanceCarryOverQueryRpt_3", (String)"fi-gl-report", (Object[])new Object[0]), (Boolean)((Object[])assEntry.getValue())[2] != false ? ResManager.loadKDString((String)"\u660e\u7ec6", (String)"BalanceCarryOverQueryRpt_4", (String)"fi-gl-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u660e\u7ec6", (String)"BalanceCarryOverQueryRpt_5", (String)"fi-gl-report", (Object[])new Object[0])}));
            }
            if (curAssStr.length() > 0) {
                curAssStr.delete(curAssStr.length() - 1, curAssStr.length());
            }
            row.add(curAssStr.toString());
            row.add(balanceCarryOverContext.getAssgrpId());
            row.add(balanceCarryOverContext.getDebitLocal());
            row.add(balanceCarryOverContext.getCreditLocal());
            row.add(balanceCarryOverContext.getDebitFor());
            row.add(balanceCarryOverContext.getCreditFor());
            AssistDifferentMsgContext assistDifferentMsgContext = balanceCarryOverContext.getAssistDifferentMsg();
            StringBuilder msg = new StringBuilder();
            Set addMustInput = assistDifferentMsgContext.getAddMustInputAssists();
            if (addMustInput != null && addMustInput.size() > 0) {
                String assistNamesStr = addMustInput.stream().map(assist -> this.flexfield2name.get(assist)).collect(Collectors.joining(","));
                if (msg.length() > 0) {
                    msg.append(MultiLangPunc.semicolon());
                }
                msg.append(ResManager.loadKDString((String)"\u65e0\u5fc5\u5f55\u6838\u7b97\u7ef4\u5ea6\uff1a%s", (String)"BalanceCarryOverQueryRpt_10", (String)"fi-gl-report", (Object[])new Object[]{assistNamesStr}));
            }
            if ((deleteAssist = assistDifferentMsgContext.getDeleteAssists()) != null && deleteAssist.size() > 0) {
                String assistNamesStr = deleteAssist.stream().map(assist -> this.flexfield2name.get(assist)).collect(Collectors.joining(","));
                if (msg.length() > 0) {
                    msg.append(MultiLangPunc.semicolon());
                }
                msg.append(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u88ab\u5220\u9664\uff1a%s", (String)"BalanceCarryOverQueryRpt_11", (String)"fi-gl-report", (Object[])new Object[]{assistNamesStr}));
            }
            if ((treeBastAddLeaf = assistDifferentMsgContext.getTreeBaseAddLeaf()) != null && treeBastAddLeaf.size() > 0) {
                String assistNamesStr = treeBastAddLeaf.stream().map(assist -> this.flexfield2name.get(assist)).collect(Collectors.joining(","));
                if (msg.length() > 0) {
                    msg.append(MultiLangPunc.semicolon());
                }
                msg.append(ResManager.loadKDString((String)"\u6811\u5f62\u57fa\u7840\u8d44\u6599\u65b0\u589e\u4e0b\u7ea7\uff1a%s", (String)"BalanceCarryOverQueryRpt_12", (String)"fi-gl-report", (Object[])new Object[]{assistNamesStr}));
            }
            row.add(msg.toString());
            row.add(balanceCarryOverContext.getCurrencyId());
            row.add(balanceCarryOverContext.getLocalCurrencyId());
            String assistDifferentMsg = "";
            try {
                assistDifferentMsg = JSONUtils.toString((Object)balanceCarryOverContext.getAssistDifferentMsg());
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5dee\u5f02\u4fe1\u606f\u89e3\u6790\u5f02\u5e38\uff1a%s\u3002", (String)"BalanceCarryOverQueryRpt_13", (String)"fi-gl-report", (Object[])new Object[0]), balanceCarryOverContext.toString()));
            }
            row.add(assistDifferentMsg);
            row.add(balanceCarryOverContext.getPeriodId());
            row.add(balanceCarryOverContext.getAccountNumber());
            row.add(balanceCarryOverContext.getMeasureunit());
            row.add(balanceCarryOverContext.getEndqty());
            for (Long comassisid : balanceCarryOverContext.getComassistIds()) {
                row.add(comassisid);
            }
            values.add(row);
        }
        return DataSetHelper.createDatSet(((Object)((Object)this)).getClass(), field, dataTypes, values).orderBy(new String[]{"accountnum"});
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        List<ReportColumn> list = this.getAllReportColumns(columns);
        ComAssistTableService.modifyReportColumn((ComAssistTable)ComAssistTable.get((Long)this.param.getAccountTable()), list);
        return columns;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren()));
        }
        return list;
    }

    private String getKey(String flexfield, long value) {
        StringBuilder sb = new StringBuilder(28);
        sb.append(flexfield);
        sb.append(value);
        return sb.toString();
    }

    private String getBalanceField() {
        return String.format(balanceField, this.getComassistField());
    }

    private String getComassistField() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= this.comassist.size(); ++i) {
            sb.append("comassist").append(i).append(" comassist").append(i).append("id,");
        }
        return sb.toString();
    }
}

