/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.cashflow.CashFlowParallelQuery;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;

public class CashFlowQueryRpt
extends AbstractReportListDataPlugin {
    private CashFlowQueryParam cfParam;

    public DataSet query(ReportQueryParam param, Object obj) {
        this.cfParam = new CashFlowQueryParam(param.getFilter(), "gl_rpt_cashflow", param);
        DataSet execute = new CashFlowParallelQuery(this.cfParam).execute();
        if (this.cfParam.isShowAssist()) {
            List cols = GLUtil.getDataSetCols((DataSet)execute);
            cols.add("assgrp as assgrpvalue");
            execute = execute.select(cols.toArray(new String[0]));
        }
        RowMeta rowMeta = execute.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> fieldList = new ArrayList<String>(8);
        for (Field field : fields) {
            String fieldName = field.getAlias();
            if (fieldName.startsWith("comassist")) {
                fieldName = fieldName + " " + fieldName + "id";
            }
            fieldList.add(fieldName);
        }
        execute = execute.select(fieldList.toArray(new String[0]));
        boolean isShowOrgField = Arrays.stream(fields).anyMatch(x -> x.getAlias().equals("orgid"));
        execute = isShowOrgField && this.cfParam.isShowOrg() ? execute.addField("orgid", "flexorgid") : execute.addField(String.valueOf(this.cfParam.getOrgs().get(0)), "flexorgid");
        DynamicObject period = PeriodUtil.getPeriodByPeriodId((long)this.cfParam.getEndPeriod(), (String)"enddate");
        Date nameCtrlDate = period.getDate("enddate");
        execute = execute.addField(DateUtils.getYearMonthDayFuncStr((Date)nameCtrlDate), "namectrldate");
        return execute;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        for (AbstractReportColumn col : columns) {
            String fieldKey = ((ReportColumn)col).getFieldKey();
            if ("orgid".equals(fieldKey)) {
                ((ReportColumn)col).setHide(!this.cfParam.isShowOrg());
                continue;
            }
            if (!"assgrp".equals(fieldKey)) continue;
            ((ReportColumn)col).setHide(!this.cfParam.isShowAssist());
        }
        if (this.cfParam.isShowAssist()) {
            ReportColumn column = new ReportColumn();
            column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u503c", (String)"CashFlowQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0])));
            column.setFieldKey("assgrpvalue");
            column.setFieldType("text");
            column.setHide(true);
            columns.add((AbstractReportColumn)column);
        }
        List comAssistEntityList = this.cfParam.getComAssistEntityList();
        int comassistColIndex = 2;
        for (Tuple2 comAssistEntity : comAssistEntityList) {
            String comassistKey = (String)comAssistEntity.t1;
            String entity = (String)comAssistEntity.t2;
            ReportColumn column = new ReportColumn();
            column.setCaption(new LocaleString(CommonAssistUtil.getComAssistEntityName((long)this.cfParam.getAccountTable(), (String)entity)));
            column.setEntityId(entity);
            column.setFieldKey(comassistKey);
            column.setFieldType("basedata");
            columns.add(comassistColIndex++, (AbstractReportColumn)column);
        }
        columns.add((AbstractReportColumn)ReportHelper.createFlexOrgidColumn());
        return columns;
    }
}

