/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.GeneralLedgerHelperRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.fiilter.ReportGroupFilter;
import kd.fi.gl.util.GLUtil;

public class GeneralLedgerQueryRpt
extends AbstractReportListDataPlugin {
    private String BEGIN_BALANCE = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"GeneralLedgerQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]);
    private QueryParamRpt qParam;
    private static String[] accSel = new String[]{"number", "dc", "name"};
    private static String[] periodBalSel = new String[]{"period", "account", "currencyid", "currencyname", "debitfor", "debitlocal", "debitqty", "creditfor", "creditlocal", "creditqty", "endfor", "endlocal", "endqty"};
    private static String[] yearBalSel = new String[]{"period", "account", "currencyid", "currencyname", "yeardebitfor debitfor", "yeardebitlocal debitlocal", "yeardebitqty debitqty", "yearcreditfor creditfor", "yearcreditlocal creditlocal", "yearcreditqty creditqty", "endfor", "endlocal", "endqty"};
    private static String[] beginBalSel = new String[]{"period", "account", "currencyid", "currencyname", "debitfor", "debitlocal", "debitqty", "creditfor", "creditlocal", "creditqty", "beginfor endfor", "beginlocal endlocal", "beginqty endqty"};

    private static String getPeriodAmount() {
        return ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"GeneralLedgerQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getYearAmount() {
        return ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"GeneralLedgerQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private void init(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        this.qParam = new QueryParamRpt(filterInfo);
    }

    public DataSet query(ReportQueryParam param, Object obj) {
        this.init(param);
        DataSet mainSet = this.queryBalanceMainSet();
        DataSet beginSet = this.queryBalanceBeginSet(mainSet.copy());
        mainSet = this.getModifiedSet(beginSet.copy(), mainSet.copy());
        if (!this.qParam.isShowLeafAccount()) {
            mainSet = mainSet.filter("level <= " + this.qParam.getAccountLevel());
            beginSet = beginSet.filter("level <= " + this.qParam.getAccountLevel());
        }
        DataSet beginBalanceSet = this.getLedgerSet(beginSet.copy(), "beginbalance");
        DataSet periodBalanceSet = this.getLedgerSet(mainSet.copy(), "periodbalance");
        DataSet yearBalanceSet = this.getLedgerSet(mainSet.copy(), "yearbalance");
        DataSet dSet = periodBalanceSet.union(yearBalanceSet).union(beginBalanceSet).orderBy(new String[]{"number", "period", "orderStr"});
        dSet = this.doCheckBoxFilter(dSet);
        if (this.qParam.isAllCurrency()) {
            dSet = dSet.orderBy(new String[]{"number", "currencyid", "period", "orderStr"});
        }
        dSet = this.gainCleanedSet(dSet);
        dSet = dSet.addField(String.valueOf(this.qParam.getCurLocal()), "currencylocalid");
        return ReportDsExtProcessHelper.doExtProcess(param, dSet, "gl_rpt_generalledger");
    }

    private DataSet doCheckBoxFilter(DataSet ds) {
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.add("number");
        if (!this.qParam.isSynCurrency()) {
            assTypeList.add("currencyid");
        }
        if (this.qParam.isShowQty()) {
            assTypeList.add("measureunit");
        }
        ReportGroupFilter filter = new ReportGroupFilter(assTypeList);
        FilterInfo filterInfo = this.qParam.getFilterInfo();
        if (filterInfo.getBoolean("balancezero")) {
            HashSet<String> checkFields = new HashSet<String>();
            checkFields.add("endlocal");
            if (this.qParam.isQueryCurrency()) {
                checkFields.add("endfor");
            }
            if (this.qParam.isShowQty()) {
                checkFields.add("endqty");
            }
            final long endPeriod = filterInfo.getLong("endperiod");
            RowMeta rowMeta = ds.getRowMeta();
            final List endFieldsIdxes = checkFields.stream().map(field -> rowMeta.getFieldIndex(field, false)).filter(i -> i != -1).collect(Collectors.toList());
            filter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    return endFieldsIdxes.stream().anyMatch(f -> row.getBigDecimal(f.intValue()) != null && row.getBigDecimal(f.intValue()).compareTo(BigDecimal.ZERO) != 0);
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return Objects.equals(row.getString("orderStr"), "2") && row.getLong("period") == endPeriod;
                }
            });
        }
        ds = filter.doFilter(ds);
        return ds;
    }

    private DataSet getModifiedSet(DataSet beginSet, DataSet mainSet) {
        Field[] fields;
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("account");
        if (this.qParam.isAllCurrency()) {
            groupBy.add("currencyid");
        }
        if (this.qParam.isShowQty()) {
            groupBy.add("measureunit");
        }
        groupBy.add("period");
        mainSet = mainSet.filter("period != " + this.qParam.getStartPeriod());
        List mainFields = GLUtil.getDataSetCols((DataSet)mainSet);
        mainSet = mainSet.union(beginSet.select(mainFields.toArray(new String[0]))).orderBy(groupBy.toArray(new String[0]));
        groupBy.remove("period");
        if (!this.qParam.isNoZeroAmount()) {
            mainSet = this.fillPeriodSet(mainSet, groupBy);
        }
        ArrayList<String> selList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String group : groupBy) {
            sb.append("PreRowValue(").append(group).append(") = ").append(group).append(" and ");
        }
        String check = sb.toString();
        String yearCheck = check + "PreRowValue(period) / " + GLUtil.YEAR_PERIOD_L + " = period / " + GLUtil.YEAR_PERIOD_L;
        check = check.substring(0, check.length() - 5);
        for (Field field : fields = mainSet.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (name.startsWith("begin")) {
                selList.add("case when " + check + " then PreRowValue(" + name.replace("begin", "end") + ") else " + name + " end as " + name);
                continue;
            }
            if (name.startsWith("end")) {
                selList.add("case when " + check + " then PreRowValue() + " + name.replace("end", "debit") + " - " + name.replace("end", "credit") + " else " + name + " end as " + name);
                continue;
            }
            if (name.startsWith("year")) {
                selList.add("case when " + yearCheck + " then PreRowValue() + " + name.replace("year", "") + " else " + name + " end as " + name);
                continue;
            }
            selList.add(name);
        }
        return mainSet.select(selList.toArray(new String[0])).orderBy(new String[]{"number"});
    }

    private DataSet fillPeriodSet(DataSet balanceSet, List<String> fieldList) {
        List<String> groupList = this.getGroupBy();
        QFilter type = new QFilter("periodtype", "=", (Object)this.qParam.getPeriodType());
        QFilter start = new QFilter("id", "<=", (Object)this.qParam.getEndPeriod());
        QFilter end = new QFilter("id", ">=", (Object)this.qParam.getStartPeriod());
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id period", (QFilter[])new QFilter[]{type, start, end}, null);
        Field[] fields = balanceSet.getRowMeta().getFields();
        DataSet groupBalanceSet = balanceSet.copy();
        groupBalanceSet = groupBalanceSet.groupBy(groupList.toArray(new String[0])).finish();
        DataSet allPeriodBalanceSet = periodSet.join(groupBalanceSet, JoinType.CROSS).select(new String[]{"period"}, groupList.toArray(new String[0])).finish();
        allPeriodBalanceSet = ReportUtils.gainSumSetHelper((DataSet)allPeriodBalanceSet, (Field[])fields);
        allPeriodBalanceSet = allPeriodBalanceSet.union(balanceSet);
        groupList.add("period");
        GroupbyDataSet grpDataSet = allPeriodBalanceSet.groupBy(groupList.toArray(new String[0]));
        for (String sum : this.getSumValue().split(",")) {
            grpDataSet.sum(sum);
        }
        allPeriodBalanceSet = grpDataSet.finish();
        return allPeriodBalanceSet.orderBy(groupList.toArray(new String[0]));
    }

    private DataSet gainExcludeZeroBalance(DataSet dSet) {
        ArrayList<String> list = new ArrayList<String>();
        DataSet ds = dSet.copy();
        String filter1 = "description != '" + this.BEGIN_BALANCE + "'";
        String filter2 = "debitfor != 0.0 or debitlocal != 0.0 or creditfor != 0.0 or creditlocal != 0.0";
        ds = ds.filter(filter1).filter(filter2);
        for (Row row : ds) {
            list.add("'" + row.getString("number") + "'");
        }
        if (list.isEmpty()) {
            list.add("''");
        }
        String filter3 = "number in " + list;
        filter3 = filter3.replace('[', '(').replace(']', ')');
        dSet = dSet.filter(filter3);
        return dSet;
    }

    private DataSet gainExcludeZeroAmount(DataSet dSet) {
        ArrayList<String> list = new ArrayList<String>();
        DataSet ds = dSet.copy();
        String filter1 = "description = '" + GeneralLedgerQueryRpt.getPeriodAmount() + "'";
        String filter2 = "debitfor != 0.0 or debitlocal != 0.0 or creditfor != 0.0 or creditlocal != 0.0";
        ds = ds.filter(filter1).filter(filter2);
        for (Row row : ds) {
            list.add("'" + row.getString("number") + "'");
        }
        if (list.isEmpty()) {
            list.add("''");
        }
        String filter3 = "number in " + list;
        filter3 = filter3.replace('[', '(').replace(']', ')');
        dSet = dSet.filter(filter3);
        return dSet;
    }

    private DataSet gainCleanedSet(DataSet dSet) {
        Object[] sel2 = new String[]{"account", "case when PreRowValue(account) = account then '' else number end as number", "case when PreRowValue(account) = account then '' else name end as name", "dc", "period", "description", "currencyid", "currencyname", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else debitfor end as debitfor", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else debitlocal end as debitlocal", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else debitqty end as debitqty", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else creditfor end as creditfor", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else creditlocal end as creditlocal", "case when description = '" + this.BEGIN_BALANCE + "' then 0.0 else creditqty end as creditqty", "endfor", "endlocal", "endqty", "direction", "orderstr"};
        if (this.qParam.isShowQty()) {
            sel2 = (String[])ArrayUtils.addAll((Object[])sel2, (Object[])new String[]{"measureunit", "measureunitname"});
        }
        return dSet.select((String[])sel2);
    }

    private DataSet addDescription(DataSet ds, String flag) {
        String[] sel1 = (String[])ArrayUtils.addAll((Object[])this.getSel("account"), (Object[])this.getSel("periodbalance"));
        ArrayList<String> selList = new ArrayList<String>(Arrays.asList(sel1));
        switch (flag) {
            case "periodbalance": {
                selList.add("'" + GeneralLedgerQueryRpt.getPeriodAmount() + "' description");
                selList.add(String.format(ResManager.loadKDString((String)"%s\u5e73", (String)"GeneralLedgerQueryRpt_4", (String)"fi-gl-report", (Object[])new Object[0]), "case when endlocal = 0.0 or endlocal = null then '") + String.format(ResManager.loadKDString((String)"%1$s\u501f%2$s", (String)"GeneralLedgerQueryRpt_5", (String)"fi-gl-report", (Object[])new Object[0]), "' when dc = '1' then '", "' else '") + String.format(ResManager.loadKDString((String)"\u8d37%s", (String)"GeneralLedgerQueryRpt_6", (String)"fi-gl-report", (Object[])new Object[0]), "' end as direction"));
                selList.add("'2' orderStr");
                break;
            }
            case "yearbalance": {
                selList.add("'" + GeneralLedgerQueryRpt.getYearAmount() + "' description");
                selList.add(String.format(ResManager.loadKDString((String)"%s\u5e73", (String)"GeneralLedgerQueryRpt_4", (String)"fi-gl-report", (Object[])new Object[0]), "case when endlocal = 0.0 or endlocal = null then '") + String.format(ResManager.loadKDString((String)"%1$s\u501f%2$s", (String)"GeneralLedgerQueryRpt_5", (String)"fi-gl-report", (Object[])new Object[0]), "' when dc = '1' then '", "' else '") + String.format(ResManager.loadKDString((String)"\u8d37%s", (String)"GeneralLedgerQueryRpt_6", (String)"fi-gl-report", (Object[])new Object[0]), "' end as direction"));
                selList.add("'3' orderStr");
                break;
            }
            case "beginbalance": {
                selList.add("'" + this.BEGIN_BALANCE + "' description");
                selList.add(String.format(ResManager.loadKDString((String)"%s\u5e73", (String)"GeneralLedgerQueryRpt_4", (String)"fi-gl-report", (Object[])new Object[0]), "case when endlocal = 0.0 or endlocal = null then '") + String.format(ResManager.loadKDString((String)"%1$s\u501f%2$s", (String)"GeneralLedgerQueryRpt_5", (String)"fi-gl-report", (Object[])new Object[0]), "' when dc = '1' then '", "' else '") + String.format(ResManager.loadKDString((String)"\u8d37%s", (String)"GeneralLedgerQueryRpt_6", (String)"fi-gl-report", (Object[])new Object[0]), "' end as direction"));
                selList.add("'1' orderStr");
            }
        }
        selList.remove("endfor");
        selList.remove("endlocal");
        selList.remove("endqty");
        selList.add("case when dc = '1' then endfor else -1.0*endfor end as endfor");
        selList.add("case when dc = '1' then endlocal else -1.0*endlocal end as endlocal");
        selList.add("case when dc = '1' then endqty else -1.0*endqty end as endqty");
        if (this.qParam.isShowQty()) {
            selList.add("measureunit");
            selList.add("measureunitname");
        }
        return ds.select(selList.toArray(new String[0]));
    }

    private DataSet getLedgerSet(DataSet ds, String flag) {
        Object[] sel1 = (String[])ArrayUtils.addAll((Object[])this.getSel("account"), (Object[])this.getSel(flag));
        if (this.qParam.isShowQty()) {
            sel1 = (String[])ArrayUtils.addAll((Object[])sel1, (Object[])new String[]{"measureunit", "measureunitname"});
        }
        ds = ds.select((String[])sel1);
        return this.addDescription(ds, flag);
    }

    private Date getEndDate() {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.qParam.getEndPeriod(), (String)"bd_period");
        return period.getDate("enddate");
    }

    private DataSet queryBalanceMainSet() {
        String selectFields = this.getBalanceSelector();
        selectFields = selectFields + ",period";
        QueryParam param = this.getGLQueryParam();
        param.setZeroAmtNoDisplay(this.qParam.isNoZeroAmount());
        DataSet amountBegin = this.getBalance(selectFields, param, this.qParam.getEndPeriod());
        if (this.qParam.isSynCurrency()) {
            amountBegin = amountBegin.addField("0L", "currencyid").addField("null", "currencyname");
        }
        return amountBegin;
    }

    private DataSet queryBalanceBeginSet(DataSet mainSet) {
        String selectFields = this.getBalanceSelector();
        QueryParam param = this.getGLQueryParam();
        param.setZeroAmtNoDisplay(false);
        param.setAccountVersionPeriodId(this.qParam.getEndPeriod());
        DataSet amountBegin = this.getBalance(selectFields, param, this.qParam.getStartPeriod());
        amountBegin = amountBegin.addField("" + this.qParam.getStartPeriod() + "L", "period");
        if (this.qParam.isSynCurrency()) {
            amountBegin = amountBegin.addField("0L", "currencyid").addField("null", "currencyname");
        }
        GroupbyDataSet grpDataSet = mainSet.groupBy(this.getGroupBy().toArray(new String[0])).min("period");
        for (String sum : this.getSumValue().split(",")) {
            grpDataSet.sum(sum);
        }
        mainSet = grpDataSet.finish();
        mainSet = mainSet.filter("period != " + this.qParam.getStartPeriod());
        mainSet = this.clearData(mainSet);
        ArrayList<String> sel = new ArrayList<String>(20);
        for (Field field : amountBegin.getRowMeta().getFields()) {
            sel.add(field.getName());
        }
        mainSet = mainSet.select(sel.toArray(new String[0])).union(amountBegin);
        List<String> groupBy = this.getGroupBy();
        groupBy.add("period");
        GroupbyDataSet grpDataSet1 = mainSet.groupBy(groupBy.toArray(new String[0]));
        for (String sum : this.getSumValue().split(",")) {
            grpDataSet1.sum(sum);
        }
        mainSet = grpDataSet1.finish();
        return mainSet.select(sel.toArray(new String[0]));
    }

    private DataSet getBalance(String selectFields, QueryParam param, long endPeriodId) {
        Long orgId = (Long)this.qParam.getOrgs().get(0);
        DataSet balanceDataSet = BalanceQueryExecutor.getInstance().getBalance(selectFields, new Long[]{orgId}, this.qParam.getBookType(), this.qParam.getAccountTable(), this.qParam.getStartPeriod(), endPeriodId, param);
        FilterInfo filterInfo = this.qParam.getFilterInfo();
        balanceDataSet = ReportHelper.filterLevel(balanceDataSet, filterInfo, (Tuple<String, String>)Tuple.create((Object)"account", (Object)"id"), orgId);
        return balanceDataSet;
    }

    private String getSumValue() {
        return "beginfor,beginlocal,beginqty,debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty,endfor,endlocal,endqty,yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty";
    }

    private DataSet clearData(DataSet mainSet) {
        Field[] fields;
        ArrayList<String> sel = new ArrayList<String>();
        for (Field field : fields = mainSet.getRowMeta().getFields()) {
            String name = field.getName();
            if (name.startsWith("begin") || name.startsWith("end") || name.startsWith("debit") || name.startsWith("credit") || name.startsWith("year")) {
                sel.add("0L " + name);
                continue;
            }
            if (name.equals("period")) {
                sel.add(this.qParam.getStartPeriod() + " period");
                continue;
            }
            sel.add(name);
        }
        return mainSet.select(sel.toArray(new String[0]));
    }

    private List<String> getGroupBy() {
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("account");
        groupBy.add("name");
        groupBy.add("number");
        groupBy.add("dc");
        groupBy.add("level");
        groupBy.add("currencyid");
        groupBy.add("currencyname");
        if (this.qParam.isShowQty()) {
            groupBy.add("measureunit");
            groupBy.add("measureunitname");
        }
        return groupBy;
    }

    private String getBalanceSelector() {
        String accountNameField = this.qParam.isShowAccountFullName() ? "fullname" : "name";
        String selectFields = String.format("account,account.%s name,account.number number,account.dc dc,account.level level,beginfor,beginlocal,beginqty,debitfor,debitlocal,debitqty,creditfor,creditlocal,creditqty,endfor,endlocal,endqty,yeardebitfor,yeardebitlocal,yeardebitqty,yearcreditfor,yearcreditlocal,yearcreditqty", accountNameField);
        if (!this.qParam.isSynCurrency()) {
            selectFields = selectFields + ",currency currencyid,currency.name currencyname";
        }
        if (this.qParam.isShowQty()) {
            selectFields = selectFields + ",measureunit,measureunit.name measureunitname";
        }
        return selectFields;
    }

    private QueryParam getGLQueryParam() {
        QueryParam param = new QueryParam();
        if (!this.qParam.isSynCurrency() && !this.qParam.isAllCurrency()) {
            param.setCurrencyIds(new Long[]{this.qParam.getCurrency()});
        }
        if (this.qParam.getAccountList() != null) {
            param.setAccountFilter(new QFilter("id", "in", (Object)this.qParam.getAccountList()));
        }
        param.setOnlyLeafAcctBal(this.qParam.isShowLeafAccount());
        param.setSubstractPL(this.qParam.isSubstractPL());
        return param;
    }

    private String[] getSel(String flag) {
        switch (flag) {
            case "account": {
                return accSel;
            }
            case "periodbalance": {
                return periodBalSel;
            }
            case "yearbalance": {
                return yearBalSel;
            }
            case "beginbalance": {
                return beginBalSel;
            }
        }
        return null;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        GeneralLedgerHelperRpt.addColumns(columns, this.qParam);
        return columns;
    }
}

