/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.common.MulColAccountInfo;
import kd.fi.gl.report.JoinAssgrpResult;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.RptAssgrpFilter;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.util.GLUtil;

public class MultColAccountRptPlugin
extends AbstractReportListDataPlugin {
    private static final Log LOG = LogFactory.getLog(MultColAccountRptPlugin.class);
    private static final String ORI = "ori";
    private static final String ENTRYENTITY = "entryentity";
    private static final String VALUE = "value";
    private static final String FIELDNAME = "fieldname";
    private static final int _2 = 2;
    private static final String ASSISTHG = "assisthg";
    private static final String CREDIT = "credit";
    private static final String DEBIT = "debit";
    private static final String AMOUNTBAL = "amountbal";
    private static final String EDESCRIPTION = "edescription";
    private static final String CURRENCYID = "currencyid";
    private static final String ASSGRP = "assgrp";
    private static final String YEARCREDIT = "yearcredit";
    private static final String YEARDEBIT = "yeardebit";
    private static final String BOOKEDDATE = "bookeddate";
    private static final String BILLNO = "billno";
    private static final String DATATYPE = "datatype";
    private static final String ASSVAL = "assval";
    private static final String ACCOUNT = "account";
    private static final String PERIOD = "period";
    private static final String FOR = "for";
    private static final String LOCAL = "local";
    private static final String CREDITTOTAL = "credittotal";
    private static final String DEBITTOTAL = "debittotal";
    private DynamicObject scheme;
    private Map<String, String> debitColKeyAndNameMap;
    private Map<String, String> creditColKeyAndNameMap;
    private List<String> multColKeys;
    private Map<Long, Long> detailIdAndColIdMap;
    private static final String COLKEY_DEBITFIELD = "fd_";
    private static final String COLKEY_CREDITFIELD = "fc_";
    private Map<Long, String> debitIdAndColKeyMap;
    private Map<Long, String> creditIdAndColKeyMap;
    private boolean isMultColAccount;
    private Set<Long> accountIds;
    private MulOrgQPRpt qParam;
    private List<MulColAccountInfo> debitTreeAccountInfos;
    private List<MulColAccountInfo> creditTreeAccountInfos;
    private Map<String, Tuple2<String, Set<Object>>> assistMap = new LinkedHashMap<String, Tuple2<String, Set<Object>>>();
    private DataSet assgrpSet;
    private static final String ASSIST_DB = "gl_assist_bd";
    private static final String ASSIST_TXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String TYPE_TXT = "type_txt";
    private static final String TYPE_BASE_STRING = "type_base_str";
    private static final String TYPE_BASE_LONG = "type_base_long";
    private static final String BASECURRENCY_ID = "0";
    private static final String SUBTOTALENDSWITH = "_subtotal";
    private static final String DEBIT_GROUP = "debitgroup";
    private static final String CREDIT_GROUP = "creditgroup";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (this.isMultColAccount) {
            this.addAccountColumns(columns);
        } else {
            this.addAssgrpColumns(columns);
        }
        return columns;
    }

    private void addAccountColumns(List<AbstractReportColumn> columns) {
        ReportColumn amtCol;
        ReportColumnGroup group;
        if (this.debitColKeyAndNameMap.size() > 0) {
            group = new ReportColumnGroup();
            group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9", (String)"MultColAccountRptPlugin_0", (String)"fi-gl-report", (Object[])new Object[0])));
            group.setFieldKey(DEBIT_GROUP);
            columns.add((AbstractReportColumn)group);
            amtCol = this.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MultColAccountRptPlugin_1", (String)"fi-gl-report", (Object[])new Object[0])), DEBITTOTAL, "amount", Boolean.FALSE);
            group.getChildren().add(amtCol);
            for (MulColAccountInfo accountInfo : this.debitTreeAccountInfos) {
                this.createColumnGroupRecurrence(group, accountInfo);
            }
        }
        if (this.creditColKeyAndNameMap.size() > 0) {
            group = new ReportColumnGroup();
            group.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9", (String)"MultColAccountRptPlugin_2", (String)"fi-gl-report", (Object[])new Object[0])));
            group.setFieldKey(CREDIT_GROUP);
            columns.add((AbstractReportColumn)group);
            amtCol = this.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MultColAccountRptPlugin_1", (String)"fi-gl-report", (Object[])new Object[0])), CREDITTOTAL, "amount", Boolean.FALSE);
            group.getChildren().add(amtCol);
            for (MulColAccountInfo accountInfo : this.creditTreeAccountInfos) {
                this.createColumnGroupRecurrence(group, accountInfo);
            }
        }
    }

    private void addAssgrpColumns(List<AbstractReportColumn> columns) {
        if (this.debitColKeyAndNameMap.size() > 0) {
            ReportColumnGroup debitGroup = this.createColumnGroup(this.debitColKeyAndNameMap, new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9", (String)"MultColAccountRptPlugin_0", (String)"fi-gl-report", (Object[])new Object[0])), DEBITTOTAL);
            debitGroup.setFieldKey(DEBIT_GROUP);
            columns.add((AbstractReportColumn)debitGroup);
        }
        if (this.creditColKeyAndNameMap.size() > 0) {
            ReportColumnGroup creditGroup = this.createColumnGroup(this.creditColKeyAndNameMap, new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9", (String)"MultColAccountRptPlugin_2", (String)"fi-gl-report", (Object[])new Object[0])), CREDITTOTAL);
            creditGroup.setFieldKey(CREDIT_GROUP);
            columns.add((AbstractReportColumn)creditGroup);
        }
    }

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        try {
            this.init(param);
            DataSet beginBalSet = this.queryBeginBalanceSet();
            DataSet ytdSet = this.queryYtdBalanceSet();
            DataSet vchSet = this.queryVoucher(param);
            JoinAssgrpResult tplSet = this.joinAssgrpDataSet(vchSet, beginBalSet, ytdSet);
            DataSet resultSet = this.getResult(tplSet);
            this.dealWithZeroAmountColumns(resultSet);
            DataSet dataSet = this.buildAccountColSubTotal(resultSet);
            return ReportDsExtProcessHelper.doExtProcess(param, dataSet, "gl_rpt_multcolumnaccount");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private DataSet buildAccountColSubTotal(DataSet dSet) {
        Tuple expression;
        int i;
        if (!this.isMultColAccount) {
            return dSet;
        }
        ArrayList<Tuple<String, String>> debitSubTotalList = new ArrayList<Tuple<String, String>>();
        ArrayList<Tuple<String, String>> creditSubTotalList = new ArrayList<Tuple<String, String>>();
        for (MulColAccountInfo info : this.debitTreeAccountInfos) {
            this.buildAccountSubTotalExpRecurrence(info, debitSubTotalList, creditSubTotalList);
        }
        for (MulColAccountInfo info : this.creditTreeAccountInfos) {
            this.buildAccountSubTotalExpRecurrence(info, debitSubTotalList, creditSubTotalList);
        }
        for (i = debitSubTotalList.size() - 1; i >= 0; --i) {
            expression = (Tuple)debitSubTotalList.get(i);
            dSet = dSet.addField((String)expression.item2, (String)expression.item1);
        }
        for (i = creditSubTotalList.size() - 1; i >= 0; --i) {
            expression = (Tuple)creditSubTotalList.get(i);
            dSet = dSet.addField((String)expression.item2, (String)expression.item1);
        }
        return dSet;
    }

    private void buildAccountSubTotalExpRecurrence(MulColAccountInfo accountInfo, List<Tuple<String, String>> debitSubTotalList, List<Tuple<String, String>> creditSubTotalList) {
        if (!accountInfo.hasChild().booleanValue()) {
            return;
        }
        ArrayList<String> colKeys = new ArrayList<String>();
        List childInfos = accountInfo.getChildAccounts();
        for (MulColAccountInfo childInfo : childInfos) {
            if (childInfo.hasChild().booleanValue()) {
                colKeys.add(childInfo.getColKey() + SUBTOTALENDSWITH);
                continue;
            }
            colKeys.add(childInfo.getColKey());
        }
        if ("1".equals(accountInfo.getDC())) {
            debitSubTotalList.add((Tuple<String, String>)new Tuple((Object)(accountInfo.getColKey() + SUBTOTALENDSWITH), (Object)String.join((CharSequence)"+", colKeys)));
        } else {
            creditSubTotalList.add((Tuple<String, String>)new Tuple((Object)(accountInfo.getColKey() + SUBTOTALENDSWITH), (Object)String.join((CharSequence)"+", colKeys)));
        }
        for (MulColAccountInfo childInfo : childInfos) {
            this.buildAccountSubTotalExpRecurrence(childInfo, debitSubTotalList, creditSubTotalList);
        }
    }

    private void dealWithZeroAmountColumns(DataSet dSet) {
        if (!this.qParam.isNoZeroAmount()) {
            return;
        }
        ArrayList<String> zeroAmountCols = new ArrayList<String>();
        zeroAmountCols.addAll(this.multColKeys);
        try (DataSet tmpSet = dSet.copy().filter("datatype=1");){
            while (tmpSet.hasNext()) {
                Row row = tmpSet.next();
                if (zeroAmountCols.isEmpty()) break;
                this.removeNoZeroColumns(zeroAmountCols, row);
            }
            for (String zeroAmountCol : zeroAmountCols) {
                this.debitColKeyAndNameMap.remove(zeroAmountCol);
                this.creditColKeyAndNameMap.remove(zeroAmountCol);
            }
        }
    }

    private void removeNoZeroColumns(List<String> zeroAmountCols, Row row) {
        Iterator<String> iterator = zeroAmountCols.iterator();
        while (iterator.hasNext()) {
            String colKey = iterator.next();
            if (row.getBigDecimal(colKey).compareTo(BigDecimal.ZERO) == 0) continue;
            iterator.remove();
        }
    }

    private DataSet queryYtdBalanceSet() {
        return this.queryBalDataSet(this.qParam.getStartPeriod(), this.qParam.getStartPeriod());
    }

    private DataSet queryBeginBalanceSet() {
        return this.queryBalDataSet(this.qParam.getStartPeriod(), this.qParam.getEndPeriod());
    }

    private DataSet queryBalDataSet(Long startPeriod, Long endPeriod) {
        String currencyId = this.scheme.getString("currency");
        String endsWith = BASECURRENCY_ID.equals(currencyId) ? LOCAL : FOR;
        String amountField = String.format("begin%s begin,yeardebit%s yeardebit,yearcredit%s yearcredit", endsWith, endsWith, endsWith);
        String selectFields = "account, account.dc dc,assgrp,currency currencyid," + amountField;
        QueryParam param = new QueryParam();
        if (!BASECURRENCY_ID.equals(currencyId)) {
            param.setCurrencyIds(new Long[]{Long.valueOf(currencyId)});
        }
        param.setAccountFilter(new QFilter("id", "in", this.accountIds));
        param.setOnlyLeafAcctBal(this.qParam.isShowLeafAccount());
        param.setZeroAmtNoDisplay(this.qParam.isNoZeroAmount());
        param.setZeroBalNoDisplay(this.qParam.isNoZeroBalance());
        param.setSubstractPL(this.qParam.isSubstractPL());
        param.setOnlyLeafAcctBal(true);
        DataSet ds = BalanceQueryExecutor.getInstance().getBalance(selectFields, this.qParam.getFilteredChildOrg().toArray(new Long[0]), this.qParam.getBookType(), this.qParam.getAccountTable(), startPeriod.longValue(), endPeriod.longValue(), param);
        ds = ds.addField("" + startPeriod + "L", PERIOD);
        List list = GLUtil.getDataSetCols((DataSet)ds);
        list.remove("begin");
        list.add("case when begin>0 then begin else 0.0 end as begindebit");
        list.add("case when begin<0 then -1.0*begin else 0.0 end as begincredit");
        return ds.select(list.toArray(new String[0]));
    }

    private DataSet buildMultColResult(DataSet dataSet, String debitField, String creditField, List<String> groupFields, List<String> sumFields, List<String> selectRstFields) {
        ArrayList<Object[]> ids = new ArrayList<Object[]>(this.detailIdAndColIdMap.size());
        for (Map.Entry<Long, Long> entry : this.detailIdAndColIdMap.entrySet()) {
            ids.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        RowMeta meta = new RowMeta(new String[]{"id", "pid"}, new DataType[]{DataType.LongType, DataType.LongType});
        DataSet parentIdSet = this.buildDataSet(ids, meta);
        String joinFieldName = this.isMultColAccount ? ACCOUNT : ASSVAL;
        List selectFields = GLUtil.getDataSetCols((DataSet)dataSet);
        selectFields.add("pid");
        dataSet = dataSet.join(parentIdSet, JoinType.INNER).on(joinFieldName, "id").select(selectFields.toArray(new String[0])).finish();
        dataSet = this.addMultColumn(dataSet, debitField, creditField);
        DataSet dsTmpRst = MulOrgQPRpt.gainSumSet((DataSet)dataSet, (String[])groupFields.toArray(new String[0]), (String[])sumFields.toArray(new String[0]));
        return dsTmpRst.select(selectRstFields.toArray(new String[0]));
    }

    private DataSet getResult(JoinAssgrpResult tplSet) {
        DataSet vchSet = tplSet.getVchSet();
        DataSet beginBalSet = tplSet.getBeginBalSet();
        DataSet ytdSet = tplSet.getYtdSet();
        vchSet = this.buildVchMultColResult(vchSet);
        beginBalSet = this.buildBeginBalMultColResult(beginBalSet);
        List periods = GLUtil.getPeriodIds((Long)this.qParam.getStartPeriod(), (Long)this.qParam.getEndPeriod());
        DataSet curPeriodSet = this.buildCurPeriodMultColResult(periods, vchSet.copy());
        ytdSet = this.buildYtdMultColResult(periods, ytdSet, curPeriodSet.copy());
        List colFields = GLUtil.getDataSetCols((DataSet)vchSet);
        String[] selectFields = colFields.toArray(new String[0]);
        DataSet result = beginBalSet.select(selectFields).union(vchSet).union(curPeriodSet.select(selectFields));
        if (Objects.nonNull(ytdSet)) {
            result = result.union(ytdSet.select(selectFields));
        }
        result = result.orderBy(new String[]{PERIOD, DATATYPE, BILLNO, BOOKEDDATE});
        return result;
    }

    private DataSet buildCurPeriodMultColResult(List<Long> periods, DataSet vchSet) {
        HashMap<Long, Object[]> map = new HashMap<Long, Object[]>();
        Field[] fields = vchSet.getRowMeta().getFields();
        try (DataSet dsVch = vchSet.filter("datatype=1");){
            for (Row row : dsVch) {
                this.sumPeriodAmount(map, fields, row);
            }
        }
        String currencyId = this.scheme.getString("currency");
        Long curId = BASECURRENCY_ID.equals(currencyId) ? this.qParam.getCurLocal() : Long.parseLong(currencyId);
        for (Long period : periods) {
            Object[] entryObject = (Object[])map.get(period);
            if (entryObject != null) continue;
            this.createNoPeriodAmountRow(map, fields, curId, period);
        }
        DataSet curPeriodSet = this.buildDataSet(map.values(), vchSet.getRowMeta());
        List selectFields = GLUtil.getDataSetCols((DataSet)curPeriodSet);
        selectFields.remove(EDESCRIPTION);
        selectFields.remove(DATATYPE);
        selectFields.remove(BILLNO);
        selectFields.add("2 datatype");
        selectFields.add(String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u5408\u8ba1%2$s", (String)"MultColAccountRptPlugin_3", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' edescription"));
        DataSet result = curPeriodSet.select(selectFields.toArray(new String[0]));
        return result.addNullField(new String[]{BOOKEDDATE, "dc", AMOUNTBAL, BILLNO});
    }

    private void createNoPeriodAmountRow(Map<Long, Object[]> map, Field[] fields, Long curId, Long period) {
        Object[] entryObject = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAlias().equals(PERIOD)) {
                entryObject[i] = period;
                continue;
            }
            if (!fields[i].getAlias().equals(CURRENCYID)) continue;
            entryObject[i] = curId;
        }
        map.put(period, entryObject);
    }

    private void sumPeriodAmount(Map<Long, Object[]> map, Field[] fields, Row row) {
        Long period = row.getLong(PERIOD);
        Object[] entryObject = map.get(period);
        if (entryObject == null) {
            entryObject = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                entryObject[i] = row.get(fields[i].getAlias());
            }
            map.put(period, entryObject);
        } else {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getDataType().equals((Object)DataType.BigDecimalType)) continue;
                BigDecimal amount = new BigDecimal(entryObject[i].toString());
                entryObject[i] = amount.add(row.getBigDecimal(fields[i].getAlias()));
            }
        }
    }

    private DataSet buildYtdMultColResult(List<Long> periods, DataSet ytdSet, DataSet curPeriodSet) {
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        String debitField = YEARDEBIT;
        String creditField = YEARCREDIT;
        sumFields.add(debitField);
        sumFields.add(creditField);
        sumFields.addAll(this.multColKeys);
        groupFields.add(PERIOD);
        groupFields.add(CURRENCYID);
        selectFields.clear();
        selectFields.addAll(this.multColKeys);
        selectFields.addAll(groupFields);
        selectFields.add(String.format("'%s' edescription", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"MultColAccountRptPlugin_4", (String)"fi-gl-report", (Object[])new Object[0])));
        selectFields.add(debitField + " debit");
        selectFields.add(creditField + " credit");
        selectFields.add(debitField + " debittotal");
        selectFields.add(creditField + " credittotal");
        ytdSet = this.buildMultColResult(ytdSet, debitField, creditField, groupFields, sumFields, selectFields);
        ArrayList<String> resultFields = new ArrayList<String>(this.multColKeys.size());
        for (String key : this.multColKeys) {
            resultFields.add(key);
        }
        resultFields.add(String.format("'%s' edescription", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"MultColAccountRptPlugin_4", (String)"fi-gl-report", (Object[])new Object[0])));
        resultFields.add(CURRENCYID);
        resultFields.add(DEBIT);
        resultFields.add(CREDIT);
        resultFields.add(DEBITTOTAL);
        resultFields.add(CREDITTOTAL);
        String[] arrResult = resultFields.toArray(new String[0]);
        sumFields.clear();
        sumFields.add(DEBIT);
        sumFields.add(CREDIT);
        sumFields.add(DEBITTOTAL);
        sumFields.add(CREDITTOTAL);
        sumFields.addAll(this.multColKeys);
        groupFields.remove(PERIOD);
        Long startPeriodId = this.qParam.getStartPeriod();
        DataSet tmpYtdSet = this.getStartPeriodYtdSet(ytdSet, startPeriodId);
        DataSet resultSet = null;
        String[] ytdFields = GLUtil.getDataSetCols((DataSet)ytdSet).toArray(new String[0]);
        Long curYear = periods.isEmpty() ? 0L : GLUtil.getYear((long)periods.get(0));
        for (Long period : periods) {
            if (period.equals(startPeriodId)) {
                resultSet = tmpYtdSet;
                continue;
            }
            Long periodYear = GLUtil.getYear((long)period);
            if (!periodYear.equals(curYear)) {
                tmpYtdSet = tmpYtdSet.filter("period=-1");
                curYear = periodYear;
            }
            DataSet tmpCurPSet = curPeriodSet.filter("period=" + period).select(ytdFields);
            tmpYtdSet = tmpYtdSet.select(ytdFields).union(tmpCurPSet);
            tmpYtdSet = MulOrgQPRpt.gainSumSet((DataSet)tmpYtdSet, (String[])groupFields.toArray(new String[0]), (String[])sumFields.toArray(new String[0]));
            tmpYtdSet = tmpYtdSet.select(arrResult).addField(period + "L", PERIOD);
            resultSet = this.addCurPeriodAmountToYtd(tmpYtdSet, resultSet);
        }
        if (resultSet != null) {
            resultSet = resultSet.addField("3", DATATYPE).addNullField(new String[]{"voucherid", BOOKEDDATE, BILLNO, "dc", AMOUNTBAL});
        }
        return resultSet;
    }

    public DataSet getStartPeriodYtdSet(DataSet ytdSet, Long startPeriodId) {
        DataSet tmpYtdSet = ytdSet.filter("period=" + startPeriodId);
        DataSet tmpSet = tmpYtdSet.copy();
        if (tmpSet.count(PERIOD, true) <= 0) {
            Field[] fields = tmpSet.getRowMeta().getFields();
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            Object[] dataObject = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i].getAlias();
                if (PERIOD.equals(field)) {
                    dataObject[i] = startPeriodId;
                    continue;
                }
                if (EDESCRIPTION.equals(field)) {
                    dataObject[i] = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"MultColAccountRptPlugin_4", (String)"fi-gl-report", (Object[])new Object[0]);
                    continue;
                }
                if ("dc".equals(field)) {
                    dataObject[i] = BASECURRENCY_ID;
                    continue;
                }
                if (!CURRENCYID.equals(field)) continue;
                String currencyId = this.scheme.getString("currency");
                dataObject[i] = BASECURRENCY_ID.equals(currencyId) ? this.qParam.getCurLocal() : Long.parseLong(currencyId);
            }
            datas.add(dataObject);
            tmpYtdSet = this.buildDataSet(datas, tmpSet.getRowMeta());
        }
        return tmpYtdSet;
    }

    public DataSet addCurPeriodAmountToYtd(DataSet tmpYtdSet, DataSet resultSet) {
        if (resultSet == null) {
            resultSet = tmpYtdSet;
        } else {
            List rstSetFields = GLUtil.getDataSetCols((DataSet)resultSet);
            resultSet = resultSet.union(tmpYtdSet.select(rstSetFields.toArray(new String[0])));
        }
        return resultSet;
    }

    private DataSet buildVchMultColResult(DataSet vchSet) {
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        String debitField = DEBIT;
        String creditField = CREDIT;
        sumFields.add(debitField);
        sumFields.add(creditField);
        sumFields.addAll(this.multColKeys);
        groupFields.add("voucherid");
        groupFields.add(PERIOD);
        groupFields.add(BOOKEDDATE);
        groupFields.add(BILLNO);
        groupFields.add(EDESCRIPTION);
        groupFields.add(CURRENCYID);
        selectFields.addAll(groupFields);
        selectFields.add("1 datatype");
        selectFields.addAll(this.multColKeys);
        selectFields.add(String.format("%s debit", debitField));
        selectFields.add(String.format("%s debittotal", debitField));
        selectFields.add(String.format("%s credit", creditField));
        selectFields.add(String.format("%s credittotal", creditField));
        vchSet = this.buildMultColResult(vchSet, debitField, creditField, groupFields, sumFields, selectFields);
        DataSet resultSet = vchSet.addNullField(new String[]{"dc", AMOUNTBAL});
        if (!this.multColKeys.isEmpty()) {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < this.multColKeys.size() - 1; ++i) {
                sb.append(String.format("%s<>0 or ", this.multColKeys.get(i)));
            }
            sb.append(String.format("%s<>0", this.multColKeys.get(i)));
            resultSet = resultSet.filter(sb.toString());
        }
        return resultSet;
    }

    private DataSet buildBeginBalMultColResult(DataSet beginBalSet) {
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        String debitField = "begindebit";
        String creditField = "begincredit";
        sumFields.add(debitField);
        sumFields.add(creditField);
        sumFields.addAll(this.multColKeys);
        groupFields.add(PERIOD);
        groupFields.add(CURRENCYID);
        selectFields.clear();
        selectFields.addAll(groupFields);
        selectFields.add("0 datatype");
        selectFields.add(String.format("'%s' edescription", ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"MultColAccountRptPlugin_5", (String)"fi-gl-report", (Object[])new Object[0])));
        selectFields.add("0 debit");
        selectFields.add("0 credit");
        selectFields.add(debitField + " debittotal");
        selectFields.add(creditField + " credittotal");
        selectFields.add("case when begindebit-begincredit >0 then 1 when  begindebit-begincredit <0 then -1 else 0 end dc");
        selectFields.add("case when begindebit-begincredit >0 then begindebit-begincredit else begincredit-begindebit end amountbal");
        selectFields.addAll(this.multColKeys);
        beginBalSet = this.buildMultColResult(beginBalSet, debitField, creditField, groupFields, sumFields, selectFields);
        beginBalSet = beginBalSet.addNullField(new String[]{"voucherid", BOOKEDDATE, BILLNO});
        DataSet tmpSet = beginBalSet.copy();
        if (tmpSet.count(DATATYPE, true) <= 0) {
            Field[] fields = tmpSet.getRowMeta().getFields();
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            Object[] dataObject = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i].getAlias();
                if (PERIOD.equals(field)) {
                    dataObject[i] = this.qParam.getStartPeriod();
                    continue;
                }
                if (EDESCRIPTION.equals(field)) {
                    dataObject[i] = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"MultColAccountRptPlugin_5", (String)"fi-gl-report", (Object[])new Object[0]);
                    continue;
                }
                if (!"dc".equals(field)) continue;
                dataObject[i] = BASECURRENCY_ID;
            }
            datas.add(dataObject);
            beginBalSet = this.buildDataSet(datas, tmpSet.getRowMeta());
        }
        return beginBalSet;
    }

    private DataSet addMultColumn(DataSet dSet, String debitField, String creditField) {
        List fields = GLUtil.getDataSetCols((DataSet)dSet);
        for (Map.Entry<Long, String> entry : this.debitIdAndColKeyMap.entrySet()) {
            String debitAmtSql = String.format("case when pid= %s then %s + -1*%s else 0 end", entry.getKey(), debitField, creditField);
            fields.add(String.format("%s %s", debitAmtSql, entry.getValue()));
        }
        for (Map.Entry<Long, String> entry : this.creditIdAndColKeyMap.entrySet()) {
            String creditAmtSql = String.format("case when pid= %s then %s + -1*%s else 0 end ", entry.getKey(), creditField, debitField);
            fields.add(String.format("%s %s", creditAmtSql, entry.getValue()));
        }
        return dSet.select(fields.toArray(new String[0]));
    }

    private DataSet buildDataSet(Collection<Object[]> entrys, RowMeta rowMeta) {
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(entrys.iterator(), rowMeta);
    }

    private JoinAssgrpResult joinAssgrpDataSet(DataSet vchSet, DataSet beginBalSet, DataSet ytdSet) {
        if (this.isMultColAccount) {
            DataSet tmpAssgrpSet = this.queryAssistGroupSet();
            if (tmpAssgrpSet != null) {
                List vchFields = GLUtil.getDataSetCols((DataSet)vchSet);
                vchSet = vchSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(vchFields.toArray(new String[0])).finish();
                List balFields = GLUtil.getDataSetCols((DataSet)beginBalSet);
                beginBalSet = beginBalSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(balFields.toArray(new String[0])).finish();
                List ytdFields = GLUtil.getDataSetCols((DataSet)ytdSet);
                ytdSet = ytdSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(ytdFields.toArray(new String[0])).finish();
            }
        } else {
            DataSet tmpAssgrpSet = this.queryAssgrpDataSet();
            if (tmpAssgrpSet != null) {
                List vchFields = GLUtil.getDataSetCols((DataSet)vchSet);
                vchFields.add(ASSVAL);
                vchSet = vchSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(vchFields.toArray(new String[0])).finish();
                List balFields = GLUtil.getDataSetCols((DataSet)beginBalSet);
                balFields.add(ASSVAL);
                beginBalSet = beginBalSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(balFields.toArray(new String[0])).finish();
                List ytdFields = GLUtil.getDataSetCols((DataSet)ytdSet);
                ytdFields.add(ASSVAL);
                ytdSet = ytdSet.join(tmpAssgrpSet, JoinType.INNER).on(ASSGRP, ASSISTHG).select(ytdFields.toArray(new String[0])).finish();
            }
        }
        return new JoinAssgrpResult(vchSet, beginBalSet, ytdSet);
    }

    private DataSet queryAssistGroupSet() {
        DataSet ds;
        if (this.assistMap.isEmpty()) {
            return null;
        }
        if (this.assgrpSet != null) {
            return this.assgrpSet;
        }
        ArrayList<DataSet> dsList = new ArrayList<DataSet>(this.assistMap.size());
        for (Map.Entry<String, Tuple2<String, Set<Object>>> entry : this.assistMap.entrySet()) {
            String flexfield = entry.getKey();
            Tuple2<String, Set<Object>> tuple2 = entry.getValue();
            ds = TYPE_BASE_LONG.equals(tuple2.t1) ? this.queryAssistSet(flexfield, (Set)tuple2.t2, ASSIST_DB) : this.queryAssistSet(flexfield, (Set)tuple2.t2, ASSIST_TXT);
            dsList.add(ds);
        }
        ds = (DataSet)dsList.get(0);
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(ASSISTHG);
        fieldList.add(ASSVAL);
        if (dsList.size() >= 2) {
            ArrayList<String> list = new ArrayList<String>(dsList.size());
            for (int i = 1; i < dsList.size(); ++i) {
                list.clear();
                list.add("assval assval" + i);
                ds = ds.join((DataSet)dsList.get(i), JoinType.INNER).on(ASSISTHG, ASSISTHG).select(fieldList.toArray(new String[0]), list.toArray(new String[0])).finish();
                fieldList.add(ASSVAL + i);
            }
        }
        this.assgrpSet = ds;
        return ds;
    }

    private void createColumnGroupRecurrence(ReportColumnGroup parentGroup, MulColAccountInfo accountInfo) {
        if (accountInfo.hasChild().booleanValue()) {
            ReportColumnGroup group = new ReportColumnGroup();
            group.setCaption(new LocaleString(accountInfo.getName()));
            group.setFieldKey(accountInfo.getColKey());
            parentGroup.getChildren().add(group);
            ReportColumn amtCol = this.createColumn(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5c0f\u8ba1", (String)"MultColAccountRptPlugin_6", (String)"fi-gl-report", (Object[])new Object[0]), group.getCaption() + " ")), group.getFieldKey() + SUBTOTALENDSWITH, "amount", Boolean.FALSE);
            group.getChildren().add(amtCol);
            for (MulColAccountInfo childInfo : accountInfo.getChildAccounts()) {
                this.createColumnGroupRecurrence(group, childInfo);
            }
        } else {
            String dc = accountInfo.getDC();
            Map<String, String> map = "1".equals(dc) ? this.debitColKeyAndNameMap : this.creditColKeyAndNameMap;
            String name = map.get(accountInfo.getColKey());
            if (name != null) {
                ReportColumn column = this.createColumn(new LocaleString(accountInfo.getName()), accountInfo.getColKey(), "amount", Boolean.FALSE);
                parentGroup.getChildren().add(column);
            }
        }
    }

    private ReportColumnGroup createColumnGroup(Map<String, String> map, LocaleString groupCaption, String totalFieldKey) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setCaption(groupCaption);
        ReportColumn amtCol = this.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MultColAccountRptPlugin_1", (String)"fi-gl-report", (Object[])new Object[0])), totalFieldKey, "amount", Boolean.FALSE);
        group.getChildren().add(amtCol);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String colName = entry.getValue();
            String colKey = entry.getKey();
            amtCol = this.createColumn(new LocaleString(colName), colKey, "amount", Boolean.FALSE);
            group.getChildren().add(amtCol);
        }
        return group;
    }

    private ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType, Boolean hyperLink) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            column.setCurrencyField(CURRENCYID);
        }
        column.setHyperlink(hyperLink.booleanValue());
        return column;
    }

    private void init(ReportQueryParam param) {
        DynamicObject assgrpType;
        FilterInfo filter = param.getFilter();
        this.qParam = new MulOrgQPRpt(filter, "gl_rpt_multcolumnaccount");
        Long schemeId = filter.getLong("scheme");
        this.scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"gl_multcol_scheme");
        if (this.scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MultColAccountRptPlugin_7", (String)"fi-gl-report", (Object[])new Object[0]));
        }
        String multColType = this.scheme.getString("type");
        List items = filter.getFlexFilterItems();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            String entityId = RptUtil.fillAssistTypeName(propName);
            Set value = (Set)filterItemInfo.getValue();
            if (entityId == null) {
                this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_TXT, (Object)value));
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType.getPrimaryKey() instanceof VarcharProp) {
                this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_STRING, (Object)value));
                continue;
            }
            this.assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_LONG, (Object)value));
        }
        this.isMultColAccount = BASECURRENCY_ID.equals(multColType);
        if (!this.isMultColAccount && (assgrpType = this.scheme.getDynamicObject(FIELDNAME)) != null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"gl_multcol_scheme");
            EntryProp entry = (EntryProp)entityType.getProperty(ENTRYENTITY);
            BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(VALUE);
            DynamicObject valueSource = null;
            String entityId = null;
            String valuetype = assgrpType.getString("valuetype");
            if ("1".equals(valuetype)) {
                valueSource = assgrpType.getDynamicObject("valuesource");
                entityId = valueSource.getString("id");
            } else if ("2".equals(valuetype)) {
                valueSource = assgrpType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            if (valueSource != null) {
                prop.setBaseEntityId(entityId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
            }
            this.scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"gl_multcol_scheme");
        }
        DynamicObjectCollection entrys = this.scheme.getDynamicObjectCollection(ENTRYENTITY);
        this.detailIdAndColIdMap = new HashMap<Long, Long>();
        this.debitColKeyAndNameMap = new LinkedHashMap<String, String>();
        this.creditColKeyAndNameMap = new LinkedHashMap<String, String>();
        this.multColKeys = new ArrayList<String>();
        this.debitIdAndColKeyMap = new HashMap<Long, String>();
        this.creditIdAndColKeyMap = new HashMap<Long, String>();
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)filter.getLong("org"));
        if (this.isMultColAccount) {
            this.buildAccountColumnEntryMap(entrys);
            this.buildAccountLevel(entrys, orgFilter, filter.getLong("org"));
        } else {
            DynamicObject assgrpType2 = this.scheme.getDynamicObject(FIELDNAME);
            Set selectedAssistValues = null;
            if (assgrpType2 != null) {
                selectedAssistValues = Optional.ofNullable(this.assistMap.get(assgrpType2.getString("flexfield"))).map(x -> (Set)x.t2).orElse(null);
            }
            this.buildAssgrpColumnEntryMap(entrys, selectedAssistValues);
            this.accountIds = this.getAllLeafAccount(this.scheme.getString("account.longnumber"), orgFilter);
            if (assgrpType2 != null) {
                String entityName = assgrpType2.getString("valuesource.number");
                this.buildAssgrpLevel(entityName, entrys);
            }
        }
    }

    private void buildAccountColumnEntryMap(DynamicObjectCollection entrys) {
        entrys.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int compartor = 0;
                int result = o1.getString("dc").compareTo(o2.getString("dc"));
                if (result < 0) {
                    compartor += 5;
                } else if (result > 0) {
                    compartor -= 5;
                }
                result = o1.getString("accountnum.level").compareTo(o2.getString("accountnum.level"));
                if (result > 0) {
                    compartor += 3;
                } else if (result < 0) {
                    compartor -= 3;
                }
                result = o1.getString("seq").compareTo(o2.getString("seq"));
                if (result > 0) {
                    ++compartor;
                } else if (result < 0) {
                    --compartor;
                }
                return compartor;
            }
        });
        this.debitTreeAccountInfos = new ArrayList<MulColAccountInfo>();
        this.creditTreeAccountInfos = new ArrayList<MulColAccountInfo>();
        int idx = 0;
        for (DynamicObject entry : entrys) {
            MulColAccountInfo accountInfo = new MulColAccountInfo(entry, idx);
            List<MulColAccountInfo> list = "1".equals(accountInfo.getDC()) ? this.debitTreeAccountInfos : this.creditTreeAccountInfos;
            boolean hasParent = false;
            for (int i = list.size() - 1; i >= 0; --i) {
                MulColAccountInfo parentInfo = list.get(i);
                if (!accountInfo.getNumber().startsWith(parentInfo.getNumber())) continue;
                this.addChildAccountInfoRecurrence(parentInfo, accountInfo);
                hasParent = true;
                break;
            }
            if (!hasParent) {
                list.add(accountInfo);
            }
            ++idx;
        }
        for (MulColAccountInfo accountInfo : this.debitTreeAccountInfos) {
            this.addColRecurrence(accountInfo);
        }
        for (MulColAccountInfo accountInfo : this.creditTreeAccountInfos) {
            this.addColRecurrence(accountInfo);
        }
    }

    private Boolean addChildAccountInfoRecurrence(MulColAccountInfo parentInfo, MulColAccountInfo accountInfo) {
        if (!accountInfo.getNumber().startsWith(parentInfo.getNumber())) {
            return Boolean.FALSE;
        }
        if (parentInfo.hasChild().booleanValue()) {
            MulColAccountInfo childInfo;
            Boolean hasParent = Boolean.FALSE;
            Iterator iterator = parentInfo.getChildAccounts().iterator();
            while (iterator.hasNext() && !(hasParent = this.addChildAccountInfoRecurrence(childInfo = (MulColAccountInfo)iterator.next(), accountInfo)).booleanValue()) {
            }
            if (!hasParent.booleanValue()) {
                parentInfo.addChildAccount(accountInfo);
            }
            return Boolean.TRUE;
        }
        parentInfo.addChildAccount(accountInfo);
        return Boolean.TRUE;
    }

    private void addColRecurrence(MulColAccountInfo accountInfo) {
        if (accountInfo.hasChild().booleanValue()) {
            for (MulColAccountInfo childInfo : accountInfo.getChildAccounts()) {
                this.addColRecurrence(childInfo);
            }
        } else {
            String dc = accountInfo.getDC();
            Long id = accountInfo.getID();
            String colName = accountInfo.getName();
            String colKey = accountInfo.getColKey();
            if ("1".equals(dc)) {
                if (!this.debitIdAndColKeyMap.containsKey(id)) {
                    this.debitColKeyAndNameMap.put(colKey, colName);
                    this.debitIdAndColKeyMap.put(id, colKey);
                    this.multColKeys.add(colKey);
                }
            } else if (!this.creditIdAndColKeyMap.containsKey(id)) {
                this.creditColKeyAndNameMap.put(colKey, colName);
                this.creditIdAndColKeyMap.put(id, colKey);
                this.multColKeys.add(colKey);
            }
        }
    }

    private void buildAssgrpColumnEntryMap(DynamicObjectCollection entrys, Set<Object> selectedAssistValues) {
        String itemFieldName = VALUE;
        int idx = 0;
        HashMap<String, Tuple> flexFieldPropMap = new HashMap<String, Tuple>(16);
        for (DynamicObject entry : entrys) {
            String colKey;
            String dc = entry.getString("dc");
            DynamicObject item = entry.getDynamicObject(itemFieldName);
            if (item == null) continue;
            String pkField = "id";
            String valueSource = item.getDataEntityType().getName();
            Tuple flexTupe = (Tuple)flexFieldPropMap.get(valueSource);
            if (Objects.isNull(flexTupe)) {
                BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valueSource);
                flexTupe = Tuple.create((Object)entity.getNameProperty(), (Object)entity.getNumberProperty());
                flexFieldPropMap.put(valueSource, flexTupe);
                if (StringUtils.isNotEmpty((String)entity.getMasteridPropName())) {
                    pkField = entity.getMasteridPropName();
                }
            }
            Long masterid = item.getLong(pkField);
            if (CollectionUtils.isNotEmpty(selectedAssistValues) && !selectedAssistValues.contains(masterid)) continue;
            String colName = item.getString((String)flexTupe.item1);
            DynamicObject assgrpType = this.scheme.getDynamicObject(FIELDNAME);
            String disprops = assgrpType.getString("disprops");
            String dispProp = "";
            if (StringUtils.isNotEmpty((String)disprops)) {
                dispProp = JSONObject.parseObject((String)disprops).getJSONObject("disp").getString("dispprop");
            }
            if ("1".equals(dispProp)) {
                colName = item.getString((String)flexTupe.item2);
            } else if ("3".equals(dispProp)) {
                colName = item.getString((String)flexTupe.item2) + "," + colName;
            }
            if ("1".equals(dc)) {
                if (!this.debitIdAndColKeyMap.containsKey(masterid)) {
                    colKey = COLKEY_DEBITFIELD + idx;
                    this.debitColKeyAndNameMap.put(colKey, colName);
                    this.debitIdAndColKeyMap.put(masterid, colKey);
                    this.multColKeys.add(colKey);
                }
            } else if (!this.creditIdAndColKeyMap.containsKey(masterid)) {
                colKey = COLKEY_CREDITFIELD + idx;
                this.creditColKeyAndNameMap.put(colKey, colName);
                this.creditIdAndColKeyMap.put(masterid, colKey);
                this.multColKeys.add(colKey);
            }
            ++idx;
        }
    }

    private DataSet queryVoucher(ReportQueryParam param) {
        String currencyId = this.scheme.getString("currency");
        String endsWith = BASECURRENCY_ID.equals(currencyId) ? LOCAL : ORI;
        List<QFilter> filters = this.getVoucherFilter(param);
        String selectFields = "id voucherid, period, bookeddate, vouchertype.name vtypename, billno billnum,entries.entrydc dc, entries.edescription edescription,entries.currency currencyid, entries.account account, entries.assgrp assgrp," + String.format("entries.debit%s debit, entries.credit%s credit", endsWith, endsWith);
        DataSet dataSet = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
        dataSet = dataSet.addField("concat(vtypename,billnum)", BILLNO);
        dataSet = dataSet.removeFields(new String[]{"vtypename", "billnum"});
        return dataSet;
    }

    private List<QFilter> getVoucherFilter(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)this.scheme.getLong("org.id")));
        filters.add(new QFilter("booktype", "=", (Object)this.scheme.getLong("booktype.id")));
        filters.add(new QFilter(PERIOD, ">=", (Object)filter.getLong("startperiod")));
        filters.add(new QFilter(PERIOD, "<=", (Object)filter.getLong("endperiod")));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        String currencyId = this.scheme.getString("currency");
        if (!BASECURRENCY_ID.equals(currencyId)) {
            filters.add(new QFilter("entries.currency", "=", (Object)Long.parseLong(currencyId)));
        }
        filters.add(new QFilter("entries.account", "in", this.accountIds));
        if (this.qParam.isSubstractPL()) {
            filters.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        return filters;
    }

    private DataSet queryAssgrpDataSet() {
        DynamicObject assgrpType = this.scheme.getDynamicObject(FIELDNAME);
        if (assgrpType == null) {
            return null;
        }
        if (this.assgrpSet != null) {
            return this.assgrpSet;
        }
        String ffield = assgrpType.getString("flexfield");
        HashSet<Long> assgrpIds = new HashSet<Long>();
        DynamicObjectCollection entrys = this.scheme.getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject entry : entrys) {
            Optional.ofNullable(entry.getDynamicObject(VALUE)).map(dyo -> dyo.getLong(dyo.containsProperty("masterid") ? "masterid" : "id")).ifPresent(assgrpIds::add);
        }
        this.assgrpSet = RptAssgrpFilter.queryAssistSet(ffield, assgrpIds, this.assistMap);
        return this.assgrpSet;
    }

    private void buildAccountLevel(DynamicObjectCollection entrys, QFilter orgFilter, Long orgID) {
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject entry : entrys) {
            DynamicObject account = entry.getDynamicObject("accountnum");
            if (account == null) continue;
            Collection<Long> mids = RptUtil.getAllLeafAccountByNums(Collections.singleton(account.getString("number")), this.qParam.getAccountTable(), Collections.singletonList(orgID), null).values();
            Set<Long> detailIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("masterid", "in", mids).toArray(), null, (int)-1).stream().mapToLong(Long.class::cast).boxed().collect(Collectors.toSet());
            ids.addAll(detailIds);
            detailIds.forEach(p -> this.detailIdAndColIdMap.put((Long)p, account.getLong("id")));
        }
        this.accountIds = ids;
    }

    private void buildAssgrpLevel(String entityName, DynamicObjectCollection entrys) {
        boolean hasParent = this.hasParent(entityName);
        for (DynamicObject entry : entrys) {
            long masterId;
            DynamicObject item = entry.getDynamicObject(VALUE);
            if (item == null) continue;
            Long id = item.getLong("id");
            long l = masterId = item.containsProperty("masterid") ? item.getLong("masterid") : id.longValue();
            if (hasParent && !item.getBoolean("isleaf")) {
                HashSet<Long> temIds = new HashSet<Long>();
                temIds.add(id);
                Set<Long> detailIds = this.getAllLeafBaseData(entityName, temIds);
                detailIds.forEach(p -> this.detailIdAndColIdMap.put((Long)p, masterId));
            }
            this.detailIdAndColIdMap.put(masterId, masterId);
        }
    }

    private boolean hasParent(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return this.hasProperty(parent) && this.hasProperty(isleaf) && this.hasProperty(level);
    }

    private boolean hasProperty(DynamicProperty parent) {
        return parent != null && !StringUtils.isBlank((String)parent.getAlias());
    }

    private Set<Long> getAllLeafBaseData(String entityName, Set<Long> accountId) {
        HashSet<Long> ids = new HashSet<Long>();
        HashSet<Long> pIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getAllLeafBaseData"), (String)entityName, (String)"id, masterid, isleaf", (QFilter[])new QFilter[]{new QFilter("parent.id", "in", accountId)}, null);){
            for (Row row : dSet) {
                Long id = row.getLong("id");
                Long masterid = row.getLong("masterid");
                Boolean isLeaf = row.getBoolean("isleaf");
                if (isLeaf.booleanValue()) {
                    ids.add(masterid);
                    continue;
                }
                pIds.add(id);
            }
        }
        if (!pIds.isEmpty()) {
            ids.addAll(this.getAllLeafBaseData(entityName, pIds));
        }
        return ids;
    }

    private Set<Long> getAllLeafAccount(String longNumber, QFilter orgFilter) {
        HashSet<Long> actIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getAllLeafAccount"), (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + "%")), new QFilter("isleaf", "=", (Object)"1"), new QFilter("accounttable", "=", (Object)this.qParam.getAccountTable()), orgFilter}, null);){
            for (Row row : dSet) {
                Long id = row.getLong("id");
                actIds.add(id);
            }
        }
        return actIds;
    }

    private DataSet queryAssistSet(String ffield, Set<Object> assval, String entityname) {
        String fields = "hg assisthg,asstype,assval";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("asstype", "=", (Object)ffield);
        qfList.add(qFilter);
        if (assval != null && !assval.isEmpty()) {
            qFilter = new QFilter(ASSVAL, "in", assval);
            qfList.add(qFilter);
        }
        qFilter = ASSIST_TXT.equals(entityname) ? new QFilter(ASSVAL, "!=", (Object)Character.valueOf('0')) : new QFilter(ASSVAL, "!=", (Object)0);
        qfList.add(qFilter);
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + entityname), (String)entityname, (String)fields, (QFilter[])qfList.toArray(new QFilter[0]), null);
    }
}

