/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IRegisterPropertyListener;
import kd.bos.entity.datamodel.events.RegisterPropertyArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;

public class ReciprocalAcctQueryRpt
extends AbstractReportListDataPlugin {
    private static final String VCH_SELECT_FIELDS = "id,entries.id entriesid";
    private static final String VCH_SELECT_FIELDS_QING = "id,vouchertype,billno voucherno, entries.id, entries.account vchaccount, entries.account.%s vchacctname";
    private static final String SELECT_FIELDS = "period,bizdate,bookeddate,voucherid, voucherentry, id,description desc,account accountno,'' accountname,assgrp,currency currencyfield,localcurrency,expiredate,amountfor,amountbalfor,amount,amountbal,biznum, masterid,org,period.number periodnumber,status";
    private static final String SELECT_ACCT_FIELDS = "period,bizdate,bookeddate,voucherid,voucherentry,id entryid,desc,accountno,accountname,assgrp,currencyfield,localcurrency,expiredate,amountfor,amountbalfor,amount,amountbal,biznum,org,periodnumber,reciprocalamount,writeoffamount,orderfield,status";
    private static final String SELECT_INIT_FIELDS = "period,bizdate,bookeddate,voucherid, voucherentry, id, desc, accountno, accountname,assgrp, currencyfield,localcurrency,expiredate,amountfor,amountbalfor,amount,amountbal,biznum, masterid,org,periodnumber,status";
    private static final String RIGHT_JOIN_FIELDS = "id";
    private static final String RIGHT_JOIN_FIELDS_QING = "id,vouchertype,voucherno, vchaccount, vchacctname";
    private static final String MASTERID = "masterid";
    private static final Map<String, String> INITVOUCHERFILTER = new HashMap(){
        {
            this.put("bizdate", "bizdate");
            this.put("entries.edescription", "description");
            this.put("entries.businessnum", "bizbillno");
        }
    };
    private DynamicObjectCollection accts;
    private DynamicObject org;
    private DynamicObject booktype;
    private DynamicObject startPeriod;
    private DynamicObject endPeriod;
    private DynamicObject periodtype;
    private Long acctTable;
    private String currency;
    private boolean uncheckvoucher;
    private boolean acctvouch;
    private boolean reciprovouch;
    private List<QFilter> assgrpList = new ArrayList<QFilter>();
    private static final String PERIOD = "period";
    private static final String AMOUNTFOR = "amountfor";
    private static final String RECIPROCALAMOUNT = "reciprocalamount";
    private static final String AMOUNTBALFOR = "amountbalfor";
    private static final String CURRENCYFIELD = "currencyfield";
    private static final String AMOUNT = "amount";
    private static final String WRITEOFFAMOUNT = "writeoffamount";
    private static final String AMOUNTBAL = "amountbal";
    private static final String LOCALCURRENCY = "localcurrency";

    private EntityType getDataEntityType() throws CloneNotSupportedException {
        FilterField filterField = FilterField.create((MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_acccurrent"), (String)"assgrp");
        FlexProp flexProp = (FlexProp)filterField.getSrcFieldProp();
        List list = flexProp.extendFlexProperties("gl_acccurrent_flexschemefiltercolumnap", registerFlexPropertyArgs -> {});
        ArrayList<String> selectFields = new ArrayList<String>(10);
        for (QFilter temp : this.assgrpList) {
            selectFields.add(temp.getProperty());
        }
        EntityType obj = (EntityType)EntityMetadataCache.getDataEntityType((String)"gl_acccurrent").clone();
        for (IRegisterPropertyListener listener : list) {
            RegisterPropertyArgs registerPropertyArgs = new RegisterPropertyArgs((DynamicObjectType)obj, selectFields, new ArrayList());
            RegisterPropertyArgs registerPropertyResult1 = listener.registerSimpleProperty(registerPropertyArgs);
            RegisterPropertyArgs registerPropertyArgs2 = listener.registerComplexProperty(registerPropertyArgs);
        }
        return obj;
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        this.init(param);
        FilterInfo filterInfo = param.getFilter();
        QFilter vchQFilter = filterInfo.getCommFilter("gl_voucher");
        QFilter initQFilter = new QFilter(RIGHT_JOIN_FIELDS, "!=", null);
        boolean queryInitRecord = true;
        if (vchQFilter != null) {
            QFilter vchQFilterCopy = vchQFilter.copy();
            queryInitRecord = this.checkInitFilter(vchQFilterCopy, initQFilter, true);
        }
        DataSet record = this.queryRecord(this.org, this.booktype, this.accts, this.startPeriod, this.endPeriod, this.currency, this.uncheckvoucher, this.acctvouch, this.reciprovouch, initQFilter);
        boolean isTableVersion = BalanceTransferUtils.isAccountTableVersion((Long)this.org.getLong(RIGHT_JOIN_FIELDS), (Long)this.booktype.getLong(RIGHT_JOIN_FIELDS));
        record = isTableVersion ? this.updateEntryId(record) : record.select(SELECT_ACCT_FIELDS);
        List recordFields = ReportUtils.getDataSetCols((DataSet)record);
        DataSet voucher = null;
        if (vchQFilter != null) {
            voucher = this.queryVoucher(vchQFilter, record.copy());
        }
        DataSet result = voucher != null ? record.join(voucher, JoinType.LEFT).on("voucherentry", "entriesid").select(recordFields.toArray(new String[0]), RIGHT_JOIN_FIELDS.split(",")).finish().filter(queryInitRecord ? "id is not null or voucherid = 0" : "id is not null").orderBy(new String[]{CURRENCYFIELD, "orderfield", "bizdate"}) : record.orderBy(new String[]{CURRENCYFIELD, "orderfield", "bizdate"});
        List resultFields = GLUtil.getDataSetCols((DataSet)result);
        DataSet set = result.copy();
        DataSet total = this.totalDataset(set);
        DataSet select = total.select(resultFields.toArray(new String[0]));
        result = result.union(select);
        result.select(resultFields.toArray(new String[0]));
        Field[] fields = result.getRowMeta().getFields();
        boolean isShowOrgField = Arrays.stream(fields).anyMatch(x -> x.getAlias().equals("org"));
        result = isShowOrgField ? result.addField("org", "flexorgid") : result.addField(String.valueOf(this.org.getLong(RIGHT_JOIN_FIELDS)), "flexorgid");
        return result;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn orgIdColumn = new ReportColumn();
        orgIdColumn.setHide(true);
        orgIdColumn.setFieldKey("flexorgid");
        orgIdColumn.setEntityId("bos_org");
        orgIdColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
        orgIdColumn.setFieldType("basedata");
        columns.add((AbstractReportColumn)orgIdColumn);
        return columns;
    }

    public DataSet queryQing(ReportQueryParam param, Object obj) throws Throwable {
        this.init(param);
        FilterInfo filterInfo = param.getFilter();
        QFilter vchQFilter = filterInfo.getCommFilter("gl_voucher");
        QFilter initQFilter = new QFilter(RIGHT_JOIN_FIELDS, "in", null);
        boolean queryInitRecord = true;
        if (vchQFilter != null) {
            QFilter vchQFilterCopy = vchQFilter.copy();
            queryInitRecord = this.checkInitFilter(vchQFilterCopy, initQFilter, true);
        }
        DataSet record = this.queryRecord(this.org, this.booktype, this.accts, this.startPeriod, this.endPeriod, this.currency, this.uncheckvoucher, this.acctvouch, this.reciprovouch, initQFilter);
        boolean isTableVersion = BalanceTransferUtils.isAccountTableVersion((Long)this.org.getLong(RIGHT_JOIN_FIELDS), (Long)this.booktype.getLong(RIGHT_JOIN_FIELDS));
        record = isTableVersion ? this.updateEntryId(record) : record.select(SELECT_ACCT_FIELDS);
        List recordFields = ReportUtils.getDataSetCols((DataSet)record);
        DataSet voucher = this.queryVoucherQing(vchQFilter, record.copy());
        DataSet result = record.join(voucher, JoinType.LEFT).on("voucherid", RIGHT_JOIN_FIELDS).on("voucherentry", "entries.id").select(recordFields.toArray(new String[0]), RIGHT_JOIN_FIELDS_QING.split(",")).finish().filter(queryInitRecord ? "id is not null or voucherid = 0" : "id is not null").orderBy(new String[]{CURRENCYFIELD, "orderfield", "bizdate"});
        List resultFields = GLUtil.getDataSetCols((DataSet)result);
        DataSet set = result.copy();
        DataSet total = this.totalDataset(set);
        DataSet select = total.select(resultFields.toArray(new String[0]));
        result = result.union(select);
        resultFields.remove("vchacctname");
        resultFields.remove("accountname");
        resultFields.remove("vchaccount");
        resultFields.remove("accountno");
        resultFields.add("case when vchacctname is null then accountname else vchacctname end accountname");
        resultFields.add("case when vchaccount is null or vchaccount == 0 then accountno else vchaccount end accountno");
        return result.select(resultFields.toArray(new String[0]));
    }

    private DataSet queryVoucherQing(QFilter vchQFilter, DataSet recordDt) {
        HashSet<Long> vchIds = new HashSet<Long>(64);
        for (Row row : recordDt.copy()) {
            vchIds.add(row.getLong("voucherid"));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter idFilter = new QFilter(RIGHT_JOIN_FIELDS, "in", vchIds);
        filterList.add(idFilter);
        filterList.add(vchQFilter);
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)((Long)this.org.getPkValue()));
        String selectField = String.format(VCH_SELECT_FIELDS_QING, accountNameField);
        return QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryvoucher", (String)"gl_voucher", (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
    }

    private DataSet updateEntryId(DataSet record) {
        DataSet latestReocrd = this.queryLatestRecordId(this.org, this.booktype, this.startPeriod, this.endPeriod, this.currency);
        List recordFields = GLUtil.getDataSetCols((DataSet)record);
        recordFields.remove(MASTERID);
        recordFields.remove(RIGHT_JOIN_FIELDS);
        record = record.join(latestReocrd, JoinType.INNER).on(MASTERID, MASTERID).select(recordFields.toArray(new String[0]), new String[]{"id entryid"}).finish();
        return record;
    }

    private void init(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        this.reciprovouch = filterInfo.getBoolean("reciprovouch");
        this.acctvouch = filterInfo.getBoolean("acctvouch");
        this.accts = filterInfo.getDynamicObjectCollection("account");
        this.org = filterInfo.getDynamicObject("org");
        this.booktype = filterInfo.getDynamicObject("booktype");
        this.startPeriod = filterInfo.getDynamicObject("startperiod");
        this.endPeriod = filterInfo.getDynamicObject("endperiod");
        this.acctTable = filterInfo.getLong("accounttable");
        this.currency = filterInfo.getString("currency");
        List iteminfos = param.getFilter().getFlexFilterItems();
        this.uncheckvoucher = filterInfo.getBoolean("uncheckvoucher");
        this.periodtype = filterInfo.getDynamicObject("periodtype");
        if (iteminfos.isEmpty()) {
            this.assgrpList = new ArrayList<QFilter>(1);
        } else {
            this.setAssitgrpFilter(iteminfos);
        }
    }

    private void setAssitgrpFilter(List<FilterItemInfo> iteminfos) {
        for (FilterItemInfo filterItemInfo : iteminfos) {
            Set values = (Set)filterItemInfo.getValue();
            String propName = filterItemInfo.getPropName();
            DynamicObject assistType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "=", (Object)propName)});
            QFilter filter = new QFilter(String.format("assgrp_%s.propertyId", propName), "=", (Object)propName);
            this.assgrpList.add(filter);
            if (values.isEmpty()) continue;
            QFilter filter_value = new QFilter(String.format("assgrp_%s.%s.id", propName, assistType.getDynamicObject("valuesource").getString("number")), "in", (Object)values);
            this.assgrpList.add(filter_value);
        }
    }

    private Set<Object> query(DBRoute gl, String sql, ResultSetHandler<Set<Object>> fid) {
        return (Set)DB.query((DBRoute)gl, (String)sql, fid);
    }

    private QFilter[] getLatestRecordFilters(DynamicObject org, DynamicObject booktype, DynamicObject startPeriod, DynamicObject endPeriod, String currency) {
        Long orgId = org.getLong(RIGHT_JOIN_FIELDS);
        QFilter qorg = new QFilter("org", "=", (Object)orgId);
        Long booktypeId = booktype.getLong(RIGHT_JOIN_FIELDS);
        QFilter qbooktype = new QFilter("booktype", "=", (Object)booktypeId);
        List<Long> periodList = this.getPeriodIds(startPeriod, endPeriod);
        periodList.add(0L);
        QFilter qperiod = new QFilter(PERIOD, "in", periodList);
        QFilter qother = null;
        if (!"allcurrency".equals(currency)) {
            qother = new QFilter("currency", "=", (Object)Long.valueOf(currency));
        }
        QFilter acctRefFilter = new QFilter("uneffectivedate", "=", (Object)BalanceTransferUtils.getEndDate());
        return new QFilter[]{qorg, qbooktype, qperiod, acctRefFilter, qother};
    }

    private List<Long> getPeriodIds(DynamicObject startPeriod, DynamicObject endPeriod) {
        ArrayList<QFilter> periodFilters = new ArrayList<QFilter>(16);
        QFilter periodTypeFilter = new QFilter("periodtype.id", "=", this.periodtype.getPkValue());
        QFilter periodRangeFilter = new QFilter(RIGHT_JOIN_FIELDS, ">=", startPeriod.getPkValue()).and(RIGHT_JOIN_FIELDS, "<=", endPeriod.getPkValue());
        periodFilters.add(periodTypeFilter);
        periodFilters.add(periodRangeFilter);
        Map periodDynMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)RIGHT_JOIN_FIELDS, (QFilter[])periodFilters.toArray(new QFilter[0]));
        ArrayList<Long> periodList = new ArrayList<Long>(16);
        for (DynamicObject entry : periodDynMap.values()) {
            periodList.add(entry.getLong(RIGHT_JOIN_FIELDS));
        }
        return periodList;
    }

    private List<QFilter> getRecordFilters(DynamicObject org, DynamicObject booktype, DynamicObjectCollection accts, DynamicObject startPeriod, DynamicObject endPeriod, String currency, boolean uncheckvoucher, boolean acctvouch, boolean reciprovouch) {
        QFilter qorg = new QFilter("org", "=", org.getPkValue());
        QFilter qbooktype = new QFilter("booktype", "=", booktype.getPkValue());
        QFilter qAccountTable = new QFilter("accounttable", "=", (Object)this.acctTable);
        List<Long> periodList = this.getPeriodIds(startPeriod, endPeriod);
        QFilter qperiod = new QFilter(PERIOD, "in", periodList);
        HashSet<Long> initAcctIds = new HashSet<Long>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("org", "=", org.getPkValue()));
        filters.add(new QFilter("booktype", "=", booktype.getPkValue()));
        filters.add(new QFilter("isendinit", "=", (Object)"1"));
        if (accts != null) {
            List acctIds = GLUtil.getIdsFromDynCollection((DynamicObjectCollection)accts, (String)MASTERID);
            filters.add(new QFilter("account.masterid", "in", (Object)acctIds));
        }
        long startPeriodId = Long.parseLong(String.valueOf(startPeriod.getPkValue()));
        long endPeriodId = Long.parseLong(String.valueOf(endPeriod.getPkValue()));
        HashSet<Long> inculdeInitAccts = new HashSet<Long>(32);
        try (DataSet initState = QueryServiceHelper.queryDataSet((String)"fi.gl.ReciprocalAcctQueryRpt.initstate", (String)"gl_reci_init_state", (String)"endinitperiod,account.masterid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : initState) {
                long endInitPeriodId = row.getLong("endinitperiod");
                long acctId = row.getLong("account.masterid");
                if (startPeriodId <= endInitPeriodId && endInitPeriodId <= endPeriodId) {
                    inculdeInitAccts.add(acctId);
                }
                initAcctIds.add(acctId);
            }
        }
        if (!inculdeInitAccts.isEmpty()) {
            QFilter qinit = new QFilter(PERIOD, "=", (Object)0).and(new QFilter("account", "in", inculdeInitAccts));
            qperiod = qperiod.or(qinit);
        }
        QFilter endInitActFilter = new QFilter("account", "in", initAcctIds);
        QFilter qother = null;
        if (!"allcurrency".equals(currency)) {
            qother = new QFilter("currency", "=", (Object)Long.valueOf(currency));
        }
        if (uncheckvoucher) {
            qother = qother == null ? new QFilter("status", "!=", (Object)"2") : qother.and(new QFilter("status", "!=", (Object)"2"));
        }
        if (acctvouch && !reciprovouch) {
            QFilter acctVouchFilter = new QFilter(AMOUNTFOR, ">", (Object)BigDecimal.ZERO).or(new QFilter(AMOUNTFOR, "=", (Object)BigDecimal.ZERO).and(new QFilter(AMOUNT, ">", (Object)BigDecimal.ZERO)));
            qother = qother == null ? acctVouchFilter : qother.and(acctVouchFilter);
        }
        if (reciprovouch && !acctvouch) {
            QFilter reciproVouchFilter = new QFilter(AMOUNTFOR, "<", (Object)BigDecimal.ZERO).or(new QFilter(AMOUNTFOR, "=", (Object)BigDecimal.ZERO).and(new QFilter(AMOUNT, "<", (Object)BigDecimal.ZERO)));
            qother = qother == null ? reciproVouchFilter : qother.and(reciproVouchFilter);
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>(10);
        list.add(qorg);
        list.add(qbooktype);
        list.add(qperiod);
        list.add(qother);
        list.add(endInitActFilter);
        list.add(qAccountTable);
        for (QFilter temp : this.assgrpList) {
            list.add(temp);
        }
        return list;
    }

    private DataSet queryLatestRecordId(DynamicObject org, DynamicObject booktype, DynamicObject startPeriod, DynamicObject endPeriod, String currency) {
        QFilter[] filters = this.getLatestRecordFilters(org, booktype, startPeriod, endPeriod, currency);
        return QueryServiceHelper.queryDataSet((String)"queryLatestRecordId", (String)"gl_acccurrent", (String)"id, masterid", (QFilter[])filters, null);
    }

    private DataSet queryRecord(DynamicObject org, DynamicObject booktype, DynamicObjectCollection accts, DynamicObject startPeriod, DynamicObject endPeriod, String currency, boolean uncheckvoucher, boolean acctvouch, boolean reciprovouch, QFilter initQFilter) throws CloneNotSupportedException {
        DataSet dt;
        List<QFilter> filters = this.getRecordFilters(org, booktype, accts, startPeriod, endPeriod, currency, uncheckvoucher, acctvouch, reciprovouch);
        if (initQFilter.getNests(false).size() > 0) {
            ORM orm = ORM.create();
            if (this.assgrpList.size() > 0) {
                orm.setDataEntityType("gl_acccurrent", (IDataEntityType)this.getDataEntityType());
            }
            dt = this.queryInitAndVoucherRecord(orm, filters, initQFilter, SELECT_FIELDS);
        } else if (this.assgrpList.size() > 0) {
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_acccurrent", (IDataEntityType)this.getDataEntityType());
            dt = orm.queryDataSet("gl_reciprocal_queryrecord", "gl_acccurrent", SELECT_FIELDS, filters.toArray(new QFilter[filters.size()]), null);
        } else {
            dt = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryrecord", (String)"gl_acccurrent", (String)SELECT_FIELDS, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        }
        dt = dt.filter("id = masterid");
        return dt.addField("amountfor-amountbalfor", RECIPROCALAMOUNT).addField("amount - amountbal", WRITEOFFAMOUNT).addField("1", "orderfield");
    }

    private DataSet queryVoucher(QFilter vchQFilter, DataSet recordDt) {
        HashSet<Long> vchIds = new HashSet<Long>(64);
        for (Row row : recordDt.copy()) {
            vchIds.add(row.getLong("voucherid"));
        }
        return ((IVoucherQueryService)GLServiceFactory.getService(IVoucherQueryService.class)).queryByIds(vchIds, vchQFilter.toArray(), VCH_SELECT_FIELDS, null);
    }

    private DataSet totalDataset(DataSet dataset) {
        DataSet sum = dataset.select(new String[]{AMOUNTFOR, RECIPROCALAMOUNT, AMOUNTBALFOR, AMOUNT, AMOUNTBAL, WRITEOFFAMOUNT, CURRENCYFIELD, LOCALCURRENCY}).groupBy(new String[]{CURRENCYFIELD, LOCALCURRENCY}).sum(AMOUNTFOR).sum(AMOUNTBALFOR).sum(RECIPROCALAMOUNT).sum(AMOUNT).sum(AMOUNTBAL).sum(WRITEOFFAMOUNT).finish();
        return sum.addNullField(new String[]{PERIOD, "bizdate", "bookeddate", "voucherid", "voucherentry", "entryid", "desc", "accountno", "assgrp", "expiredate", "biznum", "org", "periodnumber"}).addField(String.format(ResManager.loadKDString((String)"%1$s\u5408\u8ba1%2$s", (String)"ReciprocalAcctQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "'"), "accountname").addField("2", "orderfield").addNullField(new String[]{"vouchertype", "voucherno", "vchaccount", "vchacctname", RIGHT_JOIN_FIELDS, "status"});
    }

    private DataSet queryInitAndVoucherRecord(ORM orm, List<QFilter> filters, QFilter initQFilter, String selectField) {
        ArrayList<QFilter> filters1 = new ArrayList<QFilter>();
        filters1.addAll(filters);
        filters1.add(new QFilter("voucherid", "=", (Object)0));
        DataSet dt1 = orm.queryDataSet("gl_reciprocal_queryrecord", "gl_acccurrent", selectField, filters1.toArray(new QFilter[filters1.size()]), null);
        if (this.accts != null) {
            ArrayList<Long> acctMasterIds = new ArrayList<Long>(8);
            for (DynamicObject acct : this.accts) {
                acctMasterIds.add(acct.getLong(MASTERID));
            }
            List accountIdList = GLUtil.getIdsByMasterIds((String)"bd_accountview", acctMasterIds, null, (int)-1);
            if (!accountIdList.isEmpty()) {
                QFilter qother = new QFilter("account", "in", (Object)accountIdList);
                initQFilter.and(qother);
            }
        }
        initQFilter.and(new QFilter("org", "=", this.org.getPkValue()));
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)"gl_initacccurrent", (String)"gl_initacccurrent", (String)"reciprocalrecord", (QFilter[])new QFilter[]{initQFilter}, null);
        dt1 = dt1.join(initDataSet, JoinType.INNER).on(RIGHT_JOIN_FIELDS, "reciprocalrecord").select(SELECT_INIT_FIELDS.split(",")).finish();
        ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
        filters2.addAll(filters);
        filters2.add(new QFilter("voucherid", ">", (Object)0));
        DataSet dt2 = orm.queryDataSet("gl_reciprocal_queryrecord", "gl_acccurrent", selectField, filters2.toArray(new QFilter[filters2.size()]), null);
        DataSet dt = dt1.union(dt2);
        return dt;
    }

    private boolean checkInitFilter(QFilter qFilter, QFilter initQFilter, boolean isAnd) {
        boolean queryInitRecord = true;
        if (INITVOUCHERFILTER.containsKey(qFilter.getProperty())) {
            if ("bizdate".equals(qFilter.getProperty()) && qFilter.getValue() instanceof String) {
                return false;
            }
            QFilter qFilter1 = new QFilter(INITVOUCHERFILTER.get(qFilter.getProperty()), qFilter.getCP(), qFilter.getValue());
            if (isAnd) {
                initQFilter.and(qFilter1);
            } else if (initQFilter.getNests(false).size() == 0) {
                initQFilter.and(qFilter1);
            } else {
                initQFilter.or(qFilter1);
            }
            List qFilterNests = qFilter.getNests(false);
            if (!CollectionUtils.isEmpty((Collection)qFilterNests)) {
                for (QFilter.QFilterNest qFilterNest : qFilterNests) {
                    boolean result = this.checkInitFilter(qFilterNest.getFilter(), initQFilter, qFilterNest.isAnd());
                    queryInitRecord = qFilterNest.isAnd() ? queryInitRecord && result : queryInitRecord || result;
                }
            }
        } else {
            queryInitRecord = false;
            List qFilterNests = qFilter.getNests(false);
            if (!CollectionUtils.isEmpty((Collection)qFilterNests)) {
                for (QFilter.QFilterNest qFilterNest : qFilterNests) {
                    boolean result = this.checkInitFilter(qFilterNest.getFilter(), initQFilter, qFilterNest.isAnd());
                    queryInitRecord = qFilterNest.isAnd() ? queryInitRecord && result : queryInitRecord || result;
                }
            } else {
                queryInitRecord = false;
            }
        }
        return queryInitRecord;
    }
}

