/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ReciprocalLogQueryRpt
extends AbstractReportListDataPlugin {
    private long org;
    private long booktype;
    private List<Object> accountIdList;
    private String currency = "";
    private Long startPeriod;
    private Long endPeriod;
    private QFilter orgFilter;
    private QFilter bookTypeFilter;
    private QFilter periodFilter;
    private QFilter currencyQfilter;
    private QFilter accountQFilter;
    private QFilter qassgrpQfilter;
    private QFilter qprocalIdQfilter;
    private List<QFilter> vchQFilter;
    private static final String PERIOD = "period";
    private static final String VCH_SELECT_FIELDS = "id vchid, entries.id";

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        this.init(param);
        if (this.isVchFilter()) {
            Pair<Set<Long>, Set<Long>> vchOrgAndPeriod = this.getVchOrgAndPeriod(param.getFilter());
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("org", FilterType.in_range, vchOrgAndPeriod.getKey()), new HintCondition(PERIOD, FilterType.in_range, vchOrgAndPeriod.getValue())});){
                DataSet dataSet = this.getReciprocalLogData(param);
                QFilter[] voucherFilters = this.getVoucherFilters();
                DataSet voucherDt = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryvoucher", (String)"gl_voucher", (String)VCH_SELECT_FIELDS, (QFilter[])voucherFilters, null);
                DataSet buyerDataSet = dataSet.join(voucherDt, JoinType.LEFT).on("buyervoucherid", "vchid").on("buyervoucherentryid", "entries.id").select(new String[]{"currencyfield", "reciprocalfor", "reciprocallocal", "writeofffor", "writeofflocal", "ballocal", "balfor", "writeoffdate", "accountid", "accountnumber", "accountname", "writeoffentry", "writeofftype", "writername", "writerid", "entryid", "assgrp", "buyervoucherid", "writeoffvoucherid", "localcurrency", "orderfiled", "bizdate", "businessnum", "edescription", "id", "buyervoucherentryid", "writeoffvoucherentryid", "vchid", "bookeddate", "recibookeddate"}).finish().filter("vchid is not null");
                DataSet writeoffDataSet = dataSet.join(voucherDt, JoinType.LEFT).on("writeoffvoucherid", "vchid").on("writeoffvoucherentryid", "entries.id").select(new String[]{"currencyfield", "reciprocalfor", "reciprocallocal", "writeofffor", "writeofflocal", "ballocal", "balfor", "writeoffdate", "accountid", "accountnumber", "accountname", "writeoffentry", "writeofftype", "writername", "writerid", "entryid", "assgrp", "buyervoucherid", "writeoffvoucherid", "localcurrency", "orderfiled", "bizdate", "businessnum", "edescription", "id", "buyervoucherentryid", "writeoffvoucherentryid", "vchid", "bookeddate", "recibookeddate"}).finish().filter("vchid is not null");
                DataSet dataSet2 = buyerDataSet.union(writeoffDataSet).groupBy(new String[]{"currencyfield", "reciprocalfor", "reciprocallocal", "writeofffor", "writeofflocal", "ballocal", "balfor", "writeoffdate", "accountid", "accountnumber", "accountname", "writeoffentry", "writeofftype", "writername", "writerid", "entryid", "assgrp", "buyervoucherid", "writeoffvoucherid", "localcurrency", "orderfiled", "bizdate", "bookeddate", "recibookeddate", "businessnum", "edescription", "id", "buyervoucherentryid", "writeoffvoucherentryid"}).finish();
                return dataSet2;
            }
        }
        return this.getReciprocalLogData(param);
    }

    private DataSet getReciprocalLogData(ReportQueryParam param) {
        Row row = (Row)param.byBatchInfo().getCurrentBatchRows().get(0);
        Integer formIndex = row.getInteger("formIndex");
        Integer toIndex = row.getInteger("toIndex");
        Pair<ORM, QFilter[]> ormQuery = this.createOrmQuery();
        DataSet dataSet = ((ORM)ormQuery.getKey()).queryDataSet(((Object)((Object)this)).getClass().getName(), "gl_reciprocal_log", "currency currencyfield,buyerentry.amountfor reciprocalfor,buyerentry.amount reciprocallocal,amountfor writeofffor,amount writeofflocal,buyerentry.amountbal ballocal,buyerentry.amountbalfor balfor,writeoffdate,account.id accountid,writeoffentry writeoffentry,writeofftype,writer.name writername,writer.id writerid,id entryid,assgrp.id assgrp,buyerentry.voucherid buyervoucherid,writeoffentry.voucherid writeoffvoucherid,localcurrency,buyerentry.bizdate bizdate,buyerentry.biznum businessnum,buyerentry.description edescription,buyerentry.id id,buyerentry.voucherentry buyervoucherentryid,buyerentry.bookeddate bookeddate,writeoffentry.voucherentry writeoffvoucherentryid,writeoffentry.bookeddate recibookeddate", (QFilter[])ormQuery.getValue(), null, formIndex.intValue(), toIndex.intValue());
        dataSet = dataSet.addNullField(new String[]{"accountname", "accountnumber"}).addField("1", "orderfiled");
        return dataSet;
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        this.init(queryParam);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("formIndex", (DataType)DataType.IntegerType), new Field("toIndex", (DataType)DataType.IntegerType)});
        DataSetBuilder batchByDSBuilder = Algo.create((String)"").createDataSetBuilder(rowMeta);
        int logCount = this.reciprocalLogCount();
        int pageRow = 10000;
        for (int pageIndex = 0; pageIndex < 10; ++pageIndex) {
            int formIndex;
            int n = formIndex = pageIndex == 0 ? 0 : pageIndex * pageRow + 1;
            if (formIndex > logCount) break;
            batchByDSBuilder.append(new Object[]{formIndex, pageRow});
        }
        IReportBatchQueryInfo queryInfo = queryParam.byBatchInfo();
        queryInfo.setCountPerBatch(1);
        queryInfo.setMaxExcelRowCountPerSheet(pageRow);
        queryInfo.setMaxRowCountCached(pageRow);
        return batchByDSBuilder.build();
    }

    private Pair<ORM, QFilter[]> createOrmQuery() {
        try {
            MainEntityType entityType = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_reciprocal_log").clone();
            entityType.addProperty((DynamicProperty)ReciprocalLogQueryRpt.getBasedataProp("fbuyerentryid", "buyerentry", "gl_acccurrent"));
            entityType.addProperty((DynamicProperty)ReciprocalLogQueryRpt.getBasedataProp("fwriteoffentryid", "writeoffentry", "gl_acccurrent"));
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_reciprocal_log", (IDataEntityType)entityType);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            QFilter[] logFilters = new QFilter[]{this.orgFilter, this.bookTypeFilter, this.periodFilter, this.currencyQfilter, this.accountQFilter, this.qassgrpQfilter, this.qprocalIdQfilter};
            filters.addAll(new ArrayList<QFilter>(Arrays.asList(logFilters)));
            return Pair.of((Object)orm, (Object)filters.toArray(new QFilter[0]));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static BasedataProp getBasedataProp(String tableField, String filed, String number) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)number);
        BasedataProp prop = new BasedataProp();
        prop.setAlias(tableField);
        prop.setName(filed);
        prop.setComplexType((IDataEntityType)type);
        ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
        return prop;
    }

    private QFilter[] getVoucherFilters() {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(this.orgFilter);
        filterList.add(this.bookTypeFilter);
        QFilter qperiod = new QFilter(PERIOD, ">=", (Object)this.startPeriod).and(new QFilter(PERIOD, "<=", (Object)this.endPeriod));
        filterList.add(qperiod);
        filterList.addAll(this.vchQFilter);
        return filterList.toArray(new QFilter[0]);
    }

    private int reciprocalLogCount() {
        QFilter[] logFilters = new QFilter[]{this.orgFilter, this.bookTypeFilter, this.periodFilter, this.currencyQfilter, this.accountQFilter, this.qassgrpQfilter, this.qprocalIdQfilter};
        return QueryServiceHelper.queryDataSet((String)"ReciprocalLogQueryRpt", (String)"gl_reciprocal_log", (String)"id", (QFilter[])logFilters, null).count("id", Boolean.TRUE.booleanValue());
    }

    private boolean isVchFilter() {
        return this.vchQFilter != null && this.vchQFilter.get(0) != null;
    }

    private void init(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        this.qprocalIdQfilter = null;
        QFilter qf = (QFilter)filter.getCommFilter().get("acccurrent");
        if (qf != null) {
            this.qprocalIdQfilter = qf;
        }
        this.org = filter.getLong("org");
        this.booktype = filter.getLong("booktype");
        this.startPeriod = (Long)filter.getDynamicObject("startperiod").getPkValue();
        this.endPeriod = (Long)filter.getDynamicObject("endperiod").getPkValue();
        this.currency = filter.getString("currency");
        DynamicObjectCollection dyns = filter.getDynamicObjectCollection("account");
        this.accountIdList = GLUtil.getIdsFromDynCollection((DynamicObjectCollection)dyns, (String)"masterid");
        List iteminfos = param.getFilter().getFlexFilterItems();
        HashSet<Object> itemIds = new HashSet<Object>();
        for (FilterItemInfo filterItemInfo : iteminfos) {
            Set values = (Set)filterItemInfo.getValue();
            for (Object value : values) {
                itemIds.add(value);
            }
        }
        if (!itemIds.isEmpty()) {
            this.qassgrpQfilter = new QFilter("assgrp", "in", ReciprocalLogQueryRpt.getAssistIds(itemIds));
        }
        this.orgFilter = new QFilter("org", "=", (Object)this.org);
        this.bookTypeFilter = new QFilter("booktype", "=", (Object)this.booktype);
        this.periodFilter = new QFilter(PERIOD, ">=", (Object)this.startPeriod).and(new QFilter(PERIOD, "<=", (Object)this.endPeriod));
        this.currencyQfilter = !"allcurrency".equals(this.currency) ? new QFilter("currency", "=", (Object)Long.parseLong(this.currency)) : null;
        this.accountQFilter = new QFilter("account", "in", this.accountIdList);
        FilterInfo filterInfo = param.getFilter();
        Map deFilterMap = filterInfo.getCommFilters();
        this.vchQFilter = (List)deFilterMap.get("gl_voucher");
    }

    private Pair<Set<Long>, Set<Long>> getVchOrgAndPeriod(FilterInfo filterInfo) {
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"org,period", (QFilter[])((List)filterInfo.getCommFilters().get("gl_voucher")).toArray(new QFilter[0]), null);
        Pair orgAndperiod = Pair.of(new HashSet(4), new HashSet(4));
        for (Row row : ds) {
            ((Set)orgAndperiod.getKey()).add(row.getLong("org"));
            ((Set)orgAndperiod.getValue()).add(row.getLong(PERIOD));
        }
        return orgAndperiod;
    }

    private static Set<Object> getAssistIds(Set<Object> set) {
        HashSet<Object> idSet = new HashSet<Object>();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_assist_bd", (String)"hg", (QFilter[])new QFilter[]{new QFilter("assval", "in", set)});
        for (DynamicObject dyn : dyns) {
            idSet.add(dyn.getLong("hg"));
        }
        return idSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (!"allcurrency".equals(this.currency)) {
            for (AbstractReportColumn column : columns) {
                ReportColumn col;
                if (!(column instanceof ReportColumn) || !(col = (ReportColumn)column).getFieldKey().equals("currencyfield")) continue;
                col.setHide(true);
            }
        }
        return super.getColumns(columns);
    }
}

