/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;

public class VoucherSummaryQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log LOG = LogFactory.getLog(VoucherSummaryQueryRpt.class);
    private String currency;
    private String baseCurrency;
    private int maxAccountLevel;
    private int accountLevel;
    private boolean isleaf;
    private static final String DEBIT = "debit";
    private static final String CREDIT = "credit";
    private static final String DEBIT_FOR = "debitfor";
    private static final String CREDIT_FOR = "creditfor";
    private static final String DEBIT_LOCAL = "debitlocal";
    private static final String CREDIT_LOCAL = "creditlocal";
    private static final String CURRENCY_FOR = "currencyid";
    private static final String CURRENCY_LOCAL = "curlocal";
    private DataSet accountNameDataSet;

    private static LocaleString getdebitforAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u539f\u5e01", (String)"VoucherSummaryQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getcreditforAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u539f\u5e01", (String)"VoucherSummaryQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getdebitlocalAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u672c\u4f4d\u5e01", (String)"VoucherSummaryQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getcreditlocalAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"VoucherSummaryQueryRpt_3", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getdebitAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9\u53d1\u751f\u989d", (String)"VoucherSummaryQueryRpt_4", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getcreditAmt() {
        return new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9\u53d1\u751f\u989d", (String)"VoucherSummaryQueryRpt_5", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        DataSet voucherDataset = this.queryVoucher(param);
        if (!this.currency.equals("allcurrency")) {
            voucherDataset = voucherDataset.select("number,name,accnumber,parentid,level,isleaf,debit,credit,currencyid").groupBy(new String[]{"number", "name", "accnumber", "parentid", "level", CURRENCY_FOR, "isleaf"}).sum(DEBIT).sum(CREDIT).finish();
            DataSet sumVoucher = voucherDataset.copy();
            DataSet totalDataset = this.totalDataset(voucherDataset, DEBIT, CREDIT, CURRENCY_FOR);
            sumVoucher = this.gainSuperAccountHelper(sumVoucher, this.getAccountSet(), this.maxAccountLevel);
            if (this.isleaf) {
                sumVoucher = sumVoucher.orderBy(new String[]{"accnumber"});
                sumVoucher = sumVoucher.filter("isleaf = true");
            } else {
                sumVoucher = sumVoucher.filter("level <= " + this.accountLevel);
            }
            sumVoucher = this.mergeSameAccount(sumVoucher, param);
            DataSet dataset = sumVoucher.union(totalDataset);
            return dataset.orderBy(new String[]{"accnumber"});
        }
        DataSet totalDataset = this.totalDataset(voucherDataset, DEBIT_LOCAL, CREDIT_LOCAL, CURRENCY_LOCAL);
        totalDataset = totalDataset.addField("0L", DEBIT_FOR).addField("0L", CREDIT_FOR).addField("99999L", CURRENCY_FOR);
        DataSet accAndCurTotal = voucherDataset.select("number,name,accnumber,parentid,level,isleaf,currencyid,debitfor,debitlocal,creditfor,creditlocal,curlocal").groupBy(new String[]{"number", "name", "accnumber", "parentid", "level", "isleaf", CURRENCY_FOR, CURRENCY_LOCAL}).sum(DEBIT_LOCAL).sum(CREDIT_LOCAL).sum(DEBIT_FOR).sum(CREDIT_FOR).finish();
        DataSet accAndCurTotalCopy = accAndCurTotal.copy();
        DataSet accAndCurTotalUp = this.gainSuperAccountHelper(accAndCurTotalCopy, this.getAccountSet(), this.maxAccountLevel);
        accAndCurTotalUp = this.mergeSameAccount(accAndCurTotalUp, param);
        DataSet accTotalDataset = accAndCurTotalUp.select("number,name,accnumber,parentid,level,isleaf,debitlocal,creditlocal").groupBy(new String[]{"number", "name", "accnumber", "parentid", "level", "isleaf"}).sum(DEBIT_LOCAL).sum(CREDIT_LOCAL).finish();
        accTotalDataset = accTotalDataset.addField("0L", DEBIT_FOR).addField("0L", CREDIT_FOR).addField("0L", CURRENCY_FOR).addField(this.baseCurrency, CURRENCY_LOCAL);
        accAndCurTotalUp = this.realignColumn(accAndCurTotalUp).union(this.realignColumn(accTotalDataset)).union(this.realignColumn(totalDataset));
        if (this.isleaf) {
            accAndCurTotalUp = accAndCurTotalUp.orderBy(new String[]{"accnumber", CURRENCY_FOR});
            accAndCurTotalUp = accAndCurTotalUp.filter("isleaf = true");
        } else {
            accAndCurTotalUp = accAndCurTotalUp.filter("level <= " + this.accountLevel).orderBy(new String[]{"accnumber", CURRENCY_FOR});
        }
        return accAndCurTotalUp;
    }

    private DataSet mergeSameAccount(DataSet mergeDataSet, ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        if (Objects.equals(filter.getLong("startperiod"), filter.getLong("endperiod"))) {
            return mergeDataSet;
        }
        List<String> mergeCols = this.getMergeNameCols(mergeDataSet);
        List colList = GLUtil.getDataSetCols((DataSet)mergeDataSet);
        mergeDataSet = mergeDataSet.join(this.accountNameDataSet, JoinType.LEFT).on("number", "id").select(colList.toArray(new String[0]), new String[]{"id mnumber", "name mname", "accnumber maccnumber", "parentid mparentid", "level mlevel", "isleaf misleaf"}).finish().select(mergeCols.toArray(new String[0]));
        mergeDataSet = !this.currency.equals("allcurrency") ? mergeDataSet.groupBy(new String[]{"parentid", CURRENCY_FOR, "accnumber", "name", "level", "isleaf", "number"}).sum(DEBIT).sum(CREDIT).finish().select(colList.toArray(new String[0])) : mergeDataSet.groupBy(new String[]{"parentid", CURRENCY_FOR, "accnumber", "name", "level", "isleaf", "number", CURRENCY_LOCAL}).sum(DEBIT_LOCAL).sum(CREDIT_LOCAL).sum(DEBIT_FOR).sum(CREDIT_FOR).finish().select(colList.toArray(new String[0]));
        return mergeDataSet;
    }

    private List<String> getMergeNameCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        List<String> mlist = Arrays.asList("parentid", "accnumber", "name", "level", "isleaf", "number");
        for (Field field : fields) {
            String fieldName = field.getName();
            if (mlist.contains(fieldName)) {
                list.add("case when m" + fieldName + " is null then " + fieldName + " else m" + fieldName + " end as " + fieldName);
                continue;
            }
            list.add(fieldName);
        }
        return list;
    }

    public DataSet queryVoucher(ReportQueryParam param) {
        long tick = System.currentTimeMillis();
        FilterInfo filterInfo = param.getFilter();
        long orgid = filterInfo.getLong("org");
        this.maxAccountLevel = BusinessDataServiceHelper.loadSingle((Object)filterInfo.getLong("accounttable"), (String)"bd_accounttable").getInt("maxlevel");
        this.accountLevel = filterInfo.getInt("accountlevel");
        this.isleaf = filterInfo.getBoolean("showleafaccount");
        this.currency = (String)filterInfo.getValue("currency");
        QFilter org = new QFilter("org", "=", (Object)orgid);
        QFilter booktype = new QFilter("booktype", "=", ((DynamicObject)filterInfo.getValue("booktype")).get("id"));
        QFilter starttime = new QFilter("period", ">=", ((DynamicObject)filterInfo.getValue("startperiod")).getPkValue());
        QFilter endtime = new QFilter("period", "<=", ((DynamicObject)filterInfo.getValue("endperiod")).getPkValue());
        QFilter vouchBillstatus = new QFilter("billstatus", "in", (Object)new Object[]{Character.valueOf('B'), Character.valueOf('C')});
        if (this.currency.equals("basecurrency") || this.currency.equals("allcurrency")) {
            long bookType = filterInfo.getLong("booktype");
            long baseCurrency = this.getBaseCurrency(orgid, bookType);
            this.baseCurrency = String.valueOf(baseCurrency);
        }
        QFilter currency = null;
        if (!this.currency.equals("allcurrency") && !this.currency.equals("basecurrency")) {
            currency = new QFilter("entries.currency", "=", (Object)Long.valueOf(this.currency));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(org);
        filters.add(booktype);
        filters.add(starttime);
        filters.add(endtime);
        filters.add(vouchBillstatus);
        QFilter voufilter = filterInfo.getCommFilter("gl_voucher");
        if (voufilter != null) {
            filters.add(voufilter);
        }
        String select = "entries.account.id number,entries.debitori debit,entries.creditori credit,entries.currency currencyid";
        if (filterInfo.getValue("currency").equals("basecurrency")) {
            select = "entries.account.id number,entries.debitlocal debit,entries.creditlocal credit,localcur currencyid";
        } else if (filterInfo.getValue("currency").equals("allcurrency")) {
            select = "entries.account.id number,entries.debitori debitfor,entries.debitlocal debitlocal,entries.creditori creditfor,entries.creditlocal creditlocal,entries.currency currencyid,localcur curlocal";
        } else {
            filters.add(currency);
        }
        select = "id,attachment,billno," + select;
        if (DebugTrace.enable()) {
            LOG.info("report query filter as: " + StringUtils.join((Object[])new List[]{filters}));
        }
        DataSet dataset = VoucherQueryUtils.queryDataSet((String)select, (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)-1);
        LOG.info("queryVoucherCost:queryDataSet:{}ms", (Object)(System.currentTimeMillis() - tick));
        tick = System.currentTimeMillis();
        ThreadService.execute(() -> {
            DataSet summaryDataSet = VoucherQueryUtils.queryDataSet((String)"id,attachment,billno", (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)-1);
            HashMap<Long, Integer> tempMap = new HashMap<Long, Integer>();
            String min = "";
            String max = "";
            for (Row row : summaryDataSet) {
                tempMap.put(row.getLong("id"), row.getInteger("attachment"));
                String billno = row.getString("billno");
                if (min.equals("")) {
                    min = billno;
                    max = billno;
                    continue;
                }
                if (billno.compareTo(min) < 0) {
                    min = billno;
                    continue;
                }
                if (billno.compareTo(max) <= 0) continue;
                max = billno;
            }
            int idCount = tempMap.size();
            String id = RequestContext.get().getUserId();
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "VoucherSummaryQueryRpt_count", id), String.valueOf(idCount));
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "VoucherSummaryQueryRpt_showBillno", id), min + " ~ " + max);
            int attachCount = 0;
            attachCount = tempMap.values().stream().mapToInt(Integer::intValue).sum();
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "VoucherSummaryQueryRpt_attachNum", id), String.valueOf(attachCount));
        }, (TaskType)TaskType.GL_VOUCHER_SUMMARY_ASYNC_CAL_DATA);
        Boolean showAccountFullName = (Boolean)Optional.ofNullable(GLUtil.getSystemParam((String)"showfullname", (Long)orgid)).orElse(false);
        String acctNameField = showAccountFullName != false ? "fullname" : "name";
        Long accountTableId = filterInfo.getLong("accounttable");
        QFilter accountidFilter = new QFilter("accounttable.id", "=", (Object)accountTableId);
        this.accountNameDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".account"), (String)"bd_accountview", (String)String.format("masterid,id,%s name,number accnumber,parent parentid,level,isleaf", acctNameField), (QFilter[])new QFilter[]{accountidFilter}, null);
        dataset = dataset.join(this.accountNameDataSet.copy(), JoinType.LEFT).on("number", "id").select(ReportUtils.getDataSetCols((DataSet)dataset).toArray(new String[0]), new String[]{"name", "accnumber", "parentid", "level", "isleaf"}).finish();
        return dataset;
    }

    public DataSet realignColumn(DataSet dataset) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("number");
        list.add("name");
        list.add("accnumber");
        list.add("parentid");
        list.add("level");
        list.add("isleaf");
        list.add(CURRENCY_FOR);
        list.add(CURRENCY_LOCAL);
        list.add(DEBIT_FOR);
        list.add(DEBIT_LOCAL);
        list.add(CREDIT_FOR);
        list.add(CREDIT_LOCAL);
        dataset = dataset.select(list.toArray(new String[0]));
        return dataset;
    }

    public DataSet totalDataset(DataSet dataset, String debit, String credit, String cur) {
        DataSet set = dataset.select(new String[]{debit, credit, cur}).groupBy(new String[]{cur}).sum(debit).sum(credit).finish();
        DataSet totalDataset = set.addField("0L", "number").addField(String.format("'%s'", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"VoucherSummaryQueryRpt_6", (String)"fi-gl-report", (Object[])new Object[0])), "name").addField("'99999'", "accnumber").addField("0L", "parentid").addField("1", "level").addField("true", "isleaf");
        ArrayList<String> list = new ArrayList<String>();
        list.add("number");
        list.add("name");
        list.add("accnumber");
        list.add("parentid");
        list.add("level");
        list.add(cur);
        list.add("isleaf");
        list.add(debit);
        list.add(credit);
        totalDataset = totalDataset.select(list.toArray(new String[0]));
        return totalDataset;
    }

    public long getBaseCurrency(long org, long bookType) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)bookType);
        DynamicObject baseCurrency = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
        return baseCurrency.getLong("basecurrency");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn currencyColumn = (ReportColumn)columns.get(2);
        ReportColumn currencyLocalColumn = (ReportColumn)columns.get(3);
        if (this.currency.equals("allcurrency")) {
            currencyColumn.setHide(false);
            currencyLocalColumn.setHide(true);
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getdebitforAmt(), DEBIT_FOR, "amount"));
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getdebitlocalAmt(), DEBIT_LOCAL, "amount"));
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getcreditforAmt(), CREDIT_FOR, "amount"));
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getcreditlocalAmt(), CREDIT_LOCAL, "amount"));
            return super.getColumns(columns);
        }
        if (this.currency.equals("basecurrency")) {
            currencyColumn.setHide(true);
            currencyLocalColumn.setHide(true);
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getdebitAmt(), DEBIT, "amount"));
            columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getcreditAmt(), CREDIT, "amount"));
            return super.getColumns(columns);
        }
        currencyColumn.setHide(true);
        currencyLocalColumn.setHide(true);
        columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getdebitAmt(), DEBIT, "amount"));
        columns.add((AbstractReportColumn)this.createColumn(VoucherSummaryQueryRpt.getcreditAmt(), CREDIT, "amount"));
        return super.getColumns(columns);
    }

    public ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if (DEBIT.equals(fieldKey) || CREDIT.equals(fieldKey) || DEBIT_LOCAL.equals(fieldKey) || CREDIT_LOCAL.equals(fieldKey)) {
            column.setHyperlink(true);
        }
        if ("amount".equals(fieldType)) {
            if (fieldKey.endsWith("local")) {
                column.setCurrencyField(CURRENCY_LOCAL);
            } else {
                column.setCurrencyField(CURRENCY_FOR);
            }
        }
        return column;
    }

    private DataSet gainSuperAccountHelper(DataSet set, DataSet account, int accountLevel) {
        List cols = ReportUtils.getDataSetCols((DataSet)set);
        Field[] oldFields = set.getRowMeta().getFields();
        DataSet tempSet = null;
        tempSet = this.currency.equals("allcurrency") ? set.filter("level = " + accountLevel).select(cols.toArray(new String[0])).groupBy(new String[]{"parentid", CURRENCY_FOR, CURRENCY_LOCAL}).sum(DEBIT_LOCAL).sum(CREDIT_LOCAL).sum(DEBIT_FOR).sum(CREDIT_FOR).finish() : set.filter("level = " + accountLevel).select(cols.toArray(new String[0])).groupBy(new String[]{"parentid", CURRENCY_FOR}).sum(DEBIT).sum(CREDIT).finish();
        tempSet = ReportUtils.gainSumSetHelper((DataSet)tempSet, (Field[])oldFields);
        List dsCols = ReportUtils.getDataSetCols((DataSet)tempSet);
        ArrayList<String> parentAcc = new ArrayList<String>(Arrays.asList("number", "name", "accnumber", "parentid", "level"));
        dsCols.removeIf(parentAcc::contains);
        tempSet = tempSet.join(account, JoinType.INNER).on("parentid", "number").select(dsCols.toArray(new String[0]), parentAcc.toArray(new String[0])).finish();
        if (--accountLevel > 0) {
            tempSet = tempSet.select(cols.toArray(new String[0]));
            set = set.union(tempSet);
            set = this.gainSuperAccountHelper(set, account, accountLevel);
        }
        return set;
    }

    private DataSet getAccountSet() {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id number,name,number accnumber,parent parentid,level", null, null);
    }
}

