/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalLogFunction;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalLogSelector
implements ISelector {
    private AccBalReportQuery accBalQuery;
    private List<String> queryField;
    private String selectField;
    private QFilter[] qFilters;
    private OutPutFunction outPutFunction;
    private MulOrgQPRpt qpRpt;
    private int[] groupIndexes;
    private int[] beginIndexes;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int orgIndex;
    private int periodIndex;
    private int entryDCIndex;
    private int accountIndex;
    private int countIndex;

    public AccBalLogSelector(AccBalReportQuery accBalQuery) {
        this.accBalQuery = accBalQuery;
        this.qpRpt = accBalQuery.getQueryParam();
        this.initQueryField();
        this.initQFilters();
        this.initGroupIndexes();
        this.initIndexes();
        this.outPutFunction = new AccBalLogFunction(this);
    }

    private void initIndexes() {
        this.beginIndexes = this.setIndexes("begin");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.accountIndex = this.queryField.indexOf("account");
        this.orgIndex = this.queryField.indexOf("org");
        this.periodIndex = this.queryField.indexOf("period");
        this.countIndex = this.queryField.indexOf("count");
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator<String> iterator = this.merge(flag).iterator();
        block12: while (iterator.hasNext()) {
            String field;
            switch (field = iterator.next()) {
                case "beginqty": {
                    list.add(this.queryField.indexOf("debitqty-creditqty beginqty"));
                    continue block12;
                }
                case "debitlocal": 
                case "creditlocal": 
                case "beginlocal": {
                    Optional<String> fieldOptional = this.queryField.stream().filter(x -> x.endsWith(field)).findFirst();
                    list.add(this.queryField.indexOf(fieldOptional.get()));
                    continue block12;
                }
                case "beginfor": {
                    list.add(this.queryField.indexOf("debitfor-creditfor beginfor"));
                    continue block12;
                }
            }
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private List<String> merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.accBalQuery.getOutPutIndex().getTypes().split(",")) {
                list.add(pre + suf);
            }
        }
        return list;
    }

    private void initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getEndPeriod()));
        list.add(new QFilter("period", ">=", (Object)(this.qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        list.add(new QFilter("calculated", "=", (Object)"0"));
        if (this.qpRpt.getMasterIdSet() != null) {
            Set mids = this.accBalQuery.getMasterIdMap().keySet().stream().collect(Collectors.toSet());
            if (!this.accBalQuery.getAllMasterIdMap().isEmpty()) {
                this.accBalQuery.getAllMasterIdMap().keySet().stream().forEach(x -> mids.add(x));
            }
            list.add(new QFilter("account", "in", mids));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> key));
        this.qFilters = list.toArray(new QFilter[0]);
    }

    private void initQueryField() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency");
        }
        if (!this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> sels.add((String)x.t1));
        }
        if (this.qpRpt.isShowOrg() || this.qpRpt.isShowRpt() || this.qpRpt.isShowOrgTree()) {
            sels.add("org");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("debitqty");
            sels.add("creditqty");
            sels.add("debitqty-creditqty beginqty");
            sels.add("measureunit");
        }
        sels.add("period");
        sels.add("count");
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addBalanceLogAmountFields(sels, (String)mulcur);
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("debitfor");
            sels.add("creditfor");
            sels.add("debitfor-creditfor beginfor");
        }
        this.selectField = ((Object)sels).toString().replace("[", "").replace("]", "");
        this.queryField = new ArrayList<String>(sels.size());
        for (String sel : sels) {
            this.queryField.add(sel);
        }
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public AccBalReportQuery getReportQuery() {
        return this.accBalQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filters) {
        filters = filters == null ? this.qFilters : filters;
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance_log", (String)this.selectField, (QFilter[])filters, null);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    private void initGroupIndexes() {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        for (String groupByField : this.accBalQuery.getGroupByFields()) {
            list.add(this.queryField.indexOf(groupByField));
        }
        this.groupIndexes = list.stream().mapToInt(x -> x).toArray();
    }

    public int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public int getEntryDCIndex() {
        return this.entryDCIndex;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    public void setCountIndex(int countIndex) {
        this.countIndex = countIndex;
    }

    public int[] getBeginIndexes() {
        return this.beginIndexes;
    }

    public void setBeginIndexes(int[] beginIndexes) {
        this.beginIndexes = beginIndexes;
    }
}

