/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.RowMeta;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.OutPutIndex;

public class AccBalOutPutIndex
implements OutPutIndex {
    private RowMeta rowMeta;
    private int fieldCount;
    private String types;
    private List<Integer> countIndexes;
    private List<Integer> endIndexes;
    private List<Integer> beginIndexes;
    private List<Integer> yearIndexes;
    private List<Integer> debitBalanceIndexes;
    private List<Integer> creditBalanceIndexes;
    private int[] groupIndexes;
    private int[] yearBDebitIndexes;
    private int[] yearBCreditIndexes;
    private int[] beginDebitIndexes;
    private int[] beginCreditIndexes;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int[] endDebitIndexes;
    private int[] endCreditIndexes;
    private int[] yearDebitIndexes;
    private int[] yearCreditIndexes;
    private Map<Integer, Integer> rptLocalIndexMap;
    private int accountIndex;
    private int currencyIndex;
    private int orgIndex;
    private int assgrpIndex;
    private int measureunitIndex;
    private int countIndex;
    private int periodIndex;

    public AccBalOutPutIndex(AccBalReportQuery accBalQuery) {
        this.rowMeta = accBalQuery.getRowMeta();
        this.fieldCount = this.rowMeta.getFieldCount();
        MulOrgQPRpt qpRpt = accBalQuery.getQueryParam();
        this.countIndexes = new ArrayList<Integer>();
        this.beginIndexes = new ArrayList<Integer>();
        this.endIndexes = new ArrayList<Integer>();
        this.yearIndexes = new ArrayList<Integer>();
        this.debitBalanceIndexes = new ArrayList<Integer>();
        this.creditBalanceIndexes = new ArrayList<Integer>();
        this.countIndexes.add(this.rowMeta.getFieldIndex("count"));
        String prefix = "begin,end";
        this.types = this.initTypes(qpRpt);
        String rptTypes = qpRpt.isShowRpt() ? this.types + ",rpt" : this.types;
        for (String pre : prefix.split(",")) {
            if (Objects.equals(pre, "begin")) {
                for (String suf : rptTypes.split(",")) {
                    this.putIt(this.beginIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "debit", suf)));
                    this.putIt(this.beginIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "credit", suf)));
                }
                continue;
            }
            if (!Objects.equals(pre, "end")) continue;
            for (String suf : rptTypes.split(",")) {
                this.putIt(this.endIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "debit", suf)));
                this.putIt(this.endIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "credit", suf)));
            }
        }
        prefix = "yearb,begin,end";
        for (String pre : prefix.split(",")) {
            for (String suf : rptTypes.split(",")) {
                this.putIt(this.debitBalanceIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "debit", suf)));
                this.putIt(this.creditBalanceIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "credit", suf)));
            }
        }
        prefix = "year";
        for (String pre : prefix.split(",")) {
            for (String suf : rptTypes.split(",")) {
                this.putIt(this.yearIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "debit", suf)));
                this.putIt(this.yearIndexes, this.rowMeta.getFieldIndex(String.join((CharSequence)"", pre, "credit", suf)));
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        for (String groupByField : accBalQuery.getGroupByFields()) {
            list.add(this.rowMeta.getFieldIndex(groupByField));
        }
        this.groupIndexes = list.stream().mapToInt(x -> x).toArray();
        this.yearBDebitIndexes = this.setIndexes("yearbdebit");
        this.yearBCreditIndexes = this.setIndexes("yearbcredit");
        this.beginDebitIndexes = this.setIndexes("begindebit");
        this.beginCreditIndexes = this.setIndexes("begincredit");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.yearDebitIndexes = this.setIndexes("yeardebit");
        this.yearCreditIndexes = this.setIndexes("yearcredit");
        this.endDebitIndexes = this.setIndexes("enddebit");
        this.endCreditIndexes = this.setIndexes("endcredit");
        this.accountIndex = this.rowMeta.getFieldIndex("account", false);
        this.currencyIndex = this.rowMeta.getFieldIndex("currency", false);
        this.orgIndex = this.rowMeta.getFieldIndex("org", false);
        this.assgrpIndex = this.rowMeta.getFieldIndex("assgrp", false);
        this.measureunitIndex = this.rowMeta.getFieldIndex("measureunit", false);
        this.countIndex = this.rowMeta.getFieldIndex("count", false);
        this.periodIndex = this.rowMeta.getFieldIndex("period", false);
        this.rptLocalIndexMap = new HashMap<Integer, Integer>();
        if (qpRpt.isShowRpt()) {
            String[] split;
            for (String s : split = "yearbdebit#,yearbcredit#,begindebit#,begincredit#,debit#,credit#,yeardebit#,yearcredit#,enddebit#,endcredit#".split(",")) {
                int rptIndex = this.rowMeta.getFieldIndex(s.replace("#", "rpt"));
                int localIndex = this.rowMeta.getFieldIndex(s.replace("#", "local"));
                this.rptLocalIndexMap.put(rptIndex, localIndex);
            }
        }
    }

    public int getFieldIndex(String field) {
        return this.rowMeta.getFieldIndex(field);
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        for (String field : this.merge(flag)) {
            list.add(this.rowMeta.getFieldIndex(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.types.split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    private String initTypes(MulOrgQPRpt qpRpt) {
        StringBuilder sb = new StringBuilder();
        sb.append("local");
        if (qpRpt.isQueryCurrency()) {
            sb.append(",for");
        }
        if (qpRpt.isShowQty()) {
            sb.append(",qty");
        }
        return sb.toString();
    }

    private void putIt(List<Integer> list, int idx) {
        if (idx != -1) {
            list.add(idx);
        }
    }

    @Override
    public int getAccountIndex() {
        return this.accountIndex;
    }

    @Override
    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    @Override
    public int getOrgIndex() {
        return this.orgIndex;
    }

    @Override
    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    @Override
    public int getMeasureunitIndex() {
        return this.measureunitIndex;
    }

    @Override
    public List<Integer> getCountIndexes() {
        return this.countIndexes;
    }

    @Override
    public List<Integer> getEndIndexes() {
        return this.endIndexes;
    }

    @Override
    public List<Integer> getBeginIndexes() {
        return this.beginIndexes;
    }

    @Override
    public List<Integer> getYearIndexes() {
        return this.yearIndexes;
    }

    @Override
    public List<Integer> getDebitBalanceIndexes() {
        return this.debitBalanceIndexes;
    }

    @Override
    public List<Integer> getCreditBalanceIndexes() {
        return this.creditBalanceIndexes;
    }

    public int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public int[] getYearBDebitIndexes() {
        return this.yearBDebitIndexes;
    }

    public int[] getYearBCreditIndexes() {
        return this.yearBCreditIndexes;
    }

    public int[] getBeginDebitIndexes() {
        return this.beginDebitIndexes;
    }

    public int[] getBeginCreditIndexes() {
        return this.beginCreditIndexes;
    }

    @Override
    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    @Override
    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int[] getEndDebitIndexes() {
        return this.endDebitIndexes;
    }

    public int[] getEndCreditIndexes() {
        return this.endCreditIndexes;
    }

    public int[] getYearDebitIndexes() {
        return this.yearDebitIndexes;
    }

    public int[] getYearCreditIndexes() {
        return this.yearCreditIndexes;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public String getTypes() {
        return this.types;
    }

    public Map<Integer, Integer> getRptLocalIndexMap() {
        return this.rptLocalIndexMap;
    }
}

