/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.accbalance.AccBalBalSelector;
import kd.fi.gl.report.accbalance.AccBalCollector;
import kd.fi.gl.report.accbalance.AccBalInitBalSelector;
import kd.fi.gl.report.accbalance.AccBalLogSelector;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.accbalance.AccBalVouSelector;

public class AccBalParallelQuery {
    private AccBalReportQuery accBalQuery;

    public AccBalParallelQuery(MulOrgQPRpt qpRpt) {
        this.accBalQuery = new AccBalReportQuery(qpRpt);
    }

    public DataSet execute() throws Exception {
        AccBalCollector collector = new AccBalCollector(this.accBalQuery);
        AccBalBalSelector selector = new AccBalBalSelector(this.accBalQuery);
        AccBalLogSelector logSelectot = new AccBalLogSelector(this.accBalQuery);
        collector.addSelector(selector);
        collector.addSelector(logSelectot);
        if (this.accBalQuery.getQueryParam().isSubstractPL()) {
            AccBalVouSelector vouSelector = new AccBalVouSelector(this.accBalQuery);
            AccBalInitBalSelector initBalSelector = new AccBalInitBalSelector(this.accBalQuery);
            collector.addSelector(vouSelector);
            collector.addSelector(initBalSelector);
        }
        DataSet finish = collector.finish();
        if (!this.accBalQuery.getQueryParam().isOnlyShowDetailData()) {
            finish = finish.addField("account", "accountnumber");
            ArrayList<String> selList = new ArrayList<String>(16);
            List dataSetCols = ReportUtils.getDataSetCols((DataSet)finish);
            for (String dataSetCol : dataSetCols) {
                if (dataSetCol.equals("account")) {
                    selList.add("case when PreRowValue(accountnumber) = accountnumber then null else " + dataSetCol + " end as " + dataSetCol);
                    continue;
                }
                selList.add(dataSetCol);
            }
            finish = finish.select(selList.toArray(new String[0]));
        }
        List dataSetCols = ReportUtils.getDataSetCols((DataSet)finish);
        this.accBalQuery.getQueryParam().getComAssistValsList().stream().forEach(x -> {
            dataSetCols.remove(x.t1);
            dataSetCols.add((String)x.t1 + " " + this.comAssist_Suffix((String)x.t1));
        });
        finish = finish.select(dataSetCols.toArray(new String[dataSetCols.size()]));
        return finish;
    }

    private String comAssist_Suffix(String comAssist) {
        return comAssist + "id";
    }
}

