/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalBalFunction;
import kd.fi.gl.report.accbalance.AccBalOutPutIndex;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.accbalance.AccBalVouSelector;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.RateBean;

public class AccBalVouFunction
implements OutPutFunction {
    private AccBalVouSelector selector;
    private AccBalOutPutIndex opIndex;
    private MulOrgQPRpt qpRpt;
    private Map<Long, RateBean> orgRateMap;
    private long startPeriod;
    private Set<Long> periods;
    private boolean isShowPeriod;

    public AccBalVouFunction(AccBalVouSelector selector) {
        this.selector = selector;
        AccBalReportQuery reportQuery = selector.getReportQuery();
        this.opIndex = reportQuery.getOutPutIndex();
        this.qpRpt = reportQuery.getQueryParam();
        this.orgRateMap = this.qpRpt.getOrgRateMap();
        this.startPeriod = this.qpRpt.getStartPeriod();
        this.periods = this.qpRpt.getPeriods();
        this.isShowPeriod = this.qpRpt.isShowPeriod();
    }

    @Override
    public void output(Row row, ICollector collector) {
        if (this.isShowPeriod) {
            long period = row.getLong(this.selector.getPeriodIndex());
            ArrayList<Object[]> results = new ArrayList<Object[]>(this.periods.size());
            for (Long selectPeriod : this.periods) {
                if (selectPeriod < period) continue;
                Object[] result = this.outputData(row, selectPeriod);
                result[this.selector.getPeriodIndex()] = selectPeriod;
                results.add(result);
            }
            for (Object[] obj : results) {
                collector.collect(obj);
            }
        } else {
            Object[] result = this.outputData(row, this.startPeriod);
            collector.collect(result);
        }
    }

    private Object[] outputData(Row row, long startPeriod) {
        Object[] result = new Object[this.opIndex.getFieldCount()];
        int[] groupIndexes = this.selector.getGroupIndexes();
        int[] opGrpIndexes = this.opIndex.getGroupIndexes();
        for (int i = 0; i < opGrpIndexes.length; ++i) {
            result[opGrpIndexes[i]] = row.get(groupIndexes[i]);
        }
        result[this.opIndex.getAccountIndex()] = row.getLong(this.selector.getAccountIndex());
        String entrydc = row.getString(this.selector.getEntryDCIndex());
        Long period = row.getLong(this.selector.getPeriodIndex());
        int[] debitIndexes = this.selector.getDebitIndexes();
        int[] creditIndexes = this.selector.getCreditIndexes();
        int[] opYearDebitIndexes = this.opIndex.getYearDebitIndexes();
        int[] opYearCreditIndexes = this.opIndex.getYearCreditIndexes();
        if (period / GLUtil.YEAR_PERIOD_L == this.qpRpt.getEndPeriod() / GLUtil.YEAR_PERIOD_L) {
            this.copyValue(result, row, opYearDebitIndexes, debitIndexes);
            this.copyValue(result, row, opYearCreditIndexes, creditIndexes);
        }
        this.handleQty(result, entrydc, "year");
        int[] opEndDebitIndexes = this.opIndex.getEndDebitIndexes();
        int[] opEndCreditIndexes = this.opIndex.getEndCreditIndexes();
        if (period < startPeriod) {
            this.copyValue(result, row, this.opIndex.getBeginDebitIndexes(), debitIndexes);
            this.copyValue(result, row, this.opIndex.getBeginCreditIndexes(), creditIndexes);
            this.copyValue(result, row, opEndDebitIndexes, debitIndexes);
            this.copyValue(result, row, opEndCreditIndexes, creditIndexes);
            this.handleQty(result, entrydc, "begin");
            this.handleQty(result, entrydc, "end");
        } else {
            int countIndex = this.opIndex.getCountIndex();
            if (countIndex != -1) {
                result[countIndex] = -1;
            }
            this.copyValue(result, row, this.opIndex.getDebitIndexes(), debitIndexes);
            this.copyValue(result, row, this.opIndex.getCreditIndexes(), creditIndexes);
            this.copyValue(result, row, opEndDebitIndexes, debitIndexes);
            this.copyValue(result, row, opEndCreditIndexes, creditIndexes);
            this.handleQty(result, entrydc, "");
            this.handleQty(result, entrydc, "end");
        }
        int[] opYearBDebitIndexes = this.opIndex.getYearBDebitIndexes();
        for (int i = 0; i < opYearBDebitIndexes.length; ++i) {
            Object endDebit = RptUtil.subtract(result[opEndDebitIndexes[i]], result[opEndCreditIndexes[i]]);
            Object yearDebit = RptUtil.subtract(result[opYearDebitIndexes[i]], result[opYearCreditIndexes[i]]);
            result[opYearBDebitIndexes[i]] = RptUtil.subtract(endDebit, yearDebit);
        }
        Map<Integer, Integer> rptLocalIndexMap = this.opIndex.getRptLocalIndexMap();
        AccBalBalFunction.setRptAmount(row, result, rptLocalIndexMap, this.orgRateMap, this.selector.getOrgIndex());
        return result;
    }

    private void handleQty(Object[] result, String entrydc, String prefix) {
        if (this.qpRpt.isShowQty()) {
            if ("1".equals(entrydc)) {
                result[this.opIndex.getFieldIndex((String)new StringBuilder().append((String)prefix).append((String)"creditqty").toString())] = BigDecimal.ZERO;
            } else {
                result[this.opIndex.getFieldIndex((String)new StringBuilder().append((String)prefix).append((String)"debitqty").toString())] = BigDecimal.ZERO;
            }
        }
    }

    private void copyValue(Object[] result, Row row, int[] opIndexes, int[] ipIndexes) {
        for (int i = 0; i < opIndexes.length; ++i) {
            result[opIndexes[i]] = row.getBigDecimal(ipIndexes[i]).negate();
        }
    }
}

