/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.accbalance.AccBalVouFunction;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalVouSelector
implements ISelector {
    private AccBalReportQuery accBalQuery;
    private List<String> queryField;
    private String selectField;
    private QFilter[] qFilters;
    private OutPutFunction outPutFunction;
    private MulOrgQPRpt qpRpt;
    private int[] groupIndexes;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int orgIndex;
    private int periodIndex;
    private int entryDCIndex;
    private int accountIndex;

    public AccBalVouSelector(AccBalReportQuery accBalQuery) {
        this.accBalQuery = accBalQuery;
        this.qpRpt = accBalQuery.getQueryParam();
        this.initQueryField();
        this.initQFilters();
        this.initGroupIndexes();
        this.initIndexes();
        this.outPutFunction = new AccBalVouFunction(this);
    }

    private void initIndexes() {
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.orgIndex = this.queryField.indexOf("org");
        this.periodIndex = this.queryField.indexOf("period");
        this.entryDCIndex = this.queryField.indexOf("entrydc");
        this.accountIndex = this.queryField.indexOf("account");
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String field : this.merge(flag)) {
            if (field.endsWith("qty")) {
                list.add(this.queryField.indexOf("qty"));
                continue;
            }
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private List<String> merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.accBalQuery.getOutPutIndex().getTypes().split(",")) {
                list.add(pre + suf);
            }
        }
        return list;
    }

    private void initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        DynamicObject curYearMinPeriod = GLUtil.getCurYearMinPeriod((Object)this.qpRpt.getStartPeriod());
        list.add(new QFilter("period", ">=", curYearMinPeriod.getPkValue()));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getEndPeriod()));
        if (this.qpRpt.getMasterIdSet() != null) {
            Set mids = this.accBalQuery.getMasterIdMap().keySet().stream().collect(Collectors.toSet());
            if (!this.accBalQuery.getAllMasterIdMap().isEmpty()) {
                this.accBalQuery.getAllMasterIdMap().keySet().stream().forEach(x -> mids.add(x));
            }
            list.add(new QFilter("entries.account.masterid", "in", mids));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        list.add(new QFilter("sourcetype", "=", (Object)"1"));
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> "entries." + key));
        this.qFilters = list.toArray(new QFilter[0]);
    }

    private void initQueryField() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("entries.account.masterid account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("entries.currency currency");
        }
        if (!this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> sels.add("entries." + (String)x.t1 + " " + (String)x.t1));
        }
        if (this.qpRpt.isShowOrg() || this.qpRpt.isShowRpt() || this.qpRpt.isShowOrgTree()) {
            sels.add("org org");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("entries.assgrp assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("entries.quantity qty");
            sels.add("entries.measureunit measureunit");
        }
        sels.add("period");
        sels.add("entries.entrydc entrydc");
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addVoucherAmountFields(sels, (String)mulcur);
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("entries.debitori debitfor");
            sels.add("entries.creditori creditfor");
        }
        this.selectField = ((Object)sels).toString().replace("[", "").replace("]", "");
        this.queryField = new ArrayList<String>();
        for (String sel : sels) {
            String[] split = sel.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public AccBalReportQuery getReportQuery() {
        return this.accBalQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filters) {
        filters = filters == null ? this.qFilters : filters;
        return VoucherQueryUtils.queryDataSet((String)this.selectField, (QFilter[])filters, null, (int)-1);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    private void initGroupIndexes() {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        for (String groupByField : this.accBalQuery.getGroupByFields()) {
            list.add(this.queryField.indexOf(groupByField));
        }
        this.groupIndexes = list.stream().mapToInt(x -> x).toArray();
    }

    public int[] getGroupIndexes() {
        return this.groupIndexes;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public int getEntryDCIndex() {
        return this.entryDCIndex;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }
}

