/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.treelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;

public class ColIndex {
    private int rowid;
    private int pid;
    private int isgroupnode;
    private int porgid;
    private int accountId;
    private int currencyId;
    private int measureunit;
    private int orgId;
    private int orgName;
    private int forgName;
    private int assgrp;
    private List<Integer> comassists;
    private List<Integer> amounts;

    private ColIndex() {
    }

    public static ColIndex instance() {
        return new ColIndex();
    }

    public static ColIndex instance(RowMeta rowMeta) {
        int cols;
        ColIndex colIndex = ColIndex.instance();
        int orgColIndex = rowMeta.getFieldIndex("org", false);
        int accIdIndex = rowMeta.getFieldIndex("accountnumber", false);
        int porgidIndex = rowMeta.getFieldIndex("porgid", false);
        int measureunitIndex = rowMeta.getFieldIndex("measureunit", false);
        int currencyIndex = rowMeta.getFieldIndex("currency", false);
        int assgrpIndex = -1;
        if (Arrays.stream(rowMeta.getFields()).anyMatch(x -> "assgrp".equals(x.getName()))) {
            assgrpIndex = rowMeta.getFieldIndex("assgrp", false);
        }
        ArrayList<Integer> amountIndexes = new ArrayList<Integer>(8);
        ArrayList<Integer> comassistIndexes = new ArrayList<Integer>(8);
        Field[] fields = rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getDataType().getJavaType() == BigDecimal.class) {
                amountIndexes.add(i);
            }
            if (!field.getName().startsWith("comassist")) continue;
            comassistIndexes.add(i);
        }
        int orgNameIndex = cols = rowMeta.getFieldCount();
        int forgNameIndex = orgNameIndex + 1;
        int rowidIndex = forgNameIndex + 1;
        int pidIndex = rowidIndex + 1;
        int isgroupnodeIndex = pidIndex + 1;
        colIndex.rowid(rowidIndex).pid(pidIndex).porgid(porgidIndex).currencyId(currencyIndex).measureunit(measureunitIndex).forgName(forgNameIndex).isgroupnode(isgroupnodeIndex).accountId(accIdIndex).orgId(orgColIndex).orgName(orgNameIndex).assgrp(assgrpIndex).amounts(amountIndexes).comassists(comassistIndexes);
        return colIndex;
    }

    public int getRowid() {
        return this.rowid;
    }

    public ColIndex rowid(int rowid) {
        this.rowid = rowid;
        return this;
    }

    public int getPid() {
        return this.pid;
    }

    public ColIndex pid(int pid) {
        this.pid = pid;
        return this;
    }

    public int getIsgroupnode() {
        return this.isgroupnode;
    }

    public ColIndex isgroupnode(int isgroupnode) {
        this.isgroupnode = isgroupnode;
        return this;
    }

    public int getPorgid() {
        return this.porgid;
    }

    public ColIndex porgid(int porgid) {
        this.porgid = porgid;
        return this;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public ColIndex accountId(int accountId) {
        this.accountId = accountId;
        return this;
    }

    public int getCurrencyId() {
        return this.currencyId;
    }

    public ColIndex currencyId(int currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public int getMeasureunit() {
        return this.measureunit;
    }

    public ColIndex measureunit(int measureunit) {
        this.measureunit = measureunit;
        return this;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public ColIndex orgId(int orgId) {
        this.orgId = orgId;
        return this;
    }

    public int getOrgName() {
        return this.orgName;
    }

    public ColIndex orgName(int orgName) {
        this.orgName = orgName;
        return this;
    }

    public int getForgName() {
        return this.forgName;
    }

    public ColIndex forgName(int forgName) {
        this.forgName = forgName;
        return this;
    }

    public int getAssgrp() {
        return this.assgrp;
    }

    public ColIndex assgrp(int assgrp) {
        this.assgrp = assgrp;
        return this;
    }

    public List<Integer> getAmounts() {
        return this.amounts;
    }

    public ColIndex amounts(List<Integer> amounts) {
        this.amounts = amounts;
        return this;
    }

    public List<Integer> getComassists() {
        return this.comassists;
    }

    public ColIndex comassists(List<Integer> comassists) {
        this.comassists = comassists;
        return this;
    }
}

