/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.treelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.treelist.ColIndex;
import kd.fi.gl.report.accbalance.treelist.RowWrap;
import kd.fi.gl.util.BiTreeNode;
import kd.fi.gl.vo.OrgVO;

public class RowWrapGroup {
    private long currencyId;
    private int sequence;
    private long accId;
    private boolean isAllCurrency;
    private List<RowWrap> rows = new LinkedList<RowWrap>();
    private Map<Long, RowWrap> orgRowMap = new HashMap<Long, RowWrap>(8);

    public RowWrapGroup(int seq, long accId, long currencyId, boolean isAllCurrency) {
        this.sequence = seq;
        this.accId = accId;
        this.currencyId = currencyId;
        this.isAllCurrency = isAllCurrency;
    }

    public long getAccId() {
        return this.accId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean isAllCurrency() {
        return this.isAllCurrency;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public List<RowWrap> getRows() {
        return this.rows;
    }

    public void rebuildRow(MulOrgQPRpt qpRpt, ColIndex colIndex) {
        if (Long.MAX_VALUE == this.getAccId()) {
            RowWrap totalRow = this.getRows().get(0);
            totalRow.setDataItem(colIndex.getRowid(), String.valueOf(Long.MAX_VALUE));
            totalRow.setDataItem(colIndex.getPid(), "0");
            totalRow.setDataItem(colIndex.getIsgroupnode(), false);
            return;
        }
        RowWrap headRow = new RowWrap();
        ArrayList<RowWrap> detailRowList = new ArrayList<RowWrap>(8);
        for (RowWrap rowWrap : this.rows) {
            if (Objects.isNull(rowWrap.getDataItem(colIndex.getOrgId()))) {
                headRow = rowWrap;
                continue;
            }
            detailRowList.add(rowWrap);
        }
        BiTreeNode sumUpView = qpRpt.getSumUpView();
        long rootOrg = (Long)sumUpView.getId();
        HashMap orgNameMap = new HashMap(8);
        HashMap orgTreeMap = new HashMap(8);
        sumUpView.preTravel(x -> {
            orgNameMap.put(x.getId(), ((OrgVO)x.getData()).getName());
            orgTreeMap.put(x.getId(), x);
        });
        headRow.setDataItem(colIndex.getOrgName(), orgNameMap.get(rootOrg));
        headRow.setDataItem(colIndex.getForgName(), orgNameMap.get(rootOrg));
        if (sumUpView.getChild().isEmpty() && detailRowList.size() > 0) {
            rootOrg = (Long)((RowWrap)detailRowList.get(0)).getDataItem(colIndex.getPorgid());
        }
        headRow.setDataItem(colIndex.getOrgId(), rootOrg);
        HashMap<Long, RowWrap> detailOrgRowMap = new HashMap<Long, RowWrap>(detailRowList.size());
        for (int i = 0; i < detailRowList.size(); ++i) {
            RowWrap rowWrap = (RowWrap)detailRowList.get(i);
            detailOrgRowMap.computeIfAbsent((Long)rowWrap.getDataItem(colIndex.getOrgId()), x -> rowWrap);
        }
        if (!detailOrgRowMap.isEmpty()) {
            detailOrgRowMap.values().stream().forEach(x -> {
                long orgId = (Long)x.getDataItem(colIndex.getOrgId());
                x.setDataItem(colIndex.getOrgName(), orgNameMap.get(orgId));
                x.setDataItem(colIndex.getForgName(), orgNameMap.get(orgId));
                BiTreeNode orgNode = (BiTreeNode)orgTreeMap.get(orgId);
                if (Objects.nonNull(orgNode) && !orgNode.getChild().isEmpty()) {
                    List childNodes = orgNode.getChild();
                    childNodes.stream().forEach(c -> c.setPropValue("isretain", (Object)false));
                }
            });
            sumUpView.preTravel(node -> {
                if (Objects.equals(node.getPropValue("isretain"), false)) {
                    node.setParent(null);
                }
            });
            sumUpView.postTravel(x -> {
                if (Objects.isNull(x.getParent())) {
                    return;
                }
                if (x.getChild().isEmpty()) {
                    return;
                }
                long sumOrgId = (Long)x.getId();
                List childRows = x.getChild().stream().map(c -> (RowWrap)detailOrgRowMap.get(((BiTreeNode)c).getId())).filter(c -> Objects.nonNull(c)).collect(Collectors.toList());
                if (!childRows.isEmpty()) {
                    RowWrap sumRow = ((RowWrap)childRows.get(0)).cloneRow();
                    sumRow.setRowType(RowWrap.RowType.ORG_SUM);
                    sumRow.setDataItem(colIndex.getOrgId(), sumOrgId);
                    sumRow.setDataItem(colIndex.getOrgName(), orgNameMap.get(sumOrgId));
                    sumRow.setDataItem(colIndex.getForgName(), orgNameMap.get(sumOrgId));
                    sumRow.setDataItem(colIndex.getPorgid(), x.getParent().getId());
                    for (Integer amountIndex : colIndex.getAmounts()) {
                        BigDecimal sumValue = BigDecimal.valueOf(0L);
                        for (RowWrap childRow : childRows) {
                            if (!Objects.nonNull(childRow.getDataItem(amountIndex))) continue;
                            sumValue = sumValue.add((BigDecimal)childRow.getDataItem(amountIndex));
                        }
                        sumRow.setAmountDataItem(amountIndex, sumValue);
                    }
                    detailOrgRowMap.put(sumOrgId, sumRow);
                    this.rows.add(sumRow);
                }
            });
            if (detailOrgRowMap.size() == 1) {
                RowWrap curRowWrap = (RowWrap)detailRowList.get(0);
                if (Objects.equals(sumUpView.getId(), curRowWrap.getDataItem(colIndex.getOrgId())) && Objects.equals(qpRpt.getOrgs().size(), 1)) {
                    this.rows.remove(headRow);
                    curRowWrap.setRowType(RowWrap.RowType.SINGLE);
                    curRowWrap.setLevel(0);
                } else {
                    curRowWrap.setLevel(headRow.getLevel() + 1);
                }
            } else {
                Map<String, RowWrap> rowWrapIndex = this.rows.stream().collect(Collectors.toMap(x -> this.buildOrgIdKey(x.getDataItem(colIndex.getOrgId()) == null ? 1L : (Long)x.getDataItem(colIndex.getOrgId()), x.isDetail()), x -> x));
                LinkedList<RowWrap> sortedRows = new LinkedList<RowWrap>();
                sumUpView.preTravel(x -> {
                    boolean isDetail = x.getChild().isEmpty();
                    long orgId = (Long)x.getId();
                    RowWrap curRowWrap = (RowWrap)rowWrapIndex.get(this.buildOrgIdKey(orgId, isDetail));
                    if (Objects.isNull(curRowWrap)) {
                        return;
                    }
                    if (Objects.isNull(x.getParent())) {
                        curRowWrap.setLevel(0);
                    } else {
                        RowWrap parentRowWrap = (RowWrap)rowWrapIndex.get(this.buildOrgIdKey((Long)x.getParent().getId(), false));
                        curRowWrap.setLevel(parentRowWrap.getLevel() + 1);
                    }
                    if (!Objects.nonNull(curRowWrap)) {
                        throw new IllegalStateException("logic error, no found row");
                    }
                    sortedRows.add(curRowWrap);
                });
                this.rows = sortedRows;
            }
        }
        this.refineTreeAttr(colIndex);
        if (detailOrgRowMap.isEmpty()) {
            headRow.setDataItem(colIndex.getIsgroupnode(), false);
        }
    }

    public void addRow(Object[] rowData, ColIndex colIndex) {
        RowWrap.RowType rowType = RowWrap.RowType.DETAIL;
        Object orgId = rowData[colIndex.getOrgId()];
        if (Objects.isNull(rowData[colIndex.getAccountId()])) {
            rowType = RowWrap.RowType.TOTAL;
        } else {
            if (Objects.isNull(orgId)) {
                rowType = RowWrap.RowType.ACCOUNT_SUM;
            }
            if (this.isAllCurrency()) {
                if (Objects.isNull(orgId) && Objects.isNull(rowData[colIndex.getCurrencyId()])) {
                    rowType = RowWrap.RowType.ACCOUNT_SUM;
                } else if (Objects.isNull(rowData[colIndex.getPorgid()])) {
                    rowType = RowWrap.RowType.CURRENCY_SUM;
                }
            }
        }
        RowWrap row = new RowWrap(this, rowData, rowType);
        this.rows.add(row);
        if (Objects.nonNull(orgId)) {
            this.orgRowMap.put(Long.valueOf(orgId.toString()), row);
        }
    }

    public RowWrap getDetailRowByOrgId(long orgId) {
        return this.orgRowMap.get(orgId);
    }

    public void refineTreeAttr(ColIndex colIndex) {
        this.rows.stream().forEach(x -> x.refineTreeAttr(colIndex));
    }

    private String buildOrgIdKey(long orgId, boolean isDetail) {
        return String.format("%s_%s", String.valueOf(orgId), isDetail ? 0 : 1);
    }
}

