/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheLoader;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.schema.basedata.AccountSchema;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.RowIdGenerator;
import kd.fi.gl.report.accbalance.v2.RowLimitManager;
import kd.fi.gl.report.accbalance.v2.collect.OrgTreeInfo;
import kd.fi.gl.report.accbalance.v2.collect.TotalCollectService;
import kd.fi.gl.report.accbalance.v2.collect.TreeNodeUtil;
import kd.fi.gl.report.accbalance.v2.model.AccBalBatchRow;
import kd.fi.gl.report.accbalance.v2.model.BalDetailGroup;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.RateBean;

public class AccBalQueryContext
implements AutoCloseable {
    private static final ThreadLocal<AccBalQueryContext> CURRENT = new ThreadLocal();
    private final MulOrgQPRpt qpRpt;
    private final AccBalBatchRow batchRow;
    private final RowLimitManager rowLimit;
    private final RowIdGenerator rowIdGenerator;
    private final TotalCollectService totalCollectService;
    private Set<Long> leafAcctMids;
    private Map<Long, ThreeTuple<Long, String, String>> acctMid2idAndDcAndLongNum;
    private Map<String, Tuple<Long, Boolean>> longNum2AcctMidAndIsAssist;
    private List<String> comAssistKyes;
    private Map<Long, String> orgId2LongNum;
    private BiMap<String, Long> orgLongNum2Id;
    private final Map<Long, Integer> orgId2Level = new HashMap<Long, Integer>(128);
    private long queryYear = -1L;
    private Boolean queryInitYearAmount;
    private String queryId;
    private RateBean rate;
    private int minParentLevel = 0;
    private final Map<Object, Object> objectCache = new HashMap<Object, Object>(128);
    private final BalDetailGroup zeroGrp = BalDetailGroup.createGrp(this, 0L, 0L, new long[0]);
    private Map<Long, String> acctMid2LongNum;
    private final Map<Long, Tuple<Long, String>> mid2ShowLevelAcct = new HashMap<Long, Tuple<Long, String>>();
    private final Map<String, Boolean> res = new HashMap<String, Boolean>();
    private final Set<String> selectAcctNums;
    private Map<Long, Long> org2ProfitAcct;
    private OrgTreeInfo orgTreeInfo;

    public AccBalQueryContext(MulOrgQPRpt qpRpt, AccBalBatchRow batchRow, RowLimitManager rowLimit, RowIdGenerator rowIdGenerator, TotalCollectService totalCollector) {
        this.qpRpt = qpRpt;
        this.batchRow = batchRow;
        this.rowLimit = rowLimit;
        this.rowIdGenerator = rowIdGenerator;
        this.totalCollectService = totalCollector;
        DynamicObjectCollection acctDyos = qpRpt.getFilterInfo().getDynamicObjectCollection("account");
        this.selectAcctNums = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)acctDyos)) {
            acctDyos.forEach(acct -> this.selectAcctNums.add(acct.getString("longnumber")));
        }
    }

    public static AccBalQueryContext open(MulOrgQPRpt qpRpt, AccBalBatchRow batchRow, RowLimitManager rowLimit, RowIdGenerator rowIdGenerator, TotalCollectService totalCollector) {
        CURRENT.set(new AccBalQueryContext(qpRpt, batchRow, rowLimit, rowIdGenerator, totalCollector));
        return CURRENT.get();
    }

    public Set<Long> getEntityOrgIdSet() {
        List<Long> orgIds = this.batchRow.getOrgIds();
        return CollectionUtils.isEmpty(orgIds) ? this.qpRpt.getFilteredChildOrg() : new HashSet<Long>(orgIds);
    }

    public List<Long> getEntityOrgIds() {
        List orgIds = this.batchRow.getOrgIds();
        return CollectionUtils.isEmpty(orgIds) ? this.qpRpt.getAllEntityOrgs() : orgIds;
    }

    public List<Long> getAcctMids() {
        return this.batchRow.getAcctMids();
    }

    public boolean isLeafAcct(Long mid) {
        if (this.leafAcctMids == null) {
            this.initPOrgAccountInfo();
        }
        return this.leafAcctMids.contains(mid);
    }

    public TreeMap<String, Long> getLongNum2MidTreeMap() {
        Set<String> leafAcctLongNums = this.getAcctMids().stream().map(this::getAcctLongNumByEntityOrgMid).collect(Collectors.toSet());
        HashSet<String> showAcctLongNums = new HashSet<String>(leafAcctLongNums.size());
        if (!this.getStateChart().isShowLeafAccount()) {
            int showLevel = this.getQueryParam().getAccountLevel();
            TreeNodeUtil.getAllSuperLevelTable(leafAcctLongNums, '_').cellSet().forEach(c -> {
                if ((Integer)c.getColumnKey() < showLevel) {
                    showAcctLongNums.add((String)c.getValue());
                }
            });
        } else {
            showAcctLongNums.addAll(leafAcctLongNums);
        }
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        this.getLongNum2AcctMid().forEach((longNum, midAndIsAssist) -> {
            if (showAcctLongNums.contains(longNum)) {
                treeMap.put((String)longNum, (Long)midAndIsAssist.item1);
            }
        });
        return treeMap;
    }

    public Long getAcctIdByMid(Long acctMid) {
        if (this.acctMid2idAndDcAndLongNum == null) {
            this.initPOrgAccountInfo();
        }
        return (Long)this.acctMid2idAndDcAndLongNum.get((Object)acctMid).item1;
    }

    public String getAcctDcByMid(Long acctMid) {
        if (this.acctMid2idAndDcAndLongNum == null) {
            this.initPOrgAccountInfo();
        }
        return (String)this.acctMid2idAndDcAndLongNum.get((Object)acctMid).item2;
    }

    private Map<String, Tuple<Long, Boolean>> getLongNum2AcctMid() {
        if (this.longNum2AcctMidAndIsAssist == null) {
            this.initPOrgAccountInfo();
        }
        return this.longNum2AcctMidAndIsAssist;
    }

    public String getLongNumByMid(Long midOnPOrg) {
        if (this.acctMid2idAndDcAndLongNum == null) {
            this.initPOrgAccountInfo();
        }
        return (String)this.acctMid2idAndDcAndLongNum.get((Object)midOnPOrg).item3;
    }

    private void initPOrgAccountInfo() {
        this.acctMid2idAndDcAndLongNum = new HashMap<Long, ThreeTuple<Long, String, String>>(64);
        this.longNum2AcctMidAndIsAssist = new HashMap<String, Tuple<Long, Boolean>>(128);
        this.leafAcctMids = new HashSet<Long>();
        AccountSchema account = new AccountSchema();
        QFilter rangeF = null;
        List<String> acctNumRange = this.batchRow.getAcctNums();
        if (CollectionUtils.isNotEmpty(acctNumRange)) {
            rangeF = QFilter.of((String)acctNumRange.stream().map(num -> "longnumber like '" + num + "%' ").collect(Collectors.joining(" or ")), (Object[])new Object[0]);
        }
        DataSet acctDs = AccountUtils.getAccountDataSet((long)this.qpRpt.getPorg(), (long)this.qpRpt.getAccountTable(), (Date)PeriodService.getEndDate((long)this.qpRpt.getEndPeriod()), (boolean)false, (QFilter)rangeF, (String[])new String[]{Prop.toSelectFieldStr((Prop[])new Prop[]{account.id, account.masterID, account.longNum, account.isAssist, account.dc, account.isLeaf, account.level})});
        acctDs.forEach(row -> {
            Long mid = account.masterID.longOf(row);
            Boolean isLeaf = account.isLeaf.booleanOf(row);
            Boolean showAssist = isLeaf != false && account.isAssist.booleanOf(row) != false;
            this.longNum2AcctMidAndIsAssist.put(account.longNum.stringOf(row), (Tuple<Long, Boolean>)new Tuple((Object)mid, (Object)showAssist));
            this.acctMid2idAndDcAndLongNum.put(mid, (ThreeTuple<Long, String, String>)new ThreeTuple((Object)account.id.longOf(row), (Object)account.dc.stringOf(row), (Object)account.longNum.stringOf(row)));
            if (isLeaf.booleanValue()) {
                this.leafAcctMids.add(mid);
            }
        });
    }

    public Long getAcctMidByLongNum(String longNum) {
        return Optional.ofNullable(this.getLongNum2AcctMid().get(longNum)).map(r -> (Long)r.item1).orElse(null);
    }

    public MulOrgQPRpt getQueryParam() {
        return this.qpRpt;
    }

    public StateChart getStateChart() {
        return new StateChart(this.getQueryParam());
    }

    public List<String> getCommonAssistKeys() {
        if (this.comAssistKyes == null) {
            MulOrgQPRpt param = this.getQueryParam();
            this.comAssistKyes = param.isShowComassist() ? param.getCommonAssistKeys() : new ArrayList();
        }
        return this.comAssistKyes;
    }

    public String getEntityOrgLongNum(Long orgId) {
        if (orgId == null) {
            return null;
        }
        if (this.orgId2LongNum == null) {
            this.orgId2LongNum = TreeNodeUtil.getOrgLongNums(this.getQueryParam().getOrgViewId(), this.getEntityOrgIdSet());
        }
        return this.orgId2LongNum.getOrDefault(orgId, "");
    }

    public Long getOrgIdByLongNum(String longNum) {
        return this.orgLongNum2Id == null ? null : (Long)this.orgLongNum2Id.get((Object)longNum);
    }

    public void setOrgLongNum2IdMap(Map<String, Long> orgLongNumber2Id) {
        this.orgLongNum2Id = HashBiMap.create(orgLongNumber2Id);
    }

    public Integer getOrgLevelById(Long org) {
        return this.orgId2Level.computeIfAbsent(org, id -> {
            if (this.orgLongNum2Id != null) {
                String longNum = (String)this.orgLongNum2Id.inverse().get((Object)org);
                return TreeNodeUtil.getLongNumLevel(longNum, '!') - 1;
            }
            return 0;
        });
    }

    public long getQueryYear() {
        if (this.queryYear == -1L) {
            this.queryYear = GLUtil.getYear((long)this.getQueryParam().getEndPeriod());
        }
        return this.queryYear;
    }

    public Boolean isQueryInitYearAmount() {
        if (this.queryInitYearAmount == null) {
            this.queryInitYearAmount = GLUtil.getYear((long)this.getQueryParam().getStartPeriod()) == this.getQueryYear();
        }
        return this.queryInitYearAmount;
    }

    public int nextRowId() {
        return this.rowIdGenerator.next();
    }

    public static AccBalQueryContext getCurrent() {
        AccBalQueryContext context = CURRENT.get();
        assert (context != null);
        return context;
    }

    public static AccBalQueryContext setCurrent(AccBalQueryContext context) {
        CURRENT.set(context);
        return AccBalQueryContext.getCurrent();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public void close() {
        CURRENT.remove();
    }

    public RateBean getRptRate() {
        if (this.rate == null) {
            this.rate = (RateBean)this.qpRpt.getRateMap().get(this.qpRpt.getCurLocal());
        }
        return this.rate;
    }

    public int getMinParentLevel() {
        return this.minParentLevel;
    }

    public void setMinParentLevel(int minParentLevel) {
        this.minParentLevel = minParentLevel;
    }

    public TotalCollectService getTotalCollectService() {
        return this.totalCollectService;
    }

    public RowLimitManager getRowLimit() {
        return this.rowLimit;
    }

    public <T> T getFromCache(Object key, CacheLoader<T> loader) {
        Object value = this.objectCache.get(key);
        if (value == null && (value = loader.load()) != null) {
            this.objectCache.put(key, value);
        }
        return (T)value;
    }

    public BalDetailGroup getZeroDetailGrp() {
        return this.zeroGrp;
    }

    public String getAcctLongNumByEntityOrgMid(Long acctMid) {
        if (this.acctMid2LongNum == null) {
            this.initAllEntityAccount();
        }
        return this.acctMid2LongNum.get(acctMid);
    }

    private void initAllEntityAccount() {
        this.acctMid2LongNum = new HashMap<Long, String>(128);
        QFilter rangeF = null;
        List<String> acctNumRange = this.batchRow.getAcctNums();
        if (CollectionUtils.isNotEmpty(acctNumRange)) {
            rangeF = QFilter.of((String)acctNumRange.stream().map(num -> "longnumber like '" + num + "%' ").collect(Collectors.joining(" or ")), (Object[])new Object[0]);
        }
        AccountSchema account = new AccountSchema();
        DataSet acctDs = AccountUtils.getAccountDataSet((long)this.qpRpt.getAccountTable(), (Date)PeriodService.getEndDate((long)this.qpRpt.getEndPeriod()), (boolean)false, (QFilter)rangeF, (String[])new String[]{Prop.toSelectFieldStr((Prop[])new Prop[]{account.id, account.masterID, account.longNum})});
        for (Row acctRow : acctDs) {
            Long mid = account.masterID.longOf(acctRow);
            this.acctMid2LongNum.put(mid, account.longNum.stringOf(acctRow));
        }
    }

    public Tuple<Long, String> getShowAcctMidAndLongNum(Long leafAcctMid) {
        return this.mid2ShowLevelAcct.computeIfAbsent(leafAcctMid, mid -> {
            int showLevel;
            String leafLongNum = this.getAcctLongNumByEntityOrgMid((Long)mid);
            int longNumLevel = TreeNodeUtil.getLongNumLevel(leafLongNum, '_');
            while (this.getAcctMidByLongNum(leafLongNum) == null) {
                leafLongNum = TreeNodeUtil.getSubLongNumByLevel(leafLongNum, --longNumLevel, '_');
            }
            MulOrgQPRpt param = this.getQueryParam();
            int n = showLevel = param.isShowLeafAccount() ? Integer.MAX_VALUE : param.getAccountLevel();
            if (longNumLevel > showLevel) {
                leafLongNum = TreeNodeUtil.getSubLongNumByLevel(leafLongNum, showLevel, '_');
            }
            mid = this.getAcctMidByLongNum(leafLongNum);
            return new Tuple(mid, (Object)leafLongNum);
        });
    }

    public boolean needShowAcctNum(String leafLongNum) {
        if (!this.qpRpt.isShowLeafAccount() && this.selectAcctNums.size() > 0) {
            return this.res.computeIfAbsent(leafLongNum, longNum -> {
                boolean bl;
                if (!this.selectAcctNums.contains(longNum)) {
                    if (!this.selectAcctNums.stream().anyMatch(longNum::startsWith)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            });
        }
        return true;
    }

    public boolean needShowAssist(String longNum) {
        return (Boolean)this.getLongNum2AcctMid().get((Object)longNum).item2;
    }

    public List<Long> getEOrgAcctMidsByLongNum(String parentLongNum) {
        if (this.acctMid2LongNum == null) {
            this.initAllEntityAccount();
        }
        ArrayList<Long> res = new ArrayList<Long>(16);
        this.acctMid2LongNum.forEach((mid, longNum) -> {
            if (longNum.startsWith(parentLongNum)) {
                res.add((Long)mid);
            }
        });
        return res;
    }

    public boolean isQueryProfitAcct() {
        if (this.org2ProfitAcct == null) {
            this.org2ProfitAcct = this.getOrgProfitAccMap();
        }
        return !this.org2ProfitAcct.isEmpty();
    }

    public boolean hasProfitAcct(Long org) {
        if (this.org2ProfitAcct == null) {
            this.org2ProfitAcct = this.getOrgProfitAccMap();
        }
        return this.org2ProfitAcct.containsKey(org);
    }

    public Long getProfitAcct(Long org) {
        if (this.org2ProfitAcct == null) {
            this.org2ProfitAcct = this.getOrgProfitAccMap();
        }
        return this.org2ProfitAcct.get(org);
    }

    private Map<Long, Long> getOrgProfitAccMap() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        QFilter masterIdQF = new QFilter("yearprofitacct.masterid", "in", this.getAcctMids());
        BatchProcessUtil.batchQueryDataSet(this.getEntityOrgIdSet(), batchOrgs -> {
            QFilter orgQF = new QFilter("org", "in", batchOrgs);
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_transplprogram", (String)"org,yearprofitacct.masterid masterid", (QFilter[])new QFilter[]{masterIdQF, orgQF}, (String)"billno");
        }).forEach(d -> result.putIfAbsent(d.getLong("org"), d.getLong("masterid")));
        return result;
    }

    public OrgTreeInfo getOrgTreeInfo() {
        return this.orgTreeInfo;
    }

    public void setOrgTreeInfo(OrgTreeInfo orgTreeInfo) {
        this.orgTreeInfo = orgTreeInfo;
    }
}

