/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.model.IBalanceRow;
import kd.fi.gl.report.accbalance.v2.model.StateChart;
import kd.fi.gl.util.GLUtil;

public class AccBalQueryUtil {
    public static final String ACCOUNT_MID = "accountmid";
    public static final String ACCOUNT_M_NUM = "accountmid.number";

    public static Iterator<IBalanceRow> createItr(final DataSet dataSet, final Function<Row, IBalanceRow> createRowFunc) {
        return new Iterator<IBalanceRow>(){

            @Override
            public boolean hasNext() {
                return dataSet.hasNext();
            }

            @Override
            public IBalanceRow next() {
                if (this.hasNext()) {
                    return (IBalanceRow)createRowFunc.apply(dataSet.next());
                }
                return null;
            }
        };
    }

    public static List<QFilter> getBalBaseFilters(MulOrgQPRpt qpRpt, AccBalQueryContext context) {
        return AccBalQueryUtil.getBalBaseFilters(qpRpt, context.getEntityOrgIdSet(), context.getAcctMids());
    }

    public static List<QFilter> getBalBaseFilters(MulOrgQPRpt qpRpt, Set<Long> orgIds, List<Long> acctMids) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("accounttable", "=", (Object)qpRpt.getAccountTable()));
        filters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)qpRpt.getStartPeriod(), (Long[])orgIds.toArray(new Long[0]))));
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        filters.add(new QFilter("period", ">=", (Object)(qpRpt.getEndPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        if (CollectionUtils.isNotEmpty(acctMids)) {
            filters.add(new QFilter("account", "in", acctMids));
        }
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("currency", "=", (Object)qpRpt.getCurrency()));
        }
        filters.addAll(qpRpt.getComAssistFiltersForBal());
        return filters;
    }

    public static List<String> getSumFieldsOrderBys(StateChart stateChart, String accountField) {
        ArrayList<String> orderBys = new ArrayList<String>(12);
        orderBys.add(accountField);
        if (stateChart.isShowCurrency()) {
            orderBys.add("currency");
        }
        if (stateChart.isShowOrg()) {
            orderBys.add("org");
        }
        return orderBys;
    }

    public static MainEntityType getBalEntity(String balEntityId) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)balEntityId).clone();
            BasedataProp accountMidProp = new BasedataProp();
            accountMidProp.setAlias("faccountid");
            accountMidProp.setName(ACCOUNT_MID);
            IDataEntityType refAcctType = ((BasedataProp)balEntity.getProperty("account")).getComplexType();
            ((LongProp)refAcctType.getPrimaryKey()).setAlias("fid");
            accountMidProp.setComplexType(refAcctType);
            balEntity.addProperty((DynamicProperty)accountMidProp);
            return balEntity;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

