/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.report.AccBalanceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.accbalance.v2.AccBalQueryServiceImpl;
import kd.fi.gl.report.accbalance.v2.batch.AccBalBatchServiceImpl;
import kd.fi.gl.report.accbalance.v2.model.AccBalBatchRow;
import kd.fi.gl.report.batchquery.AbstractReportBatchQueryPlugin;
import kd.fi.gl.report.batchquery.IBatchService;
import kd.fi.gl.report.batchquery.IQueryService;
import kd.fi.gl.util.DateUtils;

public class AccBalanceQueryRptNew
extends AbstractReportBatchQueryPlugin<AccBalBatchRow> {
    private static final Log logger = LogFactory.getLog(AccBalanceQueryRptNew.class);
    private MulOrgQPRpt qpRpt;

    @Override
    protected Class<AccBalBatchRow> getBatchRowClazz() {
        return AccBalBatchRow.class;
    }

    @Override
    protected IBatchService<AccBalBatchRow> getBatchService(ReportQueryParam param) {
        return new AccBalBatchServiceImpl();
    }

    @Override
    protected IQueryService<AccBalBatchRow> getQueryService(ReportQueryParam param, Object o) {
        return new AccBalQueryServiceImpl();
    }

    @Override
    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        DataSet rawDs = super.query(param, o);
        Date nameCtrlDate = PeriodService.getEndDate((long)param.getFilter().getLong("endperiod"));
        rawDs = rawDs.addField(DateUtils.getYearMonthDayFuncStr((Date)nameCtrlDate), "namectrldate");
        return rawDs;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        this.qpRpt = (MulOrgQPRpt)QueryParamFactory.createOrGetWithThreadCache((ReportQueryParam)queryParam, (String)"gl_rpt_accountbalance", (boolean)false);
        List<AbstractReportColumn> reportCols = new AccBalanceHelper(this.qpRpt).getReportColumn(columns);
        Map<String, ReportColumn> columnMap = reportCols.stream().filter(x -> x instanceof ReportColumn).map(ReportColumn.class::cast).collect(Collectors.toMap(ReportColumn::getFieldKey, column -> column, (original, current) -> original));
        ReportColumn accountNumberColumn = columnMap.get("number");
        if (Objects.nonNull(accountNumberColumn)) {
            accountNumberColumn.setHyperlink(true);
        }
        if (this.qpRpt.isShowOrgTree()) {
            ReportColumn currencyIdColumn;
            if (Objects.nonNull(accountNumberColumn)) {
                accountNumberColumn.setHyperlink(false);
            }
            if (Objects.nonNull(currencyIdColumn = columnMap.get("currencyid"))) {
                currencyIdColumn.setHyperlink(false);
            }
            ReportColumn orgnameColumn = new ReportColumn();
            orgnameColumn.setHyperlink(true);
            orgnameColumn.setFreeze(true);
            orgnameColumn.setHide(false);
            orgnameColumn.setFieldKey("orgname");
            orgnameColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
            orgnameColumn.setFieldType("text");
            reportCols.add(3, (AbstractReportColumn)orgnameColumn);
            ReportColumn forgnameColumn = new ReportColumn();
            forgnameColumn.setHide(true);
            forgnameColumn.setFieldKey("forgname");
            forgnameColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AssistBalHelper_4", (String)"fi-gl-report", (Object[])new Object[0])));
            forgnameColumn.setFieldType("text");
            reportCols.add((AbstractReportColumn)forgnameColumn);
            ReportColumn orgIdColumn = columnMap.get("orgid");
            if (Objects.nonNull(orgIdColumn)) {
                orgIdColumn.setHide(true);
            }
        }
        columns.add((AbstractReportColumn)ReportHelper.createFlexOrgidColumn());
        this.createComAssistColumns(columns);
        if (this.qpRpt.isShowOrgTree()) {
            ReportColumn orgLevelColumn = new ReportColumn();
            orgLevelColumn.setHide(true);
            orgLevelColumn.setFieldKey("orglevel");
            orgLevelColumn.setCaption(new LocaleString("orglevel"));
            orgLevelColumn.setFieldType("integer");
            reportCols.add((AbstractReportColumn)orgLevelColumn);
            ReportColumn linkColumn = new ReportColumn();
            linkColumn.setHide(true);
            linkColumn.setFieldKey("islink");
            linkColumn.setCaption(new LocaleString("islink"));
            linkColumn.setFieldType("boolean");
            reportCols.add((AbstractReportColumn)linkColumn);
        }
        return reportCols;
    }

    private void createComAssistColumns(List<AbstractReportColumn> columns) {
        FilterInfo filter = this.qpRpt.getFilterInfo();
        if (filter != null && !filter.getBoolean("showcomassist")) {
            return;
        }
        String comAssistValsListStr = (String)this.qpRpt.getCustomParam("ComAssistEntityListStr");
        if (comAssistValsListStr == null) {
            return;
        }
        ArrayList<ReportColumn> comAssistColumns = new ArrayList<ReportColumn>(8);
        List comAssistList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
        if (!comAssistList.isEmpty()) {
            for (int i = 0; i < comAssistList.size(); ++i) {
                List tuplMap = (List)comAssistList.get(i);
                String comFieldKey = (String)tuplMap.get(0);
                String entityId = (String)tuplMap.get(1);
                LocaleString nameLocal = new LocaleString();
                LinkedHashMap nameMap = (LinkedHashMap)tuplMap.get(2);
                for (Map.Entry map : nameMap.entrySet()) {
                    String key = (String)map.getKey();
                    String val = (String)map.getValue();
                    nameLocal.setItem(key, (Object)val);
                }
                comAssistColumns.add(this.createComAssist(comFieldKey, entityId, nameLocal));
            }
        }
        if (!comAssistColumns.isEmpty()) {
            int index = 0;
            for (AbstractReportColumn x : columns) {
                String fieldKey;
                ++index;
                if (!(x instanceof ReportColumn) || !"org".equals(fieldKey = ((ReportColumn)x).getFieldKey()) && !"orgid".equals(fieldKey)) continue;
                break;
            }
            for (int i = comAssistColumns.size() - 1; i >= 0; --i) {
                columns.add(index, (AbstractReportColumn)comAssistColumns.get(i));
            }
        }
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        String columnType = "basedata";
        if (Objects.equals(this.qpRpt.getEntityId(), "gl_rpt_accbalance_qing")) {
            columnType = "text";
        }
        ReportColumn reportColumn = ReportHelper.createColumn(nameLocal, fieldKey, columnType);
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    public MulOrgQPRpt getQpRpt() {
        return this.qpRpt;
    }
}

