/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.accbalance.v2.AccBalActionTracer;
import kd.fi.gl.report.accbalance.v2.AccBalQueryContext;
import kd.fi.gl.report.accbalance.v2.PLBalanceCacheHelper;
import kd.fi.gl.report.accbalance.v2.collect.DetailBalCollectService;
import kd.fi.gl.report.accbalance.v2.model.BalGroup;
import kd.fi.gl.report.accbalance.v2.model.BalSumGroup;
import kd.fi.gl.report.accbalance.v2.model.BalanceRow;
import kd.fi.gl.util.GLApp;

public class DetailBalanceMerger {
    private int curSumRowIndex;
    private final CachedDataSet summaryBal;
    private final Algo algo;
    private final AccBalActionTracer tracer = AccBalActionTracer.get();

    public DetailBalanceMerger(CachedDataSet summaryBal, int curSumRowIndex, Algo algo) {
        this.summaryBal = summaryBal;
        this.curSumRowIndex = curSumRowIndex;
        this.algo = algo;
    }

    static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    public static DetailBalanceMerger create(DataSet summaryBal, Algo algo) {
        CachedDataSet summaryBalCache = summaryBal.cache(CacheHint.getDefault());
        String cacheKey = summaryBalCache.getCacheId() + "#BalanceMerger";
        DetailBalanceMerger merger = new DetailBalanceMerger(summaryBalCache, 0, algo);
        ThreadCache.put((Object)cacheKey, (Object)merger);
        return merger;
    }

    public static DetailBalanceMerger create(String cacheId, Algo algo) {
        try {
            String cacheKey = cacheId + "#BalanceMerger";
            String mergeInfoStr = (String)DetailBalanceMerger.getCache().get(cacheKey);
            if (mergeInfoStr != null) {
                MergerInfo mergerInfo = (MergerInfo)JSONUtils.cast((String)mergeInfoStr, MergerInfo.class);
                DetailBalanceMerger merger = (DetailBalanceMerger)ThreadCache.get((Object)cacheKey);
                if (merger == null) {
                    CachedDataSet summaryBal = Algo.getCacheDataSet((String)mergerInfo.getSummaryBalCacheId());
                    merger = new DetailBalanceMerger(summaryBal, mergerInfo.getCurIndex(), algo);
                    ThreadCache.put((Object)cacheKey, (Object)merger);
                } else {
                    merger.curSumRowIndex = mergerInfo.getCurIndex();
                }
                return merger;
            }
            return null;
        }
        catch (Exception e) {
            LogFactory.getLog(DetailBalanceMerger.class).error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"DetailBalanceMerger_001", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
        }
    }

    public boolean hasNext() {
        return this.curSumRowIndex < this.summaryBal.getRowCount();
    }

    public Tuple<DataSet, Iterator<BalanceRow>> nextSumAndDetailRows(AccBalQueryContext context) {
        RowMeta rowMeta = this.summaryBal.getRowMeta();
        DataSetBuilder resBuilder = this.algo.createDataSetBuilder(rowMeta);
        Iterator summaryBalItr = this.summaryBal.iterator(this.curSumRowIndex, this.summaryBal.getRowCount());
        if (!summaryBalItr.hasNext()) {
            return null;
        }
        while (summaryBalItr.hasNext()) {
            Map<BalGroup, BalanceRow> plBalMap;
            Iterator<BalanceRow> detailBalItr;
            boolean showAssist;
            ++this.curSumRowIndex;
            Row nextSummaryRow = (Row)summaryBalItr.next();
            resBuilder.append(nextSummaryRow);
            BalSumGroup nextGrp = DetailBalanceMerger.createGrp(context, rowMeta, nextSummaryRow);
            this.tracer.fetchDetailGrpRow(nextGrp);
            if (!nextSummaryRow.getBoolean("detailSumRow").booleanValue() || !(showAssist = context.needShowAssist(context.getLongNumByMid(nextSummaryRow.getLong("acctmid")))) || !(detailBalItr = DetailBalCollectService.getData(nextGrp, plBalMap = PLBalanceCacheHelper.getPlBalFromCache(context, nextGrp), context)).hasNext()) continue;
            return new Tuple((Object)resBuilder.build(), detailBalItr);
        }
        return new Tuple((Object)resBuilder.build(), Collections.emptyIterator());
    }

    public DataSet getAllSumRows() {
        RowMeta rowMeta = this.summaryBal.getRowMeta();
        DataSetBuilder resBuilder = this.algo.createDataSetBuilder(rowMeta);
        this.summaryBal.iterator(this.curSumRowIndex, this.summaryBal.getRowCount()).forEachRemaining(arg_0 -> ((DataSetBuilder)resBuilder).append(arg_0));
        this.curSumRowIndex = this.summaryBal.getRowCount();
        return resBuilder.build();
    }

    public RowMeta getRowMeta() {
        return this.summaryBal.getRowMeta();
    }

    private static BalSumGroup createGrp(AccBalQueryContext context, RowMeta rowMeta, Row balRow) {
        int index = rowMeta.getFieldIndex("org", false);
        long org = index >= 0 ? balRow.getLong(index) : 0L;
        index = rowMeta.getFieldIndex("acctmid", false);
        long acct = index >= 0 ? balRow.getLong(index) : 0L;
        index = rowMeta.getFieldIndex("currency", false);
        long currency = index >= 0 ? balRow.getLong(index) : 0L;
        return BalSumGroup.createGrp(context, org, acct, currency);
    }

    public static void close(String cacheId) {
        String cacheKey = cacheId + "#BalanceMerger";
        ThreadCache.remove((Object)cacheKey);
        DetailBalanceMerger.getCache().remove(cacheKey);
    }

    public void cache(String cacheId) {
        String cacheKey = cacheId + "#BalanceMerger";
        MergerInfo mergerInfo = new MergerInfo();
        mergerInfo.setCurIndex(this.curSumRowIndex);
        mergerInfo.setSummaryBalCacheId(this.summaryBal.getCacheId());
        try {
            DetailBalanceMerger.getCache().put(cacheKey, (Object)JSONUtils.toString((Object)mergerInfo));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static class MergerInfo {
        private String summaryBalCacheId;
        private int curIndex;

        MergerInfo() {
        }

        public String getSummaryBalCacheId() {
            return this.summaryBalCacheId;
        }

        public void setSummaryBalCacheId(String summaryBalCacheId) {
            this.summaryBalCacheId = summaryBalCacheId;
        }

        public int getCurIndex() {
            return this.curIndex;
        }

        public void setCurIndex(int curIndex) {
            this.curIndex = curIndex;
        }
    }
}

